/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2.table;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.grib.GribTables;
import ucar.nc2.grib.grib2.Grib2Parameter;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.grib.grib2.table.Grib2Table;
import ucar.nc2.grib.grib2.table.WmoCodeTable;

public abstract class LocalTables
extends Grib2Customizer {
    protected Map<Integer, Grib2Parameter> local = new HashMap<Integer, Grib2Parameter>(100);

    LocalTables(Grib2Table grib2Table) {
        super(grib2Table);
    }

    @Override
    public String getTablePath(int discipline, int category, int number) {
        if (category <= 191 && number <= 191) {
            return super.getTablePath(discipline, category, number);
        }
        return this.grib2Table.getPath();
    }

    @Override
    public List<GribTables.Parameter> getParameters() {
        ArrayList<GribTables.Parameter> result = new ArrayList<GribTables.Parameter>();
        for (Grib2Parameter p : this.local.values()) {
            result.add(p);
        }
        Collections.sort(result, new ParameterSort());
        return result;
    }

    @Override
    public String getVariableName(int discipline, int category, int parameter) {
        if (category <= 191 && parameter <= 191) {
            return super.getVariableName(discipline, category, parameter);
        }
        GribTables.Parameter te = this.getParameter(discipline, category, parameter);
        if (te == null) {
            return super.getVariableName(discipline, category, parameter);
        }
        return te.getName();
    }

    @Override
    public GribTables.Parameter getParameter(int discipline, int category, int number) {
        Grib2Parameter plocal = this.local.get(LocalTables.makeParamId(discipline, category, number));
        if (category <= 191 && number <= 191) {
            WmoCodeTable.TableEntry pwmo = WmoCodeTable.getParameterEntry(discipline, category, number);
            if (plocal == null) {
                return pwmo;
            }
            if (pwmo == null) {
                return plocal;
            }
            return new Grib2Parameter(plocal, pwmo.getName(), pwmo.getUnit());
        }
        return plocal;
    }

    @Override
    public GribTables.Parameter getParameterRaw(int discipline, int category, int number) {
        return this.local.get(LocalTables.makeParamId(discipline, category, number));
    }

    protected static class ParameterSort
    implements Comparator<GribTables.Parameter> {
        protected ParameterSort() {
        }

        @Override
        public int compare(GribTables.Parameter p1, GribTables.Parameter p2) {
            int c = p1.getDiscipline() - p2.getDiscipline();
            if (c != 0) {
                return c;
            }
            c = p1.getCategory() - p2.getCategory();
            if (c != 0) {
                return c;
            }
            return p1.getNumber() - p2.getNumber();
        }
    }
}

