/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.IOException;
import javax.annotation.concurrent.Immutable;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.GribNumbers;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public class Grib1SectionBinaryData {
    private final int length;
    private final long startingPosition;

    public Grib1SectionBinaryData(RandomAccessFile raf) throws IOException {
        this.startingPosition = raf.getFilePointer();
        this.length = GribNumbers.uint3(raf);
        raf.seek(this.startingPosition + (long)this.length);
    }

    public Grib1SectionBinaryData(long startingPosition, int length) {
        this.startingPosition = startingPosition;
        this.length = length;
    }

    public long getStartingPosition() {
        return this.startingPosition;
    }

    public int getLength() {
        return this.length;
    }

    public byte[] getBytes(RandomAccessFile raf) throws IOException {
        raf.seek(this.startingPosition);
        byte[] data = new byte[this.length];
        raf.readFully(data);
        return data;
    }

    GribData.Info getBinaryDataInfo(RandomAccessFile raf) throws IOException {
        return Grib1SectionBinaryData.getBinaryDataInfo(raf, this.startingPosition);
    }

    public static GribData.Info getBinaryDataInfo(RandomAccessFile raf, long start) throws IOException {
        raf.seek(start);
        GribData.Info info = new GribData.Info();
        info.dataLength = GribNumbers.uint3(raf);
        info.flag = raf.read();
        info.binaryScaleFactor = GribNumbers.int2(raf);
        info.referenceValue = GribNumbers.float4(raf);
        info.numberOfBits = raf.read();
        return info;
    }
}

