/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.coord.CoordinateTime2D;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.RangeIterator;
import ucar.ma2.Section;
import ucar.ma2.SectionIterable;
import ucar.nc2.ft2.coverage.CoordsSet;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.grib.GdsHorizCoordSys;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.collection.Grib;
import ucar.nc2.grib.collection.GribCollectionImmutable;
import ucar.nc2.grib.collection.GribDataValidator;
import ucar.nc2.grib.collection.GribIosp;
import ucar.nc2.grib.collection.PartitionCollectionImmutable;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Parameter;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.Grib2RecordScanner;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.util.Misc;
import ucar.unidata.io.RandomAccessFile;

@Immutable
public abstract class GribDataReader {
    private static final Logger logger = LoggerFactory.getLogger(GribDataReader.class);
    public static GribCollectionImmutable.Record currentDataRecord;
    public static GribDataValidator validator;
    public static String currentDataRafFilename;
    static boolean show;
    protected final GribCollectionImmutable gribCollection;
    private final GribCollectionImmutable.VariableIndex vindex;
    private List<DataRecord> records = new ArrayList<DataRecord>();

    public static GribDataReader factory(GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex) {
        if (gribCollection.isGrib1) {
            return new Grib1DataReader(gribCollection, vindex);
        }
        return new Grib2DataReader(gribCollection, vindex);
    }

    protected abstract float[] readData(RandomAccessFile var1, DataRecord var2) throws IOException;

    protected abstract void show(RandomAccessFile var1, long var2) throws IOException;

    protected GribDataReader(GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex) {
        this.gribCollection = gribCollection;
        this.vindex = vindex;
    }

    public Array readData(SectionIterable want) throws IOException, InvalidRangeException {
        if (this.vindex instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
            return this.readDataFromPartition((PartitionCollectionImmutable.VariableIndexPartitioned)this.vindex, want);
        }
        return this.readDataFromCollection(this.vindex, want);
    }

    private Array readDataFromCollection(GribCollectionImmutable.VariableIndex vindex, SectionIterable want) throws IOException, InvalidRangeException {
        vindex.readRecords();
        int rank = want.getRank();
        int sectionLen = rank - 2;
        SectionIterable sectionWanted = want.subSection(0, sectionLen);
        int resultIndex = 0;
        Iterator iterator = sectionWanted.iterator();
        while (iterator.hasNext()) {
            int sourceIndex = (Integer)iterator.next();
            GribCollectionImmutable.Record record = vindex.getRecordAt(sourceIndex);
            if (Grib.debugRead) {
                System.out.printf("GribIosp debugRead sourceIndex=%d resultIndex=%d record is null=%s%n", sourceIndex, resultIndex, record == null);
            }
            if (record != null) {
                this.records.add(new DataRecord(resultIndex, record, vindex.group.getGdsHorizCoordSys()));
            }
            ++resultIndex;
        }
        DataReceiver dataReceiver = new DataReceiver(want.getShape(), want.getRange(rank - 2), want.getRange(rank - 1));
        this.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private Array readDataFromPartition(PartitionCollectionImmutable.VariableIndexPartitioned vindexP, SectionIterable section) throws IOException, InvalidRangeException {
        int[] indexWanted;
        int rank = section.getRank();
        SectionIterable sectionWanted = section.subSection(0, rank - 2);
        SectionIterable.SectionIterator iterWanted = sectionWanted.getIterator();
        int[] useIndex = indexWanted = new int[rank - 2];
        int resultPos = 0;
        while (iterWanted.hasNext()) {
            PartitionCollectionImmutable.DataRecord record;
            iterWanted.next(indexWanted);
            if (vindexP.getType() == GribCollectionImmutable.Type.MRUTP) {
                CoordinateTime2D time2D = (CoordinateTime2D)vindexP.getCoordinateTime();
                assert (time2D != null);
                int[] timeIndices = time2D.getTimeIndicesFromMrutp(indexWanted[0]);
                int[] indexReallyWanted = new int[indexWanted.length + 1];
                indexReallyWanted[0] = timeIndices[0];
                indexReallyWanted[1] = timeIndices[1];
                System.arraycopy(indexWanted, 1, indexReallyWanted, 2, indexWanted.length - 1);
                useIndex = indexReallyWanted;
            }
            if ((record = vindexP.getDataRecord(useIndex)) == null) {
                if (Grib.debugRead) {
                    System.out.printf("readDataFromPartition missing data%n", new Object[0]);
                }
                ++resultPos;
                continue;
            }
            record.resultIndex = resultPos++;
            this.records.add(record);
        }
        DataReceiver dataReceiver = new DataReceiver(section.getShape(), section.getRange(rank - 2), section.getRange(rank - 1));
        this.readPartitioned(dataReceiver);
        return dataReceiver.getArray();
    }

    public Array readData2(CoordsSet want, RangeIterator yRange, RangeIterator xRange) throws IOException, InvalidRangeException {
        if (this.vindex instanceof PartitionCollectionImmutable.VariableIndexPartitioned) {
            return this.readDataFromPartition2((PartitionCollectionImmutable.VariableIndexPartitioned)this.vindex, want, yRange, xRange);
        }
        return this.readDataFromCollection2(this.vindex, want, yRange, xRange);
    }

    private Array readDataFromCollection2(GribCollectionImmutable.VariableIndex vindex, CoordsSet want, RangeIterator yRange, RangeIterator xRange) throws IOException, InvalidRangeException {
        vindex.readRecords();
        int resultIndex = 0;
        for (SubsetParams coords : want) {
            GribCollectionImmutable.Record record = vindex.getRecordAt(coords);
            if (record != null) {
                DataRecord dr = new DataRecord(resultIndex, record, vindex.group.getGdsHorizCoordSys());
                if (validator != null) {
                    dr.validation = coords;
                }
                this.records.add(dr);
            }
            ++resultIndex;
        }
        DataReceiver dataReceiver = new DataReceiver(want.getShape(yRange, xRange), yRange, xRange);
        this.read(dataReceiver);
        return dataReceiver.getArray();
    }

    private Array readDataFromPartition2(PartitionCollectionImmutable.VariableIndexPartitioned vindexP, CoordsSet want, RangeIterator yRange, RangeIterator xRange) throws IOException, InvalidRangeException {
        int resultPos = 0;
        for (SubsetParams coords : want) {
            PartitionCollectionImmutable.DataRecord record = vindexP.getDataRecord(coords);
            if (record != null) {
                record.resultIndex = resultPos;
                this.records.add(record);
            }
            ++resultPos;
        }
        DataReceiver dataReceiver = new DataReceiver(want.getShape(yRange, xRange), yRange, xRange);
        this.readPartitioned(dataReceiver);
        return dataReceiver.getArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(DataReceiverIF dataReceiver) throws IOException {
        Collections.sort(this.records);
        int currFile = -1;
        try (RandomAccessFile rafData = null;){
            for (DataRecord dr : this.records) {
                if (Grib.debugIndexOnly || Grib.debugGbxIndexOnly) {
                    ++GribIosp.debugIndexOnlyCount;
                    currentDataRecord = dr.record;
                    currentDataRafFilename = this.gribCollection.getDataRafFilename(dr.record.fileno);
                    if (Grib.debugIndexOnlyShow) {
                        dr.show(this.gribCollection);
                    }
                    dataReceiver.setDataToZero();
                    continue;
                }
                if (dr.record.fileno != currFile) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = this.gribCollection.getDataRaf(dr.record.fileno);
                    currFile = dr.record.fileno;
                }
                if (dr.record.pos == -1L) continue;
                if (validator != null && dr.validation != null && rafData != null) {
                    validator.validate(this.gribCollection.cust, rafData, dr.record.pos + (long)dr.record.drsOffset, dr.validation);
                } else if (show && rafData != null) {
                    this.show(dr.validation);
                    this.show(rafData, dr.record.pos + (long)dr.record.drsOffset);
                }
                float[] data = this.readData(rafData, dr);
                GdsHorizCoordSys hcs = this.vindex.group.getGdsHorizCoordSys();
                dataReceiver.addData(data, dr.resultIndex, hcs.nx);
            }
        }
    }

    private void show(SubsetParams validation) {
        if (validation == null) {
            return;
        }
        System.out.printf("Coords wanted%n %s", validation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPartitioned(DataReceiverIF dataReceiver) throws IOException {
        Collections.sort(this.records);
        PartitionCollectionImmutable.DataRecord lastRecord = null;
        try (RandomAccessFile rafData = null;){
            for (DataRecord dr : this.records) {
                PartitionCollectionImmutable.DataRecord drp = (PartitionCollectionImmutable.DataRecord)dr;
                if (Grib.debugIndexOnly || Grib.debugGbxIndexOnly) {
                    ++GribIosp.debugIndexOnlyCount;
                    if (Grib.debugIndexOnlyShow) {
                        drp.show();
                    }
                    dataReceiver.setDataToZero();
                    continue;
                }
                if (rafData == null || !drp.usesSameFile(lastRecord)) {
                    if (rafData != null) {
                        rafData.close();
                    }
                    rafData = drp.usePartition.getRaf(drp.partno, dr.record.fileno);
                }
                lastRecord = drp;
                if (dr.record.pos == -1L) continue;
                if (validator != null && dr.validation != null) {
                    validator.validate(this.gribCollection.cust, rafData, dr.record.pos + (long)dr.record.drsOffset, dr.validation);
                } else if (show) {
                    this.show(dr.validation);
                    this.show(rafData, dr.record.pos + (long)dr.record.drsOffset);
                }
                float[] data = this.readData(rafData, dr);
                GdsHorizCoordSys hcs = dr.hcs;
                dataReceiver.addData(data, dr.resultIndex, hcs.nx);
            }
        }
    }

    static {
        show = false;
    }

    private static class Grib1DataReader
    extends GribDataReader {
        private Grib1Customizer cust;

        protected Grib1DataReader(GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex) {
            super(gribCollection, vindex);
            this.cust = (Grib1Customizer)gribCollection.cust;
        }

        @Override
        protected float[] readData(RandomAccessFile rafData, DataRecord dr) throws IOException {
            return Grib1Record.readData(rafData, dr.record.pos);
        }

        @Override
        protected void show(RandomAccessFile rafData, long dataPos) throws IOException {
            rafData.seek(dataPos);
            Grib1Record gr = new Grib1Record(rafData);
            Formatter f = new Formatter();
            f.format("File=%s%n", rafData.getLocation());
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            Grib1Parameter param = this.cust.getParameter(pds.getCenter(), pds.getSubCenter(), pds.getTableVersion(), pds.getParameterNumber());
            f.format("  Parameter=%s%n", param);
            f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
            Grib1ParamTime ptime = gr.getParamTime(this.cust);
            f.format("  ForecastTime=%d%n", ptime.getForecastTime());
            if (ptime.isInterval()) {
                int[] tinv = ptime.getInterval();
                f.format("  TimeInterval=(%d,%d)%n", tinv[0], tinv[1]);
            }
            f.format("%n", new Object[0]);
            gr.getPDSsection().showPds(this.cust, f);
            System.out.printf("%nGrib1Record.readData at drsPos %d = %s%n", dataPos, f.toString());
        }
    }

    private static class Grib2DataReader
    extends GribDataReader {
        private Grib2Customizer cust;

        protected Grib2DataReader(GribCollectionImmutable gribCollection, GribCollectionImmutable.VariableIndex vindex) {
            super(gribCollection, vindex);
            this.cust = (Grib2Customizer)gribCollection.cust;
        }

        @Override
        protected float[] readData(RandomAccessFile rafData, DataRecord dr) throws IOException {
            GdsHorizCoordSys hcs = dr.hcs;
            long dataPos = dr.record.pos + (long)dr.record.drsOffset;
            long bmsPos = dr.record.bmsOffset > 0 ? dr.record.pos + (long)dr.record.bmsOffset : 0L;
            return Grib2Record.readData(rafData, dataPos, bmsPos, hcs.gdsNumberPoints, hcs.getScanMode(), hcs.nxRaw, hcs.nyRaw, hcs.nptsInLine);
        }

        @Override
        protected void show(RandomAccessFile rafData, long pos) throws IOException {
            Grib2Record gr = Grib2RecordScanner.findRecordByDrspos(rafData, pos);
            if (gr != null) {
                Formatter f = new Formatter();
                f.format("File=%s%n", rafData.getLocation());
                f.format("  Parameter=%s%n", this.cust.getVariableName(gr));
                f.format("  ReferenceDate=%s%n", gr.getReferenceDate());
                f.format("  ForecastDate=%s%n", this.cust.getForecastDate(gr));
                TimeCoord.TinvDate tinv = this.cust.getForecastTimeInterval(gr);
                if (tinv != null) {
                    f.format("  TimeInterval=%s%n", tinv);
                }
                f.format("  ", new Object[0]);
                gr.getPDS().show(f);
                System.out.printf("%nGrib2Record.readData at drsPos %d = %s%n", pos, f.toString());
            }
        }
    }

    public static class DataReceiver
    implements DataReceiverIF {
        private Array dataArray;
        private RangeIterator yRange;
        private RangeIterator xRange;
        private int horizSize;

        public DataReceiver(int[] shape, RangeIterator yRange, RangeIterator xRange) {
            this.yRange = yRange;
            this.xRange = xRange;
            this.horizSize = yRange.length() * xRange.length();
            long len = Section.computeSize((int[])shape);
            if (len > 400000000L) {
                logger.debug("Len greater that 100MB shape={}\n{}", (Object)Misc.showInts((int[])shape), (Object)Throwables.getStackTraceAsString((Throwable)new Throwable()));
                throw new IllegalArgumentException("RequestTooLarge: Len greater that 100M ");
            }
            float[] data = new float[(int)len];
            Arrays.fill(data, Float.NaN);
            this.dataArray = Array.factory((DataType)DataType.FLOAT, (int[])shape, (Object)data);
        }

        @Override
        public void addData(float[] data, int resultIndex, int nx) throws IOException {
            int start = resultIndex * this.horizSize;
            int count = 0;
            Iterator iterator = this.yRange.iterator();
            while (iterator.hasNext()) {
                int y = (Integer)iterator.next();
                Iterator iterator2 = this.xRange.iterator();
                while (iterator2.hasNext()) {
                    int x = (Integer)iterator2.next();
                    int dataIdx = y * nx + x;
                    this.dataArray.setFloat(start + count, data[dataIdx]);
                    ++count;
                }
            }
        }

        @Override
        public void setDataToZero() {
            float[] data = (float[])this.dataArray.get1DJavaArray(this.dataArray.getDataType());
            Arrays.fill(data, 0.0f);
        }

        @Override
        public Array getArray() {
            return this.dataArray;
        }
    }

    public static interface DataReceiverIF {
        public void addData(float[] var1, int var2, int var3) throws IOException;

        public void setDataToZero();

        public Array getArray();
    }

    public static class DataRecord
    implements Comparable<DataRecord> {
        int resultIndex;
        GribCollectionImmutable.Record record;
        GdsHorizCoordSys hcs;
        SubsetParams validation;

        DataRecord(int resultIndex, GribCollectionImmutable.Record record, GdsHorizCoordSys hcs) {
            this.resultIndex = resultIndex;
            this.record = record;
            this.hcs = hcs;
        }

        @Override
        public int compareTo(DataRecord o) {
            int r = Misc.compare((int)this.record.fileno, (int)o.record.fileno);
            if (r != 0) {
                return r;
            }
            return Misc.compare((long)this.record.pos, (long)o.record.pos);
        }

        public void show(GribCollectionImmutable gribCollection) throws IOException {
            String dataFilename = gribCollection.getFilename(this.record.fileno);
            System.out.printf(" fileno=%d filename=%s startPos=%d%n", this.record.fileno, dataFilename, this.record.pos);
        }
    }
}

