/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilderImpl;
import ucar.coord.CoordinateTimeAbstract;
import ucar.nc2.grib.GribUtils;
import ucar.nc2.grib.TimeCoord;
import ucar.nc2.grib.grib1.Grib1ParamTime;
import ucar.nc2.grib.grib1.Grib1Record;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.grib.grib2.Grib2Pds;
import ucar.nc2.grib.grib2.Grib2Record;
import ucar.nc2.grib.grib2.table.Grib2Customizer;
import ucar.nc2.time.Calendar;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.time.CalendarPeriod;
import ucar.nc2.util.Counters;
import ucar.nc2.util.Indent;
import ucar.nc2.util.Misc;

@Immutable
public class CoordinateTimeIntv
extends CoordinateTimeAbstract
implements Coordinate {
    private final List<TimeCoord.Tinv> timeIntervals;

    public CoordinateTimeIntv(int code, CalendarPeriod timeUnit, CalendarDate refDate, List<TimeCoord.Tinv> timeIntervals, int[] time2runtime) {
        super(code, timeUnit, refDate, time2runtime);
        this.timeIntervals = Collections.unmodifiableList(timeIntervals);
    }

    CoordinateTimeIntv(CoordinateTimeIntv org, CalendarDate refDate) {
        super(org.code, org.timeUnit, refDate, null);
        this.timeIntervals = org.getTimeIntervals();
    }

    public List<TimeCoord.Tinv> getTimeIntervals() {
        return this.timeIntervals;
    }

    @Override
    public List<? extends Object> getValues() {
        return this.timeIntervals;
    }

    @Override
    public Object getValue(int idx) {
        return this.timeIntervals.get(idx);
    }

    @Override
    public int getIndex(Object val) {
        return Collections.binarySearch(this.timeIntervals, (TimeCoord.Tinv)val);
    }

    @Override
    public int getSize() {
        return this.timeIntervals.size();
    }

    @Override
    public int estMemorySize() {
        return 616 + this.getSize() * 24;
    }

    @Override
    public Coordinate.Type getType() {
        return Coordinate.Type.timeIntv;
    }

    public String getTimeIntervalName() {
        int firstValue = -1;
        for (TimeCoord.Tinv tinv : this.timeIntervals) {
            int value = tinv.getBounds2() - tinv.getBounds1();
            if (firstValue < 0) {
                firstValue = value;
                continue;
            }
            if (value == firstValue) continue;
            return "Mixed_intervals";
        }
        return (firstValue *= this.timeUnit.getValue()) + "_" + this.timeUnit.getField().toString();
    }

    @Override
    public CalendarDateRange makeCalendarDateRange(Calendar cal) {
        CalendarDateUnit cdu = CalendarDateUnit.of((Calendar)cal, (CalendarPeriod.Field)this.timeUnit.getField(), (CalendarDate)this.refDate);
        CalendarDate start = cdu.makeCalendarDate(this.timeUnit.getValue() * this.timeIntervals.get(0).getBounds2());
        CalendarDate end = cdu.makeCalendarDate(this.timeUnit.getValue() * this.timeIntervals.get(this.getSize() - 1).getBounds2());
        return CalendarDateRange.of((CalendarDate)start, (CalendarDate)end);
    }

    @Override
    public void showInfo(Formatter info, Indent indent) {
        info.format("%s%s:", new Object[]{indent, this.getType()});
        for (TimeCoord.Tinv cd : this.timeIntervals) {
            info.format(" %s,", cd);
        }
        info.format(" (%d) %n", this.timeIntervals.size());
        if (this.time2runtime != null) {
            info.format("%stime2runtime: %s", indent, Misc.showInts((int[])this.time2runtime));
        }
    }

    @Override
    public void showCoords(Formatter info) {
        info.format("Time Interval offsets: (%s) ref=%s%n", this.getTimeUnit(), this.getRefDate());
        for (TimeCoord.Tinv cd : this.timeIntervals) {
            info.format("   (%3d - %3d)  %d%n", cd.getBounds1(), cd.getBounds2(), cd.getBounds2() - cd.getBounds1());
        }
    }

    @Override
    public Counters calcDistributions() {
        Counters counters = new Counters();
        counters.add("resol");
        counters.add("intv");
        List<TimeCoord.Tinv> offsets = this.getTimeIntervals();
        for (int i = 0; i < offsets.size(); ++i) {
            int intv = offsets.get(i).getBounds2() - offsets.get(i).getBounds1();
            counters.count("intv", (Comparable)Integer.valueOf(intv));
            if (i >= offsets.size() - 1) continue;
            int resol = offsets.get(i + 1).getBounds1() - offsets.get(i).getBounds1();
            counters.count("resol", (Comparable)Integer.valueOf(resol));
        }
        return counters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CoordinateTimeIntv that = (CoordinateTimeIntv)o;
        if (this.code != that.code) {
            return false;
        }
        return this.timeIntervals.equals(that.timeIntervals);
    }

    public int hashCode() {
        int result = this.code;
        result = 31 * result + this.timeIntervals.hashCode();
        return result;
    }

    @Override
    protected CoordinateTimeIntv makeBestFromComplete(int[] best, int n) {
        ArrayList<TimeCoord.Tinv> timeIntervalsBest = new ArrayList<TimeCoord.Tinv>(this.timeIntervals.size());
        int[] time2runtimeBest = new int[n];
        int count = 0;
        for (int i = 0; i < best.length; ++i) {
            int time = best[i];
            if (time < 0) continue;
            time2runtimeBest[count] = time;
            timeIntervalsBest.add(this.timeIntervals.get(i));
            ++count;
        }
        return new CoordinateTimeIntv(this.code, this.timeUnit, this.refDate, timeIntervalsBest, time2runtimeBest);
    }

    public static class Builder1
    extends CoordinateBuilderImpl<Grib1Record> {
        private final Grib1Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CalendarDate refDate;

        public Builder1(Grib1Customizer cust, int code, CalendarPeriod timeUnit, CalendarDate refDate) {
            this.cust = cust;
            this.code = code;
            this.timeUnit = timeUnit;
            this.refDate = refDate;
        }

        @Override
        public Object extract(Grib1Record gr) {
            Grib1SectionProductDefinition pds = gr.getPDSsection();
            Grib1ParamTime ptime = gr.getParamTime(this.cust);
            int tuInRecord = pds.getTimeUnit();
            int[] intv = ptime.getInterval();
            TimeCoord.Tinv tinv = new TimeCoord.Tinv(intv[0], intv[1]);
            if (tuInRecord != this.code) {
                CalendarPeriod unitInRecord = GribUtils.getCalendarPeriod(tuInRecord);
                tinv = tinv.convertReferenceDate(gr.getReferenceDate(), unitInRecord, this.refDate, this.timeUnit);
            }
            return tinv;
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<TimeCoord.Tinv> offsetSorted = new ArrayList<TimeCoord.Tinv>(values.size());
            for (Object val : values) {
                offsetSorted.add((TimeCoord.Tinv)val);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTimeIntv(this.code, this.timeUnit, this.refDate, offsetSorted, null);
        }
    }

    public static class Builder2
    extends CoordinateBuilderImpl<Grib2Record> {
        private final Grib2Customizer cust;
        private final int code;
        private final CalendarPeriod timeUnit;
        private final CalendarDate refDate;

        public Builder2(Grib2Customizer cust, int code, CalendarPeriod timeUnit, CalendarDate refDate) {
            this.cust = cust;
            this.code = code;
            this.timeUnit = timeUnit;
            this.refDate = refDate;
        }

        public Builder2(CoordinateTimeIntv from) {
            this.cust = null;
            this.code = from.getCode();
            this.timeUnit = from.getTimeUnit();
            this.refDate = from.getRefDate();
        }

        @Override
        public Object extract(Grib2Record gr) {
            TimeCoord.Tinv tinv;
            Grib2Pds pds = gr.getPDS();
            int tuInRecord = pds.getTimeUnit();
            if (tuInRecord == this.code) {
                int[] intv = this.cust.getForecastTimeIntervalOffset(gr);
                tinv = new TimeCoord.Tinv(intv[0], intv[1]);
            } else {
                TimeCoord.TinvDate tinvd = this.cust.getForecastTimeInterval(gr);
                tinv = tinvd.convertReferenceDate(this.refDate, this.timeUnit);
            }
            return tinv;
        }

        @Override
        public Coordinate makeCoordinate(List<Object> values) {
            ArrayList<TimeCoord.Tinv> offsetSorted = new ArrayList<TimeCoord.Tinv>(values.size());
            for (Object val : values) {
                offsetSorted.add((TimeCoord.Tinv)val);
            }
            Collections.sort(offsetSorted);
            return new CoordinateTimeIntv(this.code, this.timeUnit, this.refDate, offsetSorted, null);
        }
    }
}

