/*
 * Decompiled with CFR 0.152.
 */
package ucar.coord;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateBuilder;
import ucar.coord.CoordinateTime2D;
import ucar.coord.GribRecordStats;
import ucar.coord.SparseArray;
import ucar.ma2.Section;
import ucar.nc2.util.Indent;

@Immutable
public class CoordinateND<T> {
    private final List<Coordinate> coordinates;
    private final SparseArray<T> sa;

    public CoordinateND(List<Coordinate> coordinates, SparseArray<T> sa) {
        assert (coordinates.size() == sa.getRank());
        this.coordinates = Collections.unmodifiableList(coordinates);
        this.sa = sa;
    }

    public List<Coordinate> getCoordinates() {
        return this.coordinates;
    }

    public int getNCoordinates() {
        return this.coordinates.size();
    }

    public SparseArray<T> getSparseArray() {
        return this.sa;
    }

    public void showInfo(Formatter info, GribRecordStats all) {
        for (Coordinate coord : this.coordinates) {
            coord.showInfo(info, new Indent(2));
        }
        this.sa.showInfo(info, all);
    }

    public static class Builder<T> {
        private List<CoordinateBuilder<T>> builders = new ArrayList<CoordinateBuilder<T>>();
        private List<Coordinate> coordb = new ArrayList<Coordinate>();

        public Builder() {
            this.builders = new ArrayList<CoordinateBuilder<T>>();
        }

        public void addBuilder(CoordinateBuilder<T> builder) {
            this.builders.add(builder);
        }

        public void addRecord(T gr) {
            for (CoordinateBuilder<T> builder : this.builders) {
                builder.addRecord(gr);
            }
        }

        public CoordinateND<T> finish(List<T> records, Formatter info) {
            for (CoordinateBuilder<T> builder : this.builders) {
                Coordinate coord = builder.finish();
                if (coord.getType() == Coordinate.Type.time2D) {
                    this.coordb.add(((CoordinateTime2D)coord).getRuntimeCoordinate());
                }
                this.coordb.add(coord);
            }
            SparseArray<T> sa = this.buildSparseArray(records, info);
            return new CoordinateND<T>(this.coordb, sa);
        }

        public SparseArray<T> buildSparseArray(List<T> records, Formatter info) {
            int[] sizeArray = new int[this.coordb.size()];
            for (int i = 0; i < this.coordb.size(); ++i) {
                Coordinate coord = this.coordb.get(i);
                sizeArray[i] = coord.getType() == Coordinate.Type.time2D ? ((CoordinateTime2D)coord).getNtimes() : coord.getSize();
            }
            SparseArray.Builder<T> saBuilder = new SparseArray.Builder<T>(sizeArray);
            int[] index = new int[this.coordb.size()];
            for (T gr : records) {
                int count = 0;
                for (CoordinateBuilder<T> builder : this.builders) {
                    if (builder instanceof CoordinateBuilder.TwoD) {
                        CoordinateBuilder.TwoD builder2D = (CoordinateBuilder.TwoD)((Object)builder);
                        int[] coordsIdx = builder2D.getCoordIndices(gr);
                        index[count++] = coordsIdx[0];
                        index[count++] = coordsIdx[1];
                        continue;
                    }
                    index[count++] = builder.getIndex(gr);
                }
                saBuilder.add(gr, info, index);
            }
            return saBuilder.finish();
        }

        public CoordinateND<T> reindex(List<Coordinate> newCoords, CoordinateND<T> prev) {
            assert (newCoords.size() == prev.getNCoordinates());
            boolean has2Dcoord = false;
            for (Coordinate coord : newCoords) {
                if (coord.getType() != Coordinate.Type.time2D) continue;
                has2Dcoord = true;
            }
            return has2Dcoord ? this.reindex2D(newCoords, prev) : this.reindexOrth(newCoords, prev);
        }

        private CoordinateND<T> reindexOrth(List<Coordinate> newCoords, CoordinateND<T> prev) {
            SparseArray<T> prevSA = prev.getSparseArray();
            List<Coordinate> prevCoords = prev.getCoordinates();
            int[] sizeArray = new int[newCoords.size()];
            for (int i = 0; i < newCoords.size(); ++i) {
                Coordinate coord = newCoords.get(i);
                sizeArray[i] = coord instanceof CoordinateTime2D ? ((CoordinateTime2D)coord).getNtimes() : coord.getSize();
            }
            SparseArray.Builder workingSAbuilder = new SparseArray.Builder(sizeArray);
            ArrayList<IndexMap> indexMaps = new ArrayList<IndexMap>();
            int count = 0;
            for (Coordinate coord : newCoords) {
                indexMaps.add(new IndexMap(coord, prevCoords.get(count++)));
            }
            int[] currIndex = new int[newCoords.size()];
            int[] prevIndex = new int[newCoords.size()];
            int[] track = new int[SparseArray.calcTotalSize(sizeArray)];
            Section section = new Section(prevSA.getShape());
            Section.Iterator iter = section.getIterator(prevSA.getShape());
            while (iter.hasNext()) {
                int oldTrackIdx = iter.next(prevIndex);
                int oldTrackValue = prevSA.getTrack(oldTrackIdx);
                if (oldTrackValue == 0) continue;
                int coordIdx = 0;
                for (IndexMap indexMap : indexMaps) {
                    currIndex[coordIdx] = indexMap.map(prevIndex[coordIdx]);
                    ++coordIdx;
                }
                int trackIdx = workingSAbuilder.calcIndex(currIndex);
                track[trackIdx] = oldTrackValue;
            }
            SparseArray<T> newSA = new SparseArray<T>(sizeArray, track, prevSA.getContent(), prevSA.getNdups());
            return new CoordinateND<T>(newCoords, newSA);
        }

        private CoordinateND<T> reindex2D(List<Coordinate> newCoords, CoordinateND<T> prev) {
            SparseArray<T> prevSA = prev.getSparseArray();
            List<Coordinate> prevCoords = prev.getCoordinates();
            CoordinateTime2D prev2Dcoord = null;
            int ncoords = newCoords.size();
            int[] sizeArray = new int[ncoords];
            for (int i = 0; i < ncoords; ++i) {
                Coordinate coord = newCoords.get(i);
                sizeArray[i] = coord instanceof CoordinateTime2D ? ((CoordinateTime2D)coord).getNtimes() : coord.getSize();
            }
            SparseArray.Builder workingSAbuilder = new SparseArray.Builder(sizeArray);
            IndexMap[] indexMaps = new IndexMap[ncoords];
            Time2DIndexMap timeIndexMap = null;
            for (int i = 0; i < ncoords; ++i) {
                Coordinate coord = newCoords.get(i);
                if (coord.getType() == Coordinate.Type.time2D) {
                    prev2Dcoord = (CoordinateTime2D)prevCoords.get(i);
                    timeIndexMap = new Time2DIndexMap((CoordinateTime2D)coord, prev2Dcoord);
                    continue;
                }
                indexMaps[i] = new IndexMap(coord, prevCoords.get(i));
            }
            int[] currIndex = new int[ncoords];
            int[] prevIndex = new int[ncoords];
            int[] track = new int[SparseArray.calcTotalSize(sizeArray)];
            Section section = new Section(prevSA.getShape());
            Section.Iterator iter = section.getIterator(prevSA.getShape());
            while (iter.hasNext()) {
                int oldTrackIdx = iter.next(prevIndex);
                int oldTrackValue = prevSA.getTrack(oldTrackIdx);
                if (oldTrackValue == 0) continue;
                for (int i = 0; i < ncoords; ++i) {
                    Coordinate coord = newCoords.get(i);
                    if (coord.getType() == Coordinate.Type.time2D) {
                        CoordinateTime2D.Time2D prevValue = prev2Dcoord.getOrgValue(prevIndex[0], prevIndex[1]);
                        currIndex[i] = timeIndexMap.map(prevValue);
                        continue;
                    }
                    currIndex[i] = indexMaps[i].map(prevIndex[i]);
                }
                int trackIdx = workingSAbuilder.calcIndex(currIndex);
                track[trackIdx] = oldTrackValue;
            }
            SparseArray<T> newSA = new SparseArray<T>(sizeArray, track, prevSA.getContent(), prevSA.getNdups());
            return new CoordinateND<T>(newCoords, newSA);
        }

        private static class Time2DIndexMap {
            Map<Object, Integer> currValMap;

            Time2DIndexMap(CoordinateTime2D curr, CoordinateTime2D prev) {
                assert (curr.getType() == prev.getType()) : (Object)((Object)curr.getType()) + " != " + (Object)((Object)prev.getType());
                this.currValMap = new HashMap<Object, Integer>(2 * curr.getValues().size());
                int[] index2D = new int[2];
                for (Object object : prev.getValues()) {
                    if (!curr.getIndex((CoordinateTime2D.Time2D)object, index2D)) {
                        throw new IllegalStateException();
                    }
                    this.currValMap.put(object, index2D[1]);
                }
            }

            public int map(CoordinateTime2D.Time2D prevCoord) {
                Integer val = this.currValMap.get(prevCoord);
                if (val == null) {
                    throw new IllegalStateException("reindex does not have coordinate Time2D " + prevCoord);
                }
                return val;
            }
        }

        private static class IndexMap {
            boolean identity = true;
            int[] indexMap;

            IndexMap(Coordinate curr, Coordinate prev) {
                this.identity = curr.equals(prev);
                if (this.identity) {
                    return;
                }
                assert (curr.getType() == prev.getType()) : (Object)((Object)curr.getType()) + " != " + (Object)((Object)prev.getType());
                int count = 0;
                HashMap<Object, Integer> currValMap = new HashMap<Object, Integer>();
                if (curr.getValues() == null) {
                    throw new IllegalStateException();
                }
                for (Object object : curr.getValues()) {
                    currValMap.put(object, count++);
                }
                count = 0;
                this.indexMap = new int[prev.getSize()];
                for (Object object : prev.getValues()) {
                    this.indexMap[count++] = (Integer)currValMap.get(object);
                }
            }

            public int map(int oldIndex) {
                if (this.identity) {
                    return oldIndex;
                }
                return this.indexMap[oldIndex];
            }
        }
    }
}

