/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib2;

import java.io.IOException;
import java.util.Formatter;
import java.util.zip.CRC32;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

@Immutable
public abstract class Grib2Pds {
    private static final Logger log = LoggerFactory.getLogger(Grib2Pds.class);
    protected byte[] input;
    protected final int template;

    public static Grib2Pds factory(int template, byte[] input) throws IOException {
        switch (template) {
            case 0: {
                return new Grib2Pds0(input);
            }
            case 1: {
                return new Grib2Pds1(input);
            }
            case 2: {
                return new Grib2Pds2(input);
            }
            case 5: {
                return new Grib2Pds5(input);
            }
            case 6: {
                return new Grib2Pds6(input);
            }
            case 8: {
                return new Grib2Pds8(input);
            }
            case 9: {
                return new Grib2Pds9(input);
            }
            case 10: {
                return new Grib2Pds10(input);
            }
            case 11: {
                return new Grib2Pds11(input);
            }
            case 12: {
                return new Grib2Pds12(input);
            }
            case 15: {
                return new Grib2Pds15(input);
            }
            case 30: {
                return new Grib2Pds30(input);
            }
            case 31: {
                return new Grib2Pds31(input);
            }
            case 48: {
                return new Grib2Pds48(input);
            }
        }
        log.warn("Missing template " + template);
        return null;
    }

    protected Grib2Pds(byte[] input) throws IOException {
        this.input = input;
        this.template = GribNumbers.int2(this.getOctet(8), this.getOctet(9));
    }

    public abstract int templateLength();

    public int getExtraCoordinatesCount() {
        return GribNumbers.int2(this.getOctet(6), this.getOctet(7));
    }

    public final float[] getExtraCoordinates() {
        int n = this.getExtraCoordinatesCount();
        if (n == 0) {
            return null;
        }
        float[] result = new float[n];
        int count = this.templateLength() + 1;
        for (int i = 0; i < n; ++i) {
            result[i] = GribNumbers.float4(this.getOctet(count++), this.getOctet(count++), this.getOctet(count++), this.getOctet(count++));
        }
        return result;
    }

    public final int getTemplateNumber() {
        return this.template;
    }

    public final int getParameterCategory() {
        return this.getOctet(10);
    }

    public final int getParameterNumber() {
        return this.getOctet(11);
    }

    public int getGenProcessType() {
        return -9999;
    }

    public int getGenProcessId() {
        return -9999;
    }

    public int getBackProcessId() {
        return -9999;
    }

    public abstract int getTimeUnit();

    public int getForecastTime() {
        return GribNumbers.int4(this.getOctet(19), this.getOctet(20), this.getOctet(21), this.getOctet(22));
    }

    public double getLevelValue1() {
        return -9999.0;
    }

    public int getLevelScale1() {
        return -9999;
    }

    public double getLevelValue2() {
        return -9999.0;
    }

    public int getLevelType1() {
        return -9999;
    }

    public int getLevelType2() {
        return -9999;
    }

    public int getLevelScale2() {
        return -9999;
    }

    public boolean isAerosol() {
        return this.template == 48;
    }

    public boolean isEnsemble() {
        return false;
    }

    public boolean isEnsembleDerived() {
        return false;
    }

    public boolean isProbability() {
        return false;
    }

    public boolean isTimeInterval() {
        return this.template >= 8 && this.template <= 14;
    }

    public boolean isSpatialInterval() {
        return this.template == 15;
    }

    public void show(Formatter f) {
        f.format("Grib2Pds{ id=%d-%d template=%d, forecastTime= %d timeUnit=%s vertLevel=%f}", this.getParameterCategory(), this.getParameterNumber(), this.template, this.getForecastTime(), this.getTimeUnit(), this.getLevelValue1());
    }

    public final int getOctet(int index) {
        return this.input[index - 1] & 0xFF;
    }

    public final int getOctetSigned(int index) {
        return GribNumbers.convertSignedByte(this.input[index - 1]);
    }

    public final int getRawLength() {
        return this.input.length;
    }

    protected double getScaledValue(int start) {
        int scale = this.getOctetSigned(start++);
        int value = GribNumbers.int4(this.getOctet(start++), this.getOctet(start++), this.getOctet(start++), this.getOctet(start++));
        return this.applyScaleFactor(scale, value);
    }

    public int getStatisticalProcessType() {
        if (!(this instanceof PdsInterval)) {
            return -1;
        }
        PdsInterval pint = (PdsInterval)((Object)this);
        TimeInterval[] ti = pint.getTimeIntervals();
        if (ti.length > 0) {
            TimeInterval ti0 = ti[0];
            return ti0.statProcessType;
        }
        return -1;
    }

    protected CalendarDate calcTime(int startIndex) {
        int year = GribNumbers.int2(this.getOctet(startIndex++), this.getOctet(startIndex++));
        int month = this.getOctet(startIndex++);
        int day = this.getOctet(startIndex++);
        int hour = this.getOctet(startIndex++);
        int minute = this.getOctet(startIndex++);
        int second = this.getOctet(startIndex++);
        if (year == 0 && month == 0 && day == 0 && hour == 0 && minute == 0 && second == 0) {
            return null;
        }
        return CalendarDate.of(null, (int)year, (int)month, (int)day, (int)hour, (int)minute, (int)second);
    }

    double applyScaleFactor(int scale, int value) {
        return scale == 0 || scale == 255 || value == 0 ? (double)value : (double)value * Math.pow(10.0, -scale);
    }

    TimeInterval[] readTimeIntervals(int n, int startIndex) {
        TimeInterval[] result = new TimeInterval[n];
        for (int i = 0; i < n; ++i) {
            TimeInterval ti = new TimeInterval();
            ti.statProcessType = this.getOctet(startIndex++);
            ti.timeIncrementType = this.getOctet(startIndex++);
            ti.timeRangeUnit = this.getOctet(startIndex++);
            ti.timeRangeLength = GribNumbers.int4(this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++));
            ti.timeIncrementUnit = this.getOctet(startIndex++);
            ti.timeIncrement = GribNumbers.int4(this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++), this.getOctet(startIndex++));
            result[i] = ti;
        }
        return result;
    }

    public static class TimeInterval {
        public int statProcessType;
        public int timeIncrementType;
        public int timeRangeUnit;
        public int timeRangeLength;
        public int timeIncrementUnit;
        public int timeIncrement;

        public void show(Formatter f) {
            f.format("  TimeInterval: statProcessType= %d, timeIncrementType= %d, timeRangeUnit= %d, timeRangeLength= %d, timeIncrementUnit= %d, timeIncrement=%d%n", this.statProcessType, this.timeIncrementType, this.timeRangeUnit, this.timeRangeLength, this.timeIncrementUnit, this.timeIncrement);
        }
    }

    private static class Grib2Pds48
    extends Grib2Pds
    implements PdsAerosol {
        Grib2Pds48(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public int getAerosolType() {
            return GribNumbers.uint2(this.getOctet(12), this.getOctet(13));
        }

        @Override
        public double getAerosolIntervalSizeType() {
            return this.getOctet(14);
        }

        @Override
        public double getAerosolSize1() {
            return this.getScaledValue(15);
        }

        @Override
        public double getAerosolSize2() {
            return this.getScaledValue(20);
        }

        @Override
        public double getAerosolIntervalWavelengthType() {
            return this.getOctet(25);
        }

        @Override
        public double getAerosolWavelength1() {
            return this.getScaledValue(26);
        }

        @Override
        public double getAerosolWavelength2() {
            return this.getScaledValue(31);
        }

        @Override
        public int getGenProcessType() {
            return this.getOctet(36);
        }

        @Override
        public int getBackProcessId() {
            return this.getOctet(37);
        }

        @Override
        public int getGenProcessId() {
            return this.getOctet(38);
        }

        public int getHoursAfterCutoff() {
            return GribNumbers.int2(this.getOctet(39), this.getOctet(40));
        }

        public int getMinutesAfterCutoff() {
            return this.getOctet(41);
        }

        @Override
        public int getTimeUnit() {
            return this.getOctet(42);
        }

        @Override
        public int getForecastTime() {
            return GribNumbers.int4(this.getOctet(43), this.getOctet(44), this.getOctet(45), this.getOctet(46));
        }

        @Override
        public int getLevelType1() {
            return this.getOctet(47);
        }

        @Override
        public int getLevelScale1() {
            return this.getOctet(48);
        }

        @Override
        public double getLevelValue1() {
            return this.getScaledValue(48);
        }

        @Override
        public int getLevelType2() {
            return this.getOctet(53);
        }

        @Override
        public int getLevelScale2() {
            return this.getOctet(54);
        }

        @Override
        public double getLevelValue2() {
            return this.getScaledValue(54);
        }

        @Override
        public int templateLength() {
            return 58;
        }
    }

    private static class Grib2Pds31
    extends Grib2Pds {
        static int octetsPerBand = 11;

        Grib2Pds31(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public int getTimeUnit() {
            return 0;
        }

        @Override
        public int getForecastTime() {
            return 0;
        }

        @Override
        public int getGenProcessId() {
            return this.getOctet(13);
        }

        public int getNumSatelliteBands() {
            return this.getOctet(14);
        }

        public SatelliteBand[] getSatelliteBands() {
            int nb = this.getNumSatelliteBands();
            SatelliteBand[] result = new SatelliteBand[nb];
            int pos = 15;
            for (int i = 0; i < nb; ++i) {
                SatelliteBand sb = new SatelliteBand();
                sb.number = GribNumbers.int2(this.getOctet(pos), this.getOctet(pos + 1));
                sb.series = GribNumbers.int2(this.getOctet(pos + 2), this.getOctet(pos + 3));
                sb.instrumentType = GribNumbers.int2(this.getOctet(pos + 4), this.getOctet(pos + 5));
                int scaleFactor = this.getOctetSigned(pos + 6);
                int svalue = GribNumbers.int4(this.getOctet(pos + 7), this.getOctet(pos + 8), this.getOctet(pos + 9), this.getOctet(pos + 10));
                sb.value = this.applyScaleFactor(scaleFactor, svalue);
                pos += octetsPerBand;
                result[i] = sb;
            }
            return result;
        }

        @Override
        public int templateLength() {
            return 14 + this.getNumSatelliteBands() * octetsPerBand;
        }
    }

    public static class SatelliteBand {
        public int series;
        public int number;
        public int instrumentType;
        public double value;
    }

    private static class Grib2Pds30
    extends Grib2Pds {
        Grib2Pds30(byte[] input) throws IOException {
            super(input);
            log.debug("Product Definition Template 4.30 is deprecated in favor of 4.31 (WMO Manual on Codes");
        }

        @Override
        public int getTimeUnit() {
            return 0;
        }

        @Override
        public int getForecastTime() {
            return 0;
        }

        @Override
        public int getGenProcessId() {
            return this.getOctet(13);
        }

        public int getNumSatelliteBands() {
            return this.getOctet(14);
        }

        public SatelliteBand[] getSatelliteBands() {
            int nb = this.getNumSatelliteBands();
            SatelliteBand[] result = new SatelliteBand[nb];
            int pos = 15;
            for (int i = 0; i < nb; ++i) {
                SatelliteBand sb = new SatelliteBand();
                sb.number = GribNumbers.int2(this.getOctet(pos), this.getOctet(pos + 1));
                sb.series = GribNumbers.int2(this.getOctet(pos + 2), this.getOctet(pos + 3));
                sb.instrumentType = this.getOctet(pos + 4);
                int scaleFactor = this.getOctetSigned(pos + 5);
                int svalue = GribNumbers.int4(this.getOctet(pos + 6), this.getOctet(pos + 7), this.getOctet(pos + 8), this.getOctet(pos + 9));
                sb.value = this.applyScaleFactor(scaleFactor, svalue);
                pos += 10;
                result[i] = sb;
            }
            return result;
        }

        @Override
        public int templateLength() {
            return 14 + this.getNumSatelliteBands() * 10;
        }
    }

    private static class Grib2Pds10
    extends Grib2Pds6
    implements PdsInterval {
        Grib2Pds10(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public CalendarDate getIntervalTimeEnd() {
            return this.calcTime(36);
        }

        @Override
        public int getNumberTimeRanges() {
            return this.getOctet(43);
        }

        @Override
        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(44), this.getOctet(45), this.getOctet(46), this.getOctet(47));
        }

        @Override
        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 48);
        }

        @Override
        public int getStatisticalProcessType() {
            return super.getStatisticalProcessType();
        }

        @Override
        public int templateLength() {
            return 48 + this.getNumberTimeRanges() * 12;
        }

        @Override
        public long getIntervalHash() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.input, 48, this.getNumberTimeRanges() * 12);
            return crc32.getValue();
        }
    }

    private static class Grib2Pds6
    extends Grib2Pds0
    implements PdsPercentile {
        Grib2Pds6(byte[] input) throws IOException {
            super(input);
        }

        public boolean isPercentile() {
            return true;
        }

        @Override
        public int getPercentileValue() {
            return this.getOctet(35);
        }

        @Override
        public int templateLength() {
            return 36;
        }
    }

    private static class Grib2Pds8
    extends Grib2Pds0
    implements PdsInterval {
        Grib2Pds8(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public CalendarDate getIntervalTimeEnd() {
            return this.calcTime(35);
        }

        @Override
        public int getNumberTimeRanges() {
            return this.getOctet(42);
        }

        @Override
        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(43), this.getOctet(44), this.getOctet(45), this.getOctet(46));
        }

        @Override
        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 47);
        }

        @Override
        public int getStatisticalProcessType() {
            return super.getStatisticalProcessType();
        }

        @Override
        public int templateLength() {
            return 46 + this.getNumberTimeRanges() * 12;
        }

        @Override
        public void show(Formatter f) {
            super.show(f);
            try {
                f.format("%n   Grib2Pds8: endInterval=%s%n", this.getIntervalTimeEnd());
                for (TimeInterval ti : this.getTimeIntervals()) {
                    ti.show(f);
                }
            }
            catch (Throwable t) {
                f.format("%n   Grib2Pds8: endInterval error=%s%n", t.getMessage());
            }
        }

        @Override
        public long getIntervalHash() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.input, 46, 12);
            if (this.getNumberTimeRanges() > 1) {
                crc32.update(this.input, 58, 1);
            }
            return crc32.getValue();
        }
    }

    private static class Grib2Pds9
    extends Grib2Pds5
    implements PdsInterval {
        Grib2Pds9(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public CalendarDate getIntervalTimeEnd() {
            return this.calcTime(48);
        }

        @Override
        public int getNumberTimeRanges() {
            return this.getOctet(55);
        }

        @Override
        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(56), this.getOctet(57), this.getOctet(58), this.getOctet(59));
        }

        @Override
        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 60);
        }

        @Override
        public int getStatisticalProcessType() {
            return super.getStatisticalProcessType();
        }

        @Override
        public int templateLength() {
            return 59 + this.getNumberTimeRanges() * 12;
        }

        @Override
        public long getIntervalHash() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.input, 59, this.getNumberTimeRanges() * 12);
            return crc32.getValue();
        }

        @Override
        public void show(Formatter f) {
            super.show(f);
            f.format("%n   Grib2Pds9: endInterval=%s%n", this.getIntervalTimeEnd());
            for (TimeInterval ti : this.getTimeIntervals()) {
                ti.show(f);
            }
        }
    }

    private static class Grib2Pds5
    extends Grib2Pds0
    implements PdsProbability {
        int probHash = 0;

        Grib2Pds5(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public boolean isProbability() {
            return true;
        }

        @Override
        public int getForecastProbabilityNumber() {
            return this.getOctet(35);
        }

        @Override
        public int getNumberForecastProbabilities() {
            return this.getOctet(36);
        }

        @Override
        public int getProbabilityType() {
            return this.getOctet(37);
        }

        @Override
        public double getProbabilityLowerLimit() {
            int scale = this.getOctetSigned(38);
            int value = GribNumbers.int4(this.getOctet(39), this.getOctet(40), this.getOctet(41), this.getOctet(42));
            return this.applyScaleFactor(scale, value);
        }

        @Override
        public double getProbabilityUpperLimit() {
            int scale = this.getOctetSigned(43);
            int value = GribNumbers.int4(this.getOctet(44), this.getOctet(45), this.getOctet(46), this.getOctet(47));
            return this.applyScaleFactor(scale, value);
        }

        @Override
        public int getProbabilityHashcode() {
            if (this.probHash == 0) {
                int result = 0;
                switch (this.getProbabilityType()) {
                    case 0: 
                    case 3: {
                        double prob1 = this.getProbabilityLowerLimit();
                        long temp = prob1 != 0.0 ? Double.doubleToLongBits(prob1) : 0L;
                        result = (int)(temp ^ temp >>> 32);
                        break;
                    }
                    case 1: 
                    case 4: {
                        double prob2 = this.getProbabilityUpperLimit();
                        long temp = prob2 != 0.0 ? Double.doubleToLongBits(prob2) : 0L;
                        result = (int)(temp ^ temp >>> 32);
                        break;
                    }
                    case 2: {
                        double prob1 = this.getProbabilityLowerLimit();
                        double prob2 = this.getProbabilityUpperLimit();
                        long temp = prob1 != 0.0 ? Double.doubleToLongBits(prob1) : 0L;
                        result = (int)(temp ^ temp >>> 32);
                        temp = prob2 != 0.0 ? Double.doubleToLongBits(prob2) : 0L;
                        result = 31 * result + (int)(temp ^ temp >>> 32);
                        break;
                    }
                }
                this.probHash = result = 31 * result + this.getProbabilityType();
            }
            return this.probHash;
        }

        @Override
        public String getProbabilityName() {
            Formatter f = new Formatter();
            int scale1 = Math.max(1, this.getOctet(38));
            int scale2 = Math.max(1, this.getOctet(43));
            switch (this.getProbabilityType()) {
                case 0: {
                    f.format("below_%s", Format.dfrac((double)this.getProbabilityLowerLimit(), (int)scale1));
                    break;
                }
                case 1: {
                    f.format("above_%s", Format.dfrac((double)this.getProbabilityUpperLimit(), (int)scale2));
                    break;
                }
                case 2: {
                    if (this.getProbabilityLowerLimit() == this.getProbabilityUpperLimit()) {
                        f.format("equals_%s", Format.dfrac((double)this.getProbabilityLowerLimit(), (int)scale1));
                        break;
                    }
                    f.format("between_%s_and_%s", Format.dfrac((double)this.getProbabilityLowerLimit(), (int)scale1), Format.dfrac((double)this.getProbabilityUpperLimit(), (int)scale2));
                    break;
                }
                case 3: {
                    f.format("above_%s", Format.dfrac((double)this.getProbabilityLowerLimit(), (int)scale1));
                    break;
                }
                case 4: {
                    f.format("below_%s", Format.dfrac((double)this.getProbabilityUpperLimit(), (int)scale2));
                    break;
                }
                default: {
                    f.format("UknownProbType=%d", this.getProbabilityType());
                }
            }
            String result = StringUtil2.removeFromEnd((String)f.toString(), (int)48);
            return StringUtil2.removeFromEnd((String)result, (int)46);
        }

        @Override
        public int templateLength() {
            return 47;
        }
    }

    private static class Grib2Pds12
    extends Grib2Pds2
    implements PdsInterval {
        Grib2Pds12(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public CalendarDate getIntervalTimeEnd() {
            return this.calcTime(37);
        }

        @Override
        public int getNumberTimeRanges() {
            return this.getOctet(44);
        }

        @Override
        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(45), this.getOctet(46), this.getOctet(47), this.getOctet(48));
        }

        @Override
        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 49);
        }

        @Override
        public int getStatisticalProcessType() {
            return super.getStatisticalProcessType();
        }

        @Override
        public int templateLength() {
            return 48 + this.getNumberTimeRanges() * 12;
        }

        @Override
        public long getIntervalHash() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.input, 48, this.getNumberTimeRanges() * 12);
            return crc32.getValue();
        }

        @Override
        public void show(Formatter f) {
            super.show(f);
            f.format("%n   Grib2Pds8: endInterval=%s%n", this.getIntervalTimeEnd());
            for (TimeInterval ti : this.getTimeIntervals()) {
                ti.show(f);
            }
        }
    }

    private static class Grib2Pds2
    extends Grib2Pds0
    implements PdsEnsembleDerived {
        Grib2Pds2(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public boolean isEnsembleDerived() {
            return true;
        }

        @Override
        public int getDerivedForecastType() {
            return this.getOctet(35);
        }

        @Override
        public int getNumberEnsembleForecasts() {
            return this.getOctet(36);
        }

        @Override
        public int templateLength() {
            return 36;
        }
    }

    private static class Grib2Pds11
    extends Grib2Pds1
    implements PdsInterval {
        Grib2Pds11(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public CalendarDate getIntervalTimeEnd() {
            return this.calcTime(38);
        }

        @Override
        public int getNumberTimeRanges() {
            return this.getOctet(45);
        }

        @Override
        public final int getNumberMissing() {
            return GribNumbers.int4(this.getOctet(46), this.getOctet(47), this.getOctet(48), this.getOctet(49));
        }

        @Override
        public TimeInterval[] getTimeIntervals() {
            return this.readTimeIntervals(this.getNumberTimeRanges(), 50);
        }

        @Override
        public int getStatisticalProcessType() {
            return super.getStatisticalProcessType();
        }

        @Override
        public int templateLength() {
            return 49 + this.getNumberTimeRanges() * 12;
        }

        @Override
        public long getIntervalHash() {
            CRC32 crc32 = new CRC32();
            crc32.update(this.input, 49, this.getNumberTimeRanges() * 12);
            return crc32.getValue();
        }

        @Override
        public void show(Formatter f) {
            super.show(f);
            f.format("%n   Grib2Pds8: endInterval=%s%n", this.getIntervalTimeEnd());
            for (TimeInterval ti : this.getTimeIntervals()) {
                ti.show(f);
            }
        }
    }

    private static class Grib2Pds1
    extends Grib2Pds0
    implements PdsEnsemble {
        Grib2Pds1(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public boolean isEnsemble() {
            return true;
        }

        @Override
        public int getPerturbationType() {
            return this.getOctet(35);
        }

        @Override
        public int getPerturbationNumber() {
            return this.getOctet(36);
        }

        @Override
        public int getNumberEnsembleForecasts() {
            return this.getOctet(37);
        }

        @Override
        public int templateLength() {
            return 37;
        }
    }

    private static class Grib2Pds15
    extends Grib2Pds0 {
        Grib2Pds15(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public int getStatisticalProcessType() {
            return this.getOctet(35);
        }

        public int getSpatialProcessType() {
            return this.getOctet(36);
        }

        public int getNSpatialDataPoints() {
            return this.getOctet(37);
        }
    }

    private static class Grib2Pds0
    extends Grib2Pds {
        Grib2Pds0(byte[] input) throws IOException {
            super(input);
        }

        @Override
        public int getGenProcessType() {
            return this.getOctet(12);
        }

        @Override
        public int getBackProcessId() {
            return this.getOctet(13);
        }

        @Override
        public int getGenProcessId() {
            return this.getOctet(14);
        }

        public int getHoursAfterCutoff() {
            return GribNumbers.int2(this.getOctet(15), this.getOctet(16));
        }

        public int getMinutesAfterCutoff() {
            return this.getOctet(17);
        }

        @Override
        public int getTimeUnit() {
            return this.getOctet(18);
        }

        @Override
        public int getLevelType1() {
            return this.getOctet(23);
        }

        @Override
        public double getLevelValue1() {
            return this.getScaledValue(24);
        }

        public int getLevelScale() {
            return this.getOctet(24);
        }

        @Override
        public int getLevelType2() {
            return this.getOctet(29);
        }

        @Override
        public double getLevelValue2() {
            return this.getScaledValue(30);
        }

        @Override
        public int templateLength() {
            return 34;
        }
    }

    public static interface PdsProbability {
        public int getForecastProbabilityNumber();

        public int getNumberForecastProbabilities();

        public int getProbabilityType();

        public double getProbabilityLowerLimit();

        public double getProbabilityUpperLimit();

        public int getProbabilityHashcode();

        public String getProbabilityName();
    }

    public static interface PdsPercentile {
        public int getPercentileValue();
    }

    public static interface PdsEnsembleDerived {
        public int getDerivedForecastType();

        public int getNumberEnsembleForecasts();
    }

    public static interface PdsEnsemble {
        public int getPerturbationType();

        public int getPerturbationNumber();

        public int getNumberEnsembleForecasts();
    }

    public static interface PdsInterval {
        public int getStatisticalProcessType();

        public CalendarDate getIntervalTimeEnd();

        public int getForecastTime();

        public int getNumberTimeRanges();

        public int getNumberMissing();

        public TimeInterval[] getTimeIntervals();

        public long getIntervalHash();
    }

    public static interface PdsAerosol {
        public int getAerosolType();

        public double getAerosolIntervalSizeType();

        public double getAerosolSize1();

        public double getAerosolSize2();

        public double getAerosolIntervalWavelengthType();

        public double getAerosolWavelength1();

        public double getAerosolWavelength2();
    }
}

