/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import com.google.protobuf.ByteString;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.partition.PartitionManager;
import ucar.coord.Coordinate;
import ucar.coord.CoordinateEns;
import ucar.coord.CoordinateRuntime;
import ucar.coord.CoordinateSharer;
import ucar.coord.CoordinateTime;
import ucar.coord.CoordinateTime2D;
import ucar.coord.CoordinateTimeAbstract;
import ucar.coord.CoordinateTimeIntv;
import ucar.coord.CoordinateUnionizer;
import ucar.coord.CoordinateVert;
import ucar.coord.SparseArray;
import ucar.coord.TwoDTimeInventory;
import ucar.ma2.Section;
import ucar.nc2.constants.CDM;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.GribCollectionProto;
import ucar.nc2.grib.collection.GribCollectionWriter;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.grib.collection.PartitionCollectionProto;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.util.Parameter;

public abstract class GribPartitionBuilder {
    protected static final int version = 1;
    protected final PartitionManager partitionManager;
    protected String name;
    protected File directory;
    protected Logger logger;
    protected PartitionCollection result;
    private GribCollectionWriter writer;

    protected GribPartitionBuilder(String name, File directory, PartitionManager tpc, Logger logger) {
        this.name = name;
        this.directory = directory;
        this.partitionManager = tpc;
        this.logger = logger;
    }

    public boolean updateNeeded(CollectionUpdateType ff) throws IOException {
        if (ff == CollectionUpdateType.never) {
            return false;
        }
        if (ff == CollectionUpdateType.always) {
            return true;
        }
        File idx = GribCollection.getFileInCache(this.partitionManager.getIndexFilename());
        if (!idx.exists()) {
            return true;
        }
        if (ff == CollectionUpdateType.nocheck) {
            return false;
        }
        return this.needsUpdate(idx.lastModified());
    }

    private boolean needsUpdate(long collectionLastModified) throws IOException {
        for (MCollection dcm : this.partitionManager.makePartitions(CollectionUpdateType.test)) {
            File idxFile = GribCollection.getFileInCache(dcm.getIndexFilename());
            if (!idxFile.exists()) {
                return true;
            }
            if (collectionLastModified >= idxFile.lastModified()) continue;
            return true;
        }
        return false;
    }

    public boolean createPartitionedIndex(CollectionUpdateType forcePartition, CollectionUpdateType forceChildren, Formatter errlog) throws IOException {
        long start = System.currentTimeMillis();
        if (errlog == null) {
            errlog = new Formatter();
        }
        for (MCollection dcmp : this.partitionManager.makePartitions(forcePartition)) {
            dcmp.putAuxInfo("fcConfig", this.partitionManager.getAuxInfo("fcConfig"));
            this.result.addPartition(dcmp);
        }
        this.result.sortPartitions();
        int n = this.result.getPartitionSize();
        if (n == 0) {
            errlog.format("ERR Nothing in this partition = %s%n", this.result.getName());
            this.logger.error(" Nothing in this partition = {}", (Object)this.result.getName());
            return false;
        }
        int idx = this.partitionManager.getProtoIndex(n);
        PartitionCollection.Partition canon = this.result.getPartition(idx);
        this.logger.debug("     Using canonical partition {}", (Object)canon.getDcm().getCollectionName());
        try (GribCollection gc = canon.makeGribCollection(forceChildren);){
            this.result.copyInfo(gc);
            this.result.isPartitionOfPartitions = gc instanceof PartitionCollection;
        }
        GribCollection.Dataset ds2D = this.makeDataset2D(forceChildren, errlog);
        if (ds2D == null) {
            errlog.format(" ERR makeDataset2D failed, index not written on %s%n", this.result.getName());
            this.logger.error(" makeDataset2D failed, index not written on {} errors = \n{}", (Object)this.result.getName(), (Object)errlog.toString());
            return false;
        }
        this.result.makeHorizCS();
        this.makeDatasetBest(ds2D, errlog);
        this.writeIndex(this.result, errlog);
        long took = System.currentTimeMillis() - start;
        errlog.format(" INFO CreatePartitionedIndex took %d msecs%n", took);
        return true;
    }

    private GribCollection.Dataset makeDataset2D(CollectionUpdateType forceChildren, Formatter f) throws IOException {
        Object ds2dp;
        FeatureCollectionConfig config = (FeatureCollectionConfig)this.partitionManager.getAuxInfo("fcConfig");
        FeatureCollectionConfig.GribIntvFilter intvMap = config != null ? config.gribConfig.intvFilter : null;
        GribCollection.Dataset ds2D = this.result.makeDataset(GribCollection.Type.TwoD);
        int npart = this.result.getPartitionSize();
        HashMap<Integer, GroupPartitions> groupMap = new HashMap<Integer, GroupPartitions>(40);
        CoordinateRuntime.Builder2 runtimeAllBuilder = new CoordinateRuntime.Builder2(null);
        int countPartition = 0;
        for (PartitionCollection.Partition tpp : this.result.getPartitions()) {
            GribCollection gc = tpp.makeGribCollection(forceChildren);
            Throwable throwable = null;
            try {
                if (gc == null) {
                    tpp.setBad(true);
                    this.logger.warn("Bad partition - skip " + tpp.getName());
                    continue;
                }
                CoordinateRuntime partRuntime = gc.getMasterRuntime();
                runtimeAllBuilder.addAll(partRuntime);
                ds2dp = gc.getDatasetCanonical();
                int groupIdx = 0;
                for (GribCollection.GroupGC groupGC : ((GribCollection.Dataset)ds2dp).groups) {
                    GroupPartitions gs = (GroupPartitions)groupMap.get(groupGC.getGdsHash());
                    if (gs == null) {
                        gs = new GroupPartitions(ds2D.addGroupCopy(groupGC), npart);
                        groupMap.put(groupGC.getGdsHash(), gs);
                    }
                    gs.componentGroups[countPartition] = groupGC;
                    gs.componentGroupIndex[countPartition] = groupIdx++;
                }
            }
            catch (Throwable partRuntime) {
                throwable = partRuntime;
                throw partRuntime;
            }
            finally {
                if (gc == null) continue;
                if (throwable != null) {
                    try {
                        gc.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                gc.close();
                continue;
            }
            ++countPartition;
        }
        ArrayList groupPartitions = new ArrayList(groupMap.values());
        this.result.masterRuntime = (CoordinateRuntime)runtimeAllBuilder.finish();
        this.result.run2part = new int[this.result.masterRuntime.getSize()];
        int partIdx = 0;
        for (PartitionCollection.Partition tpp : this.result.getPartitions()) {
            if (tpp.isBad()) continue;
            GribCollection gc = tpp.makeGribCollection(forceChildren);
            ds2dp = null;
            try {
                CoordinateRuntime partRuntime = gc.getMasterRuntime();
                for (Object object : partRuntime.getValues()) {
                    int idx = this.result.masterRuntime.getIndex(object);
                    this.result.run2part[idx] = partIdx;
                }
            }
            catch (Throwable partRuntime) {
                ds2dp = partRuntime;
                throw partRuntime;
            }
            finally {
                if (gc != null) {
                    if (ds2dp != null) {
                        try {
                            gc.close();
                        }
                        catch (Throwable partRuntime) {
                            ((Throwable)ds2dp).addSuppressed(partRuntime);
                        }
                    } else {
                        gc.close();
                    }
                }
            }
            ++partIdx;
        }
        for (GroupPartitions gp : groupPartitions) {
            GribCollection.GroupGC resultGroup = gp.resultGroup;
            gp.makeVariableIndexPartitioned();
            String gname = resultGroup.getId();
            String gdesc = resultGroup.getDescription();
            for (int partno = 0; partno < npart; ++partno) {
                GribCollection.GroupGC groupGC = gp.componentGroups[partno];
                if (groupGC == null) {
                    f.format(" INFO canonical group %s not in partition %s%n", gname, this.result.getPartition(partno).getName());
                    continue;
                }
                int groupIdx = gp.componentGroupIndex[partno];
                for (int varIdx = 0; varIdx < groupGC.variList.size(); ++varIdx) {
                    GribCollection.VariableIndex vi = groupGC.variList.get(varIdx);
                    int flag = 0;
                    PartitionCollection.VariableIndexPartitioned vip = (PartitionCollection.VariableIndexPartitioned)resultGroup.findVariableByHash(vi.cdmHash);
                    vip.addPartition(partno, groupIdx, varIdx, flag, vi);
                }
            }
            boolean isDense = false;
            CoordinateSharer coordinateSharer = new CoordinateSharer(isDense);
            for (GribCollection.VariableIndex viResult : resultGroup.variList) {
                CoordinateUnionizer unionizer = new CoordinateUnionizer(viResult.getVarid(), intvMap);
                for (int partno = 0; partno < npart; ++partno) {
                    GribCollection.VariableIndex vi;
                    GribCollection.GroupGC group = gp.componentGroups[partno];
                    if (group == null || (vi = group.findVariableByHash(viResult.cdmHash)) == null) continue;
                    unionizer.addCoords(vi.getCoordinates());
                }
                viResult.coords = unionizer.finish();
                coordinateSharer.addCoords(viResult.coords);
            }
            coordinateSharer.finish();
            resultGroup.coords = coordinateSharer.getUnionCoords();
            ArrayList<CoordinateTime2D> time2DCoords = new ArrayList<CoordinateTime2D>();
            HashMap<CoordinateRuntime, CoordinateRuntime> runtimes = new HashMap<CoordinateRuntime, CoordinateRuntime>();
            for (Coordinate coord : resultGroup.coords) {
                Coordinate.Type type = coord.getType();
                switch (type) {
                    case runtime: {
                        CoordinateRuntime reftime = (CoordinateRuntime)coord;
                        runtimes.put(reftime, reftime);
                        break;
                    }
                    case time2D: {
                        CoordinateTime2D t2d = (CoordinateTime2D)coord;
                        time2DCoords.add(t2d);
                    }
                }
            }
            for (CoordinateTime2D t2d : time2DCoords) {
                CoordinateRuntime runtime2D = t2d.getRuntimeCoordinate();
                CoordinateRuntime runtime = (CoordinateRuntime)runtimes.get(runtime2D);
                if (runtime != null) continue;
                this.logger.warn("HEY assignRuntimeNames failed on {} group {}", (Object)t2d.getName(), (Object)resultGroup.getId());
            }
            for (GribCollection.VariableIndex viResult : resultGroup.variList) {
                viResult.coordIndex = coordinateSharer.reindex2shared(viResult.coords);
                if (this.result.isPartitionOfPartitions) {
                    viResult.twot = null;
                    continue;
                }
                this.makeMissing(isDense, gp, this.result, viResult);
            }
        }
        return ds2D;
    }

    private void makeMissing(boolean isDense, GroupPartitions gp, PartitionCollection result, GribCollection.VariableIndex viResult) throws IOException {
        Coordinate cr = viResult.getCoordinate(Coordinate.Type.runtime);
        if (cr == null) {
            this.logger.error("Missing runtime coordinate vi=" + viResult.toStringShort());
            return;
        }
        CoordinateTimeAbstract ct = viResult.getCoordinateTime();
        if (ct == null) {
            this.logger.error("Missing time coordinate vi=" + viResult.toStringShort());
            return;
        }
        boolean isTwoD = ct instanceof CoordinateTime2D;
        CoordinateTime2D ct2D = isTwoD ? (CoordinateTime2D)ct : null;
        int ntimes = ct instanceof CoordinateTime2D ? ((CoordinateTime2D)ct).getNtimes() : ct.getSize();
        viResult.twot = new TwoDTimeInventory(cr.getSize(), ntimes);
        HashMap<Object, Integer> ctMap = new HashMap<Object, Integer>(2 * ct.getSize());
        for (int i = 0; i < ct.getSize(); ++i) {
            ctMap.put(ct.getValue(i), i);
        }
        int runIdx = 0;
        for (int partno : result.run2part) {
            GribCollection.VariableIndex vi;
            GribCollection.GroupGC group = gp.componentGroups[partno];
            if (group == null || (vi = group.findVariableByHash(viResult.cdmHash)) == null) continue;
            CoordinateTimeAbstract ctGC = vi.getCoordinateTime();
            CoordinateTime2D ctGC2d = isTwoD ? (CoordinateTime2D)ctGC : null;
            vi.readRecords();
            SparseArray<GribCollection.Record> sa = vi.getSparseArray();
            Section s = new Section(sa.getShape());
            Section.Iterator iter = s.getIterator(sa.getShape());
            int[] index = new int[sa.getRank()];
            while (iter.hasNext()) {
                Integer timeIdxR;
                Object val;
                int linearIndex = iter.next(index);
                if (sa.getContent(linearIndex) == null) continue;
                int timeIdxP = index[1];
                if (isTwoD) {
                    val = ctGC2d.getOrgValue(0, timeIdxP, false);
                    ct2D.getIndex((CoordinateTime2D.Time2D)val, index);
                    timeIdxR = index[1];
                    assert (runIdx == index[0]);
                    assert (index[1] >= 0);
                } else {
                    val = ctGC.getValue(timeIdxP);
                    timeIdxR = (Integer)ctMap.get(val);
                    assert (timeIdxR != null);
                }
                viResult.twot.add(runIdx, timeIdxR);
            }
            ++runIdx;
        }
    }

    private void makeDatasetBest(GribCollection.Dataset ds2D, Formatter f) throws IOException {
        GribCollection.Dataset dsa = this.result.makeDataset(GribCollection.Type.Best);
        int npart = this.result.getPartitionSize();
        for (GribCollection.GroupGC group2D : ds2D.groups) {
            GribCollection.GroupGC groupB = dsa.addGroupCopy(group2D);
            groupB.isTwod = false;
            CoordinateRuntime rtc = null;
            for (Coordinate coord : group2D.coords) {
                if (coord.getType() != Coordinate.Type.runtime) continue;
                rtc = (CoordinateRuntime)coord;
            }
            assert (rtc != null);
            List<Double> runOffset = rtc.getOffsetsInTimeUnits();
            for (Coordinate coord : group2D.coords) {
                if (coord instanceof CoordinateTimeAbstract) {
                    CoordinateTimeAbstract best = ((CoordinateTimeAbstract)coord).makeBestTimeCoordinate(runOffset);
                    groupB.coords.add(best);
                    continue;
                }
                groupB.coords.add(coord);
            }
            for (GribCollection.VariableIndex vi2d : group2D.variList) {
                CoordinateTimeAbstract timeBest;
                CoordinateTimeAbstract time2d;
                PartitionCollection.VariableIndexPartitioned vip = this.result.makeVariableIndexPartitioned(groupB, vi2d, npart);
                vip.twot = null;
                int timeIdx = vi2d.getCoordinateIndex(Coordinate.Type.time2D);
                if (timeIdx >= 0) {
                    time2d = (CoordinateTime2D)group2D.coords.get(timeIdx);
                    timeBest = (CoordinateTimeAbstract)groupB.coords.get(timeIdx);
                    vip.time2runtime = ((CoordinateTime2D)time2d).makeTime2RuntimeMap(timeBest, ((PartitionCollection.VariableIndexPartitioned)vi2d).twot);
                    continue;
                }
                timeIdx = vi2d.getCoordinateIndex(Coordinate.Type.time);
                if (timeIdx >= 0) {
                    time2d = (CoordinateTime)group2D.coords.get(timeIdx);
                    timeBest = (CoordinateTime)groupB.coords.get(timeIdx);
                    vip.time2runtime = ((CoordinateTime)time2d).makeTime2RuntimeMap(runOffset, (CoordinateTime)timeBest, ((PartitionCollection.VariableIndexPartitioned)vi2d).twot);
                    continue;
                }
                timeIdx = vi2d.getCoordinateIndex(Coordinate.Type.timeIntv);
                if (timeIdx < 0) continue;
                time2d = (CoordinateTimeIntv)group2D.coords.get(timeIdx);
                timeBest = (CoordinateTimeIntv)groupB.coords.get(timeIdx);
                vip.time2runtime = ((CoordinateTimeIntv)time2d).makeTime2RuntimeMap(runOffset, (CoordinateTimeIntv)timeBest, ((PartitionCollection.VariableIndexPartitioned)vi2d).twot);
            }
        }
    }

    protected abstract String getMagicStart();

    protected boolean writeIndex(PartitionCollection pc, Formatter f) throws IOException {
        File idxFile = GribCollection.getFileInCache(this.partitionManager.getIndexFilename());
        if (idxFile.exists() && !idxFile.delete()) {
            this.logger.error("gc2tp cant delete " + idxFile.getPath());
        }
        this.writer = new GribCollectionWriter();
        try (RandomAccessFile raf = new RandomAccessFile(idxFile.getPath(), "rw");){
            raf.order(0);
            raf.write(this.getMagicStart().getBytes(CDM.utf8Charset));
            raf.writeInt(1);
            raf.writeLong(0L);
            GribCollectionProto.GribCollection.Builder indexBuilder = GribCollectionProto.GribCollection.newBuilder();
            indexBuilder.setName(pc.getName());
            indexBuilder.setTopDir(pc.getDirectory().getPath());
            int count = 0;
            for (PartitionCollection.Partition part : pc.partitions) {
                GribCollectionProto.MFile.Builder b = GribCollectionProto.MFile.newBuilder();
                b.setFilename(part.getFilename());
                b.setLastModified(part.getLastModified());
                b.setIndex(count++);
                indexBuilder.addMfiles(b.build());
            }
            indexBuilder.setCenter(pc.getCenter());
            indexBuilder.setSubcenter(pc.getSubcenter());
            indexBuilder.setMaster(pc.getMaster());
            indexBuilder.setLocal(pc.getLocal());
            indexBuilder.setGenProcessId(pc.getGenProcessId());
            indexBuilder.setGenProcessType(pc.getGenProcessType());
            indexBuilder.setBackProcessId(pc.getBackProcessId());
            indexBuilder.setMasterRuntime(this.writer.writeCoordProto(pc.getMasterRuntime()));
            for (GribCollection.HorizCoordSys hcs : pc.horizCS) {
                indexBuilder.addGds(this.writer.writeGdsProto(hcs));
            }
            for (Object ds : pc.datasets) {
                indexBuilder.addDataset(this.writeDatasetProto(pc, (GribCollection.Dataset)ds));
            }
            ArrayList<Integer> run2partList = new ArrayList<Integer>();
            if (pc.run2part != null) {
                for (Object part : (Object)pc.run2part) {
                    run2partList.add((int)part);
                }
                indexBuilder.setExtension(PartitionCollectionProto.run2Part, run2partList);
            }
            ArrayList<PartitionCollectionProto.Partition> partProtoList = new ArrayList<PartitionCollectionProto.Partition>();
            for (PartitionCollection.Partition part : pc.partitions) {
                partProtoList.add(this.writePartitionProto(part));
            }
            indexBuilder.setExtension(PartitionCollectionProto.partitions, partProtoList);
            indexBuilder.setExtension(PartitionCollectionProto.isPartitionOfPartitions, pc.isPartitionOfPartitions);
            GribCollectionProto.GribCollection index = indexBuilder.build();
            byte[] b = index.toByteArray();
            NcStream.writeVInt((RandomAccessFile)raf, (int)b.length);
            raf.write(b);
            f.format("Grib2PartitionIndex= %d bytes file size =  %d bytes%n%n", b.length, raf.length());
        }
        return true;
    }

    private GribCollectionProto.Dataset writeDatasetProto(PartitionCollection pc, GribCollection.Dataset ds) throws IOException {
        GribCollectionProto.Dataset.Builder b = GribCollectionProto.Dataset.newBuilder();
        GribCollectionProto.Dataset.Type type = GribCollectionProto.Dataset.Type.valueOf(ds.getType().toString());
        b.setType(type);
        for (GribCollection.GroupGC group : ds.groups) {
            b.addGroups(this.writeGroupProto(pc, group));
        }
        return b.build();
    }

    private GribCollectionProto.Group writeGroupProto(PartitionCollection pc, GribCollection.GroupGC g) throws IOException {
        GribCollectionProto.Group.Builder b = GribCollectionProto.Group.newBuilder();
        b.setGdsIndex(pc.findHorizCS(g.horizCoordSys));
        b.setIsTwod(g.isTwod);
        for (GribCollection.VariableIndex vb : g.variList) {
            b.addVariables(this.writeVariableProto((PartitionCollection.VariableIndexPartitioned)vb));
        }
        for (Coordinate coord : g.coords) {
            switch (coord.getType()) {
                case runtime: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateRuntime)coord));
                    break;
                }
                case time: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTime)coord));
                    break;
                }
                case timeIntv: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTimeIntv)coord));
                    break;
                }
                case time2D: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateTime2D)coord));
                    break;
                }
                case vert: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateVert)coord));
                    break;
                }
                case ens: {
                    b.addCoords(this.writer.writeCoordProto((CoordinateEns)coord));
                }
            }
        }
        if (g.filenose != null) {
            Object object = g.filenose;
            int n = ((Object)object).length;
            for (int i = 0; i < n; ++i) {
                Integer fileno = (int)object[i];
                b.addFileno(fileno);
            }
        }
        return b.build();
    }

    private GribCollectionProto.Variable writeVariableProto(PartitionCollection.VariableIndexPartitioned vp) throws IOException {
        GribCollectionProto.Variable.Builder b = GribCollectionProto.Variable.newBuilder();
        b.setDiscipline(vp.discipline);
        b.setPds(ByteString.copyFrom((byte[])vp.rawPds));
        b.setCdmHash(vp.cdmHash);
        b.setRecordsPos(vp.recordsPos);
        b.setRecordsLen(vp.recordsLen);
        Iterator iterator = vp.coordIndex.iterator();
        while (iterator.hasNext()) {
            int idx = (Integer)iterator.next();
            b.addCoordIdx(idx);
        }
        b.setDensity(vp.density);
        b.setNdups(vp.ndups);
        b.setNrecords(vp.nrecords);
        b.setMissing(vp.missing);
        if (vp.twot != null) {
            for (Object invCount : (Iterator)vp.twot.getCount()) {
                b.addInvCount((int)invCount);
            }
        }
        if (vp.time2runtime != null) {
            for (Object idx : (Iterator)vp.time2runtime) {
                b.addTime2Runtime((int)idx);
            }
        }
        ArrayList<PartitionCollectionProto.PartitionVariable> pvarList = new ArrayList<PartitionCollectionProto.PartitionVariable>();
        for (PartitionCollection.PartitionForVariable2D pvar : vp.getPartitionsForVariable()) {
            pvarList.add(this.writePartitionVariableProto(pvar));
        }
        b.setExtension(PartitionCollectionProto.partition, pvarList);
        return b.build();
    }

    private PartitionCollectionProto.PartitionVariable writePartitionVariableProto(PartitionCollection.PartitionForVariable2D pvar) throws IOException {
        PartitionCollectionProto.PartitionVariable.Builder pb = PartitionCollectionProto.PartitionVariable.newBuilder();
        pb.setPartno(pvar.partno);
        pb.setGroupno(pvar.groupno);
        pb.setVarno(pvar.varno);
        pb.setFlag(pvar.flag);
        pb.setNdups(pvar.ndups);
        pb.setNrecords(pvar.nrecords);
        pb.setMissing(pvar.missing);
        pb.setDensity(pvar.density);
        return pb.build();
    }

    private PartitionCollectionProto.Partition writePartitionProto(PartitionCollection.Partition p) throws IOException {
        PartitionCollectionProto.Partition.Builder b = PartitionCollectionProto.Partition.newBuilder();
        b.setFilename(p.getFilename());
        b.setName(p.getName());
        b.setDirectory(p.getDirectory());
        b.setLastModified(p.getLastModified());
        return b.build();
    }

    protected GribCollectionProto.Parameter writeParamProto(Parameter param) throws IOException {
        GribCollectionProto.Parameter.Builder b = GribCollectionProto.Parameter.newBuilder();
        b.setName(param.getName());
        if (param.isString()) {
            b.setSdata(param.getStringValue());
        } else {
            for (int i = 0; i < param.getLength(); ++i) {
                b.addData(param.getNumericValue(i));
            }
        }
        return b.build();
    }

    private class GroupPartitions {
        GribCollection.GroupGC resultGroup;
        GribCollection.GroupGC[] componentGroups;
        int[] componentGroupIndex;
        int npart;

        GroupPartitions(GribCollection.GroupGC resultGroup, int npart) {
            this.resultGroup = resultGroup;
            this.npart = npart;
            this.componentGroups = new GribCollection.GroupGC[npart];
            this.componentGroupIndex = new int[npart];
        }

        void makeVariableIndexPartitioned() {
            HashMap<Integer, GribCollection.VariableIndex> varMap = new HashMap<Integer, GribCollection.VariableIndex>(2 * this.resultGroup.variList.size());
            for (GribCollection.GroupGC group : this.componentGroups) {
                if (group == null) continue;
                for (GribCollection.VariableIndex vi : group.variList) {
                    varMap.put(vi.cdmHash, vi);
                }
            }
            for (GribCollection.VariableIndex vi : varMap.values()) {
                GribPartitionBuilder.this.result.makeVariableIndexPartitioned(this.resultGroup, vi, this.npart);
            }
        }
    }
}

