/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.collection;

import java.io.File;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import ucar.nc2.NetcdfFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.grib.collection.Grib1Iosp;
import ucar.nc2.grib.collection.GribCollection;
import ucar.nc2.grib.collection.PartitionCollection;
import ucar.nc2.grib.grib1.Grib1SectionProductDefinition;
import ucar.nc2.grib.grib1.tables.Grib1Customizer;
import ucar.nc2.iosp.IOServiceProvider;

public class Grib1Partition
extends PartitionCollection
implements AutoCloseable {
    public Grib1Partition(String name, File directory, FeatureCollectionConfig config, Logger logger) {
        super(name, directory, config, true, logger);
    }

    @Override
    public NetcdfDataset getNetcdfDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC((IOServiceProvider)iosp, null, this.getIndexFilepathInCache(), null);
        return new NetcdfDataset((NetcdfFile)ncfile);
    }

    @Override
    public GridDataset getGridDataset(GribCollection.Dataset ds, GribCollection.GroupGC group, String filename, FeatureCollectionConfig config, Formatter errlog, Logger logger) throws IOException {
        Grib1Iosp iosp = new Grib1Iosp(group, ds.getType());
        GribCollection.NetcdfFileGC ncfile = new GribCollection.NetcdfFileGC((IOServiceProvider)iosp, null, this.getIndexFilepathInCache(), null);
        NetcdfDataset ncd = new NetcdfDataset((NetcdfFile)ncfile);
        return new GridDataset(ncd);
    }

    @Override
    public String makeVariableName(GribCollection.VariableIndex vindex) {
        Grib1Customizer cust1 = (Grib1Customizer)this.cust;
        Grib1SectionProductDefinition pdss = new Grib1SectionProductDefinition(vindex.rawPds);
        return Grib1Iosp.makeVariableName(cust1, pdss);
    }
}

