/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage;

import ucar.nc2.ft2.coverage.CoordAxisHelper;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordAxisBuilder;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.util.Optional;

public class TimeOffsetAxis
extends CoverageCoordAxis1D {
    public TimeOffsetAxis(CoverageCoordAxisBuilder builder) {
        super(builder);
    }

    @Override
    public CoverageCoordAxis copy() {
        return new TimeOffsetAxis(new CoverageCoordAxisBuilder(this));
    }

    public Optional<TimeOffsetAxis> subsetFromTime(SubsetParams params, CalendarDate runDate) {
        CalendarDateRange dateRange;
        Integer stride;
        CalendarDate dateWanted;
        CoordAxisHelper helper = new CoordAxisHelper(this);
        CoverageCoordAxisBuilder builder = null;
        if (params.isTrue("timePresent")) {
            double offset = this.getOffsetInTimeUnits(runDate, CalendarDate.present());
            builder = helper.subsetClosest(offset);
        }
        if ((dateWanted = (CalendarDate)params.get("time")) != null) {
            double offset = this.getOffsetInTimeUnits(runDate, dateWanted);
            builder = helper.subsetClosest(offset);
        }
        if ((stride = (Integer)params.get("timeStride")) == null || stride < 0) {
            stride = 1;
        }
        if ((dateRange = (CalendarDateRange)params.get("timeRange")) != null) {
            double max;
            double min = this.getOffsetInTimeUnits(runDate, dateRange.getStart());
            Optional<CoverageCoordAxisBuilder> buildero = helper.subset(min, max = this.getOffsetInTimeUnits(runDate, dateRange.getEnd()), stride);
            if (buildero.isPresent()) {
                builder = buildero.get();
            } else {
                return Optional.empty(buildero.getErrorMessage());
            }
        }
        assert (builder != null);
        builder.setReferenceDate(runDate);
        return Optional.of(new TimeOffsetAxis(builder));
    }

    public CalendarDate makeDate(CalendarDate runDate, double val) {
        double offset = this.timeHelper.getOffsetInTimeUnits(this.timeHelper.getRefDate(), runDate);
        return this.timeHelper.makeDate(offset + val);
    }

    @Override
    public Optional<CoverageCoordAxis> subset(SubsetParams params) {
        Optional<CoverageCoordAxisBuilder> buildero = this.subsetBuilder(params);
        return !buildero.isPresent() ? Optional.empty(buildero.getErrorMessage()) : Optional.of(new TimeOffsetAxis(buildero.get()));
    }

    @Override
    public Optional<CoverageCoordAxis> subset(double minValue, double maxValue, int stride) {
        CoordAxisHelper helper = new CoordAxisHelper(this);
        Optional<CoverageCoordAxisBuilder> buildero = helper.subset(minValue, maxValue, stride);
        return !buildero.isPresent() ? Optional.empty(buildero.getErrorMessage()) : Optional.of(new TimeOffsetAxis(buildero.get()));
    }
}

