/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.ma2.StructureData;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.point.PointCollectionIteratorFiltered;
import ucar.nc2.ft.point.PointFeatureCCImpl;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.util.IOIterator;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.geoloc.StationImpl;

public abstract class StationProfileFeatureImpl
extends PointFeatureCCImpl
implements StationProfileFeature {
    protected int timeSeriesNpts;
    protected Station station;
    protected PointFeatureCollectionIterator localIterator;

    public StationProfileFeatureImpl(String name, String desc, String wmoId, double lat, double lon, double alt, CalendarDateUnit timeUnit, String altUnits, int npts) {
        super(name, timeUnit, altUnits, FeatureType.STATION_PROFILE);
        this.station = new StationImpl(name, desc, wmoId, lat, lon, alt, npts);
        this.timeSeriesNpts = npts;
    }

    public StationProfileFeatureImpl(Station s, CalendarDateUnit timeUnit, String altUnits, int npts) {
        super(s.getName(), timeUnit, altUnits, FeatureType.STATION_PROFILE);
        this.station = s;
        this.timeSeriesNpts = npts;
    }

    @Override
    public int getNobs() {
        return this.timeSeriesNpts;
    }

    @Override
    public String getWmoId() {
        return this.station.getWmoId();
    }

    @Override
    public int size() {
        return this.timeSeriesNpts;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.station.getName();
    }

    @Override
    public String getDescription() {
        return this.station.getDescription();
    }

    @Override
    public double getLatitude() {
        return this.station.getLatitude();
    }

    @Override
    public double getLongitude() {
        return this.station.getLongitude();
    }

    @Override
    public double getAltitude() {
        return this.station.getAltitude();
    }

    @Override
    public LatLonPoint getLatLon() {
        return this.station.getLatLon();
    }

    @Override
    public boolean isMissing() {
        return Double.isNaN(this.getLatitude()) || Double.isNaN(this.getLongitude());
    }

    @Override
    public int compareTo(@Nonnull Station so) {
        return this.station.getName().compareTo(so.getName());
    }

    public StationProfileFeature subset(LatLonRect boundingBox) throws IOException {
        return this;
    }

    @Override
    public StationProfileFeature subset(CalendarDateRange dateRange) throws IOException {
        return new StationProfileFeatureSubset(this, dateRange);
    }

    @Override
    public Iterator<ProfileFeature> iterator() {
        return new ProfileFeatureIterator();
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public ProfileFeature next() throws IOException {
        return (ProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator();
    }

    private class ProfileFeatureIterator
    implements Iterator<ProfileFeature> {
        PointFeatureCollectionIterator pfIterator;

        public ProfileFeatureIterator() {
            try {
                this.pfIterator = StationProfileFeatureImpl.this.getPointFeatureCollectionIterator();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public boolean hasNext() {
            try {
                return this.pfIterator.hasNext();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ProfileFeature next() {
            try {
                return (ProfileFeature)this.pfIterator.next();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class StationProfileFeatureSubset
    extends StationProfileFeatureImpl {
        private final StationProfileFeature from;
        private final CalendarDateRange dateRange;

        public StationProfileFeatureSubset(StationProfileFeatureImpl from, CalendarDateRange filter_date) {
            super(from.station, from.getTimeUnit(), from.getAltUnits(), -1);
            this.from = from;
            this.dateRange = filter_date;
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.from.getFeatureData();
        }

        @Override
        public List<CalendarDate> getTimes() throws IOException {
            ArrayList<CalendarDate> result = new ArrayList<CalendarDate>();
            for (ProfileFeature pf : this) {
                if (!this.dateRange.includes(pf.getTime())) continue;
                result.add(pf.getTime());
            }
            return result;
        }

        @Override
        public ProfileFeature getProfileByDate(CalendarDate date) throws IOException {
            return this.from.getProfileByDate(date);
        }

        @Override
        public IOIterator<PointFeatureCollection> getCollectionIterator() throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(), new DateFilter());
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator() throws IOException {
            return new PointCollectionIteratorFiltered(this.from.getPointFeatureCollectionIterator(), new DateFilter());
        }

        private class DateFilter
        implements PointFeatureCollectionIterator.Filter {
            private DateFilter() {
            }

            @Override
            public boolean filter(PointFeatureCollection pointFeatureCollection) {
                ProfileFeature profileFeature = (ProfileFeature)pointFeatureCollection;
                return StationProfileFeatureSubset.this.dateRange.includes(profileFeature.getTime());
            }
        }
    }
}

