/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.util.StringUtil2;

public class AWIPSConvention
extends CoordSysBuilder {
    private static final boolean debugProj = false;
    private static final boolean debugBreakup = false;
    private ProjectionCT projCT = null;
    private double startx;
    private double starty;

    public static boolean isMine(NetcdfFile ncfile) {
        return null != ncfile.findGlobalAttribute("projName") && null != ncfile.findDimension("charsPerLevel") && null != ncfile.findDimension("x") && null != ncfile.findDimension("y");
    }

    public AWIPSConvention() {
        this.conventionName = "AWIPS";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        if (null != ds.findVariable("x")) {
            return;
        }
        Dimension dimx = ds.findDimension("x");
        int nx = dimx.getLength();
        Dimension dimy = ds.findDimension("y");
        int ny = dimy.getLength();
        String projName = ds.findAttValueIgnoreCase(null, "projName", "none");
        if (projName.equalsIgnoreCase("LATLON")) {
            ds.addCoordinateAxis(this.makeLonCoordAxis(ds, nx, "x"));
            ds.addCoordinateAxis(this.makeLatCoordAxis(ds, ny, "y"));
        } else if (projName.equalsIgnoreCase("LAMBERT_CONFORMAL")) {
            this.projCT = this.makeLCProjection(ds, projName);
            ds.addCoordinateAxis(this.makeXCoordAxis(ds, nx, "x"));
            ds.addCoordinateAxis(this.makeYCoordAxis(ds, ny, "y"));
        } else if (projName.equalsIgnoreCase("STEREOGRAPHIC")) {
            this.projCT = this.makeStereoProjection(ds, projName);
            ds.addCoordinateAxis(this.makeXCoordAxis(ds, nx, "x"));
            ds.addCoordinateAxis(this.makeYCoordAxis(ds, ny, "y"));
        }
        CoordinateAxis timeCoord = this.makeTimeCoordAxis(ds);
        if (timeCoord != null) {
            ds.addCoordinateAxis(timeCoord);
            Dimension d = timeCoord.getDimension(0);
            if (!d.getShortName().equals(timeCoord.getShortName())) {
                timeCoord.addAttribute(new Attribute("_CoordinateAliasForDimension", d.getShortName()));
            }
        }
        for (Variable ncvar : ds.getVariables()) {
            String levelName = ncvar.getShortName() + "Levels";
            Variable levelVar = ds.findVariable(levelName);
            if (levelVar == null || levelVar.getRank() != 2 || levelVar.getDataType() != DataType.CHAR) continue;
            try {
                List<Dimension> levels = this.breakupLevels(ds, levelVar);
                this.createNewVariables(ds, ncvar, levels, levelVar.getDimension(0));
            }
            catch (InvalidRangeException ex) {
                this.parseInfo.format("createNewVariables InvalidRangeException%n", new Object[0]);
            }
            catch (IOException ioe) {
                this.parseInfo.format("createNewVariables IOException%n", new Object[0]);
            }
        }
        if (this.projCT != null) {
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.projCT);
            v.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            ds.addVariable(null, v);
        }
        ds.finish();
        List<Variable> vlist = ds.getVariables();
        for (Variable v : vlist) {
            Attribute att = v.findAttributeIgnoreCase("units");
            if (att == null) continue;
            String units = att.getStringValue();
            v.addAttribute(new Attribute("units", this.normalize(units)));
        }
    }

    private String normalize(String units) {
        if (units.equals("/second")) {
            units = "1/sec";
        }
        if (units.equals("degrees K")) {
            units = "K";
        } else {
            units = StringUtil2.substitute(units, "**", "^");
            units = StringUtil2.remove(units, 41);
            units = StringUtil2.remove(units, 40);
        }
        return units;
    }

    private List<Dimension> breakupLevels(NetcdfDataset ds, Variable levelVar) throws IOException {
        ArrayChar levelVarData;
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        try {
            levelVarData = (ArrayChar)levelVar.read();
        }
        catch (IOException ioe) {
            return dimList;
        }
        ArrayList<String> values = null;
        String currentUnits = null;
        ArrayChar.StringIterator iter = levelVarData.getStringIterator();
        while (iter.hasNext()) {
            String s = iter.next();
            StringTokenizer stoke = new StringTokenizer(s);
            if (!stoke.hasMoreTokens()) continue;
            String units = stoke.nextToken().trim();
            if (!units.equals(currentUnits)) {
                if (values != null) {
                    dimList.add(this.makeZCoordAxis(ds, values, currentUnits));
                }
                values = new ArrayList<String>();
                currentUnits = units;
            }
            if (stoke.hasMoreTokens()) {
                values.add(stoke.nextToken());
                continue;
            }
            values.add("0");
        }
        if (values != null) {
            dimList.add(this.makeZCoordAxis(ds, values, currentUnits));
        }
        return dimList;
    }

    private Dimension makeZCoordAxis(NetcdfDataset ds, List<String> values, String units) throws IOException {
        Array newData;
        Variable coord;
        Array coordData;
        int len = values.size();
        String name = this.makeZCoordName(units);
        name = len > 1 ? name + Integer.toString(len) : name + values.get(0);
        StringUtil2.replace(name, ' ', "-");
        Dimension dim = ds.getRootGroup().findDimension(name);
        if (null != dim && dim.getLength() == len && MAMath.nearlyEquals(coordData = (coord = ds.getRootGroup().findVariable(name)).read(), newData = Array.makeArray(coord.getDataType(), values))) {
            return dim;
        }
        String orgName = name;
        int count = 1;
        while (ds.getRootGroup().findDimension(name) != null) {
            name = orgName + "-" + count;
            ++count;
        }
        dim = new Dimension(name, len);
        ds.addDimension(null, dim);
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, name, DataType.DOUBLE, name, this.makeUnitsName(units), this.makeLongName(name));
        String positive = this.getZisPositive(ds, v);
        if (null != positive) {
            v.addAttribute(new Attribute("_CoordinateZisPositive", positive));
        }
        v.setValues(values);
        ds.addCoordinateAxis(v);
        this.parseInfo.format("Created Z Coordinate Axis = ", new Object[0]);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return dim;
    }

    private String makeZCoordName(String units) {
        if (units.equalsIgnoreCase("MB")) {
            return "PressureLevels";
        }
        if (units.equalsIgnoreCase("K")) {
            return "PotTempLevels";
        }
        if (units.equalsIgnoreCase("BL")) {
            return "BoundaryLayers";
        }
        if (units.equalsIgnoreCase("FHAG")) {
            return "FixedHeightAboveGround";
        }
        if (units.equalsIgnoreCase("FH")) {
            return "FixedHeight";
        }
        if (units.equalsIgnoreCase("SFC")) {
            return "Surface";
        }
        if (units.equalsIgnoreCase("MSL")) {
            return "MeanSeaLevel";
        }
        if (units.equalsIgnoreCase("FRZ")) {
            return "FreezingLevel";
        }
        if (units.equalsIgnoreCase("TROP")) {
            return "Tropopause";
        }
        if (units.equalsIgnoreCase("MAXW")) {
            return "MaxWindLevel";
        }
        return units;
    }

    private String makeUnitsName(String units) {
        if (units.equalsIgnoreCase("MB")) {
            return "hPa";
        }
        if (units.equalsIgnoreCase("BL")) {
            return "hPa";
        }
        if (units.equalsIgnoreCase("FHAG")) {
            return "m";
        }
        if (units.equalsIgnoreCase("FH")) {
            return "m";
        }
        return "";
    }

    private String makeLongName(String name) {
        if (name.equalsIgnoreCase("PotTempLevels")) {
            return "Potential Temperature Level";
        }
        if (name.equalsIgnoreCase("BoundaryLayers")) {
            return "BoundaryLayer hectoPascals above ground";
        }
        return name;
    }

    private void createNewVariables(NetcdfDataset ds, Variable ncVar, List<Dimension> newDims, Dimension levelDim) throws InvalidRangeException {
        List<Dimension> dims = ncVar.getDimensions();
        int newDimIndex = dims.indexOf(levelDim);
        int[] origin = new int[ncVar.getRank()];
        int[] shape = ncVar.getShape();
        int count = 0;
        for (Dimension dim : newDims) {
            String name = ncVar.getShortName() + "-" + dim.getShortName();
            origin[newDimIndex] = count;
            shape[newDimIndex] = dim.getLength();
            Variable varNew = ncVar.section(new Section(origin, shape));
            varNew.setName(name);
            varNew.setDimension(newDimIndex, dim);
            String long_name = ds.findAttValueIgnoreCase(ncVar, "long_name", ncVar.getShortName());
            long_name = long_name + "-" + dim.getShortName();
            ds.addVariableAttribute(varNew, new Attribute("long_name", long_name));
            ds.addVariable(null, varNew);
            this.parseInfo.format("Created New Variable as section = ", new Object[0]);
            varNew.getNameAndDimensions(this.parseInfo, true, false);
            this.parseInfo.format("%n", new Object[0]);
            count += dim.getLength();
        }
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        Dimension dim = v.getDimension(0);
        if (dim != null && dim.getShortName().equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        String unit = ve.getUnitsString();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return AxisType.GeoZ;
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        if (this.projCT != null) {
            CoordSysBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = this.projCT;
        }
        super.makeCoordinateTransforms(ds);
    }

    private String getZisPositive(NetcdfDataset ds, CoordinateAxis v) {
        String attValue = ds.findAttValueIgnoreCase(v, "positive", null);
        if (null != attValue) {
            return attValue.equalsIgnoreCase("up") ? "up" : "down";
        }
        String unit = v.getUnitsString();
        if (unit != null && SimpleUnit.isCompatible("millibar", unit)) {
            return "down";
        }
        if (unit != null && SimpleUnit.isCompatible("m", unit)) {
            return "up";
        }
        return null;
    }

    private ProjectionCT makeLCProjection(NetcdfDataset ds, String name) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble(ds, "centralLat");
        double centralLon = this.findAttributeDouble(ds, "centralLon");
        double rotation = this.findAttributeDouble(ds, "rotation");
        LambertConformal lc = new LambertConformal(rotation, centralLon, centralLat, centralLat);
        double lat0 = this.findAttributeDouble(ds, "lat00");
        double lon0 = this.findAttributeDouble(ds, "lon00");
        ProjectionPointImpl start = (ProjectionPointImpl)lc.latLonToProj(new LatLonPointImpl(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        return new ProjectionCT(name, "FGDC", lc);
    }

    private ProjectionCT makeStereoProjection(NetcdfDataset ds, String name) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble(ds, "centralLat");
        double centralLon = this.findAttributeDouble(ds, "centralLon");
        double latDxDy = this.findAttributeDouble(ds, "latDxDy");
        double latR = Math.toRadians(latDxDy);
        double scale = (1.0 + Math.abs(Math.sin(latR))) / 2.0;
        Stereographic proj = new Stereographic(centralLat, centralLon, scale);
        double lat0 = this.findAttributeDouble(ds, "lat00");
        double lon0 = this.findAttributeDouble(ds, "lon00");
        ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj(new LatLonPointImpl(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        this.parseInfo.format("---makeStereoProjection start at proj coord %s%n", start);
        double latN = this.findAttributeDouble(ds, "latNxNy");
        double lonN = this.findAttributeDouble(ds, "lonNxNy");
        ProjectionPointImpl pt = (ProjectionPointImpl)proj.latLonToProj(new LatLonPointImpl(latN, lonN));
        this.parseInfo.format("                        end at proj coord %s%n", pt);
        this.parseInfo.format("                        scale= %f%n", scale);
        return new ProjectionCT(name, "FGDC", proj);
    }

    private CoordinateAxis makeXCoordAxis(NetcdfDataset ds, int nx, String xname) {
        double dx = this.findAttributeDouble(ds, "dxKm");
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, xname, DataType.DOUBLE, xname, "km", "x on projection");
        v.setValues(nx, this.startx, dx);
        this.parseInfo.format("Created X Coordinate Axis = ", new Object[0]);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return v;
    }

    private CoordinateAxis makeYCoordAxis(NetcdfDataset ds, int ny, String yname) {
        double dy = this.findAttributeDouble(ds, "dyKm");
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, yname, DataType.DOUBLE, yname, "km", "y on projection");
        v.setValues(ny, this.starty, dy);
        this.parseInfo.format("Created Y Coordinate Axis = ", new Object[0]);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return v;
    }

    private CoordinateAxis makeLonCoordAxis(NetcdfDataset ds, int n, String xname) {
        double min = this.findAttributeDouble(ds, "xMin");
        double max = this.findAttributeDouble(ds, "xMax");
        double d = this.findAttributeDouble(ds, "dx");
        if (Double.isNaN(min) || Double.isNaN(max) || Double.isNaN(d)) {
            return null;
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, xname, DataType.DOUBLE, xname, "degrees_east", "longitude");
        v.setValues(n, min, d);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        double maxCalc = min + d * (double)n;
        this.parseInfo.format("Created Lon Coordinate Axis (max calc= %f shoule be = %f)%n", maxCalc, max);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return v;
    }

    private CoordinateAxis makeLatCoordAxis(NetcdfDataset ds, int n, String xname) {
        double min = this.findAttributeDouble(ds, "yMin");
        double max = this.findAttributeDouble(ds, "yMax");
        double d = this.findAttributeDouble(ds, "dy");
        if (Double.isNaN(min) || Double.isNaN(max) || Double.isNaN(d)) {
            return null;
        }
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, xname, DataType.DOUBLE, xname, "degrees_north", "latitude");
        v.setValues(n, min, d);
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        double maxCalc = min + d * (double)n;
        this.parseInfo.format("Created Lat Coordinate Axis (max calc= %f should be = %f)%n", maxCalc, max);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return v;
    }

    private CoordinateAxis makeTimeCoordAxis(NetcdfDataset ds) {
        String units;
        Array vals;
        Variable timeVar = ds.findVariable("valtimeMINUSreftime");
        Dimension recordDim = ds.findDimension("record");
        try {
            vals = timeVar.read();
        }
        catch (IOException ioe) {
            return null;
        }
        int recLen = recordDim.getLength();
        int valLen = (int)vals.getSize();
        if (recLen != valLen) {
            try {
                vals = vals.sectionNoReduce(new int[]{0}, new int[]{recordDim.getLength()}, null);
                this.parseInfo.format(" corrected the TimeCoordAxis length%n", new Object[0]);
            }
            catch (InvalidRangeException e) {
                this.parseInfo.format("makeTimeCoordAxis InvalidRangeException%n", new Object[0]);
            }
        }
        if ((units = this.makeTimeUnitFromFilename(ds.getLocation())) == null) {
            return this.makeTimeCoordAxisFromReference(ds, timeVar, vals);
        }
        String desc = "synthesized time coordinate from valtimeMINUSreftime and filename YYYYMMDD_HHMM";
        CoordinateAxis1D timeCoord = new CoordinateAxis1D(ds, null, "timeCoord", DataType.INT, "record", units, desc);
        timeCoord.setCachedData(vals, true);
        this.parseInfo.format("Created Time Coordinate Axis = ", new Object[0]);
        timeCoord.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return timeCoord;
    }

    private String makeTimeUnitFromFilename(String dsName) {
        int posLast;
        int posFirst = (dsName = dsName.replace('\\', '/')).lastIndexOf(47);
        if (posFirst < 0) {
            posFirst = 0;
        }
        if ((dsName = (posLast = dsName.indexOf(46, posFirst)) < 0 ? dsName.substring(posFirst + 1) : dsName.substring(posFirst + 1, posLast)).length() != 13) {
            return null;
        }
        String year = dsName.substring(0, 4);
        String mon = dsName.substring(4, 6);
        String day = dsName.substring(6, 8);
        String hour = dsName.substring(9, 11);
        String min = dsName.substring(11, 13);
        return "seconds since " + year + "-" + mon + "-" + day + " " + hour + ":" + min + ":0";
    }

    private CoordinateAxis makeTimeCoordAxisFromReference(NetcdfDataset ds, Variable timeVar, Array vals) {
        double refValue;
        Variable refVar = ds.findVariable("reftime");
        if (refVar == null) {
            return null;
        }
        try {
            Array refArray = refVar.read();
            refValue = refArray.getDouble(refArray.getIndex());
        }
        catch (IOException ioe) {
            return null;
        }
        if (refValue == (double)9.96921E36f) {
            return null;
        }
        Array dvals = Array.factory(DataType.DOUBLE, vals.getShape());
        IndexIterator diter = dvals.getIndexIterator();
        IndexIterator iiter = vals.getIndexIterator();
        while (iiter.hasNext()) {
            diter.setDoubleNext(iiter.getDoubleNext() + refValue);
        }
        String units = ds.findAttValueIgnoreCase(refVar, "units", "seconds since 1970-1-1 00:00:00");
        units = this.normalize(units);
        String desc = "synthesized time coordinate from reftime, valtimeMINUSreftime";
        CoordinateAxis1D timeCoord = new CoordinateAxis1D(ds, null, "timeCoord", DataType.DOUBLE, "record", units, desc);
        timeCoord.setCachedData(dvals, true);
        this.parseInfo.format("Created Time Coordinate Axis From Reference = ", new Object[0]);
        timeCoord.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("%n", new Object[0]);
        return timeCoord;
    }

    private double findAttributeDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        if (att == null) {
            this.parseInfo.format("ERROR cant find attribute= %s%n", attname);
            return Double.NaN;
        }
        return att.getNumericValue().doubleValue();
    }
}

