/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.AlbersEqualArea;
import ucar.nc2.dataset.transform.AzimuthalEquidistant;
import ucar.nc2.dataset.transform.CFHybridHeight;
import ucar.nc2.dataset.transform.CFHybridSigmaPressure;
import ucar.nc2.dataset.transform.CFOceanS;
import ucar.nc2.dataset.transform.CFOceanSigma;
import ucar.nc2.dataset.transform.CFSigma;
import ucar.nc2.dataset.transform.FlatEarth;
import ucar.nc2.dataset.transform.Geostationary;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.nc2.dataset.transform.LambertAzimuthal;
import ucar.nc2.dataset.transform.LambertConformalConic;
import ucar.nc2.dataset.transform.LambertCylindricalEqualArea;
import ucar.nc2.dataset.transform.LatLon;
import ucar.nc2.dataset.transform.MSGnavigation;
import ucar.nc2.dataset.transform.Mercator;
import ucar.nc2.dataset.transform.Orthographic;
import ucar.nc2.dataset.transform.PolarStereographic;
import ucar.nc2.dataset.transform.PolyconicProjection;
import ucar.nc2.dataset.transform.RotatedLatLon;
import ucar.nc2.dataset.transform.RotatedPole;
import ucar.nc2.dataset.transform.Sinusoidal;
import ucar.nc2.dataset.transform.Stereographic;
import ucar.nc2.dataset.transform.TransverseMercator;
import ucar.nc2.dataset.transform.UTM;
import ucar.nc2.dataset.transform.VExplicitField;
import ucar.nc2.dataset.transform.VOceanSG1;
import ucar.nc2.dataset.transform.VOceanSG2;
import ucar.nc2.dataset.transform.VertTransformBuilderIF;
import ucar.nc2.dataset.transform.VerticalPerspective;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Parameter;

public class CoordTransBuilder {
    private static Logger log = LoggerFactory.getLogger(CoordTransBuilder.class);
    private static List<Transform> transformList = new ArrayList<Transform>();
    private static boolean userMode = false;
    private static final boolean loadWarnings = false;

    public static void registerTransform(String transformName, Class c) {
        if (!VertTransformBuilderIF.class.isAssignableFrom(c) && !HorizTransformBuilderIF.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement VertTransformBuilderIF or HorizTransformBuilderIF");
        }
        try {
            c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("CoordTransBuilderIF Class " + c.getName() + " is not accessible");
        }
        if (userMode) {
            transformList.add(0, new Transform(transformName, c));
        } else {
            transformList.add(new Transform(transformName, c));
        }
    }

    public static void registerTransform(String transformName, String className) throws ClassNotFoundException {
        Class<?> c = Class.forName(className);
        CoordTransBuilder.registerTransform(transformName, c);
    }

    public static void registerTransformMaybe(String transformName, String className) {
        Class<?> c;
        try {
            c = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return;
        }
        CoordTransBuilder.registerTransform(transformName, c);
    }

    public static CoordinateTransform makeCoordinateTransform(NetcdfDataset ds, AttributeContainer ctv, Formatter parseInfo, Formatter errInfo) {
        CoordinateTransform ct;
        Object builderObject;
        String transform_name = ctv.findAttValueIgnoreCase("transform_name", null);
        if (null == transform_name) {
            transform_name = ctv.findAttValueIgnoreCase("Projection_Name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttValueIgnoreCase("grid_mapping_name", null);
        }
        if (null == transform_name) {
            transform_name = ctv.findAttValueIgnoreCase("standard_name", null);
        }
        if (null == transform_name) {
            parseInfo.format("**Failed to find Coordinate Transform name from Variable= %s%n", ctv);
            return null;
        }
        transform_name = transform_name.trim();
        Class builderClass = null;
        for (Transform transform : transformList) {
            if (!transform.transName.equals(transform_name)) continue;
            builderClass = transform.transClass;
            break;
        }
        if (null == builderClass) {
            parseInfo.format("**Failed to find CoordTransBuilder name= %s from Variable= %s%n", transform_name, ctv);
            return null;
        }
        try {
            builderObject = builderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cant create new instance " + builderClass.getName(), (Throwable)e);
            return null;
        }
        if (null == builderObject) {
            parseInfo.format("**Failed to build CoordTransBuilder object from class= %s for Variable= %s%n", builderClass.getName(), ctv);
            return null;
        }
        if (builderObject instanceof VertTransformBuilderIF) {
            VertTransformBuilderIF vertBuilder = (VertTransformBuilderIF)builderObject;
            vertBuilder.setErrorBuffer(errInfo);
            ct = vertBuilder.makeCoordinateTransform(ds, ctv);
        } else if (builderObject instanceof HorizTransformBuilderIF) {
            HorizTransformBuilderIF horizBuilder = (HorizTransformBuilderIF)builderObject;
            horizBuilder.setErrorBuffer(errInfo);
            String units = AbstractTransformBuilder.getGeoCoordinateUnits(ds, ctv);
            ct = horizBuilder.makeCoordinateTransform(ctv, units);
        } else {
            log.error("Illegals class " + builderClass.getName());
            return null;
        }
        if (ct != null) {
            parseInfo.format(" Made Coordinate transform %s from variable %s: %s%n", transform_name, ctv.getName(), builderObject.getClass().getName());
        }
        return ct;
    }

    public static VariableDS makeDummyTransformVariable(NetcdfDataset ds, CoordinateTransform ct) {
        VariableDS v = new VariableDS(ds, null, null, ct.getName(), DataType.CHAR, "", null, null);
        List<Parameter> params = ct.getParameters();
        for (Parameter p : params) {
            if (p.isString()) {
                v.addAttribute(new Attribute(p.getName(), p.getStringValue()));
                continue;
            }
            double[] data = p.getNumericValues();
            Array dataA = Array.factory(DataType.DOUBLE, new int[]{data.length}, (Object)data);
            v.addAttribute(new Attribute(p.getName(), dataA));
        }
        v.addAttribute(new Attribute("_CoordinateTransformType", ct.getTransformType().toString()));
        Array data = Array.factory(DataType.CHAR, new int[0], (Object)new char[]{' '});
        v.setCachedData(data, true);
        return v;
    }

    public static ProjectionImpl makeProjection(CoverageTransform gct, Formatter errInfo) {
        HorizTransformBuilderIF builder;
        String transform_name = gct.findAttValueIgnoreCase("grid_mapping_name", null);
        if (null == transform_name) {
            errInfo.format("**Failed to find Coordinate Transform name from GridCoordTransform= %s%n", gct);
            return null;
        }
        transform_name = transform_name.trim();
        Class builderClass = null;
        for (Transform transform : transformList) {
            if (!transform.transName.equals(transform_name)) continue;
            builderClass = transform.transClass;
            break;
        }
        if (null == builderClass) {
            errInfo.format("**Failed to find CoordTransBuilder name= %s from GridCoordTransform= %s%n", transform_name, gct);
            return null;
        }
        try {
            builder = (HorizTransformBuilderIF)builderClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Cant create new instance " + builderClass.getName(), (Throwable)e);
            return null;
        }
        if (null == builder) {
            errInfo.format("**Failed to build CoordTransBuilder object from class= %s for GridCoordTransform= %s%n", builderClass.getName(), gct);
            return null;
        }
        String units = gct.findAttValueIgnoreCase("units", null);
        builder.setErrorBuffer(errInfo);
        ProjectionCT ct = builder.makeCoordinateTransform(gct, units);
        assert (ct != null);
        return ct.getProjection();
    }

    static {
        CoordTransBuilder.registerTransform("albers_conical_equal_area", AlbersEqualArea.class);
        CoordTransBuilder.registerTransform("azimuthal_equidistant", AzimuthalEquidistant.class);
        CoordTransBuilder.registerTransform("flat_earth", FlatEarth.class);
        CoordTransBuilder.registerTransform("geostationary", Geostationary.class);
        CoordTransBuilder.registerTransform("lambert_azimuthal_equal_area", LambertAzimuthal.class);
        CoordTransBuilder.registerTransform("lambert_conformal_conic", LambertConformalConic.class);
        CoordTransBuilder.registerTransform("lambert_cylindrical_equal_area", LambertCylindricalEqualArea.class);
        CoordTransBuilder.registerTransform("latitude_longitude", LatLon.class);
        CoordTransBuilder.registerTransformMaybe("mcidas_area", "ucar.nc2.iosp.mcidas.McIDASAreaTransformBuilder");
        CoordTransBuilder.registerTransform("mercator", Mercator.class);
        CoordTransBuilder.registerTransform("MSGnavigation", MSGnavigation.class);
        CoordTransBuilder.registerTransform("orthographic", Orthographic.class);
        CoordTransBuilder.registerTransform("polar_stereographic", PolarStereographic.class);
        CoordTransBuilder.registerTransform("polyconic", PolyconicProjection.class);
        CoordTransBuilder.registerTransform("rotated_latitude_longitude", RotatedPole.class);
        CoordTransBuilder.registerTransform("rotated_latlon_grib", RotatedLatLon.class);
        CoordTransBuilder.registerTransform("sinusoidal", Sinusoidal.class);
        CoordTransBuilder.registerTransform("stereographic", Stereographic.class);
        CoordTransBuilder.registerTransform("transverse_mercator", TransverseMercator.class);
        CoordTransBuilder.registerTransform("UTM", UTM.class);
        CoordTransBuilder.registerTransform("vertical_perspective", VerticalPerspective.class);
        CoordTransBuilder.registerTransform("atmosphere_hybrid_height_coordinate", CFHybridHeight.class);
        CoordTransBuilder.registerTransform("atmosphere_hybrid_sigma_pressure_coordinate", CFHybridSigmaPressure.class);
        CoordTransBuilder.registerTransform("atmosphere_sigma_coordinate", CFSigma.class);
        CoordTransBuilder.registerTransform("ocean_s_coordinate", CFOceanS.class);
        CoordTransBuilder.registerTransform("ocean_sigma_coordinate", CFOceanSigma.class);
        CoordTransBuilder.registerTransform("explicit_field", VExplicitField.class);
        CoordTransBuilder.registerTransform("existing3DField", VExplicitField.class);
        CoordTransBuilder.registerTransform("ocean_s_coordinate_g1", VOceanSG1.class);
        CoordTransBuilder.registerTransform("ocean_s_coordinate_g2", VOceanSG2.class);
        userMode = true;
    }

    private static class Transform {
        String transName;
        Class transClass;

        Transform(String transName, Class transClass) {
            this.transName = transName;
            this.transClass = transClass;
        }
    }
}

