/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.constants;

public enum AxisType {
    RunTime(0, "R"),
    Ensemble(2, "E"),
    Time(1, "T"),
    GeoX(5, "X"),
    GeoY(4, "Y"),
    GeoZ(3, "Z"),
    Lat(4, "Y"),
    Lon(5, "X"),
    Height(3, "Z"),
    Pressure(3, "Z"),
    RadialAzimuth(7),
    RadialDistance(8),
    RadialElevation(6),
    Spectral(1),
    TimeOffset(1, "TO"),
    Dimension(99, "Dim");

    private final int order;
    private final String cfAxisName;

    private AxisType(int order) {
        this.order = order;
        this.cfAxisName = null;
    }

    private AxisType(int order, String cfAxisName) {
        this.order = order;
        this.cfAxisName = cfAxisName;
    }

    public static AxisType getType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return AxisType.valueOf(name);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public int axisOrder() {
        return this.order;
    }

    public String getCFAxisName() {
        return this.cfAxisName;
    }

    public boolean isHoriz() {
        return this == GeoX || this == GeoY || this == Lat || this == Lon;
    }

    public boolean isTime() {
        return this == Time || this == RunTime || this == TimeOffset;
    }

    public boolean isVert() {
        return this == Height || this == Pressure || this == GeoZ;
    }
}

