/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.DatasetBuilder;

@Immutable
public class DatasetNode {
    protected final DatasetNode parent;
    protected final String name;
    protected final Map<String, Object> flds;

    protected DatasetNode(DatasetNode parent, String name, Map<String, Object> flds, List<DatasetBuilder> datasetBuilders) {
        this.parent = parent;
        this.name = name;
        this.flds = Collections.unmodifiableMap(flds);
        if (datasetBuilders != null && datasetBuilders.size() > 0) {
            ArrayList<Dataset> datasets = new ArrayList<Dataset>(datasetBuilders.size());
            for (DatasetBuilder dsb : datasetBuilders) {
                datasets.add(dsb.makeDataset(this));
            }
            flds.put("Datasets", Collections.unmodifiableList(datasets));
        }
    }

    public Iterable<Map.Entry<String, Object>> getFldIterator() {
        return this.flds.entrySet();
    }

    public Object get(String key) {
        return this.flds.get(key);
    }

    public DatasetNode getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public List<Dataset> getDatasetsLocal() {
        List datasets = (List)this.flds.get("Datasets");
        return datasets == null ? new ArrayList(0) : datasets;
    }

    public List<Dataset> getDatasets() {
        return this.getDatasetsLocal();
    }

    public List<Dataset> getDatasetsLogical() {
        return this.getDatasets();
    }

    public Dataset findDatasetByName(String name) {
        for (Dataset ds : this.getDatasets()) {
            if (ds.getName().equals(name)) {
                return ds;
            }
            Dataset result = ds.findDatasetByName(name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public boolean hasNestedDatasets() {
        List<Dataset> datasets = this.getDatasets();
        return !datasets.isEmpty();
    }

    public Catalog getParentCatalog() {
        if (this.parent == null) {
            return null;
        }
        if (this.parent instanceof Catalog) {
            return (Catalog)this.parent;
        }
        return this.parent.getParentCatalog();
    }

    public Dataset getParentDataset() {
        if (this.parent == null) {
            return null;
        }
        return this.parent instanceof Dataset ? (Dataset)this.parent : null;
    }

    public List getLocalFieldAsList(String fldName) {
        Object value = this.flds.get(fldName);
        if (value != null) {
            if (value instanceof List) {
                return (List)value;
            }
            ArrayList<Object> result = new ArrayList<Object>(1);
            result.add(value);
            return result;
        }
        return new ArrayList(0);
    }
}

