/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard.plug;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.constants.CF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.point.standard.CoordSysEvaluator;
import ucar.nc2.ft.point.standard.Evaluator;
import ucar.nc2.ft.point.standard.JoinArray;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.ft.point.standard.TableConfigurerImpl;

public class CFpointObs
extends TableConfigurerImpl {
    @Override
    public boolean isMine(FeatureType wantFeatureType, NetcdfDataset ds) {
        String conv = ds.findAttValueIgnoreCase(null, "Conventions", null);
        if (conv == null) {
            return false;
        }
        List<String> names = CoordSysBuilder.breakupConventionNames(conv);
        for (String s : names) {
            if (!s.startsWith("CF-1")) continue;
            return true;
        }
        return false;
    }

    @Override
    public TableConfig getConfig(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        EncodingInfo info = new EncodingInfo();
        CF.FeatureType ftype = CF.FeatureType.getFeatureTypeFromGlobalAttribute(ds);
        if (ftype == null) {
            ftype = CF.FeatureType.point;
        }
        if (!this.checkCoordinates(ds, info, errlog)) {
            return null;
        }
        switch (ftype) {
            case point: {
                return this.getPointConfig(ds, info, errlog);
            }
            case timeSeries: {
                return this.getStationConfig(ds, info, errlog);
            }
            case profile: {
                return this.getProfileConfig(ds, info, errlog);
            }
            case trajectory: {
                return this.getTrajectoryConfig(ds, info, errlog);
            }
            case timeSeriesProfile: {
                return this.getTimeSeriesProfileConfig(ds, info, errlog);
            }
            case trajectoryProfile: {
                return this.getSectionConfig(ds, info, errlog);
            }
        }
        return null;
    }

    protected boolean checkCoordinates(NetcdfDataset ds, EncodingInfo info, Formatter errlog) {
        List<Dimension> dimLon;
        boolean ok = true;
        info.time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (info.time == null) {
            errlog.format("CFpointObs cant find a Time coordinate %n", new Object[0]);
            ok = false;
        }
        info.lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        if (info.lat == null) {
            errlog.format("CFpointObs cant find a Latitude coordinate %n", new Object[0]);
            ok = false;
        }
        info.lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (info.lon == null) {
            errlog.format("CFpointObs cant find a Longitude coordinate %n", new Object[0]);
            ok = false;
        }
        if (!ok) {
            return false;
        }
        List<Dimension> dimLat = info.lat.getDimensions();
        if (!dimLat.equals(dimLon = info.lon.getDimensions())) {
            errlog.format("CFpointObs Lat, Lon coordinate dimensions must match lat=%s lon=%s %n", info.lat.getNameAndDimensions(), info.lon.getNameAndDimensions());
            ok = false;
        }
        return ok;
    }

    protected TableConfig getPointConfig(NetcdfDataset ds, EncodingInfo info, Formatter errlog) throws IOException {
        if (info.time.getRank() != 1) {
            errlog.format("CFpointObs type=point: coord time must have rank 1, coord var= %s %n", info.time.getNameAndDimensions());
            return null;
        }
        Dimension obsDim = info.time.getDimension(0);
        TableConfig obsTable = this.makeSingle(ds, obsDim, errlog);
        obsTable.featureType = FeatureType.POINT;
        return obsTable;
    }

    protected TableConfig getStationConfig(NetcdfDataset ds, EncodingInfo info, Formatter errlog) throws IOException {
        if (!this.identifyEncodingStation(ds, info, CF.FeatureType.timeSeries, errlog)) {
            return null;
        }
        TableConfig stnTable = this.makeStationTable(ds, FeatureType.STATION, info, errlog);
        if (stnTable == null) {
            return null;
        }
        Dimension obsDim = info.childDim;
        TableConfig obsTable = null;
        switch (info.encoding) {
            case single: {
                obsTable = this.makeSingle(ds, obsDim, errlog);
                break;
            }
            case multidim: {
                obsTable = this.makeMultidimInner(ds, stnTable, info.childDim, info, errlog);
                if (info.time.getRank() != 1) break;
                obsTable.addJoin(new JoinArray(info.time, JoinArray.Type.raw, 0));
                obsTable.time = info.time.getFullName();
                break;
            }
            case raggedContiguous: {
                stnTable.numRecords = info.ragged_rowSize.getFullName();
                obsTable = this.makeRaggedContiguousChildTable(ds, info.parentDim, info.childDim, info.childStruct, errlog);
                break;
            }
            case raggedIndex: {
                obsTable = this.makeRaggedIndexChildTable(ds, info.parentDim, info.childDim, info.ragged_parentIndex, errlog);
                break;
            }
            case flat: {
                info.set(Encoding.flat, obsDim);
                obsTable = this.makeStructTable(ds, FeatureType.STATION, info, errlog);
                obsTable.parentIndex = info.instanceId == null ? null : info.instanceId.getFullName();
                Variable stnIdVar = Evaluator.findVariableWithAttributeAndDimension(ds, "cf_role", "station_id", obsDim, errlog);
                if (stnIdVar == null) {
                    stnIdVar = Evaluator.findVariableWithAttributeAndDimension(ds, "standard_name", "station_id", obsDim, errlog);
                }
                obsTable.stnId = stnIdVar == null ? null : stnIdVar.getFullName();
                obsTable.stnDesc = Evaluator.findNameOfVariableWithAttributeValue(ds, "standard_name", "platform_name");
                if (obsTable.stnDesc == null) {
                    obsTable.stnDesc = Evaluator.findNameOfVariableWithAttributeValue(ds, "standard_name", "station_description");
                }
                obsTable.stnWmoId = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "station_WMO_id", obsDim, errlog);
                obsTable.stnAlt = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "surface_altitude", obsDim, errlog);
                if (obsTable.stnAlt != null) break;
                obsTable.stnAlt = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "station_altitude", obsDim, errlog);
            }
        }
        if (obsTable == null) {
            return null;
        }
        stnTable.addChild(obsTable);
        return stnTable;
    }

    protected TableConfig getProfileConfig(NetcdfDataset ds, EncodingInfo info, Formatter errlog) throws IOException {
        CoordinateAxis z;
        if (!this.identifyEncodingProfile(ds, info, errlog)) {
            return null;
        }
        TableConfig profileTable = this.makeStructTable(ds, FeatureType.PROFILE, info, errlog);
        if (profileTable == null) {
            return null;
        }
        profileTable.feature_id = this.identifyIdVariableName(ds, CF.FeatureType.profile);
        if (profileTable.feature_id == null) {
            errlog.format("CFpointObs getProfileConfig cant find a profile id %n", new Object[0]);
        }
        if ((z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height)) == null) {
            z = CoordSysEvaluator.findCoordByType(ds, AxisType.Pressure);
        }
        if (z == null) {
            z = CoordSysEvaluator.findCoordByType(ds, AxisType.GeoZ);
        }
        if (z == null) {
            errlog.format("CFpointObs getProfileConfig cant find a Height coordinate %n", new Object[0]);
            return null;
        }
        if (info.childStruct == null) {
            info.childStruct = z.getParentStructure();
        }
        TableConfig obsTable = null;
        switch (info.encoding) {
            case single: {
                obsTable = this.makeSingle(ds, info.childDim, errlog);
                break;
            }
            case multidim: {
                obsTable = this.makeMultidimInner(ds, profileTable, info.childDim, info, errlog);
                if (z.getRank() != 1) break;
                obsTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                obsTable.elev = z.getFullName();
                break;
            }
            case raggedContiguous: {
                profileTable.numRecords = info.ragged_rowSize.getFullName();
                obsTable = this.makeRaggedContiguousChildTable(ds, info.parentDim, info.childDim, info.childStruct, errlog);
                break;
            }
            case raggedIndex: {
                obsTable = this.makeRaggedIndexChildTable(ds, info.parentDim, info.childDim, info.ragged_parentIndex, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs: profile flat encoding");
            }
        }
        if (obsTable == null) {
            return null;
        }
        profileTable.addChild(obsTable);
        return profileTable;
    }

    protected TableConfig getTrajectoryConfig(NetcdfDataset ds, EncodingInfo info, Formatter errlog) throws IOException {
        if (!this.identifyEncodingTraj(ds, info, errlog)) {
            return null;
        }
        TableConfig trajTable = this.makeStructTable(ds, FeatureType.TRAJECTORY, info, errlog);
        if (trajTable == null) {
            return null;
        }
        trajTable.feature_id = this.identifyIdVariableName(ds, CF.FeatureType.trajectory);
        if (trajTable.feature_id == null) {
            errlog.format("CFpointObs getTrajectoryConfig cant find a trajectoy id %n", new Object[0]);
        }
        TableConfig obsConfig = null;
        switch (info.encoding) {
            case single: {
                obsConfig = this.makeSingle(ds, info.childDim, errlog);
                break;
            }
            case multidim: {
                obsConfig = this.makeMultidimInner(ds, trajTable, info.childDim, info, errlog);
                if (info.time.getRank() != 1) break;
                obsConfig.addJoin(new JoinArray(info.time, JoinArray.Type.raw, 0));
                obsConfig.time = info.time.getFullName();
                break;
            }
            case raggedContiguous: {
                trajTable.numRecords = info.ragged_rowSize.getFullName();
                obsConfig = this.makeRaggedContiguousChildTable(ds, info.parentDim, info.childDim, info.childStruct, errlog);
                break;
            }
            case raggedIndex: {
                obsConfig = this.makeRaggedIndexChildTable(ds, info.parentDim, info.childDim, info.ragged_parentIndex, errlog);
                break;
            }
            case flat: {
                throw new UnsupportedOperationException("CFpointObs: trajectory flat encoding");
            }
        }
        if (obsConfig == null) {
            return null;
        }
        trajTable.addChild(obsConfig);
        return trajTable;
    }

    protected TableConfig getTimeSeriesProfileConfig(NetcdfDataset ds, EncodingInfo info, Formatter errlog) throws IOException {
        if (!this.identifyEncodingTimeSeriesProfile(ds, info, CF.FeatureType.timeSeriesProfile, errlog)) {
            return null;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            return null;
        }
        if (time.getRank() == 0 && time.getParentStructure() == null) {
            errlog.format("CFpointObs timeSeriesProfile cannot have a scalar time coordinate%n", new Object[0]);
            return null;
        }
        TableConfig stationTable = this.makeStationTable(ds, FeatureType.STATION_PROFILE, info, errlog);
        if (stationTable == null) {
            return null;
        }
        VariableDS z = info.alt;
        switch (info.encoding) {
            case single: {
                TableConfig profileTable;
                assert (time.getRank() >= 1 && time.getRank() <= 2) : "time must be rank 1 or 2";
                assert (z.getRank() >= 1 && z.getRank() <= 2) : "z must be rank 1 or 2";
                if (time.getRank() == 2) {
                    if (z.getRank() == 2) {
                        assert (time.getDimensions().equals(z.getDimensions())) : "rank-2 time and z dimensions must be the same";
                    } else assert (time.getDimension(1).equals(z.getDimension(0))) : "rank-2 time must have z inner dimension";
                } else if (z.getRank() == 2) {
                    assert (z.getDimension(0).equals(time.getDimension(0))) : "rank-2 z must have time outer dimension";
                } else assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                if ((profileTable = this.makeStructTable(ds, FeatureType.PROFILE, new EncodingInfo().set(Encoding.multidim, info.childDim), errlog)) == null) {
                    return null;
                }
                if (time.getRank() == 1) {
                    profileTable.addJoin(new JoinArray(time, JoinArray.Type.level, 1));
                    profileTable.time = time.getFullName();
                }
                stationTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner(ds, profileTable, info.grandChildDim, info, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                    zTable.elev = z.getFullName();
                }
                profileTable.addChild(zTable);
                break;
            }
            case multidim: {
                TableConfig profileTable;
                assert (time.getRank() >= 1 && time.getRank() <= 3) : "time must be rank 2 or 3";
                assert (z.getRank() == 1 || z.getRank() == 3) : "z must be rank 1 or 3";
                if (time.getRank() == 3) {
                    if (z.getRank() == 3) {
                        assert (time.getDimensions().equals(z.getDimensions())) : "rank-3 time and z dimensions must be the same";
                    } else assert (time.getDimension(2).equals(z.getDimension(0))) : "rank-3 time must have z inner dimension";
                } else if (time.getRank() == 2) {
                    if (z.getRank() == 3) {
                        assert (z.getDimension(1).equals(time.getDimension(1))) : "rank-2 time must have time inner dimension";
                    } else {
                        assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                        assert (!time.getDimension(1).equals(z.getDimension(0))) : "time and z dimensions must be different";
                    }
                } else if (z.getRank() == 1) assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                if ((profileTable = this.makeMultidimInner(ds, stationTable, info.childDim, info, errlog)) == null) {
                    return null;
                }
                if (time.getRank() == 1) {
                    profileTable.addJoin(new JoinArray(time, JoinArray.Type.level, 1));
                    profileTable.time = time.getFullName();
                }
                stationTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner3D(ds, stationTable, profileTable, info.grandChildDim, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                    zTable.elev = z.getFullName();
                }
                profileTable.addChild(zTable);
                break;
            }
            case raggedIndex: {
                TableConfig profileTable = this.makeRaggedIndexChildTable(ds, info.parentDim, info.childDim, info.ragged_parentIndex, errlog);
                stationTable.addChild(profileTable);
                profileTable.numRecords = info.ragged_rowSize.getFullName();
                TableConfig obsTable = this.makeRaggedContiguousChildTable(ds, info.childDim, info.grandChildDim, info.grandChildStruct, errlog);
                profileTable.addChild(obsTable);
                break;
            }
            case raggedContiguous: {
                throw new UnsupportedOperationException("CFpointObs: timeSeriesProfile raggedContiguous encoding not allowed");
            }
        }
        return stationTable;
    }

    protected TableConfig getSectionConfig(NetcdfDataset ds, EncodingInfo info, Formatter errlog) throws IOException {
        if (!this.identifyEncodingSection(ds, info, CF.FeatureType.trajectoryProfile, errlog)) {
            return null;
        }
        TableConfig parentTable = this.makeStructTable(ds, FeatureType.TRAJECTORY_PROFILE, info, errlog);
        if (parentTable == null) {
            return null;
        }
        parentTable.feature_id = this.identifyIdVariableName(ds, CF.FeatureType.trajectoryProfile);
        if (parentTable.feature_id == null) {
            errlog.format("CFpointObs:getSectionConfig cant find a section id %n", new Object[0]);
        }
        VariableDS time = info.time;
        VariableDS z = info.alt;
        switch (info.encoding) {
            case single: {
                TableConfig profileTable;
                assert (time.getRank() >= 1 && time.getRank() <= 2) : "time must be rank 1 or 2";
                assert (z.getRank() >= 1 && z.getRank() <= 2) : "z must be rank 1 or 2";
                if (time.getRank() == 2) {
                    if (z.getRank() == 2) {
                        assert (time.getDimensions().equals(z.getDimensions())) : "rank-2 time and z dimensions must be the same";
                    } else assert (time.getDimension(1).equals(z.getDimension(0))) : "rank-2 time must have z inner dimension";
                } else if (z.getRank() == 2) {
                    assert (z.getDimension(0).equals(time.getDimension(0))) : "rank-2 z must have time outer dimension";
                } else assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                if ((profileTable = this.makeStructTable(ds, FeatureType.PROFILE, new EncodingInfo().set(Encoding.multidim, info.childDim), errlog)) == null) {
                    return null;
                }
                if (time.getRank() == 1) {
                    profileTable.addJoin(new JoinArray(time, JoinArray.Type.raw, 0));
                    profileTable.time = time.getFullName();
                }
                parentTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner(ds, profileTable, info.grandChildDim, info, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                    zTable.elev = z.getFullName();
                }
                profileTable.addChild(zTable);
                break;
            }
            case multidim: {
                TableConfig profileTable;
                assert (time.getRank() >= 2 && time.getRank() <= 3) : "time must be rank 2 or 3";
                assert (z.getRank() == 1 || z.getRank() == 3) : "z must be rank 1 or 3";
                if (time.getRank() == 3) {
                    if (z.getRank() == 3) {
                        assert (time.getDimensions().equals(z.getDimensions())) : "rank-3 time and z dimensions must be the same";
                    } else assert (time.getDimension(2).equals(z.getDimension(0))) : "rank-3 time must have z inner dimension";
                } else if (z.getRank() == 3) {
                    assert (z.getDimension(1).equals(time.getDimension(1))) : "rank-2 time must have time inner dimension";
                } else {
                    assert (!time.getDimension(0).equals(z.getDimension(0))) : "time and z dimensions must be different";
                    assert (!time.getDimension(1).equals(z.getDimension(0))) : "time and z dimensions must be different";
                }
                if ((profileTable = this.makeMultidimInner(ds, parentTable, info.childDim, info, errlog)) == null) {
                    return null;
                }
                profileTable.feature_id = this.identifyIdVariableName(ds, CF.FeatureType.profile);
                parentTable.addChild(profileTable);
                TableConfig zTable = this.makeMultidimInner3D(ds, parentTable, profileTable, info.grandChildDim, errlog);
                if (z.getRank() == 1) {
                    zTable.addJoin(new JoinArray(z, JoinArray.Type.raw, 0));
                    zTable.elev = z.getFullName();
                }
                profileTable.addChild(zTable);
                break;
            }
            case raggedIndex: {
                TableConfig profileTable = this.makeRaggedIndexChildTable(ds, info.parentDim, info.childDim, info.ragged_parentIndex, errlog);
                profileTable.feature_id = this.identifyIdVariableName(ds, CF.FeatureType.profile);
                if (profileTable.feature_id == null) {
                    errlog.format("CFpointObs:getSectionConfig cant find a profile id %n", new Object[0]);
                }
                parentTable.addChild(profileTable);
                profileTable.numRecords = info.ragged_rowSize.getFullName();
                TableConfig obsTable = this.makeRaggedContiguousChildTable(ds, info.childDim, info.grandChildDim, info.grandChildStruct, errlog);
                profileTable.addChild(obsTable);
                break;
            }
            case raggedContiguous: {
                throw new UnsupportedOperationException("CFpointObs: section raggedContiguous encoding " + (Object)((Object)info.encoding));
            }
        }
        return parentTable;
    }

    protected boolean identifyEncodingStation(NetcdfDataset ds, EncodingInfo info, CF.FeatureType ftype, Formatter errlog) {
        Dimension obsDim = null;
        if (info.time.getRank() > 0) {
            obsDim = info.time.getDimension(info.time.getRank() - 1);
        } else if (info.time.getParentStructure() != null) {
            Structure parent = info.time.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("CFpointObs: must have a non-scalar Time coordinate%n", new Object[0]);
            return false;
        }
        if (info.lat.getRank() == 0) {
            info.set(Encoding.single, null, obsDim);
            return true;
        }
        Dimension stnDim = info.lat.getDimension(0);
        if (obsDim == stnDim) {
            info.set(Encoding.flat, null, obsDim);
            return true;
        }
        if (this.identifyRaggeds(ds, info, stnDim, obsDim, errlog)) {
            return true;
        }
        if (info.lat.getRank() == 1) {
            info.set(Encoding.multidim, stnDim, obsDim);
            return true;
        }
        errlog.format("CFpointObs: %s Must have Lat/Lon coordinates of rank 0 or 1%n", new Object[]{ftype});
        return false;
    }

    protected boolean identifyRaggeds(NetcdfDataset ds, EncodingInfo info, Dimension instanceDim, Dimension sampleDim, Formatter errlog) {
        Evaluator.VarAtt varatt = Evaluator.findVariableWithAttribute(ds, "sample_dimension");
        if (varatt == null) {
            varatt = Evaluator.findVariableWithAttribute(ds, "CF:ragged_row_count");
        }
        if (varatt != null) {
            Dimension rrDim;
            Variable ragged_rowSize = varatt.var;
            String sampleDimName = varatt.att.getStringValue();
            if (sampleDim != null && !sampleDimName.equals(sampleDim.getShortName())) {
                errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable has sample dimension %s must be %s%n", sampleDimName, sampleDim.getShortName());
                return false;
            }
            if (sampleDim == null && (sampleDim = ds.findDimension(sampleDimName)) == null) {
                errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable has invalid sample dimension %s%n", sampleDimName);
                return false;
            }
            if (ragged_rowSize.getRank() > 0) {
                rrDim = ragged_rowSize.getDimension(0);
            } else if (ragged_rowSize.getParentStructure() != null) {
                Structure parent = ragged_rowSize.getParentStructure();
                rrDim = parent.getDimension(0);
            } else {
                errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable (%s) must have rank 1%n", ragged_rowSize);
                return false;
            }
            if (instanceDim != null && instanceDim != rrDim) {
                errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable has invalid instance dimension %s must be %s%n", rrDim, instanceDim);
                return false;
            }
            instanceDim = rrDim;
            if (ragged_rowSize.getDataType() != DataType.INT) {
                errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable must be of type integer%n", new Object[0]);
                return false;
            }
            info.set(Encoding.raggedContiguous, instanceDim, sampleDim);
            info.ragged_rowSize = ragged_rowSize;
            info.parentStruct = ragged_rowSize.getParentStructure();
            return true;
        }
        varatt = Evaluator.findVariableWithAttribute(ds, "instance_dimension");
        if (varatt == null) {
            varatt = Evaluator.findVariableWithAttribute(ds, "CF:ragged_parent_index");
        }
        if (varatt != null) {
            Variable ragged_parentIndex = varatt.var;
            String instanceDimName = varatt.att.getStringValue();
            if (instanceDim != null && !instanceDimName.equals(instanceDim.getShortName())) {
                errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable has instance dimension %s must be %s%n", instanceDimName, instanceDim.getShortName());
                return false;
            }
            if (instanceDim == null && (instanceDim = ds.findDimension(instanceDimName)) == null) {
                errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable has invalid instance dimension %s%n", instanceDimName);
                return false;
            }
            if (ragged_parentIndex.getDataType() != DataType.INT) {
                errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable must be of type integer%n", new Object[0]);
                return false;
            }
            if (ragged_parentIndex.isMemberOfStructure()) {
                Structure s = ragged_parentIndex.getParentStructure();
                if (s.getRank() == 0 || !s.getDimension(0).equals(sampleDim)) {
                    errlog.format("CFpointObs: Indexed ragged array representation (structure): parent_index variable must be of form Struct { %s }(%s) %n", ragged_parentIndex.getFullName(), sampleDim.getShortName());
                    return false;
                }
            } else if (ragged_parentIndex.getRank() != 1 || !ragged_parentIndex.getDimension(0).equals(sampleDim)) {
                errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable must be of form %s(%s) %n", ragged_parentIndex.getFullName(), sampleDim.getShortName());
                return false;
            }
            info.set(Encoding.raggedIndex, instanceDim, sampleDim);
            info.ragged_parentIndex = ragged_parentIndex;
            info.childStruct = ragged_parentIndex.getParentStructure();
            return true;
        }
        return false;
    }

    protected boolean identifyDoubleRaggeds(NetcdfDataset ds, EncodingInfo info, Formatter errlog) {
        Dimension profileDim2;
        Evaluator.VarAtt varatt = Evaluator.findVariableWithAttribute(ds, "instance_dimension");
        if (varatt == null) {
            varatt = Evaluator.findVariableWithAttribute(ds, "CF:ragged_parent_index");
        }
        if (varatt == null) {
            return false;
        }
        Variable ragged_parentIndex = varatt.var;
        String instanceDimName = varatt.att.getStringValue();
        Dimension stationDim = ds.findDimension(instanceDimName);
        if (stationDim == null) {
            errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable has illegal value for %s = %s%n", "instance_dimension", instanceDimName);
            return false;
        }
        if (ragged_parentIndex.getDataType() != DataType.INT) {
            errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable must be of type integer%n", new Object[0]);
            return false;
        }
        if (ragged_parentIndex.getRank() != 1 && info.childStruct == null) {
            errlog.format("CFpointObs: Indexed ragged array representation: parent_index variable %s must be 1D %n", ragged_parentIndex);
            return false;
        }
        Dimension profileDim = info.childDim != null ? info.childDim : ragged_parentIndex.getDimension(0);
        varatt = Evaluator.findVariableWithAttribute(ds, "sample_dimension");
        if (varatt == null) {
            varatt = Evaluator.findVariableWithAttribute(ds, "CF:ragged_row_count");
        }
        if (varatt == null) {
            return false;
        }
        Variable ragged_rowSize = varatt.var;
        String obsDimName = varatt.att.getStringValue();
        Dimension obsDim = ds.findDimension(obsDimName);
        if (obsDimName == null) {
            errlog.format("CFpointObs: Contiguous ragged array representation: parent_index variable has illegal value for %s = %s%n", "sample_dimension", obsDimName);
            return false;
        }
        if (!obsDimName.equals(info.grandChildDim.getShortName())) {
            errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable has obs dimension %s must be %s%n", obsDimName, info.childDim);
            return false;
        }
        if (ragged_rowSize.getDataType() != DataType.INT) {
            errlog.format("CFpointObs: Contiguous ragged array representation: row_size variable must be of type integer%n", new Object[0]);
            return false;
        }
        if (info.childDim == null && (profileDim2 = ragged_rowSize.getDimension(0)) != profileDim) {
            errlog.format("CFpointObs: Double ragged array representation dimensions do not agree: %s != %s%n", profileDim2.getShortName(), profileDim.getShortName());
            return false;
        }
        info.set(Encoding.raggedIndex, stationDim, profileDim, obsDim);
        info.ragged_parentIndex = ragged_parentIndex;
        info.ragged_rowSize = ragged_rowSize;
        return true;
    }

    protected boolean identifyEncodingProfile(NetcdfDataset ds, EncodingInfo info, Formatter errlog) {
        Dimension parentDim;
        CoordinateAxis z = CoordSysEvaluator.findCoordByType(ds, AxisType.Height);
        if (z == null) {
            z = CoordSysEvaluator.findCoordByType(ds, AxisType.Pressure);
        }
        if (z == null) {
            z = CoordSysEvaluator.findCoordByType(ds, AxisType.GeoZ);
        }
        if (z == null) {
            errlog.format("CFpointObs: Must have a Height coordinate%n", new Object[0]);
            return false;
        }
        info.alt = z;
        Dimension obsDim = null;
        if (z.getRank() > 0) {
            obsDim = z.getDimension(z.getRank() - 1);
        } else if (z.getParentStructure() != null) {
            Structure parent = z.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("CFpointObs: Must have a non-scalar Height coordinate%n", new Object[0]);
            return false;
        }
        if (this.identifyRaggeds(ds, info, null, obsDim, errlog)) {
            return true;
        }
        if (z.getRank() > 1) {
            parentDim = z.getDimension(0);
            info.set(Encoding.multidim, parentDim, obsDim);
            return true;
        }
        CoordinateAxis time = CoordSysEvaluator.findCoordByType(ds, AxisType.Time);
        if (time == null) {
            return false;
        }
        if (time.getRank() == 0 || time.getDimension(0) == obsDim) {
            info.set(Encoding.single, null, obsDim);
            return true;
        }
        parentDim = time.getDimension(0);
        info.set(Encoding.multidim, parentDim, obsDim);
        return true;
    }

    protected boolean identifyEncodingTraj(NetcdfDataset ds, EncodingInfo info, Formatter errlog) {
        Dimension obsDim = null;
        if (info.time.getRank() > 0) {
            obsDim = info.time.getDimension(info.time.getRank() - 1);
        } else if (info.time.getParentStructure() != null) {
            Structure parent = info.time.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("CFpointObs: Must have a non-scalar Time coordinate%n", new Object[0]);
            return false;
        }
        if (this.identifyRaggeds(ds, info, null, obsDim, errlog)) {
            return true;
        }
        if (info.time.getRank() > 1) {
            Dimension parentDim = info.time.getDimension(0);
            info.set(Encoding.multidim, parentDim, obsDim);
            return true;
        }
        if (info.lat.getRank() > 0) {
            for (Dimension d : info.lat.getDimensions()) {
                if (d.equals(obsDim)) continue;
                info.set(Encoding.multidim, d, obsDim);
                return true;
            }
        }
        info.set(Encoding.single, null, obsDim);
        return true;
    }

    protected boolean identifyEncodingSection(NetcdfDataset ds, EncodingInfo info, CF.FeatureType ftype, Formatter errlog) {
        Dimension trajDim;
        CoordinateAxis z = this.findZAxisNotStationAlt(ds);
        if (z == null) {
            errlog.format("CFpointObs: section must have a z coordinate%n", new Object[0]);
            return false;
        }
        if (z.getRank() == 0) {
            errlog.format("CFpointObs: section cannot have a scalar z coordinate%n", new Object[0]);
            return false;
        }
        info.alt = z;
        Dimension obsDim = null;
        if (z.getRank() > 0) {
            obsDim = z.getDimension(z.getRank() - 1);
        } else if (z.getParentStructure() != null) {
            Structure parent = z.getParentStructure();
            obsDim = parent.getDimension(parent.getRank() - 1);
        }
        if (obsDim == null) {
            errlog.format("CFpointObs: Must have a non-scalar Height coordinate%n", new Object[0]);
            return false;
        }
        info.grandChildDim = obsDim;
        if (z.getRank() > 2) {
            trajDim = z.getDimension(0);
            Dimension profileDim = z.getDimension(1);
            info.set(Encoding.multidim, trajDim, profileDim, obsDim);
            return true;
        }
        if (this.identifyDoubleRaggeds(ds, info, errlog)) {
            return true;
        }
        if (info.time.getRank() > 2) {
            trajDim = info.time.getDimension(0);
            Dimension profileDim = info.time.getDimension(1);
            info.set(Encoding.multidim, trajDim, profileDim, obsDim);
            return true;
        }
        if (info.lat.getRank() == 1) {
            Dimension profileDim = info.lat.getDimension(0);
            info.set(Encoding.single, null, profileDim, obsDim);
            return true;
        }
        if (info.lat.getRank() == 2) {
            trajDim = info.lat.getDimension(0);
            Dimension profileDim = info.lat.getDimension(0);
            info.set(Encoding.multidim, trajDim, profileDim, obsDim);
            return true;
        }
        errlog.format("CFpointObs %s unrecognized form%n", new Object[]{ftype});
        return false;
    }

    protected boolean identifyEncodingTimeSeriesProfile(NetcdfDataset ds, EncodingInfo info, CF.FeatureType ftype, Formatter errlog) {
        CoordinateAxis z = this.findZAxisNotStationAlt(ds);
        if (z == null) {
            errlog.format("CFpointObs: timeSeriesProfile must have a z coordinate, not the station altitude%n", new Object[0]);
            return false;
        }
        if (z.getRank() == 0) {
            errlog.format("CFpointObs: timeSeriesProfile cannot have a scalar z coordinate%n", new Object[0]);
            return false;
        }
        Dimension obsDim = z.getDimension(z.getRank() - 1);
        info.alt = z;
        info.grandChildDim = obsDim;
        if (z.getRank() > 2) {
            Dimension stnDim = z.getDimension(0);
            Dimension profileDim = z.getDimension(1);
            info.set(Encoding.multidim, stnDim, profileDim, obsDim);
            return true;
        }
        if (this.identifyDoubleRaggeds(ds, info, errlog)) {
            return true;
        }
        if (info.lat.getRank() == 0) {
            Dimension profileDim = info.time.getDimension(0);
            info.set(Encoding.single, null, profileDim, obsDim);
            return true;
        }
        Dimension stnDim = info.lat.getDimension(0);
        if (info.time.getRank() == 1 || info.time.getRank() == 2 && info.time.getDimension(1) == obsDim) {
            Dimension profileDim = info.time.getDimension(0);
            info.set(Encoding.multidim, stnDim, profileDim, obsDim);
            return true;
        }
        if (info.time.getRank() > 2) {
            Dimension profileDim = info.time.getDimension(1);
            info.set(Encoding.multidim, stnDim, profileDim, obsDim);
            return true;
        }
        if (info.time.getRank() == 2 && info.time.getDimension(0) == stnDim) {
            Dimension profileDim = info.time.getDimension(1);
            info.set(Encoding.multidim, stnDim, profileDim, obsDim);
            return true;
        }
        errlog.format("CFpointObs %s unrecognized form%n", new Object[]{ftype});
        return false;
    }

    private String identifyIdVariableName(NetcdfDataset ds, CF.FeatureType ftype) {
        Variable v = this.identifyIdVariable(ds, ftype);
        return v == null ? null : v.getFullName();
    }

    private Variable identifyIdVariable(NetcdfDataset ds, CF.FeatureType ftype) {
        switch (ftype) {
            case timeSeries: 
            case timeSeriesProfile: {
                Variable result = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "timeseries_id");
                if (result != null) {
                    return result;
                }
                return Evaluator.findVariableWithAttributeValue(ds, "standard_name", "station_id");
            }
            case trajectory: 
            case trajectoryProfile: {
                Variable result = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "trajectory_id");
                if (result != null) {
                    return result;
                }
                return Evaluator.findVariableWithAttributeValue(ds, "standard_name", "trajectory_id");
            }
            case profile: {
                Variable result = Evaluator.findVariableWithAttributeValue(ds, "cf_role", "profile_id");
                if (result != null) {
                    return result;
                }
                return Evaluator.findVariableWithAttributeValue(ds, "standard_name", "profile_id");
            }
        }
        return null;
    }

    private TableConfig makeStationTable(NetcdfDataset ds, FeatureType ftype, EncodingInfo info, Formatter errlog) throws IOException {
        CoordinateAxis alt;
        CoordinateAxis lat = CoordSysEvaluator.findCoordByType(ds, AxisType.Lat);
        CoordinateAxis lon = CoordSysEvaluator.findCoordByType(ds, AxisType.Lon);
        if (lat == null || lon == null) {
            errlog.format("CFpointObs: must have lat and lon coordinates%n", new Object[0]);
            return null;
        }
        Table.Type stationTableType = Table.Type.Structure;
        if (info.encoding == Encoding.single) {
            stationTableType = Table.Type.Top;
        }
        if (info.encoding == Encoding.flat) {
            stationTableType = Table.Type.Construct;
        }
        Dimension stationDim = info.encoding == Encoding.flat ? info.childDim : info.parentDim;
        String name = stationDim == null ? " single" : stationDim.getShortName();
        TableConfig stnTable = new TableConfig(stationTableType, name);
        stnTable.featureType = ftype;
        Variable stnIdVar = Evaluator.findVariableWithAttributeAndDimension(ds, "cf_role", "timeseries_id", stationDim, errlog);
        if (stnIdVar == null) {
            stnIdVar = Evaluator.findVariableWithAttributeAndDimension(ds, "standard_name", "station_id", stationDim, errlog);
        }
        if (stnIdVar == null) {
            errlog.format("CFpointObs: must have a Station id variable with %s = %s%n", "cf_role", "timeseries_id");
            return null;
        }
        stnTable.stnId = stnIdVar.getFullName();
        info.instanceId = stnIdVar;
        stnTable.stnDesc = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "platform_name", stationDim, errlog);
        if (stnTable.stnDesc == null) {
            stnTable.stnDesc = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "station_description", stationDim, errlog);
        }
        stnTable.stnWmoId = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "platform_id", stationDim, errlog);
        if (stnTable.stnWmoId == null) {
            stnTable.stnWmoId = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "station_WMO_id", stationDim, errlog);
        }
        stnTable.stnAlt = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "surface_altitude", stationDim, errlog);
        if (stnTable.stnAlt == null) {
            stnTable.stnAlt = Evaluator.findNameVariableWithStandardNameAndDimension(ds, "station_altitude", stationDim, errlog);
        }
        stnTable.lat = lat.getFullName();
        stnTable.lon = lon.getFullName();
        if (info.encoding != Encoding.single && stationDim != null) {
            stnTable.dimName = stationDim.getShortName();
            this.makeStructureInfo(stnTable, ds, stnIdVar.getParentStructure(), stationDim);
        }
        if (stnTable.stnAlt == null && (alt = CoordSysEvaluator.findCoordByType(ds, AxisType.Height)) != null) {
            if (info.encoding == Encoding.single && alt.getRank() == 0) {
                stnTable.stnAlt = alt.getFullName();
            }
            if (info.encoding != Encoding.single && lat.getRank() == alt.getRank() && alt.getRank() > 0 && alt.getDimension(0).equals(stationDim)) {
                stnTable.stnAlt = alt.getFullName();
            }
        }
        return stnTable;
    }

    private void makeStructureInfo(TableConfig tableConfig, NetcdfDataset ds, Structure parent, Dimension dim) {
        tableConfig.dimName = dim.getShortName();
        if (parent != null) {
            tableConfig.structureType = TableConfig.StructureType.Structure;
            tableConfig.structName = parent.getShortName();
        } else {
            boolean hasNetcdf3Struct = Evaluator.hasNetcdf3RecordStructure(ds) && dim.isUnlimited();
            tableConfig.structureType = hasNetcdf3Struct ? TableConfig.StructureType.Structure : TableConfig.StructureType.PsuedoStructure;
            tableConfig.structName = hasNetcdf3Struct ? "record" : dim.getShortName();
        }
    }

    private TableConfig makeStructTable(NetcdfDataset ds, FeatureType ftype, EncodingInfo info, Formatter errlog) throws IOException {
        Table.Type tableType = Table.Type.Structure;
        if (info.encoding == Encoding.single) {
            tableType = Table.Type.Top;
        }
        if (info.encoding == Encoding.flat) {
            tableType = Table.Type.ParentId;
        }
        String name = info.parentDim == null ? " single" : info.parentDim.getShortName();
        TableConfig tableConfig = new TableConfig(tableType, name);
        tableConfig.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, info.parentDim);
        tableConfig.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, info.parentDim);
        tableConfig.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, info.parentDim);
        if (tableConfig.elev == null) {
            tableConfig.elev = this.matchAxisTypeAndDimension(ds, AxisType.Pressure, info.parentDim);
        }
        if (tableConfig.elev == null) {
            tableConfig.elev = this.matchAxisTypeAndDimension(ds, AxisType.GeoZ, info.parentDim);
        }
        tableConfig.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, info.parentDim);
        tableConfig.featureType = ftype;
        if (info.encoding != Encoding.single && info.parentDim != null) {
            tableConfig.dimName = name;
            Structure parent = info.parentStruct;
            if (parent == null) {
                switch (info.encoding) {
                    case raggedContiguous: {
                        parent = info.ragged_rowSize.getParentStructure();
                        break;
                    }
                    case raggedIndex: {
                        parent = info.ragged_parentIndex.getParentStructure();
                    }
                }
            }
            this.makeStructureInfo(tableConfig, ds, parent, info.parentDim);
        }
        return tableConfig;
    }

    private TableConfig makeStructTableTestTraj(NetcdfDataset ds, FeatureType ftype, EncodingInfo info, Formatter errlog) throws IOException {
        Table.Type tableType = Table.Type.Structure;
        if (info.encoding == Encoding.single) {
            tableType = Table.Type.Top;
        }
        if (info.encoding == Encoding.flat) {
            tableType = Table.Type.ParentId;
        }
        String name = info.parentDim == null ? " single" : info.parentDim.getShortName();
        TableConfig tableConfig = new TableConfig(tableType, name);
        tableConfig.lat = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lat);
        tableConfig.lon = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Lon);
        tableConfig.elev = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Height);
        if (tableConfig.elev == null) {
            tableConfig.elev = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Pressure);
        }
        if (tableConfig.elev == null) {
            tableConfig.elev = CoordSysEvaluator.findCoordNameByType(ds, AxisType.GeoZ);
        }
        tableConfig.time = CoordSysEvaluator.findCoordNameByType(ds, AxisType.Time);
        tableConfig.featureType = ftype;
        if (info.encoding != Encoding.single && info.parentDim != null) {
            tableConfig.dimName = name;
            this.makeStructureInfo(tableConfig, ds, null, info.parentDim);
        }
        return tableConfig;
    }

    private TableConfig makeRaggedContiguousChildTable(NetcdfDataset ds, Dimension parentDim, Dimension childDim, Structure childStruct, Formatter errlog) throws IOException {
        TableConfig childTable = new TableConfig(Table.Type.Contiguous, childDim.getShortName());
        childTable.dimName = childDim.getShortName();
        childTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, childDim);
        childTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, childDim);
        childTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, childDim);
        if (childTable.elev == null) {
            childTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Pressure, childDim);
        }
        if (childTable.elev == null) {
            childTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.GeoZ, childDim);
        }
        childTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, childDim);
        this.makeStructureInfo(childTable, ds, childStruct, childDim);
        return childTable;
    }

    private TableConfig makeRaggedIndexChildTable(NetcdfDataset ds, Dimension parentDim, Dimension childDim, Variable ragged_parentIndex, Formatter errlog) throws IOException {
        TableConfig childTable = new TableConfig(Table.Type.ParentIndex, childDim.getShortName());
        childTable.dimName = childDim.getShortName();
        childTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, childDim);
        childTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, childDim);
        childTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, childDim);
        if (childTable.elev == null) {
            childTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Pressure, childDim);
        }
        if (childTable.elev == null) {
            childTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.GeoZ, childDim);
        }
        childTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, childDim);
        this.makeStructureInfo(childTable, ds, ragged_parentIndex.getParentStructure(), childDim);
        childTable.parentIndex = ragged_parentIndex.getFullName();
        return childTable;
    }

    private TableConfig makeMultidimInner(NetcdfDataset ds, TableConfig parentTable, Dimension obsDim, EncodingInfo info, Formatter errlog) throws IOException {
        Dimension parentDim = ds.findDimension(parentTable.dimName);
        Table.Type obsTableType = parentTable.structureType == TableConfig.StructureType.PsuedoStructure ? Table.Type.MultidimInnerPsuedo : Table.Type.MultidimInner;
        TableConfig obsTable = new TableConfig(obsTableType, obsDim.getShortName());
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, parentDim, obsDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, parentDim, obsDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, parentDim, obsDim);
        if (obsTable.elev == null) {
            obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Pressure, parentDim, obsDim);
        }
        if (obsTable.elev == null) {
            obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.GeoZ, parentDim, obsDim);
        }
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, parentDim, obsDim);
        List<Variable> vars = ds.getVariables();
        ArrayList<String> parentVars = new ArrayList<String>(vars.size());
        ArrayList<String> obsVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            Dimension dim0;
            if (orgV instanceof Structure || (dim0 = orgV.getDimension(0)) == null || !dim0.equals(parentDim)) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                parentVars.add(orgV.getShortName());
                continue;
            }
            Dimension dim1 = orgV.getDimension(1);
            if (dim1 == null || !dim1.equals(obsDim)) continue;
            obsVars.add(orgV.getShortName());
        }
        parentTable.vars = parentVars;
        obsTable.structureType = parentTable.structureType;
        obsTable.outerName = parentDim.getShortName();
        obsTable.innerName = obsDim.getShortName();
        obsTable.dimName = parentTable.structureType == TableConfig.StructureType.PsuedoStructure ? obsTable.outerName : obsTable.innerName;
        obsTable.structName = obsDim.getShortName();
        obsTable.vars = obsVars;
        return obsTable;
    }

    private TableConfig makeMultidimInner3D(NetcdfDataset ds, TableConfig outerTable, TableConfig middleTable, Dimension innerDim, Formatter errlog) throws IOException {
        Dimension outerDim = ds.findDimension(outerTable.dimName);
        Dimension middleDim = ds.findDimension(middleTable.innerName);
        Table.Type obsTableType = outerTable.structureType == TableConfig.StructureType.PsuedoStructure ? Table.Type.MultidimInnerPsuedo3D : Table.Type.MultidimInner3D;
        TableConfig obsTable = new TableConfig(obsTableType, innerDim.getShortName());
        obsTable.structureType = TableConfig.StructureType.PsuedoStructure2D;
        obsTable.dimName = outerTable.dimName;
        obsTable.outerName = middleTable.innerName;
        obsTable.innerName = innerDim.getShortName();
        obsTable.structName = innerDim.getShortName();
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, outerDim, middleDim, innerDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, outerDim, middleDim, innerDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, outerDim, middleDim, innerDim);
        if (obsTable.elev == null) {
            obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Pressure, middleDim, innerDim);
        }
        if (obsTable.elev == null) {
            obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.GeoZ, middleDim, innerDim);
        }
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, outerDim, middleDim, innerDim);
        List<Variable> vars = ds.getVariables();
        ArrayList<String> outerVars = new ArrayList<String>(vars.size());
        ArrayList<String> middleVars = new ArrayList<String>(vars.size());
        ArrayList<String> innerVars = new ArrayList<String>(vars.size());
        for (Variable orgV : vars) {
            if (orgV instanceof Structure) continue;
            if (orgV.getRank() == 1 || orgV.getRank() == 2 && orgV.getDataType() == DataType.CHAR) {
                if (!outerDim.equals(orgV.getDimension(0))) continue;
                outerVars.add(orgV.getShortName());
                continue;
            }
            if (orgV.getRank() == 2) {
                if (!outerDim.equals(orgV.getDimension(0)) || !middleDim.equals(orgV.getDimension(1))) continue;
                middleVars.add(orgV.getShortName());
                continue;
            }
            if (orgV.getRank() != 3 || !outerDim.equals(orgV.getDimension(0)) || !middleDim.equals(orgV.getDimension(1)) || !innerDim.equals(orgV.getDimension(2))) continue;
            innerVars.add(orgV.getShortName());
        }
        outerTable.vars = outerVars;
        middleTable.vars = middleVars;
        obsTable.vars = innerVars;
        return obsTable;
    }

    private TableConfig makeSingle(NetcdfDataset ds, Dimension obsDim, Formatter errlog) throws IOException {
        Table.Type obsTableType = Table.Type.Structure;
        TableConfig obsTable = new TableConfig(obsTableType, "single");
        obsTable.dimName = obsDim.getShortName();
        obsTable.lat = this.matchAxisTypeAndDimension(ds, AxisType.Lat, obsDim);
        obsTable.lon = this.matchAxisTypeAndDimension(ds, AxisType.Lon, obsDim);
        obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Height, obsDim);
        if (obsTable.elev == null) {
            obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.Pressure, obsDim);
        }
        if (obsTable.elev == null) {
            obsTable.elev = this.matchAxisTypeAndDimension(ds, AxisType.GeoZ, obsDim);
        }
        obsTable.time = this.matchAxisTypeAndDimension(ds, AxisType.Time, obsDim);
        this.makeStructureInfo(obsTable, ds, null, obsDim);
        return obsTable;
    }

    private TableConfig makeMiddleTable(NetcdfDataset ds, TableConfig parentTable, Dimension obsDim, Formatter errlog) throws IOException {
        throw new UnsupportedOperationException("CFpointObs: middleTable encoding");
    }

    protected String matchAxisTypeAndDimension(NetcdfDataset ds, AxisType type, final Dimension outer) {
        CoordinateAxis var = CoordSysEvaluator.findCoordByType(ds, type, new CoordSysEvaluator.Predicate(){

            @Override
            public boolean match(CoordinateAxis axis) {
                if (outer == null && axis.getRank() == 0) {
                    return true;
                }
                if (outer != null && axis.getRank() == 1 && outer.equals(axis.getDimension(0))) {
                    return true;
                }
                if (axis.getParentStructure() != null) {
                    Structure parent = axis.getParentStructure();
                    if (outer != null && parent.getRank() == 1 && outer.equals(parent.getDimension(0))) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (var == null) {
            return null;
        }
        return var.getFullName();
    }

    protected static class EncodingInfo {
        Encoding encoding;
        VariableDS lat;
        VariableDS lon;
        VariableDS alt;
        VariableDS time;
        Dimension parentDim;
        Dimension childDim;
        Dimension grandChildDim;
        Variable instanceId;
        Variable ragged_parentIndex;
        Variable ragged_rowSize;
        Structure parentStruct;
        Structure childStruct;
        Structure grandChildStruct;

        protected EncodingInfo() {
        }

        EncodingInfo set(Encoding encoding, Dimension parentDim) {
            this.encoding = encoding;
            this.parentDim = parentDim;
            return this;
        }

        EncodingInfo set(Encoding encoding, Dimension parentDim, Dimension childDim) {
            this.encoding = encoding;
            this.parentDim = parentDim;
            this.childDim = childDim;
            return this;
        }

        EncodingInfo set(Encoding encoding, Dimension parentDim, Dimension childDim, Dimension grandChildDim) {
            this.encoding = encoding;
            this.parentDim = parentDim;
            this.childDim = childDim;
            this.grandChildDim = grandChildDim;
            return this;
        }
    }

    protected static enum Encoding {
        single,
        multidim,
        raggedContiguous,
        raggedIndex,
        flat;

    }
}

