/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ListenerManager {
    private static final Logger logger = LoggerFactory.getLogger(ListenerManager.class);
    private final List<Object> listeners = new CopyOnWriteArrayList<Object>();
    private final Method method;
    private boolean hasListeners = false;
    private boolean enabled = true;

    public ListenerManager(String listener_class, String event_class, String method_name) {
        try {
            Class<?> lc = Class.forName(listener_class);
            Class<?> ec = Class.forName(event_class);
            Class[] params = new Class[]{ec};
            this.method = lc.getMethod(method_name, params);
        }
        catch (Exception ee) {
            logger.error("ListenerManager failed on " + listener_class + "." + method_name + "( " + event_class + " )", (Throwable)ee);
            throw new RuntimeException(ee);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public synchronized void addListener(Object l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
            this.hasListeners = true;
        } else {
            logger.warn("ListenerManager.addListener already has Listener " + l);
        }
    }

    public synchronized void removeListener(Object l) {
        if (this.listeners.contains(l)) {
            this.listeners.remove(l);
            this.hasListeners = this.listeners.size() > 0;
        } else {
            logger.warn("ListenerManager.removeListener couldnt find Listener " + l);
        }
    }

    public synchronized boolean hasListeners() {
        return this.hasListeners;
    }

    public synchronized void sendEvent(EventObject event) {
        if (!this.hasListeners || !this.enabled) {
            return;
        }
        Object[] args = new Object[]{event};
        ListIterator<Object> iter = this.listeners.listIterator();
        while (iter.hasNext()) {
            Object client = iter.next();
            try {
                this.method.invoke(client, args);
            }
            catch (IllegalAccessException e) {
                logger.error("ListenerManager IllegalAccessException", (Throwable)e);
                iter.remove();
            }
            catch (IllegalArgumentException e) {
                logger.error("ListenerManager IllegalArgumentException", (Throwable)e);
                iter.remove();
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    public synchronized void sendEventExcludeSource(EventObject event) {
        if (!this.hasListeners || !this.enabled) {
            return;
        }
        Object source = event.getSource();
        Object[] args = new Object[]{event};
        ListIterator<Object> iter = this.listeners.listIterator();
        while (iter.hasNext()) {
            Object client = iter.next();
            if (client == source) continue;
            try {
                this.method.invoke(client, args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
                if (e.getCause() != null) {
                    e.getCause().printStackTrace();
                }
                logger.error("ListenerManager calling " + this.method + " threw exception ", (Throwable)e);
            }
        }
    }
}

