/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.misc;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.iosp.misc.AbstractLightningIOSP;
import ucar.nc2.util.CancelTask;
import ucar.unidata.io.RandomAccessFile;

public class Uspln
extends AbstractLightningIOSP {
    private static final Logger logger = LoggerFactory.getLogger(Uspln.class);
    private static final String MAGIC = "LIGHTNING-.*(P|G)LN1";
    private Pattern pMAGIC = Pattern.compile("LIGHTNING-.*(P|G)LN1");
    private static final String MAGIC_OLD = "..PLN-LIGHTNING";
    private Pattern pMAGIC_OLD = Pattern.compile("..PLN-LIGHTNING");
    private static final String MAGIC_EX = ".*(GLN1|PLN1EX).*";
    private Pattern pMAGIC_EX = Pattern.compile(".*(GLN1|PLN1EX).*");
    private static final String TIME_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String TIME_FORMAT_EX = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private boolean isExtended = false;
    private long[] offsets;
    private double lat_min;
    private double lat_max;
    private double lon_min;
    private double lon_max;
    private double time_min;
    private double time_max;
    private StructureMembers sm;
    private SimpleDateFormat isoDateFormat = null;
    private int nelems = -1;

    @Override
    public boolean isValidFile(RandomAccessFile raf) throws IOException {
        raf.seek(0L);
        int n = MAGIC.length();
        if (raf.length() < (long)n) {
            return false;
        }
        String got = raf.readString(n);
        return this.pMAGIC.matcher(got).find() || this.pMAGIC_OLD.matcher(got).find();
    }

    @Override
    public void open(RandomAccessFile raf, NetcdfFile ncfile, CancelTask cancelTask) throws IOException {
        super.open(raf, ncfile, cancelTask);
        this.isExtended = this.checkFormat();
        this.isoDateFormat = new SimpleDateFormat();
        this.isoDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.isoDateFormat.applyPattern(this.isExtended ? TIME_FORMAT_EX : TIME_FORMAT);
        Sequence seq = this.makeSequence(ncfile);
        ncfile.addVariable(null, seq);
        this.addLightningGlobalAttributes(ncfile);
        ncfile.finish();
        this.sm = seq.makeStructureMembers();
        ArrayStructureBB.setOffsets(this.sm);
    }

    protected Sequence makeSequence(NetcdfFile ncfile) {
        Sequence seq = new Sequence(ncfile, null, null, "record");
        Variable v = this.makeLightningVariable(ncfile, null, seq, "time", DataType.DOUBLE, "", "time of stroke", null, "seconds since 1970-01-01 00:00:00", AxisType.Time);
        seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, seq, "lat", DataType.DOUBLE, "", "latitude", "latitude", "degrees_north", AxisType.Lat);
        seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, seq, "lon", DataType.DOUBLE, "", "longitude", "longitude", "degrees_east", AxisType.Lon);
        seq.addMemberVariable(v);
        v = this.makeLightningVariable(ncfile, null, seq, "sgnl", DataType.FLOAT, "", "signed peak amplitude (signal strength)", null, "kAmps", null);
        v.addAttribute(new Attribute("missing_value", new Double(999.0)));
        seq.addMemberVariable(v);
        if (this.isExtended) {
            v = this.makeLightningVariable(ncfile, null, seq, "majorAxis", DataType.FLOAT, "", "error ellipse semi-major axis", null, "km", null);
            seq.addMemberVariable(v);
            v = this.makeLightningVariable(ncfile, null, seq, "minorAxis", DataType.FLOAT, "", "error ellipse minor axis ", null, "km", null);
            seq.addMemberVariable(v);
            v = this.makeLightningVariable(ncfile, null, seq, "ellipseAngle", DataType.INT, "", "error ellipse axis angle of orientation ", null, "degrees", null);
            seq.addMemberVariable(v);
        } else {
            v = this.makeLightningVariable(ncfile, null, seq, "mult", DataType.INT, "", "multiplicity [#strokes per flash]", null, "", null);
            seq.addMemberVariable(v);
        }
        return seq;
    }

    @Override
    protected void addLightningGlobalAttributes(NetcdfFile ncfile) {
        super.addLightningGlobalAttributes(ncfile);
        ncfile.addAttribute(null, new Attribute("title", "USPLN Lightning Data"));
        ncfile.addAttribute(null, new Attribute("file_format", "USPLN1 " + (this.isExtended ? "(extended)" : "(original)")));
    }

    private boolean checkFormat() throws IOException {
        boolean extended;
        block1: {
            String line;
            this.raf.seek(0L);
            extended = false;
            do {
                long offset = this.raf.getFilePointer();
                line = this.raf.readLine();
                if (line == null) break block1;
            } while (!this.pMAGIC.matcher(line).find() && !this.pMAGIC_OLD.matcher(line).find());
            extended = this.pMAGIC_EX.matcher(line).find();
        }
        return extended;
    }

    int readAllData(RandomAccessFile raf) throws IOException, NumberFormatException, ParseException {
        ArrayList<Long> offsetList = new ArrayList<Long>();
        SimpleDateFormat isoDateTimeFormat = new SimpleDateFormat(TIME_FORMAT);
        isoDateTimeFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.lat_min = 1000.0;
        this.lat_max = -1000.0;
        this.lon_min = 1000.0;
        this.lon_max = -1000.0;
        this.time_min = Double.POSITIVE_INFINITY;
        this.time_max = Double.NEGATIVE_INFINITY;
        raf.seek(0L);
        int count = 0;
        boolean knowExtended = false;
        while (true) {
            long offset = raf.getFilePointer();
            String line = raf.readLine();
            if (line == null) break;
            if (this.pMAGIC.matcher(line).find() || this.pMAGIC_OLD.matcher(line).find()) {
                if (knowExtended) continue;
                this.isExtended = this.pMAGIC_EX.matcher(line).find();
                if (this.isExtended) {
                    isoDateTimeFormat.applyPattern(TIME_FORMAT_EX);
                }
                knowExtended = true;
                continue;
            }
            StringTokenizer stoker = new StringTokenizer(line, ",\r\n");
            while (stoker.hasMoreTokens()) {
                Date date = isoDateTimeFormat.parse(stoker.nextToken());
                double lat = Double.parseDouble(stoker.nextToken());
                double lon = Double.parseDouble(stoker.nextToken());
                double amp = Double.parseDouble(stoker.nextToken());
                int nstrokes = 1;
                double axisMaj = Double.NaN;
                double axisMin = Double.NaN;
                int orient = 0;
                if (this.isExtended) {
                    axisMaj = Double.parseDouble(stoker.nextToken());
                    axisMin = Double.parseDouble(stoker.nextToken());
                    orient = Integer.parseInt(stoker.nextToken());
                } else {
                    nstrokes = Integer.parseInt(stoker.nextToken());
                }
                Stroke s = this.isExtended ? new Stroke(date, lat, lon, amp, axisMaj, axisMin, orient) : new Stroke(date, lat, lon, amp, nstrokes);
                this.lat_min = Math.min(this.lat_min, s.lat);
                this.lat_max = Math.max(this.lat_max, s.lat);
                this.lon_min = Math.min(this.lon_min, s.lon);
                this.lon_max = Math.max(this.lon_max, s.lon);
                this.time_min = Math.min(this.time_min, s.secs);
                this.time_max = Math.max(this.time_max, s.secs);
            }
            offsetList.add(new Long(offset));
            ++count;
        }
        this.offsets = new long[count];
        for (int i = 0; i < offsetList.size(); ++i) {
            Long off = (Long)offsetList.get(i);
            this.offsets[i] = off;
        }
        return count;
    }

    @Override
    public Array readData(Variable v2, Section section) throws IOException, InvalidRangeException {
        return new ArraySequence(this.sm, this.getStructureIterator(null, 0), this.nelems);
    }

    @Override
    public StructureDataIterator getStructureIterator(Structure s, int bufferSize) throws IOException {
        return new UsplnSeqIter();
    }

    @Override
    public String getFileTypeId() {
        return "USPLN";
    }

    @Override
    public String getFileTypeDescription() {
        return "US Precision Lightning Network";
    }

    @Override
    public String getFileTypeVersion() {
        return "1";
    }

    private class Stroke {
        double secs;
        double lat;
        double lon;
        double amp;
        int n = 1;
        double axisMajor;
        double axisMinor;
        int axisOrient;

        Stroke(long offset, SimpleDateFormat isoDateTimeFormat) throws IOException, ParseException {
            Uspln.this.raf.seek(offset);
            String line = Uspln.this.raf.readLine();
            if (line == null || Uspln.this.pMAGIC.matcher(line).find() || Uspln.this.pMAGIC_OLD.matcher(line).find()) {
                throw new IllegalStateException();
            }
            StringTokenizer stoker = new StringTokenizer(line, ",\r\n");
            Date date = isoDateTimeFormat.parse(stoker.nextToken());
            this.makeSecs(date);
            this.lat = Double.parseDouble(stoker.nextToken());
            this.lon = Double.parseDouble(stoker.nextToken());
            this.amp = Double.parseDouble(stoker.nextToken());
            if (Uspln.this.isExtended) {
                this.n = 1;
                this.axisMajor = Double.parseDouble(stoker.nextToken());
                this.axisMinor = Double.parseDouble(stoker.nextToken());
                this.axisOrient = Integer.parseInt(stoker.nextToken());
            } else {
                this.n = Integer.parseInt(stoker.nextToken());
            }
        }

        Stroke(Date date, double lat, double lon, double amp, int n) {
            this.makeSecs(date);
            this.lat = lat;
            this.lon = lon;
            this.amp = amp;
            this.n = n;
        }

        Stroke(Date date, double lat, double lon, double amp, double maj, double min, int orient) {
            this.makeSecs(date);
            this.lat = lat;
            this.lon = lon;
            this.amp = amp;
            this.axisMajor = maj;
            this.axisMinor = min;
            this.axisOrient = orient;
        }

        void makeSecs(Date date) {
            this.secs = (int)(date.getTime() / 1000L);
        }

        public String toString() {
            return Uspln.this.isExtended ? this.lat + " " + this.lon + " " + this.amp + " " + this.axisMajor + "/" + this.axisMinor + " " + this.axisOrient : this.lat + " " + this.lon + " " + this.amp + " " + this.n;
        }
    }

    private class UsplnSeqIter
    implements StructureDataIterator {
        private ArrayStructureBB asbb = null;
        int numFlashes = 0;

        UsplnSeqIter() throws IOException {
            Uspln.this.raf.seek(0L);
        }

        @Override
        public StructureDataIterator reset() {
            this.numFlashes = 0;
            try {
                Uspln.this.raf.seek(0L);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.readStroke();
        }

        @Override
        public StructureData next() throws IOException {
            ++this.numFlashes;
            return this.asbb.getStructureData(0);
        }

        private boolean readStroke() throws IOException {
            String line = Uspln.this.raf.readLine();
            if (line == null) {
                Uspln.this.nelems = this.numFlashes;
                return false;
            }
            if (Uspln.this.pMAGIC.matcher(line).find() || Uspln.this.pMAGIC_OLD.matcher(line).find()) {
                return this.readStroke();
            }
            Stroke stroke = null;
            StringTokenizer stoker = new StringTokenizer(line, ",\r\n");
            try {
                while (stoker.hasMoreTokens()) {
                    Date date = Uspln.this.isoDateFormat.parse(stoker.nextToken());
                    double lat = Double.parseDouble(stoker.nextToken());
                    double lon = Double.parseDouble(stoker.nextToken());
                    double amp = Double.parseDouble(stoker.nextToken());
                    int nstrokes = 1;
                    double axisMaj = Double.NaN;
                    double axisMin = Double.NaN;
                    int orient = 0;
                    if (Uspln.this.isExtended) {
                        axisMaj = Double.parseDouble(stoker.nextToken());
                        axisMin = Double.parseDouble(stoker.nextToken());
                        orient = Integer.parseInt(stoker.nextToken());
                    } else {
                        nstrokes = Integer.parseInt(stoker.nextToken());
                    }
                    stroke = Uspln.this.isExtended ? new Stroke(date, lat, lon, amp, axisMaj, axisMin, orient) : new Stroke(date, lat, lon, amp, nstrokes);
                }
            }
            catch (Exception e) {
                logger.error("bad header: {}", (Object)line.trim());
                return false;
            }
            if (stroke == null) {
                logger.error("bad header: {}", (Object)line.trim());
                return false;
            }
            byte[] data = new byte[Uspln.this.sm.getStructureSize()];
            ByteBuffer bbdata = ByteBuffer.wrap(data);
            Iterator<String> iterator = Uspln.this.sm.getMemberNames().iterator();
            while (iterator.hasNext()) {
                String mbrName;
                switch (mbrName = iterator.next()) {
                    case "time": {
                        bbdata.putDouble(stroke.secs);
                        break;
                    }
                    case "lat": {
                        bbdata.putDouble(stroke.lat);
                        break;
                    }
                    case "lon": {
                        bbdata.putDouble(stroke.lon);
                        break;
                    }
                    case "sgnl": {
                        bbdata.putFloat((float)stroke.amp);
                        break;
                    }
                    case "mult": {
                        bbdata.putInt(stroke.n);
                        break;
                    }
                    case "majorAxis": {
                        bbdata.putFloat((float)stroke.axisMajor);
                        break;
                    }
                    case "minorAxis": {
                        bbdata.putFloat((float)stroke.axisMinor);
                        break;
                    }
                    case "ellipseAngle": {
                        bbdata.putInt(stroke.axisOrient);
                    }
                }
            }
            this.asbb = new ArrayStructureBB(Uspln.this.sm, new int[]{1}, bbdata, 0);
            return true;
        }

        @Override
        public int getCurrentRecno() {
            return this.numFlashes - 1;
        }
    }
}

