/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;

public class NCheader {
    private static final int MAGIC_NUMBER_LEN = 8;
    private static final long MAXHEADERPOS = 50000L;
    public static final byte[] H5HEAD = new byte[]{-119, 72, 68, 70, 13, 10, 26, 10};
    public static final byte[] H4HEAD = new byte[]{14, 3, 19, 1};
    public static final byte[] CDF1HEAD = new byte[]{67, 68, 70, 1};
    public static final byte[] CDF2HEAD = new byte[]{67, 68, 70, 2};
    public static final byte[] CDF5HEAD = new byte[]{67, 68, 70, 5};
    public static final int NC_FORMAT_NETCDF3 = 1;
    public static final int NC_FORMAT_64BIT_OFFSET = 2;
    public static final int NC_FORMAT_NETCDF4 = 3;
    public static final int NC_FORMAT_64BIT_DATA = 5;
    public static final int NC_FORMAT_HDF4 = 28677;
    public static final int NC_FORMAT_CLASSIC = 1;
    public static final int NC_FORMAT_64BIT = 2;
    public static final int NC_FORMAT_CDF5 = 5;
    public static final int NC_FORMAT_HDF5 = 3;

    public static int checkFileType(RandomAccessFile raf) throws IOException {
        int format = 0;
        byte[] magic = new byte[8];
        raf.seek(0L);
        if (raf.readBytes(magic, 0, 8) < 8) {
            return 0;
        }
        int hdrlen = 0;
        hdrlen = CDF1HEAD.length;
        format = 0;
        if (NCheader.memequal(CDF1HEAD, magic, CDF1HEAD.length)) {
            format = 1;
        } else if (NCheader.memequal(CDF2HEAD, magic, CDF2HEAD.length)) {
            format = 2;
        } else if (NCheader.memequal(CDF5HEAD, magic, CDF5HEAD.length)) {
            format = 5;
        } else if (NCheader.memequal(H4HEAD, magic, H4HEAD.length)) {
            format = 28677;
        }
        if (format != 0) {
            raf.seek(hdrlen);
            return format;
        }
        format = 0;
        long filePos = 0L;
        long size = raf.length();
        while (filePos < size - 8L && filePos < 50000L) {
            raf.seek(filePos);
            if (raf.readBytes(magic, 0, 8) < 8) {
                return 0;
            }
            if (NCheader.memequal(H5HEAD, magic, H5HEAD.length)) {
                format = 3;
                break;
            }
            filePos = filePos == 0L ? 512L : 2L * filePos;
        }
        if (format != 0) {
            raf.seek(filePos + (long)H5HEAD.length);
        }
        return format;
    }

    static boolean memequal(byte[] b1, byte[] b2, int len) {
        if (b1 == b2) {
            return true;
        }
        if (b1 == null || b2 == null) {
            return false;
        }
        if (b1.length < len || b2.length < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }

    public static String formatName(int format) {
        switch (format) {
            case 1: {
                return "netcdf-3";
            }
            case 2: {
                return "netcdf-3 64bit-offset";
            }
            case 3: {
                return "netcdf-4";
            }
            case 5: {
                return "netcdf-5";
            }
            case 28677: {
                return "HDF-4";
            }
        }
        return null;
    }
}

