/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureBB;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataDeep;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.ParsedSectionSpec;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.iosp.Layout;
import ucar.nc2.iosp.LayoutBB;
import ucar.nc2.stream.NcStream;
import ucar.unidata.io.PositioningDataInputStream;
import ucar.unidata.io.RandomAccessFile;

public class IospHelper {
    private static boolean showLayoutTypes = false;

    public static Object readDataFill(RandomAccessFile raf, Layout index, DataType dataType, Object fillValue, int byteOrder) throws IOException {
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType) : IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType, fillValue);
        return IospHelper.readData(raf, index, dataType, arr, byteOrder, true);
    }

    public static Object readDataFill(RandomAccessFile raf, Layout index, DataType dataType, Object fillValue, int byteOrder, boolean convertChar) throws IOException {
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType) : IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType, fillValue);
        return IospHelper.readData(raf, index, dataType, arr, byteOrder, convertChar);
    }

    public static Object readData(RandomAccessFile raf, Layout layout, DataType dataType, Object arr, int byteOrder, boolean convertChar) throws IOException {
        if (showLayoutTypes) {
            System.out.println("***RAF LayoutType=" + layout.getClass().getName());
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE || dataType == DataType.CHAR) {
            byte[] pa = (byte[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFully(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            if (convertChar && dataType == DataType.CHAR) {
                return IospHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = (short[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readShort(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = (int[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readInt(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFloat(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readDouble(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = (long[])arr;
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readLong(pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            byte[] pa = (byte[])arr;
            int recsize = layout.getElemSize();
            while (layout.hasNext()) {
                Layout.Chunk chunk = layout.next();
                raf.order(byteOrder);
                raf.seek(chunk.getSrcPos());
                raf.readFully(pa, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return pa;
        }
        throw new IllegalStateException("unknown type= " + (Object)((Object)dataType));
    }

    public static Object readDataFill(PositioningDataInputStream is, Layout index, DataType dataType, Object fillValue) throws IOException {
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType) : IospHelper.makePrimitiveArray((int)index.getTotalNelems(), dataType, fillValue);
        return IospHelper.readData(is, index, dataType, arr);
    }

    public static Object readData(PositioningDataInputStream raf, Layout index, DataType dataType, Object arr) throws IOException {
        if (showLayoutTypes) {
            System.out.println("***PositioningDataInputStream LayoutType=" + index.getClass().getName());
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE || dataType == DataType.CHAR) {
            byte[] pa = (byte[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.read(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            if (dataType == DataType.CHAR) {
                return IospHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = (short[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readShort(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = (int[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readInt(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readFloat(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readDouble(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = (long[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.readLong(chunk.getSrcPos(), pa, (int)chunk.getDestElem(), chunk.getNelems());
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            int recsize = index.getElemSize();
            byte[] pa = (byte[])arr;
            while (index.hasNext()) {
                Layout.Chunk chunk = index.next();
                raf.read(chunk.getSrcPos(), pa, (int)chunk.getDestElem() * recsize, chunk.getNelems() * recsize);
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static Object readDataFill(LayoutBB layout, DataType dataType, Object fillValue) throws IOException {
        long size = layout.getTotalNelems();
        if (dataType == DataType.STRUCTURE) {
            size *= (long)layout.getElemSize();
        }
        Object arr = fillValue == null ? IospHelper.makePrimitiveArray((int)size, dataType) : IospHelper.makePrimitiveArray((int)size, dataType, fillValue);
        return IospHelper.readData(layout, dataType, arr);
    }

    public static Object readData(LayoutBB layout, DataType dataType, Object arr) throws IOException {
        if (showLayoutTypes) {
            System.out.println("***BB LayoutType=" + layout.getClass().getName());
        }
        if (dataType.getPrimitiveClassType() == Byte.TYPE || dataType == DataType.CHAR) {
            byte[] pa = (byte[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ByteBuffer bb = chunk.getByteBuffer();
                bb.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = bb.get();
                }
            }
            if (dataType == DataType.CHAR) {
                return IospHelper.convertByteToChar(pa);
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = (short[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ShortBuffer buff = chunk.getShortBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = (int[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                IntBuffer buff = chunk.getIntBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = (float[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                FloatBuffer buff = chunk.getFloatBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = (double[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                DoubleBuffer buff = chunk.getDoubleBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = (long[])arr;
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                LongBuffer buff = chunk.getLongBuffer();
                buff.position(chunk.getSrcElem());
                int pos = (int)chunk.getDestElem();
                for (int i = 0; i < chunk.getNelems(); ++i) {
                    pa[pos++] = buff.get();
                }
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            byte[] pa = (byte[])arr;
            int recsize = layout.getElemSize();
            while (layout.hasNext()) {
                LayoutBB.Chunk chunk = layout.next();
                ByteBuffer bb = chunk.getByteBuffer();
                bb.position(chunk.getSrcElem() * recsize);
                int pos = (int)chunk.getDestElem() * recsize;
                for (int i = 0; i < chunk.getNelems() * recsize; ++i) {
                    pa[pos++] = bb.get();
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static long copyToByteChannel(Array data, WritableByteChannel channel) throws IOException {
        Class classType = data.getElementType();
        DataOutputStream outStream = new DataOutputStream(Channels.newOutputStream(channel));
        IndexIterator iterA = data.getIndexIterator();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            byte[] pa = IospHelper.convertCharToByte((char[])data.get1DJavaArray(DataType.CHAR));
            outStream.write(pa, 0, pa.length);
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            if (classType == String.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    String s = (String)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(outStream, s.length());
                    byte[] b = s.getBytes(CDM.utf8Charset);
                    outStream.write(b);
                    size += (long)b.length;
                }
                return size;
            }
            if (classType == ByteBuffer.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(outStream, bb.limit());
                    bb.rewind();
                    channel.write(bb);
                    size += (long)bb.limit();
                }
                return size;
            }
            if (data instanceof ArrayObject) {
                long size = 0L;
                while (iterA.hasNext()) {
                    Array row = (Array)iterA.getObjectNext();
                    ByteBuffer bb = row.getDataAsByteBuffer();
                    byte[] result = bb.array();
                    size += (long)NcStream.writeVInt(outStream, result.length);
                    outStream.write(result);
                    size += (long)result.length;
                }
                return size;
            }
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return data.getSizeBytes();
    }

    public static long copyToOutputStream(Array data, OutputStream out) throws IOException {
        Class classType = data.getElementType();
        DataOutputStream dataOut = out instanceof DataOutputStream ? (DataOutputStream)out : new DataOutputStream(out);
        IndexIterator iterA = data.getIndexIterator();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            byte[] pa = IospHelper.convertCharToByte((char[])data.get1DJavaArray(DataType.CHAR));
            dataOut.write(pa, 0, pa.length);
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                dataOut.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            if (classType == String.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    String s = (String)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(dataOut, s.length());
                    byte[] b = s.getBytes(CDM.utf8Charset);
                    dataOut.write(b);
                    size += (long)b.length;
                }
                return size;
            }
            if (classType == ByteBuffer.class) {
                long size = 0L;
                while (iterA.hasNext()) {
                    ByteBuffer bb = (ByteBuffer)iterA.getObjectNext();
                    size += (long)NcStream.writeVInt(dataOut, bb.limit());
                    bb.rewind();
                    dataOut.write(bb.array());
                    size += (long)bb.limit();
                }
                return size;
            }
            if (data instanceof ArrayObject) {
                long size = 0L;
                while (iterA.hasNext()) {
                    Array row = (Array)iterA.getObjectNext();
                    ByteBuffer bb = row.getDataAsByteBuffer();
                    byte[] result = bb.array();
                    size += (long)NcStream.writeVInt(dataOut, result.length);
                    dataOut.write(result);
                    size += (long)result.length;
                }
                return size;
            }
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return data.getSizeBytes();
    }

    public static ArrayStructureBB makeArrayBB(ArrayStructure as) throws IOException {
        if (as.getClass().equals(ArrayStructureBB.class)) {
            return (ArrayStructureBB)as;
        }
        StructureMembers smo = as.getStructureMembers();
        StructureMembers sm = new StructureMembers(smo);
        ArrayStructureBB abb = new ArrayStructureBB(sm, as.getShape());
        ArrayStructureBB.setOffsets(sm);
        try (StructureDataIterator iter = as.getStructureDataIterator();){
            while (iter.hasNext()) {
                StructureDataDeep.copyToArrayBB(iter.next(), abb);
            }
        }
        return abb;
    }

    public static ArrayStructureBB copyToArrayBB(StructureData sdata) {
        StructureMembers sm = new StructureMembers(sdata.getStructureMembers());
        int size = sm.getStructureSize();
        ByteBuffer bb = ByteBuffer.allocate(size);
        ArrayStructureBB abb = new ArrayStructureBB(sm, new int[]{1}, bb, 0);
        ArrayStructureBB.setOffsets(sm);
        StructureDataDeep.copyToArrayBB(sdata, abb);
        return abb;
    }

    public static Object makePrimitiveArray(int size, DataType dataType) {
        Object[] arr = null;
        if (dataType.getPrimitiveClassType() == Byte.TYPE || dataType == DataType.CHAR || dataType == DataType.OPAQUE || dataType == DataType.STRUCTURE) {
            arr = new byte[size];
        } else if (dataType.getPrimitiveClassType() == Short.TYPE) {
            arr = new short[size];
        } else if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            arr = new int[size];
        } else if (dataType.getPrimitiveClassType() == Long.TYPE) {
            arr = new long[size];
        } else if (dataType == DataType.FLOAT) {
            arr = new float[size];
        } else if (dataType == DataType.DOUBLE) {
            arr = new double[size];
        } else if (dataType == DataType.STRING) {
            arr = new String[size];
        }
        return arr;
    }

    public static Object makePrimitiveArray(int size, DataType dataType, Object fillValue) {
        if (dataType.getPrimitiveClassType() == Byte.TYPE || dataType == DataType.CHAR) {
            byte[] pa = new byte[size];
            byte val = ((Number)fillValue).byteValue();
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.OPAQUE) {
            return new byte[size];
        }
        if (dataType.getPrimitiveClassType() == Short.TYPE) {
            short[] pa = new short[size];
            short val = ((Number)fillValue).shortValue();
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Integer.TYPE) {
            int[] pa = new int[size];
            int val = ((Number)fillValue).intValue();
            if (val != 0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType.getPrimitiveClassType() == Long.TYPE) {
            long[] pa = new long[size];
            long val = ((Number)fillValue).longValue();
            if (val != 0L) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.FLOAT) {
            float[] pa = new float[size];
            float val = ((Number)fillValue).floatValue();
            if ((double)val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.DOUBLE) {
            double[] pa = new double[size];
            double val = ((Number)fillValue).doubleValue();
            if (val != 0.0) {
                for (int i = 0; i < size; ++i) {
                    pa[i] = val;
                }
            }
            return pa;
        }
        if (dataType == DataType.STRING) {
            String[] pa = new String[size];
            for (int i = 0; i < size; ++i) {
                pa[i] = (String)fillValue;
            }
            return pa;
        }
        if (dataType == DataType.STRUCTURE) {
            byte[] pa = new byte[size];
            if (fillValue != null) {
                byte[] val = (byte[])fillValue;
                int count = 0;
                while (count < size) {
                    for (byte aVal : val) {
                        pa[count++] = aVal;
                    }
                }
            }
            return pa;
        }
        throw new IllegalStateException();
    }

    public static char[] convertByteToCharUTF(byte[] byteArray) {
        Charset c = CDM.utf8Charset;
        CharBuffer output = c.decode(ByteBuffer.wrap(byteArray));
        return output.array();
    }

    public static byte[] convertCharToByteUTF(char[] from) {
        Charset c = CDM.utf8Charset;
        ByteBuffer output = c.encode(CharBuffer.wrap(from));
        return output.array();
    }

    public static char[] convertByteToChar(byte[] byteArray) {
        int size = byteArray.length;
        char[] cbuff = new char[size];
        for (int i = 0; i < size; ++i) {
            cbuff[i] = (char)DataType.unsignedByteToShort(byteArray[i]);
        }
        return cbuff;
    }

    public static byte[] convertCharToByte(char[] from) {
        int size = from.length;
        byte[] to = new byte[size];
        for (int i = 0; i < size; ++i) {
            to[i] = (byte)from[i];
        }
        return to;
    }

    public static long transferData(Array result, WritableByteChannel channel) throws IOException, InvalidRangeException {
        DataOutputStream outStream = new DataOutputStream(Channels.newOutputStream(channel));
        IndexIterator iterA = result.getIndexIterator();
        Class classType = result.getElementType();
        if (classType == Double.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeDouble(iterA.getDoubleNext());
            }
        } else if (classType == Float.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeFloat(iterA.getFloatNext());
            }
        } else if (classType == Long.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeLong(iterA.getLongNext());
            }
        } else if (classType == Integer.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeInt(iterA.getIntNext());
            }
        } else if (classType == Short.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeShort(iterA.getShortNext());
            }
        } else if (classType == Character.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeChar(iterA.getCharNext());
            }
        } else if (classType == Byte.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeByte(iterA.getByteNext());
            }
        } else if (classType == Boolean.TYPE) {
            while (iterA.hasNext()) {
                outStream.writeBoolean(iterA.getBooleanNext());
            }
        } else {
            throw new UnsupportedOperationException("Class type = " + classType.getName());
        }
        return 0L;
    }

    public static Array readSection(ParsedSectionSpec cer) throws IOException, InvalidRangeException {
        Variable inner = null;
        ArrayList<Range> totalRanges = new ArrayList<Range>();
        ParsedSectionSpec current = cer;
        while (current != null) {
            totalRanges.addAll(current.section.getRanges());
            inner = current.v;
            current = current.child;
        }
        assert (inner != null);
        Section total = new Section(totalRanges);
        Array result = Array.factory(inner.getDataType(), total.getShape());
        Structure outer = (Structure)cer.v;
        Structure outerSubset = outer.select(cer.child.v.getShortName());
        ArrayStructure outerData = (ArrayStructure)outerSubset.read(cer.section);
        IospHelper.extractSection(cer.child, outerData, result.getIndexIterator());
        return result;
    }

    private static void extractSection(ParsedSectionSpec child, ArrayStructure outerData, IndexIterator to) throws IOException, InvalidRangeException {
        long wantNelems = child.section.computeSize();
        StructureMembers.Member m = outerData.findMember(child.v.getShortName());
        int recno = 0;
        while ((long)recno < outerData.getSize()) {
            Array innerData = outerData.getArray(recno, m);
            if (child.child == null) {
                if (wantNelems != innerData.getSize()) {
                    innerData = innerData.section(child.section.getRanges());
                }
                MAMath.copy(child.v.getDataType(), innerData.getIndexIterator(), to);
            } else if (innerData instanceof ArraySequence) {
                IospHelper.extractSectionFromSequence(child.child, (ArraySequence)innerData, to);
            } else {
                if (wantNelems != innerData.getSize()) {
                    innerData = IospHelper.sectionArrayStructure(child, (ArrayStructure)innerData, m);
                }
                IospHelper.extractSection(child.child, (ArrayStructure)innerData, to);
            }
            ++recno;
        }
    }

    private static void extractSectionFromSequence(ParsedSectionSpec child, ArraySequence outerData, IndexIterator to) throws IOException, InvalidRangeException {
        try (StructureDataIterator sdataIter = outerData.getStructureDataIterator();){
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                StructureMembers.Member m = outerData.findMember(child.v.getShortName());
                Array innerData = sdata.getArray(child.v.getShortName());
                MAMath.copy(m.getDataType(), innerData.getIndexIterator(), to);
            }
        }
    }

    private static ArrayStructure sectionArrayStructure(ParsedSectionSpec child, ArrayStructure innerData, StructureMembers.Member m) throws IOException, InvalidRangeException {
        StructureMembers membersw = new StructureMembers(m.getStructureMembers());
        ArrayStructureW result = new ArrayStructureW(membersw, child.section.getShape());
        int count = 0;
        Section.Iterator iter = child.section.getIterator(child.v.getShape());
        while (iter.hasNext()) {
            int recno = iter.next(null);
            StructureData sd = innerData.getStructureData(recno);
            result.setStructureData(sd, count++);
        }
        return result;
    }
}

