/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft2.coverage.writer;

import java.io.IOException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.ft2.coverage.Coverage;
import ucar.nc2.ft2.coverage.CoverageCollection;
import ucar.nc2.ft2.coverage.CoverageCoordAxis;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.CoverageTransform;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.ft2.coverage.SubsetParams;
import ucar.nc2.ft2.coverage.writer.CoverageSubsetter2;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.util.Optional;
import ucar.unidata.geoloc.LatLonRect;

public class CFGridCoverageWriter2 {
    private static final Logger logger = LoggerFactory.getLogger(CFGridCoverageWriter2.class);
    private static final boolean show = false;
    private static final String BOUNDS = "_bounds";
    private static final String BOUNDS_DIM = "bounds_dim";

    public static Optional<Long> writeOrTestSize(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subset, boolean addLatLon, boolean testSizeOnly, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        CFGridCoverageWriter2 writer2 = new CFGridCoverageWriter2();
        return writer2.writeFile(gdsOrg, gridNames, subset, addLatLon, testSizeOnly, writer);
    }

    private Optional<Long> writeFile(CoverageCollection gdsOrg, List<String> gridNames, SubsetParams subsetParams, boolean addLatLon, boolean testSizeOnly, NetcdfFileWriter writer) throws IOException, InvalidRangeException {
        Variable v;
        Variable v2;
        Optional<CoverageCollection> opt = CoverageSubsetter2.makeCoverageDatasetSubset(gdsOrg, gridNames, subsetParams);
        if (!opt.isPresent()) {
            return Optional.empty(opt.getErrorMessage());
        }
        CoverageCollection subsetDataset = opt.get();
        long total_size = 0L;
        for (Coverage grid : subsetDataset.getCoverages()) {
            total_size += grid.getSizeInBytes();
        }
        if (testSizeOnly) {
            return Optional.of(total_size);
        }
        boolean isLargeFile = this.isLargeFile(total_size);
        writer.setLargeFile(isLargeFile);
        this.addGlobalAttributes(subsetDataset, writer);
        HashMap<String, Dimension> dimHash = new HashMap<String, Dimension>();
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            Dimension d;
            if (axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent) {
                d = writer.addDimension(null, axis.getName(), axis.getNcoords());
                dimHash.put(axis.getName(), d);
            }
            if (!axis.isInterval() || null != dimHash.get(BOUNDS_DIM)) continue;
            d = writer.addDimension(null, BOUNDS_DIM, 2);
            dimHash.put(BOUNDS_DIM, d);
        }
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            String dims = axis.getDependenceType() == CoverageCoordAxis.DependenceType.independent ? axis.getName() : (axis.getDependenceType() == CoverageCoordAxis.DependenceType.scalar ? "" : axis.getDependsOn());
            boolean hasBounds = false;
            if (axis.isInterval()) {
                Variable vb = writer.addVariable(null, axis.getName() + BOUNDS, axis.getDataType(), dims + " " + BOUNDS_DIM);
                vb.addAttribute(new Attribute("units", axis.getUnits()));
                hasBounds = true;
            }
            v2 = writer.addVariable(null, axis.getName(), axis.getDataType(), dims);
            this.addVariableAttributes(v2, axis.getAttributes());
            v2.addAttribute(new Attribute("units", axis.getUnits()));
            if (hasBounds) {
                v2.addAttribute(new Attribute("bounds", axis.getName() + BOUNDS));
            }
            if (axis.getAxisType() != AxisType.TimeOffset) continue;
            v2.addAttribute(new Attribute("standard_name", "forecast_period"));
        }
        for (Coverage grid : subsetDataset.getCoverages()) {
            v = writer.addVariable(null, grid.getName(), grid.getDataType(), grid.getIndependentAxisNamesOrdered());
            this.addVariableAttributes(v, grid.getAttributes());
        }
        for (CoverageTransform ct : subsetDataset.getCoordTransforms()) {
            Variable ctv = writer.addVariable(null, ct.getName(), DataType.INT, "");
            for (Attribute att : ct.getAttributes()) {
                ctv.addAttribute(att);
            }
        }
        this.addCFAnnotations(subsetDataset, writer, addLatLon);
        writer.create();
        for (CoverageCoordAxis axis : subsetDataset.getCoordAxes()) {
            v = writer.findVariable(axis.getName());
            if (v != null) {
                writer.write(v, axis.getCoordsAsArray());
            } else {
                logger.error("CFGridCoverageWriter2 No variable for %s%n", (Object)axis.getName());
            }
            if (!axis.isInterval()) continue;
            Variable vb = writer.findVariable(axis.getName() + BOUNDS);
            writer.write(vb, axis.getCoordBoundsAsArray());
        }
        for (Coverage grid : subsetDataset.getCoverages()) {
            Coverage gridOrg = gdsOrg.findCoverage(grid.getName());
            GeoReferencedArray array = gridOrg.readData(subsetParams);
            this.checkConformance(gridOrg, grid, array, gdsOrg.getName());
            v2 = writer.findVariable(grid.getName());
            writer.write(v2, array.getData());
        }
        writer.close();
        return Optional.of(total_size);
    }

    private boolean isLargeFile(long total_size) {
        boolean isLargeFile = false;
        long maxSize = Integer.MAX_VALUE;
        if (total_size > maxSize) {
            logger.debug("Request size = {} Mbytes", (Object)(total_size / 1000L / 1000L));
            isLargeFile = true;
        }
        return isLargeFile;
    }

    private void addGlobalAttributes(CoverageCollection gds, NetcdfFileWriter writer) {
        for (Attribute att : gds.getGlobalAttributes()) {
            if (att.getShortName().equals("file_format") || att.getShortName().equals("_CoordSysBuilder")) continue;
            writer.addGroupAttribute(null, att);
        }
        Attribute att = gds.findAttributeIgnoreCase("Conventions");
        if (att == null || !att.getStringValue().startsWith("CF-")) {
            writer.addGroupAttribute(null, new Attribute("Conventions", "CF-1.0"));
        }
        writer.addGroupAttribute(null, new Attribute("History", "Translated to CF-1.0 Conventions by Netcdf-Java CDM (CFGridCoverageWriter)\nOriginal Dataset = " + gds.getName() + "; Translation Date = " + CalendarDate.present()));
        LatLonRect llbb = gds.getLatlonBoundingBox();
        if (llbb != null) {
            writer.addGroupAttribute(null, new Attribute("geospatial_lat_min", llbb.getLatMin()));
            writer.addGroupAttribute(null, new Attribute("geospatial_lat_max", llbb.getLatMax()));
            writer.addGroupAttribute(null, new Attribute("geospatial_lon_min", llbb.getLonMin()));
            writer.addGroupAttribute(null, new Attribute("geospatial_lon_max", llbb.getLonMax()));
        }
    }

    private void addVariableAttributes(Variable v, List<Attribute> atts) {
        for (Attribute att : atts) {
            if (att.getShortName().startsWith("_Coordinate") || att.getShortName().startsWith("_Chunk")) continue;
            v.addAttribute(att);
        }
    }

    private void addCFAnnotations(CoverageCollection gds, NetcdfFileWriter writer, boolean addLatLon) {
        for (Coverage grid : gds.getCoverages()) {
            CoverageCoordSys gcs = grid.getCoordSys();
            Variable newV = writer.findVariable(grid.getName());
            if (newV == null) {
                logger.error("CFGridCoverageWriter2 cant find " + grid.getName() + " in writer ");
                continue;
            }
            Formatter sbuff = new Formatter();
            for (String s : grid.getCoordSys().getAxisNames()) {
                sbuff.format("%s ", s);
            }
            newV.addAttribute(new Attribute("coordinates", sbuff.toString()));
            CoverageTransform ct = gcs.getHorizTransform();
            if (ct == null || !ct.isHoriz()) continue;
            newV.addAttribute(new Attribute("grid_mapping", ct.getName()));
        }
        for (CoverageCoordAxis axis : gds.getCoordAxes()) {
            Variable newV = writer.findVariable(axis.getName());
            if (newV == null) {
                logger.error("CFGridCoverageWriter2 cant find " + axis.getName() + " in writer ");
                continue;
            }
            if (axis.getAxisType() == AxisType.Lat) {
                newV.addAttribute(new Attribute("units", "degrees_north"));
                newV.addAttribute(new Attribute("standard_name", "latitude"));
            }
            if (axis.getAxisType() == AxisType.Lon) {
                newV.addAttribute(new Attribute("units", "degrees_east"));
                newV.addAttribute(new Attribute("standard_name", "longitude"));
            }
            if (axis.getAxisType() == AxisType.GeoX) {
                newV.addAttribute(new Attribute("standard_name", "projection_x_coordinate"));
            }
            if (axis.getAxisType() == AxisType.GeoY) {
                newV.addAttribute(new Attribute("standard_name", "projection_y_coordinate"));
            }
            if (axis.getAxisType() != AxisType.Ensemble) continue;
            newV.addAttribute(new Attribute("standard_name", "realization"));
        }
    }

    private void checkConformance(Coverage gridOrg, Coverage gridSubset, GeoReferencedArray geo, String where) {
        CoverageCoordSys csys = gridSubset.getCoordSys();
        CoverageCoordSys csysData = geo.getCoordSysForData();
        Section s = new Section(csys.getShape());
        Section so = new Section(csysData.getShape());
        boolean ok = s.conformal(so);
        int[] dataShape = geo.getData().getShape();
        Section sdata = new Section(dataShape);
        boolean ok2 = s.conformal(sdata);
        if (!ok || !ok2) {
            logger.warn("CFGridCoverageWriter2 checkConformance fails " + where);
        }
    }
}

