/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.collection;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import thredds.inventory.MFileCollectionManager;
import thredds.inventory.TimedCollection;
import ucar.nc2.Attribute;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.collection.CompositePointCollection;
import ucar.nc2.ft.point.collection.CompositeStationCollection;
import ucar.nc2.ft.point.collection.UpdateableCollection;
import ucar.nc2.time.CalendarDateRange;
import ucar.unidata.geoloc.LatLonRect;

public class CompositeDatasetFactory {
    public static final String SCHEME = "collection:";
    static boolean debug = false;

    public static FeatureDataset factory(String location, FeatureType wantFeatureType, MFileCollectionManager dcm, Formatter errlog) throws IOException {
        TimedCollection collection = new TimedCollection(dcm, errlog);
        if (collection.getDatasets().size() == 0) {
            throw new FileNotFoundException("Collection is empty; spec=" + dcm);
        }
        TimedCollection.Dataset d = collection.getPrototype();
        try (FeatureDatasetPoint proto = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open(wantFeatureType, d.getLocation(), null, errlog);){
            DsgCollectionImpl fc;
            List<DsgFeatureCollection> fcList;
            if (proto == null) {
                throw new FileNotFoundException("Collection dataset is not a FeatureDatasetPoint; spec=" + dcm);
            }
            if (wantFeatureType == FeatureType.ANY_POINT) {
                wantFeatureType = proto.getFeatureType();
            }
            if ((fcList = proto.getPointFeatureCollectionList()).size() == 0) {
                throw new FileNotFoundException("FeatureCollectionList is empty; spec=" + dcm);
            }
            DsgFeatureCollection first = fcList.get(0);
            switch (wantFeatureType) {
                case POINT: {
                    CompositePointCollection pfc;
                    PointFeatureCollection firstPc = (PointFeatureCollection)first;
                    fc = pfc = new CompositePointCollection(dcm.getCollectionName(), firstPc.getTimeUnit(), firstPc.getAltUnits(), collection);
                    break;
                }
                case STATION: {
                    PointFeatureCC firstNpc = (PointFeatureCC)first;
                    CompositeStationCollection sfc = new CompositeStationCollection(dcm.getCollectionName(), firstNpc.getTimeUnit(), firstNpc.getAltUnits(), collection);
                    fc = sfc;
                    break;
                }
                default: {
                    FeatureDataset featureDataset = null;
                    return featureDataset;
                }
            }
            CompositePointDataset compositePointDataset = new CompositePointDataset(location, wantFeatureType, fc, collection, null);
            return compositePointDataset;
        }
    }

    private static class CompositePointDataset
    extends PointDatasetImpl
    implements UpdateableCollection {
        private DsgFeatureCollection pfc;
        private List<Attribute> globalAttributes;

        public CompositePointDataset(String location, FeatureType featureType, DsgFeatureCollection pfc, TimedCollection datasets, LatLonRect bb) {
            super(featureType);
            this.setLocationURI(location);
            this.setPointFeatureCollection(pfc);
            this.pfc = pfc;
            this.dateRange = datasets.getDateRange();
            if (datasets.getDateRange() != null) {
                this.setDateRange(datasets.getDateRange());
            }
            if (bb != null) {
                this.setBoundingBox(bb);
            }
        }

        @Override
        public List<VariableSimpleIF> getDataVariables() {
            if (this.dataVariables == null) {
                if (this.pfc instanceof CompositePointCollection) {
                    this.dataVariables = ((CompositePointCollection)this.pfc).getDataVariables();
                } else if (this.pfc instanceof CompositeStationCollection) {
                    this.dataVariables = ((CompositeStationCollection)this.pfc).getDataVariables();
                }
            }
            return this.dataVariables;
        }

        @Override
        public List<Attribute> getGlobalAttributes() {
            if (this.globalAttributes == null) {
                if (this.pfc instanceof CompositePointCollection) {
                    this.globalAttributes = ((CompositePointCollection)this.pfc).getGlobalAttributes();
                } else if (this.pfc instanceof CompositeStationCollection) {
                    this.globalAttributes = ((CompositeStationCollection)this.pfc).getGlobalAttributes();
                }
            }
            return this.globalAttributes;
        }

        @Override
        public void setDateRange(CalendarDateRange dateRange) {
            super.setDateRange(dateRange);
        }

        @Override
        public void setBoundingBox(LatLonRect boundingBox) {
            super.setBoundingBox(boundingBox);
        }

        @Override
        public CalendarDateRange update() throws IOException {
            UpdateableCollection uc = (UpdateableCollection)((Object)this.pfc);
            return uc.update();
        }
    }
}

