/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.Immutable;
import ucar.ma2.Index;
import ucar.ma2.Range;
import ucar.ma2.RangeIterator;
import ucar.ma2.Section;

@Immutable
public class SectionIterable
implements Iterable<Integer> {
    private final List<RangeIterator> ranges;
    private final int[] fullShape;

    public SectionIterable(List<RangeIterator> ranges, int[] fullShape) {
        assert (ranges.size() == fullShape.length) : ranges.size() + " != " + fullShape.length;
        int count = 0;
        for (RangeIterator ri : ranges) {
            assert (ri.length() <= fullShape[count]);
            ++count;
        }
        this.ranges = ranges;
        this.fullShape = fullShape;
    }

    public SectionIterable(List<RangeIterator> ranges, List<Integer> fullShapeList) {
        assert (ranges.size() == fullShapeList.size()) : ranges.size() + " != " + fullShapeList.size();
        int count = 0;
        this.fullShape = new int[fullShapeList.size()];
        for (RangeIterator ri : ranges) {
            assert (ri.length() <= fullShapeList.get(count));
            this.fullShape[count] = fullShapeList.get(count);
            ++count;
        }
        this.ranges = ranges;
    }

    public SectionIterable(Section section, int[] fullShape) {
        this.ranges = new ArrayList<RangeIterator>();
        for (Range r : section.getRanges()) {
            this.ranges.add(r);
        }
        this.fullShape = fullShape;
    }

    public int getRank() {
        return this.ranges.size();
    }

    public SectionIterable subSection(int start, int endExclusive) {
        int n = endExclusive - start;
        int[] subFullRange = new int[n];
        System.arraycopy(this.fullShape, start, subFullRange, 0, n);
        return new SectionIterable(this.ranges.subList(start, endExclusive), subFullRange);
    }

    public RangeIterator getRange(int i) {
        return this.ranges.get(i);
    }

    public int[] getShape() {
        int[] result = new int[this.getRank()];
        for (int i = 0; i < this.getRank(); ++i) {
            result[i] = this.getRange(i).length();
        }
        return result;
    }

    public long computeSize() {
        long product = 1L;
        for (RangeIterator r : this.ranges) {
            product *= (long)r.length();
        }
        return product;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new SectionIterator();
    }

    public SectionIterator getIterator() {
        return new SectionIterator();
    }

    public class SectionIterator
    implements Iterator<Integer> {
        private int[] odo;
        private List<Iterator<Integer>> rangeIterList;
        private int[] stride;
        private long done;
        private long total;

        SectionIterator() {
            int i;
            this.odo = new int[SectionIterable.this.getRank()];
            this.rangeIterList = new ArrayList<Iterator<Integer>>();
            this.stride = new int[SectionIterable.this.getRank()];
            int ss = 1;
            for (i = SectionIterable.this.getRank() - 1; i >= 0; --i) {
                this.stride[i] = ss;
                ss *= SectionIterable.this.fullShape[i];
            }
            for (i = 0; i < SectionIterable.this.getRank(); ++i) {
                Iterator<Integer> iter = SectionIterable.this.getRange(i).iterator();
                this.odo[i] = iter.next();
                this.rangeIterList.add(iter);
            }
            this.done = 0L;
            this.total = Index.computeSize(SectionIterable.this.getShape());
        }

        @Override
        public boolean hasNext() {
            return this.done < this.total;
        }

        @Override
        public Integer next() {
            int next = this.currentElement();
            ++this.done;
            if (this.done < this.total) {
                this.incr();
            }
            return next;
        }

        public int next(int[] index) {
            int next = this.currentElement();
            if (index != null) {
                System.arraycopy(this.odo, 0, index, 0, this.odo.length);
            }
            ++this.done;
            if (this.done < this.total) {
                this.incr();
            }
            return next;
        }

        private void incr() {
            int digit = SectionIterable.this.getRank() - 1;
            while (digit >= 0) {
                Iterator<Integer> iter = this.rangeIterList.get(digit);
                if (iter.hasNext()) {
                    this.odo[digit] = iter.next();
                    break;
                }
                Iterator<Integer> iterReset = SectionIterable.this.getRange(digit).iterator();
                this.odo[digit] = iterReset.next();
                this.rangeIterList.set(digit, iterReset);
                assert (--digit >= 0);
            }
        }

        private int currentElement() {
            int value = 0;
            for (int ii = 0; ii < SectionIterable.this.getRank(); ++ii) {
                value += this.odo[ii] * this.stride[ii];
            }
            return value;
        }
    }
}

