/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.remote.PointCollectionStreamAbstract;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.remote.QueryMaker;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class PointCollectionStreamRemote
extends PointCollectionStreamAbstract
implements QueryMaker {
    private final String uri;
    private final QueryMaker queryMaker;
    LatLonRect filter_bb;
    CalendarDateRange filter_date;

    public PointCollectionStreamRemote(String uri, CalendarDateUnit timeUnit, String altUnits, QueryMaker queryMaker) {
        super(uri, timeUnit, altUnits);
        this.uri = uri;
        this.queryMaker = queryMaker == null ? this : queryMaker;
    }

    @Override
    public String makeQuery() {
        return PointDatasetRemote.makeQuery(null, this.filter_bb, this.filter_date);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return CdmRemote.sendQuery(null, this.uri, this.queryMaker.makeQuery());
    }

    @Override
    public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) throws IOException {
        return new Subset(this, boundingBox, dateRange);
    }

    private class Subset
    extends PointCollectionStreamRemote {
        LatLonRect filter_bb;
        CalendarDateRange filter_date;

        Subset(PointCollectionStreamRemote from, LatLonRect filter_bb, CalendarDateRange filter_date) throws IOException {
            super(from.uri, from.getTimeUnit(), from.getAltUnits(), null);
            this.filter_bb = filter_bb;
            this.filter_date = filter_date;
        }
    }
}

