/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.util.Indent;

public class Structure
extends Variable {
    protected static Logger log = LoggerFactory.getLogger(Structure.class);
    protected static int defaultBufferSize = 500000;
    protected List<Variable> members;
    protected HashMap<String, Variable> memberHash;
    protected boolean isSubset;

    public Structure(NetcdfFile ncfile, Group group, Structure parent, String shortName) {
        super(ncfile, group, parent, shortName);
        this.setDataType(DataType.STRUCTURE);
        this.elementSize = -1;
        this.members = new ArrayList<Variable>();
        this.memberHash = new HashMap();
    }

    public Structure(NetcdfFile ncfile, Group group, Structure parent, String shortName, List<Dimension> dimList) {
        this(ncfile, group, parent, shortName);
        this.setDimensions(dimList);
    }

    protected Structure(Structure from) {
        super(from);
        this.members = new ArrayList<Variable>(from.members);
        this.memberHash = new HashMap<String, Variable>(from.memberHash);
        this.isSubset = from.isSubset();
    }

    public Structure select(List<String> memberNames) {
        Structure result = (Structure)this.copy();
        ArrayList<Variable> members = new ArrayList<Variable>();
        for (String name : memberNames) {
            Variable m = this.findVariable(name);
            if (null == m) continue;
            members.add(m);
        }
        result.setMemberVariables(members);
        result.isSubset = true;
        return result;
    }

    public Structure select(String varName) {
        ArrayList<String> memberNames = new ArrayList<String>(1);
        memberNames.add(varName);
        return this.select(memberNames);
    }

    public boolean isSubset() {
        return this.isSubset;
    }

    @Override
    protected Variable copy() {
        return new Structure(this);
    }

    protected int calcStructureSize() {
        int structureSize = 0;
        for (Variable member : this.members) {
            structureSize = (int)((long)structureSize + member.getSize() * (long)member.getElementSize());
        }
        return structureSize;
    }

    @Override
    public boolean isCaching() {
        return false;
    }

    @Override
    public void setCaching(boolean caching) {
        this.cache.isCaching = false;
        this.cache.cachingSet = true;
    }

    public Variable addMemberVariable(Variable v) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        this.members.add(v);
        this.memberHash.put(v.getShortName(), v);
        v.setParentStructure(this);
        return v;
    }

    public void setMemberVariables(List<Variable> vars) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        this.members = new ArrayList<Variable>();
        this.memberHash = new HashMap(2 * vars.size());
        for (Variable v : vars) {
            this.addMemberVariable(v);
        }
    }

    public boolean removeMemberVariable(Variable v) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        if (v == null) {
            return false;
        }
        java.util.Iterator<Variable> iter = this.members.iterator();
        while (iter.hasNext()) {
            Variable mv = iter.next();
            if (!mv.getShortName().equals(v.getShortName())) continue;
            iter.remove();
            this.memberHash.remove(v.getShortName());
            return true;
        }
        return false;
    }

    public boolean replaceMemberVariable(Variable newVar) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        boolean found = false;
        for (int i = 0; i < this.members.size(); ++i) {
            Variable v = this.members.get(i);
            if (v.getShortName() == null) {
                System.out.println("BAD null short name");
            }
            if (!v.getShortName().equals(newVar.getShortName())) continue;
            this.members.set(i, newVar);
            found = true;
        }
        if (!found) {
            this.members.add(newVar);
        }
        return found;
    }

    @Override
    public void setParentGroup(Group group) {
        if (this.isImmutable()) {
            throw new IllegalStateException("Cant modify");
        }
        super.setParentGroup(group);
        if (this.members != null) {
            for (Variable v : this.members) {
                v.setParentGroup(group);
            }
        }
    }

    @Override
    public Variable setImmutable() {
        this.members = Collections.unmodifiableList(this.members);
        for (Variable m : this.members) {
            m.setImmutable();
        }
        super.setImmutable();
        return this;
    }

    public List<Variable> getVariables() {
        return this.isImmutable() ? this.members : new ArrayList<Variable>(this.members);
    }

    public int getNumberOfMemberVariables() {
        return this.members.size();
    }

    public List<String> getVariableNames() {
        return new ArrayList<String>(this.memberHash.keySet());
    }

    public Variable findVariable(String shortName) {
        if (shortName == null) {
            return null;
        }
        return this.memberHash.get(shortName);
    }

    public StructureMembers makeStructureMembers() {
        StructureMembers smembers = new StructureMembers(this.getShortName());
        for (Variable v2 : this.getVariables()) {
            StructureMembers.Member m = smembers.addMember(v2.getShortName(), v2.getDescription(), v2.getUnitsString(), v2.getDataType(), v2.getShape());
            if (!(v2 instanceof Structure)) continue;
            m.setStructureMembers(((Structure)v2).makeStructureMembers());
        }
        return smembers;
    }

    @Override
    public int getElementSize() {
        if (this.elementSize == -1) {
            this.calcElementSize();
        }
        return this.elementSize;
    }

    public void calcElementSize() {
        int total = 0;
        for (Variable v : this.members) {
            total = (int)((long)total + (long)v.getElementSize() * v.getSize());
        }
        this.elementSize = total;
    }

    public StructureData readStructure() throws IOException {
        if (this.getRank() != 0) {
            throw new UnsupportedOperationException("not a scalar structure");
        }
        Array dataArray = this.read();
        ArrayStructure data = (ArrayStructure)dataArray;
        return data.getStructureData(0);
    }

    public StructureData readStructure(int index) throws IOException, InvalidRangeException {
        Section section = null;
        if (this.getRank() == 1) {
            section = new Section().appendRange(index, index);
        } else if (this.getRank() > 1) {
            Index ii = Index.factory(this.shape);
            ii.setCurrentCounter(index);
            int[] origin = ii.getCurrentCounter();
            section = new Section();
            for (int anOrigin : origin) {
                section.appendRange(anOrigin, anOrigin);
            }
        }
        Array dataArray = this.read(section);
        ArrayStructure data = (ArrayStructure)dataArray;
        return data.getStructureData(0);
    }

    public ArrayStructure readStructure(int start, int count) throws IOException, InvalidRangeException {
        if (this.getRank() != 1) {
            throw new UnsupportedOperationException("not a vector structure");
        }
        int[] origin = new int[]{start};
        int[] shape = new int[]{count};
        if (NetcdfFile.debugStructureIterator) {
            System.out.println("readStructure " + start + " " + count);
        }
        return (ArrayStructure)this.read(origin, shape);
    }

    public StructureDataIterator getStructureIterator() throws IOException {
        return this.getStructureIterator(defaultBufferSize);
    }

    public StructureDataIterator getStructureIterator(int bufferSize) throws IOException {
        return this.getRank() < 2 ? new IteratorRank1(bufferSize) : new Iterator(bufferSize);
    }

    public String getNameAndAttributes() {
        Formatter sbuff = new Formatter();
        sbuff.format("Structure ", new Object[0]);
        this.getNameAndDimensions(sbuff, false, true);
        sbuff.format("%n", new Object[0]);
        for (Attribute att : this.attributes.getAttributes()) {
            sbuff.format("  %s:%s;%n", this.getShortName(), att.toString());
        }
        return sbuff.toString();
    }

    @Override
    protected void writeCDL(Formatter buf, Indent indent, boolean useFullName, boolean strict) {
        buf.format("%n%s%s {%n", new Object[]{indent, this.dataType});
        indent.incr();
        for (Variable v : this.members) {
            v.writeCDL(buf, indent, useFullName, strict);
        }
        indent.decr();
        buf.format("%s} ", indent);
        this.getNameAndDimensions(buf, useFullName, strict);
        buf.format(";%s%n", this.extraInfo());
        for (Attribute att : this.getAttributes()) {
            if (Attribute.suppress(att, strict)) continue;
            buf.format("  ", indent);
            att.writeCDL(buf, strict, this.getShortName());
            buf.format(";", new Object[0]);
            if (!strict && att.getDataType() != DataType.STRING) {
                buf.format(" // %s", new Object[]{att.getDataType()});
            }
            buf.format("%n", new Object[0]);
        }
        buf.format("%n", new Object[0]);
    }

    private class Iterator
    implements StructureDataIterator {
        private int count;
        private int total;
        private int readStart;
        private int readCount;
        private int outerCount;
        private ArrayStructure as = null;

        protected Iterator(int bufferSize) {
            this.reset();
        }

        @Override
        public boolean hasNext() {
            return this.count < this.total;
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            this.total = (int)Structure.this.getSize();
            this.readStart = 0;
            this.readCount = 0;
            this.outerCount = 0;
            return this;
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }

        @Override
        public StructureData next() throws IOException {
            if (this.count >= this.readStart) {
                this.readNextGeneralRank();
            }
            ++this.count;
            return this.as.getStructureData(this.readCount++);
        }

        private void readNextGeneralRank() throws IOException {
            try {
                Section section = new Section(Structure.this.shape);
                section.setRange(0, new Range(this.outerCount, this.outerCount));
                this.as = (ArrayStructure)Structure.this.read(section);
                if (NetcdfFile.debugStructureIterator) {
                    System.out.println("readNext inner=" + this.outerCount + " total=" + this.outerCount);
                }
                ++this.outerCount;
            }
            catch (InvalidRangeException e) {
                log.error("Structure.Iterator.readNext() ", (Throwable)e);
                throw new IllegalStateException("Structure.Iterator.readNext() ", e);
            }
            this.readStart = (int)((long)this.readStart + this.as.getSize());
            this.readCount = 0;
        }
    }

    private class IteratorRank1
    implements StructureDataIterator {
        private int count = 0;
        private int recnum = (int)Structure.this.getSize();
        private int readStart = 0;
        private int readCount = 0;
        private int readAtaTime;
        private ArrayStructure as = null;

        protected IteratorRank1(int bufferSize) {
            this.setBufferSize(bufferSize);
        }

        @Override
        public boolean hasNext() {
            return this.count < this.recnum;
        }

        @Override
        public StructureDataIterator reset() {
            this.count = 0;
            this.readStart = 0;
            this.readCount = 0;
            return this;
        }

        @Override
        public StructureData next() throws IOException {
            if (this.count >= this.readStart) {
                this.readNext();
            }
            ++this.count;
            return this.as.getStructureData(this.readCount++);
        }

        @Override
        public int getCurrentRecno() {
            return this.count - 1;
        }

        private void readNext() throws IOException {
            int left = Math.min(this.recnum, this.readStart + this.readAtaTime);
            int need = left - this.readStart;
            try {
                this.as = Structure.this.readStructure(this.readStart, need);
                if (NetcdfFile.debugStructureIterator) {
                    System.out.println("readNext " + this.count + " " + this.readStart);
                }
            }
            catch (InvalidRangeException e) {
                log.error("Structure.IteratorRank1.readNext() ", (Throwable)e);
                throw new IllegalStateException("Structure.Iterator.readNext() ", e);
            }
            this.readStart += need;
            this.readCount = 0;
        }

        @Override
        public void setBufferSize(int bytes) {
            if (this.count > 0) {
                return;
            }
            int structureSize = Structure.this.calcStructureSize();
            if (structureSize <= 0) {
                structureSize = 1;
            }
            if (bytes <= 0) {
                bytes = defaultBufferSize;
            }
            this.readAtaTime = Math.max(10, bytes / structureSize);
            if (NetcdfFile.debugStructureIterator) {
                System.out.println("Iterator structureSize= " + structureSize + " readAtaTime= " + this.readAtaTime);
            }
        }
    }
}

