/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.io.BufferedWriter;
import java.io.CharArrayWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;
import org.jdom2.Element;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArraySequence;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.CDM;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;

public class NCdumpW {
    private static String usage = "usage: NCdumpW <filename> [-unsigned] [-cdl | -ncml] [-c | -vall] [-v varName1;varName2;..] [-v varName(0:1,:,12)]\n";
    static boolean useUnsigned = false;
    public static final BigInteger BIG_UMASK64 = new BigInteger("FFFFFFFFFFFFFFFF", 16);

    static Object fixUnsigned(Object o, boolean isunsigned) {
        if (!(useUnsigned && isunsigned && o instanceof Number)) {
            return o;
        }
        if (o instanceof Byte) {
            int i = ((Byte)o).intValue();
            return i &= 0xFF;
        }
        if (o instanceof Short) {
            int i = ((Short)o).intValue();
            return i &= 0xFFFF;
        }
        if (o instanceof Integer) {
            long l = ((Integer)o).longValue();
            return l &= 0xFFFFFFFFL;
        }
        if (o instanceof Long) {
            long l = (Long)o;
            BigInteger bi = BigInteger.valueOf(l);
            bi = bi.and(BIG_UMASK64);
            return bi;
        }
        return o;
    }

    public static boolean printHeader(String fileName, Writer out) throws IOException {
        return NCdumpW.print(fileName, out, false, false, false, false, null, null);
    }

    public static boolean printNcML(String fileName, Writer out) throws IOException {
        return NCdumpW.print(fileName, out, false, true, true, false, null, null);
    }

    public static boolean print(String command, Writer out) throws IOException {
        return NCdumpW.print(command, out, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String command, Writer out, CancelTask ct) throws IOException {
        StringTokenizer stoke = new StringTokenizer(command);
        if (!stoke.hasMoreTokens()) {
            out.write(usage);
            return false;
        }
        String filename = stoke.nextToken();
        NetcdfFile nc = null;
        try {
            nc = NetcdfDataset.openFile(filename, ct);
            int pos = command.indexOf(filename);
            command = command.substring(pos + filename.length());
            boolean bl = NCdumpW.print(nc, command, out, ct);
            return bl;
        }
        catch (FileNotFoundException e) {
            out.write("file not found= ");
            out.write(filename);
            boolean bl = false;
            return bl;
        }
        finally {
            if (nc != null) {
                nc.close();
            }
            out.flush();
        }
    }

    public static boolean print(NetcdfFile nc, String command, Writer out, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        boolean ncml = false;
        boolean strict = false;
        String varNames = null;
        useUnsigned = false;
        String trueDataset = null;
        String fakeDataset = null;
        if (command != null) {
            StringTokenizer stoke = new StringTokenizer(command);
            while (stoke.hasMoreTokens()) {
                String toke = stoke.nextToken();
                if (toke.equalsIgnoreCase("-help")) {
                    out.write(usage);
                    out.write(10);
                    return true;
                }
                if (toke.equalsIgnoreCase("-vall")) {
                    showValues = WantValues.all;
                }
                if (toke.equalsIgnoreCase("-c") && showValues == WantValues.none) {
                    showValues = WantValues.coordsOnly;
                }
                if (toke.equalsIgnoreCase("-ncml")) {
                    ncml = true;
                }
                if (toke.equalsIgnoreCase("-unsigned")) {
                    useUnsigned = true;
                }
                if (toke.equalsIgnoreCase("-cdl") || toke.equalsIgnoreCase("-strict")) {
                    strict = true;
                }
                if (toke.equalsIgnoreCase("-v") && stoke.hasMoreTokens()) {
                    varNames = stoke.nextToken();
                }
                if (!toke.equalsIgnoreCase("-datasetname") || !stoke.hasMoreTokens()) continue;
                fakeDataset = stoke.nextToken();
                if (fakeDataset.length() == 0) {
                    fakeDataset = null;
                }
                if (fakeDataset == null) continue;
                trueDataset = nc.getLocation();
                nc.setLocation(fakeDataset);
            }
        }
        boolean ok = NCdumpW.print(nc, out, showValues, ncml, strict, varNames, ct);
        if (trueDataset != null && fakeDataset != null) {
            nc.setLocation(trueDataset);
        }
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(String filename, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        try (NetcdfFile nc = null;){
            nc = NetcdfDataset.openFile(filename, ct);
            boolean bl = NCdumpW.print(nc, out, showAll, showCoords, ncml, strict, varNames, ct);
            return bl;
        }
    }

    public static boolean print(NetcdfFile nc, Writer out, boolean showAll, boolean showCoords, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        WantValues showValues = WantValues.none;
        if (showAll) {
            showValues = WantValues.all;
        } else if (showCoords) {
            showValues = WantValues.coordsOnly;
        }
        return NCdumpW.print(nc, out, showValues, ncml, strict, varNames, ct);
    }

    public static boolean print(NetcdfFile nc, Writer out, WantValues showValues, boolean ncml, boolean strict, String varNames, CancelTask ct) throws IOException {
        block16: {
            boolean headerOnly = showValues == WantValues.none && varNames == null;
            try {
                if (ncml) {
                    NCdumpW.writeNcML(nc, out, showValues, null);
                    break block16;
                }
                if (headerOnly) {
                    nc.writeCDL(new PrintWriter(out), strict);
                    break block16;
                }
                PrintWriter ps = new PrintWriter(out);
                nc.toStringStart(ps, strict);
                ps.print(" data:\n");
                if (showValues == WantValues.all) {
                    for (Variable v : nc.getVariables()) {
                        NCdumpW.printArray(v.read(), v.getFullName(), ps, ct);
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                } else if (showValues == WantValues.coordsOnly) {
                    for (Variable v : nc.getVariables()) {
                        if (v.isCoordinateVariable()) {
                            NCdumpW.printArray(v.read(), v.getFullName(), ps, ct);
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                if (showValues != WantValues.all && varNames != null) {
                    StringTokenizer stoke = new StringTokenizer(varNames, ";");
                    while (stoke.hasMoreTokens()) {
                        String varSubset = stoke.nextToken();
                        if (varSubset.indexOf(40) >= 0) {
                            Array data = nc.readSection(varSubset);
                            NCdumpW.printArray(data, varSubset, ps, ct);
                        } else {
                            Variable v = nc.findVariable(varSubset);
                            if (v == null) {
                                ps.print(" cant find variable: " + varSubset + "\n   " + usage);
                                continue;
                            }
                            if (showValues != WantValues.coordsOnly || v.isCoordinateVariable()) {
                                NCdumpW.printArray(v.read(), v.getFullName(), ps, ct);
                            }
                        }
                        if (ct == null || !ct.isCancel()) continue;
                        return false;
                    }
                }
                nc.toStringEnd(ps);
            }
            catch (Exception e) {
                e.printStackTrace();
                out.write(e.getMessage());
                out.flush();
                return false;
            }
        }
        out.flush();
        return true;
    }

    public static String printVariableData(VariableIF v, CancelTask ct) throws IOException {
        Array data = v.read();
        StringWriter writer = new StringWriter(10000);
        NCdumpW.printArray(data, v.getFullName(), new PrintWriter(writer), ct);
        return writer.toString();
    }

    public static String printVariableDataSection(Variable v, String sectionSpec, CancelTask ct) throws IOException, InvalidRangeException {
        Array data = v.read(sectionSpec);
        StringWriter writer = new StringWriter(20000);
        NCdumpW.printArray(data, v.getFullName(), new PrintWriter(writer), ct);
        return writer.toString();
    }

    public static void printArray(Array array, String name, PrintWriter out, CancelTask ct) throws IOException {
        NCdumpW.printArray(array, name, null, out, new Indent(2), ct, true);
        out.flush();
    }

    public static void printArray(Array array, String name, PrintStream out, CancelTask ct) {
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, CDM.utf8Charset));
        NCdumpW.printArray(array, name, null, pw, new Indent(2), ct, true);
    }

    public static String toString(Array array, String name, CancelTask ct) {
        CharArrayWriter carray = new CharArrayWriter(100000);
        PrintWriter pw = new PrintWriter(carray);
        NCdumpW.printArray(array, name, null, pw, new Indent(2), ct, true);
        return carray.toString();
    }

    private static void printArray(Array array, String name, String units, PrintWriter out, Indent ilev, CancelTask ct, boolean printSeq) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        if (name != null) {
            out.print(ilev + name + " =");
        }
        ilev.incr();
        if (array == null) {
            out.println("null array for " + name);
            ilev.decr();
            return;
        }
        if (array instanceof ArrayChar && array.getRank() > 0) {
            NCdumpW.printStringArray(out, (ArrayChar)array, ilev, ct);
        } else if (array.getElementType() == String.class) {
            NCdumpW.printStringArray(out, array, ilev, ct);
        } else if (array instanceof ArraySequence) {
            if (printSeq) {
                NCdumpW.printSequence(out, (ArraySequence)array, ilev, ct);
            }
        } else if (array instanceof ArrayStructure) {
            if (array.getSize() == 1L) {
                NCdumpW.printStructureData(out, (StructureData)array.getObject(array.getIndex()), ilev, ct);
            } else {
                NCdumpW.printStructureDataArray(out, (ArrayStructure)array, ilev, ct);
            }
        } else if (array.getElementType() == ByteBuffer.class) {
            array.resetLocalIterator();
            while (array.hasNext()) {
                NCdumpW.printByteBuffer(out, (ByteBuffer)array.next(), ilev);
                out.println(array.hasNext() ? "," : ";");
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        } else if (array instanceof ArrayObject) {
            NCdumpW.printVariableArray(out, (ArrayObject)array, ilev, ct);
        } else {
            NCdumpW.printArray(array, out, ilev, ct);
        }
        if (units != null) {
            out.print(" " + units);
        }
        out.print("\n");
        ilev.decr();
        out.flush();
    }

    private static void printArray(Array ma, PrintWriter out, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            Object o = ma.getObject(ima);
            o = NCdumpW.fixUnsigned(o, ma.isUnsigned());
            out.print(o.toString());
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        if (rank == 1 && ma.getElementType() != StructureData.class) {
            for (int ii = 0; ii < last; ++ii) {
                Object o = ma.getObject(ima.set(ii));
                o = NCdumpW.fixUnsigned(o, ma.isUnsigned());
                if (ii > 0) {
                    out.print(", ");
                }
                out.print(o.toString());
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            out.print("}");
            return;
        }
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            Array slice = ma.slice(0, ii);
            if (ii > 0) {
                out.print(",");
            }
            NCdumpW.printArray(slice, out, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    static void printStringArray(PrintWriter out, ArrayChar ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        if (rank == 1) {
            out.print("  \"" + ma.getString() + "\"");
            return;
        }
        if (rank == 2) {
            boolean first = true;
            ArrayChar.StringIterator iter = ma.getStringIterator();
            while (iter.hasNext()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("\"" + iter.next() + "\"");
                first = false;
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayChar slice = (ArrayChar)ma.slice(0, ii);
            if (ii > 0) {
                out.print(",");
            }
            NCdumpW.printStringArray(out, slice, indent, ct);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printByteBuffer(PrintWriter out, ByteBuffer bb, Indent indent) {
        out.print(indent + "0x");
        int last = bb.limit() - 1;
        if (last < 0) {
            out.printf("00", new Object[0]);
        } else {
            for (int i = bb.position(); i <= last; ++i) {
                out.printf("%02x", bb.get(i));
            }
        }
    }

    static void printStringArray(PrintWriter out, Array ma, Indent indent, CancelTask ct) {
        if (ct != null && ct.isCancel()) {
            return;
        }
        int rank = ma.getRank();
        Index ima = ma.getIndex();
        if (rank == 0) {
            out.print("  \"" + ma.getObject(ima) + "\"");
            return;
        }
        if (rank == 1) {
            boolean first = true;
            int i = 0;
            while ((long)i < ma.getSize()) {
                if (!first) {
                    out.print(", ");
                }
                out.print("  \"" + ma.getObject(ima.set(i)) + "\"");
                first = false;
                ++i;
            }
            return;
        }
        int[] dims = ma.getShape();
        int last = dims[0];
        out.print("\n" + indent + "{");
        indent.incr();
        for (int ii = 0; ii < last; ++ii) {
            ArrayObject slice = (ArrayObject)ma.slice(0, ii);
            if (ii > 0) {
                out.print(",");
            }
            NCdumpW.printStringArray(out, slice, indent, ct);
        }
        indent.decr();
        out.print("\n" + indent + "}");
    }

    private static void printStructureDataArray(PrintWriter out, ArrayStructure array, Indent indent, CancelTask ct) {
        try (StructureDataIterator sdataIter = array.getStructureDataIterator();){
            int count = 0;
            while (sdataIter.hasNext()) {
                StructureData sdata = sdataIter.next();
                out.println("\n" + indent + "{");
                NCdumpW.printStructureData(out, sdata, indent, ct);
                out.print(indent + "} " + sdata.getName() + "(" + count + ")");
                if (ct != null && ct.isCancel()) {
                    return;
                }
                ++count;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void printVariableArray(PrintWriter out, ArrayObject array, Indent indent, CancelTask ct) {
        out.println("\n" + indent + "{");
        indent.incr();
        IndexIterator iter = array.getIndexIterator();
        boolean first = true;
        while (iter.hasNext()) {
            Array data = (Array)iter.next();
            if (!first) {
                out.print(", ");
            }
            NCdumpW.printArray(data, out, indent, ct);
            first = false;
        }
        indent.decr();
        out.print(indent + "}");
    }

    private static void printSequence(PrintWriter out, ArraySequence seq, Indent indent, CancelTask ct) {
        try (StructureDataIterator iter = seq.getStructureDataIterator();){
            while (iter.hasNext()) {
                StructureData sdata = iter.next();
                out.println("\n" + indent + "{");
                NCdumpW.printStructureData(out, sdata, indent, ct);
                out.print(indent + "} " + sdata.getName());
                if (ct == null || !ct.isCancel()) continue;
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void printStructureData(PrintWriter out, StructureData sdata) throws IOException {
        NCdumpW.printStructureData(out, sdata, new Indent(2), null);
        out.flush();
    }

    private static void printStructureData(PrintWriter out, StructureData sdata, Indent indent, CancelTask ct) {
        indent.incr();
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array sdataArray = sdata.getArray(m);
            NCdumpW.printArray(sdataArray, m.getName(), m.getUnitsString(), out, indent, ct, true);
            if (ct == null || !ct.isCancel()) continue;
            return;
        }
        indent.decr();
    }

    public static String toString(StructureData sdata) throws IOException {
        CharArrayWriter carray = new CharArrayWriter(1000);
        PrintWriter pw = new PrintWriter(carray);
        for (StructureMembers.Member m : sdata.getMembers()) {
            Array memData = sdata.getArray(m);
            if (memData instanceof ArrayChar) {
                pw.print(((ArrayChar)memData).getString());
            } else {
                NCdumpW.printArray(memData, pw);
            }
            pw.print(',');
        }
        return carray.toString();
    }

    public static void printArrayPlain(Array ma, PrintWriter out) {
        ma.resetLocalIterator();
        while (ma.hasNext()) {
            out.print(ma.next());
            out.print(' ');
        }
    }

    public static void printArray(Array ma) {
        PrintWriter out = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, CDM.utf8Charset));
        NCdumpW.printArray(ma, out);
        out.flush();
    }

    public static void printArray(Array array, PrintWriter pw) {
        NCdumpW.printArray(array, null, null, pw, new Indent(2), null, true);
    }

    public static String toString(Array ma) {
        return NCdumpW.toString(ma, "", null);
    }

    public static void writeNcML(NetcdfFile ncfile, Writer writer, WantValues showValues, String url) throws IOException {
        Predicate<Variable> writeVarsPred;
        Preconditions.checkNotNull((Object)ncfile);
        Preconditions.checkNotNull((Object)writer);
        Preconditions.checkNotNull((Object)((Object)showValues));
        switch (showValues) {
            case none: {
                writeVarsPred = NcMLWriter.writeNoVariablesPredicate;
                break;
            }
            case coordsOnly: {
                writeVarsPred = NcMLWriter.writeCoordinateVariablesPredicate;
                break;
            }
            case all: {
                writeVarsPred = NcMLWriter.writeAllVariablesPredicate;
                break;
            }
            default: {
                String message = String.format("CAN'T HAPPEN: showValues (%s) != null and checked all possible enum values.", new Object[]{showValues});
                throw new AssertionError((Object)message);
            }
        }
        NcMLWriter ncmlWriter = new NcMLWriter();
        ncmlWriter.setWriteVariablesPredicate(writeVarsPred);
        Element netcdfElement = ncmlWriter.makeNetcdfElement(ncfile, url);
        ncmlWriter.writeToWriter(netcdfElement, writer);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println(usage);
            return;
        }
        StringBuilder sbuff = new StringBuilder();
        for (String arg : args) {
            sbuff.append(arg);
            sbuff.append(" ");
        }
        try {
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)System.out, CDM.utf8Charset));
            NCdumpW.print(sbuff.toString(), writer, null);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public static enum WantValues {
        none,
        coordsOnly,
        all;

    }
}

