/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.util;

import java.io.File;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.unidata.util.StringUtil2;

public class DiskCache2 {
    private static Logger cacheLog = LoggerFactory.getLogger((String)"cacheLogger");
    private CachePathPolicy cachePathPolicy = CachePathPolicy.NestedDirectory;
    private boolean alwaysUseCache = false;
    private boolean neverUseCache = false;
    private String cachePathPolicyParam = null;
    private String root;
    private int persistMinutes;
    private int scourEveryMinutes;
    private Timer timer;
    private boolean fail = false;

    public static DiskCache2 getDefault() {
        String root = System.getProperty("nj22.cache");
        if (root == null) {
            String home = System.getProperty("user.home");
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            root = home + "/.unidata/cache/";
        }
        DiskCache2 result = new DiskCache2();
        result.setRootDirectory(root);
        result.alwaysUseCache = false;
        return result;
    }

    public static DiskCache2 getNoop() {
        DiskCache2 noop = new DiskCache2();
        noop.neverUseCache = true;
        return noop;
    }

    private DiskCache2() {
    }

    public DiskCache2(String root, boolean reletiveToHome, int persistMinutes, int scourEveryMinutes) {
        this.persistMinutes = persistMinutes;
        this.scourEveryMinutes = scourEveryMinutes;
        if (reletiveToHome) {
            String home = System.getProperty("nj22.cachePersistRoot");
            if (home == null) {
                home = System.getProperty("user.home");
            }
            if (home == null) {
                home = System.getProperty("user.dir");
            }
            if (home == null) {
                home = ".";
            }
            if (!home.endsWith("/")) {
                home = home + "/";
            }
            root = home + root;
        }
        this.setRootDirectory(root);
        if (!this.fail && scourEveryMinutes > 0) {
            this.timer = new Timer("DiskCache-" + root);
            Calendar c = Calendar.getInstance();
            c.add(12, scourEveryMinutes);
            this.timer.scheduleAtFixedRate((TimerTask)new CacheScourTask(), c.getTime(), 60000L * (long)scourEveryMinutes);
        }
    }

    public void exit() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    public void setLogger(Logger cacheLog) {
        DiskCache2.cacheLog = cacheLog;
    }

    public void setRootDirectory(String cacheDir) {
        if (!cacheDir.endsWith("/")) {
            cacheDir = cacheDir + "/";
        }
        this.root = StringUtil2.replace(cacheDir, '\\', "/");
        File dir = new File(this.root);
        if (!dir.mkdirs()) {
            // empty if block
        }
        if (!dir.exists()) {
            this.fail = true;
            cacheLog.error("DiskCache2 failed to create directory " + this.root);
        } else {
            cacheLog.debug("DiskCache2 create directory " + this.root);
        }
    }

    public String getRootDirectory() {
        return this.root;
    }

    public File getCacheFile(String fileLocation) {
        boolean ret;
        File dir;
        File f;
        if (this.neverUseCache) {
            return null;
        }
        if (!this.alwaysUseCache && DiskCache2.canWrite(f = new File(fileLocation))) {
            return f;
        }
        f = new File(this.makeCachePath(fileLocation));
        if (this.cachePathPolicy == CachePathPolicy.NestedDirectory && !(dir = f.getParentFile()).exists() && !(ret = dir.mkdirs())) {
            cacheLog.warn("Error creating dir: " + dir);
        }
        return f;
    }

    public File getFile(String fileLocation) {
        File dir;
        File f;
        if (!this.alwaysUseCache) {
            f = new File(fileLocation);
            if (f.exists()) {
                return f;
            }
            if (DiskCache2.canWrite(f)) {
                return f;
            }
        }
        if (this.neverUseCache) {
            throw new IllegalStateException("neverUseCache=true, but file does not exist and directory is not writeable =" + fileLocation);
        }
        f = new File(this.makeCachePath(fileLocation));
        if (this.cachePathPolicy == CachePathPolicy.NestedDirectory && !(dir = f.getParentFile()).exists() && !dir.mkdirs()) {
            cacheLog.warn("Cant create directories for file " + dir.getPath());
        }
        return f;
    }

    private static boolean canWrite(File f) {
        Path path = f.toPath().toAbsolutePath();
        return Files.isWritable(path.getParent());
    }

    public File getExistingFileOrCache(String fileLocation) {
        File f = new File(fileLocation);
        if (f.exists()) {
            return f;
        }
        if (this.neverUseCache) {
            return null;
        }
        File fc = new File(this.makeCachePath(fileLocation));
        if (fc.exists()) {
            return fc;
        }
        return null;
    }

    public synchronized File createUniqueFile(String prefix, String suffix) {
        if (suffix == null) {
            suffix = ".tmp";
        }
        Random random = new Random(System.currentTimeMillis());
        File result = new File(this.getRootDirectory(), prefix + Integer.toString(random.nextInt()) + suffix);
        while (result.exists()) {
            result = new File(this.getRootDirectory(), prefix + Integer.toString(random.nextInt()) + suffix);
        }
        return result;
    }

    public void setPolicy(CachePathPolicy cachePathPolicy) {
        this.cachePathPolicy = cachePathPolicy;
    }

    public void setCachePathPolicy(CachePathPolicy cachePathPolicy, String cachePathPolicyParam) {
        this.cachePathPolicy = cachePathPolicy;
        this.cachePathPolicyParam = cachePathPolicyParam;
    }

    public void setCachePathPolicy(int cachePathPolicy, String cachePathPolicyParam) {
        this.setPolicy(cachePathPolicy);
        this.cachePathPolicyParam = cachePathPolicyParam;
    }

    public void setPolicy(int cachePathPolicy) {
        switch (cachePathPolicy) {
            case 0: {
                this.setPolicy(CachePathPolicy.OneDirectory);
                break;
            }
            case 1: {
                this.setPolicy(CachePathPolicy.NestedDirectory);
                break;
            }
            case 2: {
                this.setPolicy(CachePathPolicy.NestedTruncate);
            }
        }
    }

    public void setPolicy(String policy) {
        if (policy == null) {
            return;
        }
        if (policy.equalsIgnoreCase("oneDirectory")) {
            this.setCachePathPolicy(CachePathPolicy.OneDirectory, null);
        } else if (policy.equalsIgnoreCase("nestedDirectory")) {
            this.setCachePathPolicy(CachePathPolicy.NestedDirectory, null);
        }
    }

    public void setAlwaysUseCache(boolean alwaysUseCache) {
        this.alwaysUseCache = alwaysUseCache;
    }

    public void setNeverUseCache(boolean neverUseCache) {
        this.neverUseCache = neverUseCache;
    }

    private String makeCachePath(String fileLocation) {
        File file;
        File parent;
        String cachePath = fileLocation;
        cachePath = StringUtil2.remove(cachePath, 63);
        cachePath = StringUtil2.remove(cachePath, 61);
        if ((cachePath = StringUtil2.replace(cachePath, '\\', "/")).startsWith("/")) {
            cachePath = cachePath.substring(1);
        }
        if (cachePath.endsWith("/")) {
            cachePath = cachePath.substring(0, cachePath.length() - 1);
        }
        cachePath = StringUtil2.remove(cachePath, 58);
        if (this.cachePathPolicy == CachePathPolicy.OneDirectory) {
            cachePath = StringUtil2.replace(cachePath, '/', "-");
        } else if (this.cachePathPolicy == CachePathPolicy.NestedTruncate) {
            int pos = cachePath.indexOf(this.cachePathPolicyParam);
            if (pos >= 0) {
                cachePath = cachePath.substring(pos + this.cachePathPolicyParam.length());
            }
            if (cachePath.startsWith("/")) {
                cachePath = cachePath.substring(1);
            }
        }
        if (this.cachePathPolicy != CachePathPolicy.OneDirectory && !(parent = (file = new File(this.root + cachePath)).getParentFile()).exists()) {
            boolean ret;
            if (this.root == null) {
                System.out.printf("mkdir4 %s%n", parent.getPath());
                new Throwable().printStackTrace();
            }
            if (!(ret = parent.mkdirs())) {
                cacheLog.warn("Error creating parent: " + parent);
            }
        }
        return this.root + cachePath;
    }

    public void showCache(PrintStream pw) {
        pw.println("Cache files");
        pw.println("Size   LastModified       Filename");
        File dir = new File(this.root);
        File[] files = dir.listFiles();
        if (files != null) {
            for (File file : files) {
                String org = null;
                try {
                    org = URLDecoder.decode(file.getName(), "UTF8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                pw.println(" " + file.length() + " " + new Date(file.lastModified()) + " " + org);
            }
        }
    }

    public void cleanCache(File dir, StringBuilder sbuff, boolean isRoot) {
        long now = System.currentTimeMillis();
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalStateException("DiskCache2: not a directory or I/O error on dir=" + dir.getAbsolutePath());
        }
        if (!isRoot && files.length == 0) {
            long duration = now - dir.lastModified();
            if ((duration /= 60000L) > (long)this.persistMinutes) {
                boolean ret = dir.delete();
                if (sbuff != null) {
                    sbuff.append(" deleted ").append(ret).append(dir.getPath()).append(" last= ").append(new Date(dir.lastModified())).append("\n");
                }
            }
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                this.cleanCache(file, sbuff, false);
                continue;
            }
            long duration = now - file.lastModified();
            if ((duration /= 60000L) <= (long)this.persistMinutes) continue;
            boolean ret = file.delete();
            if (sbuff == null) continue;
            sbuff.append(" deleted ").append(file.getPath()).append(" last= ").append(new Date(file.lastModified())).append("\n");
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DiskCache2");
        sb.append("{cachePathPolicy=").append((Object)this.cachePathPolicy);
        sb.append(", alwaysUseCache=").append(this.alwaysUseCache);
        sb.append(", cachePathPolicyParam='").append(this.cachePathPolicyParam).append('\'');
        sb.append(", root='").append(this.root).append('\'');
        sb.append(", scourEveryMinutes=").append(this.scourEveryMinutes);
        sb.append(", persistMinutes=").append(this.persistMinutes);
        sb.append(", fail=").append(this.fail);
        sb.append('}');
        return sb.toString();
    }

    private class CacheScourTask
    extends TimerTask {
        CacheScourTask() {
        }

        @Override
        public void run() {
            StringBuilder sbuff = new StringBuilder();
            sbuff.append("DiskCache2 scour on directory= ").append(DiskCache2.this.root).append("\n");
            DiskCache2.this.cleanCache(new File(DiskCache2.this.root), sbuff, true);
            sbuff.append("----------------------\n");
            if (cacheLog != null) {
                cacheLog.info(sbuff.toString());
            }
        }
    }

    public static enum CachePathPolicy {
        OneDirectory,
        NestedDirectory,
        NestedTruncate;

    }
}

