/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDataset;
import ucar.nc2.dt.TypedDatasetFactoryIF;
import ucar.nc2.dt.radial.RadialDatasetSweepAdapter;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateUnit;
import ucar.nc2.units.DateUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class CFnetCDF2Dataset
extends RadialDatasetSweepAdapter
implements TypedDatasetFactoryIF {
    private static Logger log = LoggerFactory.getLogger(CFnetCDF2Dataset.class);
    private NetcdfDataset ds = null;
    private double latv;
    private double lonv;
    private double elev;
    private double[] time;
    private float[] elevation;
    private float[] azimuth;
    private float[] range;
    private int[] rayStartIdx;
    private int[] rayEndIdx;
    private int[] ray_n_gates;
    private int[] ray_start_index;
    private int nsweeps;
    private boolean isStationary;
    private boolean isStationaryChecked = false;

    @Override
    public boolean isMine(NetcdfDataset ds) {
        String convention = ds.findAttValueIgnoreCase(null, "Conventions", null);
        return null != convention && convention.startsWith("CF/Radial");
    }

    @Override
    public TypedDataset open(NetcdfDataset ncd, CancelTask task, StringBuilder errlog) throws IOException {
        return new CFnetCDF2Dataset(ncd);
    }

    @Override
    public FeatureType getScientificDataType() {
        return FeatureType.RADIAL;
    }

    public CFnetCDF2Dataset() {
    }

    public CFnetCDF2Dataset(NetcdfDataset ds) {
        this.ds = ds;
        this.desc = "CF/Radial radar dataset";
        this.init();
        for (Variable var : ds.getVariables()) {
            this.addRadialVariable(ds, var);
        }
    }

    public void init() {
        this.setEarthLocation();
        try {
            Variable t = this.ds.findVariable("time");
            Array tArray = t.read();
            this.time = (double[])tArray.copyTo1DJavaArray();
            Variable ele = this.ds.findVariable("elevation");
            Array eArray = ele.read();
            this.elevation = (float[])eArray.copyTo1DJavaArray();
            Variable azi = this.ds.findVariable("azimuth");
            Array aArray = azi.read();
            this.azimuth = (float[])aArray.copyTo1DJavaArray();
            Variable rng = this.ds.findVariable("range");
            Array rArray = rng.read();
            this.range = (float[])rArray.copyTo1DJavaArray();
            Variable sidx0 = this.ds.findVariable("sweep_start_ray_index");
            this.rayStartIdx = (int[])sidx0.read().copyTo1DJavaArray();
            Variable sidx1 = this.ds.findVariable("sweep_end_ray_index");
            this.rayEndIdx = (int[])sidx1.read().copyTo1DJavaArray();
            this.nsweeps = this.ds.findDimension("sweep").getLength();
            Variable var = this.ds.findVariable("ray_n_gates");
            if (var != null) {
                this.ray_n_gates = (int[])var.read().copyTo1DJavaArray();
            }
            if ((var = this.ds.findVariable("ray_start_index")) != null) {
                this.ray_start_index = (int[])var.read().copyTo1DJavaArray();
            }
            this.setTimeUnits();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.setStartDate();
        this.setEndDate();
        this.setBoundingBox();
    }

    @Override
    protected void setBoundingBox() {
        LatLonRect bb;
        if (this.origin == null) {
            return;
        }
        double dLat = Math.toDegrees(this.getMaximumRadialDist() / Earth.getRadius());
        double latRadians = Math.toRadians(this.origin.getLatitude());
        double dLon = dLat * Math.cos(latRadians);
        double lat1 = this.origin.getLatitude() - dLat / 2.0;
        double lon1 = this.origin.getLongitude() - dLon / 2.0;
        this.boundingBox = bb = new LatLonRect(new LatLonPointImpl(lat1, lon1), dLat, dLon);
    }

    double getMaximumRadialDist() {
        double maxdist = 0.0;
        for (Object dataVariable : this.dataVariables) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)dataVariable;
            RadialDatasetSweep.Sweep sp = rv.getSweep(0);
            double dist = (float)sp.getGateNumber() * sp.getGateSize();
            if (!(dist > maxdist)) continue;
            maxdist = dist;
        }
        return maxdist;
    }

    @Override
    protected void setEarthLocation() {
        try {
            Array gar;
            Variable ga = this.ds.findVariable("latitude");
            if (ga != null) {
                if (ga.isScalar()) {
                    this.latv = ga.readScalarDouble();
                } else {
                    gar = ga.read();
                    this.latv = gar.getDouble(0);
                }
            } else {
                this.latv = 0.0;
            }
            ga = this.ds.findVariable("longitude");
            if (ga != null) {
                if (ga.isScalar()) {
                    this.lonv = ga.readScalarDouble();
                } else {
                    gar = ga.read();
                    this.lonv = gar.getDouble(0);
                }
            } else {
                this.lonv = 0.0;
            }
            ga = this.ds.findVariable("altitude");
            if (ga != null) {
                if (ga.isScalar()) {
                    this.elev = ga.readScalarDouble();
                } else {
                    gar = ga.read();
                    this.elev = gar.getDouble(0);
                }
            } else {
                this.elev = 0.0;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.origin = new EarthLocationImpl(this.latv, this.lonv, this.elev);
    }

    @Override
    public EarthLocation getCommonOrigin() {
        return this.origin;
    }

    @Override
    public String getRadarID() {
        Attribute ga = this.ds.findGlobalAttribute("Station");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "XXXX";
    }

    @Override
    public String getRadarName() {
        Attribute ga = this.ds.findGlobalAttribute("instrument_name");
        if (ga != null) {
            return ga.getStringValue();
        }
        return "Unknown Station";
    }

    @Override
    public String getDataFormat() {
        return "CF/RadialNetCDF";
    }

    @Override
    public boolean isVolume() {
        return true;
    }

    public boolean isHighResolution(NetcdfDataset nds) {
        return true;
    }

    @Override
    public boolean isStationary() {
        if (!this.isStationaryChecked) {
            Variable lat = this.ds.findVariable("latitude");
            if (lat != null) {
                if (lat.isScalar()) {
                    this.isStationary = lat.getSize() == 1L;
                } else {
                    Array gar = null;
                    try {
                        gar = lat.read();
                        Object firstVal = gar.getObject(0);
                        Array gar2 = gar.copy();
                        int i = 1;
                        while ((long)i < gar.getSize()) {
                            gar2.setObject(i, firstVal);
                            ++i;
                        }
                        this.isStationary = MAMath.fuzzyEquals(gar, gar2);
                    }
                    catch (IOException e) {
                        log.error("Error reading latitude variable {}. Cannot determine if platform is stationary. Setting to default (false).", (Object)lat.getFullName());
                    }
                }
            }
            this.isStationaryChecked = true;
        }
        return this.isStationary;
    }

    @Override
    protected void setTimeUnits() throws Exception {
        Variable t = this.ds.findVariable("time");
        String ut = t.getUnitsString();
        this.dateUnits = new DateUnit(ut);
        this.calDateUnits = CalendarDateUnit.of(null, ut);
    }

    @Override
    protected void setStartDate() {
        String datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_start", null);
        this.startDate = datetime != null ? CalendarDate.parseISOformat(null, datetime).toDate() : this.calDateUnits.makeCalendarDate(this.time[0]).toDate();
    }

    @Override
    protected void setEndDate() {
        String datetime = this.ds.findAttValueIgnoreCase(null, "time_coverage_end", null);
        this.endDate = datetime != null ? CalendarDate.parseISOformat(null, datetime).toDate() : this.calDateUnits.makeCalendarDate(this.time[this.time.length - 1]).toDate();
    }

    @Override
    public void clearDatasetMemory() {
        for (VariableSimpleIF rvar : this.getDataVariables()) {
            RadialDatasetSweep.RadialVariable radVar = (RadialDatasetSweep.RadialVariable)rvar;
            radVar.clearVariableMemory();
        }
    }

    @Override
    protected void addRadialVariable(NetcdfDataset nds, Variable var) {
        RadialDatasetSweep.RadialVariable rsvar = null;
        String vName = var.getShortName();
        int tIdx = var.findDimensionIndex("time");
        int rIdx = var.findDimensionIndex("range");
        int ptsIdx = var.findDimensionIndex("n_points");
        if (tIdx == 0 && rIdx == 1 || ptsIdx == 0) {
            RadialDatasetSweepAdapter.MyRadialVariableAdapter v = new RadialDatasetSweepAdapter.MyRadialVariableAdapter(vName, var.getAttributes());
            rsvar = this.makeRadialVariable(nds, v, var);
        }
        if (rsvar != null) {
            this.dataVariables.add(rsvar);
        }
    }

    @Override
    protected RadialDatasetSweep.RadialVariable makeRadialVariable(NetcdfDataset nds, VariableSimpleIF v, Variable v0) {
        return new CFRadial2Variable(nds, v0);
    }

    public String getInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("CFRadial2Dataset\n");
        sbuff.append(super.getDetailInfo());
        sbuff.append("\n\n");
        sbuff.append(this.parseInfo.toString());
        return sbuff.toString();
    }

    private class CFRadial2Variable
    extends RadialDatasetSweepAdapter.MyRadialVariableAdapter
    implements RadialDatasetSweep.RadialVariable {
        ArrayList<CFRadial2Sweep> sweeps;
        String name;
        private boolean flattened;

        private CFRadial2Variable(NetcdfDataset nds, Variable v0) {
            super(v0.getShortName(), v0.getAttributes());
            this.sweeps = new ArrayList();
            this.name = v0.getShortName();
            int[] shape = v0.getShape();
            int ngates = shape[v0.getRank() - 1];
            this.flattened = v0.findDimensionIndex("n_points") == 0;
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
                if (this.flattened) {
                    ngates = CFnetCDF2Dataset.this.ray_n_gates[CFnetCDF2Dataset.this.rayStartIdx[i]];
                    for (int ray = CFnetCDF2Dataset.this.rayStartIdx[i]; ray <= CFnetCDF2Dataset.this.rayEndIdx[i]; ++ray) {
                        ngates = CFnetCDF2Dataset.this.ray_n_gates[ray] > ngates ? CFnetCDF2Dataset.this.ray_n_gates[ray] : ngates;
                    }
                }
                this.sweeps.add(new CFRadial2Sweep(v0, i, ngates, CFnetCDF2Dataset.this.rayStartIdx[i], CFnetCDF2Dataset.this.rayEndIdx[i]));
            }
        }

        @Override
        public String toString() {
            return this.name;
        }

        @Override
        public int getNumSweeps() {
            return CFnetCDF2Dataset.this.nsweeps;
        }

        @Override
        public RadialDatasetSweep.Sweep getSweep(int sweepNo) {
            return this.sweeps.get(sweepNo);
        }

        public int getNumRadials() {
            return CFnetCDF2Dataset.this.azimuth.length;
        }

        @Override
        public float[] readAllData() throws IOException {
            Array allData;
            RadialDatasetSweep.Sweep spn = this.sweeps.get(0);
            Variable v = spn.getsweepVar();
            Attribute missing = v.findAttribute("_FillValue");
            float missingVal = missing == null ? Float.NaN : missing.getNumericValue().floatValue();
            int minRadial = this.getMinRadialNumber();
            int radials = this.getNumRadials();
            int gates = CFnetCDF2Dataset.this.range.length;
            try {
                allData = v.read();
            }
            catch (IOException e) {
                throw new IOException(e.getMessage());
            }
            if (this.flattened) {
                float[] fa0 = (float[])allData.get1DJavaArray(Float.TYPE);
                float[] fa = new float[minRadial * gates * CFnetCDF2Dataset.this.nsweeps];
                Arrays.fill(fa, missingVal);
                for (int s = 0; s < CFnetCDF2Dataset.this.nsweeps; ++s) {
                    for (int r = 0; r < minRadial; ++r) {
                        System.arraycopy(fa0, CFnetCDF2Dataset.this.ray_start_index[CFnetCDF2Dataset.this.rayStartIdx[s] + r], fa, s * minRadial * gates + r * gates, CFnetCDF2Dataset.this.ray_n_gates[CFnetCDF2Dataset.this.rayStartIdx[s] + r]);
                    }
                }
                return fa;
            }
            if (minRadial == radials) {
                return (float[])allData.get1DJavaArray(Float.TYPE);
            }
            float[] fa = new float[minRadial * gates * CFnetCDF2Dataset.this.nsweeps];
            float[] fa0 = (float[])allData.get1DJavaArray(Float.TYPE);
            int pos = 0;
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
                int startIdx = CFnetCDF2Dataset.this.rayStartIdx[i];
                int len = minRadial * gates;
                System.arraycopy(fa0, startIdx * gates, fa, pos, len);
                pos += len;
            }
            return fa;
        }

        public int getMinRadialNumber() {
            int minRadialNumber = Integer.MAX_VALUE;
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
                RadialDatasetSweep.Sweep swp = this.sweeps.get(i);
                int radialNumber = swp.getRadialNumber();
                if (radialNumber >= minRadialNumber) continue;
                minRadialNumber = radialNumber;
            }
            return minRadialNumber;
        }

        @Override
        public void clearVariableMemory() {
            for (int i = 0; i < CFnetCDF2Dataset.this.nsweeps; ++i) {
            }
        }

        private class CFRadial2Sweep
        implements RadialDatasetSweep.Sweep {
            double meanElevation = Double.NaN;
            double meanAzimuth = Double.NaN;
            int ngates;
            public int startIdx;
            public int endIdx;
            public int numRays;
            int sweepno;
            Variable sweepVar;

            CFRadial2Sweep(Variable v, int sweepno, int gates, int startIdx, int endIdx) {
                this.sweepVar = v;
                this.sweepno = sweepno;
                this.ngates = gates;
                this.startIdx = startIdx;
                this.endIdx = endIdx;
                this.numRays = endIdx - startIdx + 1;
            }

            public int getStartIdx() {
                return this.startIdx;
            }

            public int getEndIdx() {
                return this.endIdx;
            }

            @Override
            public Variable getsweepVar() {
                return this.sweepVar;
            }

            @Override
            public float[] readData() throws IOException {
                return this.sweepData();
            }

            private float[] sweepData() throws IOException {
                try {
                    if (CFRadial2Variable.this.flattened) {
                        int[] origin = new int[]{CFnetCDF2Dataset.this.ray_start_index[this.startIdx]};
                        int[] shape = new int[]{CFnetCDF2Dataset.this.ray_start_index[this.endIdx] + CFnetCDF2Dataset.this.ray_n_gates[this.endIdx] - origin[0]};
                        Array tempArray = this.sweepVar.read(origin, shape).reduce();
                        float[] tempD = (float[])tempArray.get1DJavaArray(Float.TYPE);
                        float missingVal = Float.NaN;
                        Attribute missing = this.sweepVar.findAttribute("_FillValue");
                        if (missing != null) {
                            missingVal = missing.getNumericValue().floatValue();
                        }
                        float[] ret = new float[this.ngates * this.numRays];
                        Arrays.fill(ret, missingVal);
                        int srcInd = 0;
                        for (int ray = 0; ray < this.numRays; ++ray) {
                            int gates = CFnetCDF2Dataset.this.ray_n_gates[this.startIdx + ray];
                            System.arraycopy(tempD, srcInd, ret, ray * this.ngates, gates);
                            srcInd += gates;
                        }
                        return ret;
                    }
                    int[] origin = new int[2];
                    origin[0] = this.startIdx;
                    int[] shape = this.sweepVar.getShape();
                    shape[0] = this.numRays;
                    Array sweepTmp = this.sweepVar.read(origin, shape).reduce();
                    return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public float[] readData(int ray) throws IOException {
                return this.rayData(ray);
            }

            public float[] rayData(int ray) throws IOException {
                int[] shape;
                int[] origin;
                if (CFRadial2Variable.this.flattened) {
                    origin = new int[]{CFnetCDF2Dataset.this.ray_start_index[this.startIdx + ray]};
                    shape = new int[]{CFnetCDF2Dataset.this.ray_n_gates[this.startIdx + ray]};
                } else {
                    origin = new int[2];
                    origin[0] = this.startIdx + ray;
                    shape = this.sweepVar.getShape();
                    shape[0] = 1;
                }
                try {
                    Array sweepTmp = this.sweepVar.read(origin, shape).reduce();
                    return (float[])sweepTmp.get1DJavaArray(Float.TYPE);
                }
                catch (InvalidRangeException e) {
                    throw new IOException(e);
                }
            }

            public void setMeanElevation() {
                double sum = 0.0;
                int sumSize = 0;
                for (int i = 0; i < this.numRays; ++i) {
                    if (Double.isNaN(CFnetCDF2Dataset.this.elevation[i])) continue;
                    sum += (double)CFnetCDF2Dataset.this.elevation[this.startIdx + i];
                    ++sumSize;
                }
                if (sumSize > 0) {
                    this.meanElevation = sum / (double)sumSize;
                }
            }

            @Override
            public float getMeanElevation() {
                if (Double.isNaN(this.meanElevation)) {
                    this.setMeanElevation();
                }
                return (float)this.meanElevation;
            }

            @Override
            public int getGateNumber() {
                return this.ngates;
            }

            @Override
            public int getRadialNumber() {
                return this.numRays;
            }

            @Override
            public RadialDatasetSweep.Type getType() {
                return null;
            }

            @Override
            public EarthLocation getOrigin(int ray) {
                return CFnetCDF2Dataset.this.origin;
            }

            @Override
            public Date getStartingTime() {
                return CFnetCDF2Dataset.this.startDate;
            }

            @Override
            public Date getEndingTime() {
                return CFnetCDF2Dataset.this.endDate;
            }

            @Override
            public int getSweepIndex() {
                return this.sweepno;
            }

            public void setMeanAzimuth() {
                double sum = 0.0;
                int sumSize = 0;
                for (int i = 0; i < this.numRays; ++i) {
                    if (Double.isNaN(CFnetCDF2Dataset.this.azimuth[i])) continue;
                    sum += (double)CFnetCDF2Dataset.this.azimuth[this.startIdx + i];
                    ++sumSize;
                }
                if (sumSize > 0) {
                    this.meanAzimuth = sum / (double)sumSize;
                }
            }

            @Override
            public float getMeanAzimuth() {
                if (Double.isNaN(this.meanAzimuth)) {
                    this.setMeanAzimuth();
                }
                return (float)this.meanAzimuth;
            }

            public boolean isConic() {
                return true;
            }

            @Override
            public float getElevation(int ray) throws IOException {
                return CFnetCDF2Dataset.this.elevation[ray + this.startIdx];
            }

            @Override
            public float[] getElevation() throws IOException {
                float[] elev = new float[this.numRays];
                System.arraycopy(CFnetCDF2Dataset.this.elevation, this.startIdx, elev, 0, this.numRays);
                return elev;
            }

            @Override
            public float[] getAzimuth() throws IOException {
                float[] azimu = new float[this.numRays];
                System.arraycopy(CFnetCDF2Dataset.this.azimuth, this.startIdx, azimu, 0, this.numRays);
                return azimu;
            }

            @Override
            public float getAzimuth(int ray) throws IOException {
                return CFnetCDF2Dataset.this.azimuth[ray + this.startIdx];
            }

            public float getRadialDistance(int gate) throws IOException {
                return CFnetCDF2Dataset.this.range[gate];
            }

            @Override
            public float getTime(int ray) throws IOException {
                return (float)CFnetCDF2Dataset.this.time[ray + this.startIdx];
            }

            @Override
            public float getBeamWidth() {
                return 0.95f;
            }

            @Override
            public float getNyquistFrequency() {
                return 0.0f;
            }

            @Override
            public float getRangeToFirstGate() {
                try {
                    return this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            @Override
            public float getGateSize() {
                try {
                    return this.getRadialDistance(1) - this.getRadialDistance(0);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return 0.0f;
                }
            }

            public boolean isGateSizeConstant() {
                return true;
            }

            @Override
            public void clearSweepMemory() {
            }
        }
    }
}

