/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.s3;

import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.crawlabledataset.s3.CachingThreddsS3Client;
import thredds.crawlabledataset.s3.S3URI;
import thredds.crawlabledataset.s3.ThreddsS3Client;
import thredds.crawlabledataset.s3.ThreddsS3ClientImpl;

public class CrawlableDatasetAmazonS3
extends CrawlableDatasetFile {
    private static final Logger logger = LoggerFactory.getLogger(CrawlableDatasetAmazonS3.class);
    private static final long ENTRY_EXPIRATION_TIME = 1L;
    private static final long MAX_SUMMARY_ENTRIES = 10000L;
    private static final Cache<S3URI, S3ObjectSummary> objectSummaryCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.HOURS).maximumSize(10000L).build();
    private static ThreddsS3Client defaultThreddsS3Client = new CachingThreddsS3Client(new ThreddsS3ClientImpl());
    private final S3URI s3uri;
    private final ThreddsS3Client threddsS3Client;

    public CrawlableDatasetAmazonS3(String path) {
        this(path, null);
    }

    public CrawlableDatasetAmazonS3(String path, Object configObject) {
        this(new S3URI(path), configObject);
    }

    public CrawlableDatasetAmazonS3(S3URI s3uri) {
        this(s3uri, null);
    }

    public CrawlableDatasetAmazonS3(S3URI s3uri, Object configObject) {
        this(s3uri, configObject, defaultThreddsS3Client);
    }

    public CrawlableDatasetAmazonS3(S3URI s3uri, Object configObject, ThreddsS3Client threddsS3Client) {
        super(s3uri.toString(), configObject);
        this.s3uri = s3uri;
        this.threddsS3Client = threddsS3Client;
    }

    public static void setDefaultThreddsS3Client(ThreddsS3Client threddsS3Client) {
        defaultThreddsS3Client = threddsS3Client;
    }

    public static void clearCache() {
        objectSummaryCache.invalidateAll();
    }

    public S3URI getS3URI() {
        return this.s3uri;
    }

    public ThreddsS3Client getThreddsS3Client() {
        return this.threddsS3Client;
    }

    @Override
    public File getFile() {
        try {
            return this.threddsS3Client.saveObjectToFile(this.s3uri, this.s3uri.getTempFile());
        }
        catch (IOException e) {
            logger.error(String.format("Could not save S3 object '%s' to file.", this.s3uri), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getPath() {
        return this.s3uri.toString();
    }

    @Override
    public String getName() {
        return this.s3uri.getBaseName();
    }

    @Override
    public CrawlableDataset getParentDataset() {
        return new CrawlableDatasetAmazonS3(this.s3uri.getParent(), this.getConfigObject(), this.threddsS3Client);
    }

    @Override
    public CrawlableDataset getDescendant(String relativePath) {
        return new CrawlableDatasetAmazonS3(this.s3uri.getChild(relativePath), this.getConfigObject(), this.threddsS3Client);
    }

    @Override
    public boolean exists() {
        return objectSummaryCache.getIfPresent((Object)this.s3uri) != null || this.threddsS3Client.getObjectMetadata(this.s3uri) != null || this.threddsS3Client.listObjects(this.s3uri) != null;
    }

    @Override
    public boolean isCollection() {
        return objectSummaryCache.getIfPresent((Object)this.s3uri) == null && this.threddsS3Client.listObjects(this.s3uri) != null;
    }

    @Override
    public List<CrawlableDataset> listDatasets() throws IOException {
        CrawlableDatasetAmazonS3 crawlableDset;
        S3URI childS3uri;
        ObjectListing objectListing;
        boolean isCachedObject;
        boolean bl = isCachedObject = objectSummaryCache.getIfPresent((Object)this.s3uri) != null;
        if (isCachedObject || (objectListing = this.threddsS3Client.listObjects(this.s3uri)) == null) {
            String tmpMsg = String.format("'%s' is not a collection dataset.", this.s3uri);
            logger.error("listDatasets(): " + tmpMsg);
            throw new IllegalStateException(tmpMsg);
        }
        ArrayList<CrawlableDataset> crawlableDsets = new ArrayList<CrawlableDataset>();
        for (S3ObjectSummary objectSummary : objectListing.getObjectSummaries()) {
            childS3uri = new S3URI(objectSummary.getBucketName(), objectSummary.getKey());
            crawlableDset = new CrawlableDatasetAmazonS3(childS3uri, this.getConfigObject(), this.threddsS3Client);
            crawlableDsets.add(crawlableDset);
            objectSummaryCache.put((Object)childS3uri, (Object)objectSummary);
        }
        for (String commonPrefix : objectListing.getCommonPrefixes()) {
            childS3uri = new S3URI(this.s3uri.getBucket(), commonPrefix);
            crawlableDset = new CrawlableDatasetAmazonS3(childS3uri, this.getConfigObject(), this.threddsS3Client);
            crawlableDsets.add(crawlableDset);
        }
        assert (!crawlableDsets.isEmpty()) : "This is a collection and collections shouldn't be empty.";
        return crawlableDsets;
    }

    @Override
    public long length() {
        S3ObjectSummary objectSummary = (S3ObjectSummary)objectSummaryCache.getIfPresent((Object)this.s3uri);
        if (objectSummary != null) {
            return objectSummary.getSize();
        }
        ObjectMetadata metadata = this.threddsS3Client.getObjectMetadata(this.s3uri);
        if (metadata != null) {
            return metadata.getContentLength();
        }
        return 0L;
    }

    @Override
    public Date lastModified() {
        S3ObjectSummary objectSummary = (S3ObjectSummary)objectSummaryCache.getIfPresent((Object)this.s3uri);
        if (objectSummary != null) {
            return objectSummary.getLastModified();
        }
        ObjectMetadata metadata = this.threddsS3Client.getObjectMetadata(this.s3uri);
        if (metadata != null) {
            return metadata.getLastModified();
        }
        return null;
    }

    @Override
    public String toString() {
        return String.format("CrawlableDatasetAmazonS3{'%s'}", this.s3uri);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CrawlableDatasetAmazonS3 that = (CrawlableDatasetAmazonS3)other;
        return Objects.equals(this.getS3URI(), that.getS3URI()) && Objects.equals(this.getConfigObject(), that.getConfigObject());
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.getS3URI(), this.getConfigObject()});
    }
}

