/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.writer;

import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.builder.CatalogBuilder;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.Indent;

public class CatalogCrawler {
    private Filter filter = null;
    private int max = -1;
    private Type type = Type.all;
    private Listener listen;
    private Random random;
    private int countCatrefs = 0;
    private int numReadFailures = 0;

    public CatalogCrawler(Type type, int max, Filter filter, Listener listen) {
        this.type = type;
        this.max = max;
        this.filter = filter;
        this.listen = listen;
        if (type == Type.random_direct || type == Type.random_direct_middle || type == Type.random_direct_max) {
            this.random = new Random(System.currentTimeMillis());
        }
    }

    public int crawl(String catUrl, CancelTask task, PrintWriter out, Object context) throws IOException {
        boolean isValid;
        CatalogBuilder catFactory = new CatalogBuilder();
        Catalog cat = catFactory.buildFromLocation(catUrl);
        boolean bl = isValid = !catFactory.hasFatalError();
        if (out != null) {
            out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
            out.println(" validation output=\n" + catFactory.getErrorMessage());
        }
        if (out != null) {
            out.println("***CATALOG " + cat.getBaseURI());
        }
        if (isValid) {
            return this.crawl(cat, task, out, context, new Indent(2));
        }
        return 0;
    }

    public int crawl(Catalog cat, CancelTask task, PrintWriter out, Object context, Indent indent) throws IOException {
        for (Dataset ds : cat.getDatasets()) {
            this.crawlDataset(ds, true, task, out, context, indent);
            if (task == null || !task.isCancel()) continue;
            break;
        }
        return 1 + this.countCatrefs;
    }

    private void crawlDataset(Dataset ds, boolean isTop, CancelTask task, PrintWriter out, Object context, Indent indent) throws IOException {
        if (this.filter != null && this.filter.skipAll(ds)) {
            return;
        }
        if (ds instanceof CatalogRef) {
            CatalogRef catref = (CatalogRef)ds;
            if (out != null) {
                out.printf("%s**CATREF %s (%s)%n", indent, catref.getURI(), ds.getName());
            }
            ++this.countCatrefs;
            if (!this.listen.getCatalogRef(catref, context)) {
                return;
            }
            Catalog cat = this.readCatref(catref, out, indent);
            if (cat == null) {
                ++this.numReadFailures;
                return;
            }
            this.crawl(cat, task, out, context, indent.incr());
            indent.decr();
            return;
        }
        if (isTop && (this.type == Type.all || ds.hasAccess())) {
            this.listen.getDataset(ds, context);
        }
        if (this.type == Type.all) {
            for (Dataset dds : ds.getDatasets()) {
                this.listen.getDataset(dds, context);
                this.crawlDataset(dds, false, task, out, context, indent.incr());
                indent.decr();
                if (task == null || !task.isCancel()) continue;
                break;
            }
        } else {
            List<Dataset> dlist = ds.getDatasets();
            ArrayList<Dataset> leaves = new ArrayList<Dataset>();
            for (Dataset dds : dlist) {
                if (!dds.hasAccess()) continue;
                leaves.add(dds);
            }
            if (leaves.size() > 0) {
                if (this.type == Type.first_direct) {
                    Dataset dds = (Dataset)leaves.get(0);
                    this.listen.getDataset(dds, context);
                } else if (this.type == Type.random_direct) {
                    this.listen.getDataset(this.chooseRandom(leaves), context);
                } else if (this.type == Type.random_direct_middle) {
                    this.listen.getDataset(this.chooseRandomNotFirstOrLast(leaves), context);
                } else {
                    for (Dataset dds : leaves) {
                        this.listen.getDataset(dds, context);
                        if (task == null || !task.isCancel()) continue;
                        break;
                    }
                }
            }
        }
        for (Dataset dds : ds.getDatasets()) {
            if (dds.hasNestedDatasets() || dds instanceof CatalogRef) {
                this.crawlDataset(dds, false, task, out, context, indent.incr());
                indent.decr();
            }
            if (task == null || !task.isCancel()) continue;
            break;
        }
    }

    private Catalog readCatref(CatalogRef catref, PrintWriter out, Indent indent) {
        CatalogBuilder builder = new CatalogBuilder();
        try {
            Catalog cat = builder.buildFromCatref(catref);
            if (builder.hasFatalError() || cat == null) {
                if (out != null) {
                    out.printf("%sError reading catref %s err=%s%n", indent, catref.getName(), builder.getErrorMessage());
                }
                return null;
            }
            return cat;
        }
        catch (IOException e) {
            if (out != null) {
                out.printf("%sError reading catref %s err=%s%n", indent, catref.getName(), e.getMessage());
            }
            return null;
        }
    }

    private Dataset chooseRandom(List datasets) {
        int index = this.random.nextInt(datasets.size());
        return (Dataset)datasets.get(index);
    }

    private Dataset chooseRandomNotFirstOrLast(List datasets) {
        int index = this.random.nextInt(datasets.size());
        if (index == 0 && datasets.size() > 1) {
            ++index;
        } else if (index == datasets.size() - 1 && datasets.size() > 1) {
            --index;
        }
        return (Dataset)datasets.get(index);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", (Object)this.filter).add("max", this.max).add("type", (Object)this.type).add("listen", (Object)this.listen).add("random", (Object)this.random).add("countCatrefs", this.countCatrefs).toString();
    }

    public int getNumReadFailures() {
        return this.numReadFailures;
    }

    private static class FilterDatasetScan
    implements Filter {
        boolean skipDatasetScan;

        private FilterDatasetScan(boolean skipDatasetScan) {
            this.skipDatasetScan = skipDatasetScan;
        }

        @Override
        public boolean skipAll(Dataset ds) {
            return this.skipDatasetScan && ds instanceof CatalogRef && ds.findProperty("DatasetScan") != null;
        }
    }

    public static interface Filter {
        public boolean skipAll(Dataset var1);
    }

    public static interface Listener {
        public void getDataset(Dataset var1, Object var2);

        public boolean getCatalogRef(CatalogRef var1, Object var2);
    }

    public static enum Type {
        all,
        all_direct,
        first_direct,
        random_direct,
        random_direct_middle,
        random_direct_max;

    }
}

