/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog.crawl;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Formatter;
import java.util.List;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.crawl.CatalogCrawler;
import ucar.nc2.Attribute;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VerticalCT;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.thredds.ThreddsDataFactory;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.units.TimeUnit;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.IO;
import ucar.nc2.util.NamedObject;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.util.Format;
import ucar.unidata.util.Parameter;
import ucar.unidata.util.StringUtil2;

public class CatalogExtractor
implements CatalogCrawler.Listener {
    private boolean verbose = true;
    private InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory(true);
    private ThreddsDataFactory tdataFactory = new ThreddsDataFactory();
    private int countDatasets;
    private int countNoAccess;
    private int countNoOpen;
    private PrintWriter out;
    private String transferDir = "C:/data/bad/";
    private String copyDir = null;

    public CatalogExtractor(boolean verbose) {
        this.verbose = verbose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copy(String catUrl, String copyToDir, CancelTask task) throws IOException {
        StringBuilder buff;
        this.copyDir = copyToDir;
        InvCatalogImpl cat = this.catFactory.readXML(catUrl);
        if (!cat.check(buff = new StringBuilder(), false)) {
            return;
        }
        this.countDatasets = 0;
        this.countNoAccess = 0;
        this.countNoOpen = 0;
        int countCatRefs = 0;
        CatalogCrawler crawler = new CatalogCrawler(1, false, new CatalogCrawler.Listener(){

            @Override
            public void getDataset(InvDataset dd, Object context) {
                InvAccess access = CatalogExtractor.this.tdataFactory.chooseDatasetAccess(dd.getAccess());
                if (null != access) {
                    CatalogExtractor.this.transfer(access.getStandardUrlName(), CatalogExtractor.this.copyDir);
                }
            }

            @Override
            public boolean getCatalogRef(InvCatalogRef dd, Object context) {
                return true;
            }
        });
        long start = System.currentTimeMillis();
        try {
            countCatRefs = crawler.crawl(cat, task, this.out, null);
        }
        finally {
            int took = (int)(System.currentTimeMillis() - start) / 1000;
            this.out.println("***Done " + catUrl + " took = " + took + " secs\n   datasets=" + this.countDatasets + " no access=" + this.countNoAccess + " open failed=" + this.countNoOpen + " total catalogs=" + countCatRefs);
            if (this.verbose) {
                System.out.println("***Done " + catUrl + " took = " + took + " secs\n   datasets=" + this.countDatasets + " no access=" + this.countNoAccess + " open failed=" + this.countNoOpen + " total catalogs=" + countCatRefs);
            }
        }
    }

    public void extractLoop(PrintWriter out, String catUrl, int type, boolean skipDatasetScan, CancelTask task) throws IOException {
        do {
            this.extract(out, catUrl, type, skipDatasetScan, task);
        } while (task == null || !task.isCancel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void extract(PrintWriter out, String catUrl, int type, boolean skipDatasetScan, CancelTask task) throws IOException {
        this.out = out;
        out.println("***read " + catUrl);
        InvCatalogImpl cat = this.catFactory.readXML(catUrl);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        if (!isValid) {
            System.out.println("***Catalog invalid= " + catUrl + " validation output=\n" + buff);
            out.println("***Catalog invalid= " + catUrl + " validation output=\n" + buff);
            return;
        }
        out.println("catalog <" + cat.getName() + "> is valid");
        out.println(" validation output=\n" + buff);
        this.countDatasets = 0;
        this.countNoAccess = 0;
        this.countNoOpen = 0;
        int countCatRefs = 0;
        CatalogCrawler crawler = new CatalogCrawler(type, skipDatasetScan, (CatalogCrawler.Listener)this);
        long start = System.currentTimeMillis();
        try {
            countCatRefs = crawler.crawl(cat, task, out, null);
        }
        finally {
            int took = (int)(System.currentTimeMillis() - start) / 1000;
            out.println("***Done " + catUrl + " took = " + took + " secs\n   datasets=" + this.countDatasets + " no access=" + this.countNoAccess + " open failed=" + this.countNoOpen + " total catalogs=" + countCatRefs);
            if (this.verbose) {
                System.out.println("***Done " + catUrl + " took = " + took + " secs\n   datasets=" + this.countDatasets + " no access=" + this.countNoAccess + " open failed=" + this.countNoOpen + " total catalogs=" + countCatRefs);
            }
        }
    }

    @Override
    public void getDataset(InvDataset ds, Object context) {
        ++this.countDatasets;
        this.openDataset(this.out, ds);
    }

    @Override
    public boolean getCatalogRef(InvCatalogRef dd, Object context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openDataset(PrintWriter out, InvDataset ds) {
        InvAccess access = this.tdataFactory.chooseDatasetAccess(ds.getAccess());
        if (access == null) {
            ++this.countNoAccess;
            out.println("  **FAILED to find access " + ds.getName());
            System.out.println("  **FAILED to find access " + ds.getName());
            return false;
        }
        NetcdfDataset ncd = null;
        long start = System.currentTimeMillis();
        try {
            Formatter log = new Formatter();
            ncd = this.tdataFactory.openDataset(access, true, null, log);
            if (ncd == null) {
                ++this.countNoOpen;
                out.println("  **FAILED to open " + access.getStandardUrlName() + " " + log);
                System.out.println("  **FAILED to open " + access.getStandardUrlName() + " " + log);
                this.transfer(access.getStandardUrlName(), this.transferDir);
                boolean bl = false;
                return bl;
            }
            int took = (int)(System.currentTimeMillis() - start);
            boolean ok = true;
            out.println("  **Open " + (Object)((Object)ds.getDataType()) + " " + ncd.getLocation() + " (" + ds.getName() + ") " + took + " msecs");
            if (this.verbose) {
                System.out.println("  **Open " + (Object)((Object)ds.getDataType()) + " " + ncd.getLocation() + " (" + ds.getName() + ") " + took + " msecs");
            }
        }
        catch (Throwable e) {
            ++this.countNoOpen;
            out.println("  **FAILED to open " + access.getStandardUrlName());
            System.out.println("  **FAILED to open " + access.getStandardUrlName());
            this.transfer(access.getStandardUrlName(), this.transferDir);
            boolean bl = false;
            return bl;
        }
        finally {
            if (ncd != null) {
                try {
                    ncd.close();
                    out.println("   Close " + ncd.getLocation());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    private void transfer(String url, String copyToDir) {
        String new_url = StringUtil2.substitute(url, "dodsC", "fileServer");
        int pos = url.lastIndexOf(47);
        String filename = url.substring(pos + 1);
        File file = new File(copyToDir, filename);
        IO.readURLtoFile(new_url, file);
        System.out.println("  **copied to " + file.getPath() + " size=" + file.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean extractTypedDatasetInfo(PrintWriter out, InvDataset ds) {
        boolean ok = true;
        long start = System.currentTimeMillis();
        ThreddsDataFactory.Result result = null;
        try {
            result = this.tdataFactory.openFeatureDataset(ds, null);
            int took = (int)(System.currentTimeMillis() - start);
            if (this.verbose) {
                System.out.println("  **Open " + (Object)((Object)result.featureType) + " " + result.location + " (" + ds.getName() + ") " + took + " msecs");
            }
            out.println("  **Open " + (Object)((Object)result.featureType) + " " + result.location + " (" + ds.getName() + ") " + took + " msecs");
            if (result.location == null) {
                ok = false;
            } else if (result.featureType == FeatureType.GRID) {
                this.extractGridDataset(out, (GridDataset)((Object)result.featureDataset));
            }
        }
        catch (Throwable e) {
            out.println("   **FAILED " + ds.getName());
            e.printStackTrace(out);
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (result != null && result.featureDataset != null) {
                try {
                    result.featureDataset.close();
                    out.println("   Close " + (Object)((Object)result.featureType) + " " + result.location);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ok;
    }

    private void extractGridDataset(PrintWriter out, GridDataset gridDs) {
        if (!this.verbose) {
            out.println("    ngrids = " + gridDs.getGrids().size());
            return;
        }
        if (gridDs == null) {
            return;
        }
        out.println("Global Attributes");
        NetcdfDataset ds = (NetcdfDataset)gridDs.getNetcdfFile();
        this.showAtts(out, ds.getGlobalAttributes());
        out.println();
        GridCoordSystem gcsMax = null;
        LatLonRect llbbMax = null;
        LatLonRect llbb = null;
        CalendarDateRange dateRange = null;
        long nx = 0L;
        long ny = 0L;
        for (GridDataset.Gridset gset : gridDs.getGridsets()) {
            CoordinateAxis1D vaxis;
            ProjectionImpl proj;
            GridCoordSystem gcs = gset.getGeoCoordSystem();
            CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
            CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
            long nx2 = xaxis.getSize();
            long ny2 = yaxis.getSize();
            if (nx != nx2 || ny != ny2) {
                nx = nx2;
                ny = ny2;
                double dx = xaxis.getIncrement();
                double dy = yaxis.getIncrement();
                out.println("  horizontal = " + nx + " by " + ny + " points, resolution " + Format.d(dx, 4) + " " + Format.d(dy, 4) + " " + xaxis.getUnitsString());
            }
            if ((proj = gcs.getProjection()) != null) {
                out.println(", " + proj.getClassName() + " projection;");
                List<Parameter> params = proj.getProjectionParameters();
                for (Parameter p : params) {
                    out.println("       " + p.getName() + " " + p.getStringValue());
                }
            } else {
                out.println();
            }
            LatLonRect llbb2 = gcs.getLatLonBoundingBox();
            if (llbb == null || !llbb2.equals(llbb)) {
                llbb = llbb2;
                if (llbbMax == null) {
                    llbbMax = llbb;
                } else {
                    llbbMax.extend(llbb);
                }
                if (llbb.getWidth() >= 360.0) {
                    out.println("  BoundingBox == GLOBAL");
                } else {
                    StringBuilder buff = new StringBuilder();
                    LatLonPointImpl ll = llbb.getLowerLeftPoint();
                    LatLonPointImpl ur = llbb.getUpperRightPoint();
                    buff.append(Double.toString(ll.getLongitude()));
                    buff.append(" ");
                    buff.append(Double.toString(ll.getLatitude()));
                    buff.append(" ");
                    buff.append(Double.toString(ur.getLongitude()));
                    buff.append(" ");
                    buff.append(Double.toString(ur.getLatitude()));
                    buff.append(" ");
                    out.println("  BoundingBox == " + buff + " width= " + llbb.getWidth() + " " + (llbb.getWidth() >= 360.0 ? "global" : ""));
                }
            }
            CoordinateAxis1DTime taxis = gcs.getTimeAxis1D();
            CalendarDateRange dateRange2 = gcs.getCalendarDateRange();
            if (!(taxis == null || dateRange != null && dateRange2.equals(dateRange))) {
                long ntimes = taxis.getSize();
                try {
                    TimeUnit tUnit = taxis.getTimeResolution();
                    if (dateRange != null) {
                        out.printf("  DateRange == %s duration = %d secs; ntimes = %d  data resolution = %s%n", dateRange, dateRange.getDurationInSecs(), ntimes, tUnit);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if ((vaxis = gcs.getVerticalAxis()) == null) continue;
            long nvert = vaxis.getSize();
            out.print("  Vertical axis= " + vaxis.getFullName() + " units=" + vaxis.getUnitsString() + " size= " + nvert);
            VerticalCT vt = gcs.getVerticalCT();
            if (vt != null) {
                out.print(" transform= " + vt.getVerticalTransformType());
            }
            List<NamedObject> vertNames = vaxis.getNames();
            for (NamedObject vertName : vertNames) {
                out.print(" " + vertName);
            }
            out.println();
            if (gcsMax != null && gcsMax.getVerticalAxis().getSize() >= vaxis.getSize()) continue;
            gcsMax = gcs;
        }
    }

    private void showAtts(PrintWriter out, List<Attribute> atts) {
        for (Attribute att : atts) {
            out.println("  " + att);
        }
    }

    private void makeGrib1Vocabulary(List<GridDatatype> grids, PrintWriter out) {
        out.println("\n<variables vocabulary='GRIB-1'>");
        for (GridDatatype grid : grids) {
            Attribute att = grid.findAttributeIgnoreCase("GRIB_param_number");
            String stdName = att != null ? att.getNumericValue().toString() : null;
            out.print("  <variable name='");
            out.print(grid.getFullName());
            out.print("' vocabulary_name='");
            out.print(stdName != null ? stdName : "dunno");
            out.print("' units='");
            out.print(grid.getUnitsString());
            out.println("'/>");
        }
        out.println("</variables>");
    }
}

