/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.cover.collection;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.featurecollection.FeatureCollectionType;
import thredds.inventory.CollectionPathMatcher;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MFile;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ft.cover.CoverageCS;
import ucar.nc2.ft.cover.impl.CoverageCSFactory;
import ucar.nc2.ft.cover.impl.CoverageDatasetImpl;
import ucar.nc2.ft.cover.impl.CoverageIndexWriter;

public class GridCollectionBuilder {
    public boolean updateGribCollection(FeatureCollectionConfig config, CollectionUpdateType updateType, Logger logger) throws IOException {
        long start = System.currentTimeMillis();
        ArrayList<CoverageDatasetImpl> collection = new ArrayList<CoverageDatasetImpl>();
        Formatter errlog = new Formatter();
        CollectionSpecParser specp = new CollectionSpecParser(config.spec, errlog);
        System.out.printf("specp=%s%n", specp);
        boolean changed = false;
        try (CollectionPathMatcher dcm = new CollectionPathMatcher(config, specp, logger);){
            for (MFile file : dcm.getFilesSorted()) {
                System.out.printf(" %s == %s == ", file.getPath(), dcm.extractDate(file));
                NetcdfDataset ds = NetcdfDataset.openDataset(file.getPath());
                Throwable throwable = null;
                try {
                    System.out.printf("%s%n", CoverageCSFactory.describe(errlog, ds));
                    CoverageDatasetImpl cds = new CoverageDatasetImpl(ds, errlog);
                    if (cds.getType() == null) {
                        System.out.printf(" **Error classifying: %s%n", errlog);
                        continue;
                    }
                    if (cds.getType() != CoverageCS.Type.Grid) {
                        System.out.printf(" **NOT A GRID %s%n", ds.getLocation());
                        continue;
                    }
                    collection.add(cds);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ds == null) continue;
                    if (throwable != null) {
                        try {
                            ds.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    ds.close();
                }
            }
        }
        if (collection.size() > 0) {
            this.writeIndex((CoverageDatasetImpl)collection.get(0));
        }
        long took = System.currentTimeMillis() - start;
        logger.info("updateGribCollection {} changed {} took {} msecs", new Object[]{config.collectionName, changed, took});
        return changed;
    }

    private void writeIndex(CoverageDatasetImpl cds) throws IOException {
        CoverageIndexWriter writer = new CoverageIndexWriter();
        File idxFile = new File("C:/temp/testCovIndex.ncx3");
        writer.writeIndex("name", idxFile, null, cds);
    }

    public static void main(String[] args) throws IOException {
        Logger logger = LoggerFactory.getLogger((String)"test");
        FeatureCollectionConfig config = new FeatureCollectionConfig("RFC", "grid/CM2", FeatureCollectionType.GRID, "B:/CM2.1R/**/.*nc$", null, "#atmos.#yyyyMM", null, "none", null);
        GridCollectionBuilder builder = new GridCollectionBuilder();
        boolean changed = builder.updateGribCollection(config, CollectionUpdateType.always, logger);
        System.out.printf("changed = %s%n", changed);
    }
}

