/*
 * Decompiled with CFR 0.152.
 */
package thredds.inventory.partition;

import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import thredds.featurecollection.FeatureCollectionConfig;
import thredds.inventory.CollectionListRange;
import thredds.inventory.CollectionPathMatcher;
import thredds.inventory.CollectionSpecParser;
import thredds.inventory.CollectionUpdateType;
import thredds.inventory.MCollection;
import thredds.inventory.MFile;
import thredds.inventory.partition.PartitionManager;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarPeriod;

public class TimePartition
extends CollectionPathMatcher
implements PartitionManager {
    CalendarPeriod timePeriod;
    CalendarDateFormatter cdf;

    public TimePartition(FeatureCollectionConfig config, CollectionSpecParser specp, Logger logger) {
        super(config, specp, logger);
        this.timePeriod = config.timePeriod;
        this.cdf = CalendarDateFormatter.factory(this.timePeriod);
    }

    @Override
    public Iterable<MCollection> makePartitions(CollectionUpdateType forceCollection) throws IOException {
        ArrayList<MCollection> result = new ArrayList<MCollection>();
        CollectionListRange curr = null;
        CalendarDate startDate = null;
        CalendarDate endDate = null;
        for (MFile mfile : this.getFilesSorted()) {
            CalendarDate cdate = this.dateExtractor.getCalendarDate(mfile);
            if (cdate == null) continue;
            if (curr == null || !endDate.isAfter(cdate)) {
                startDate = cdate.truncate(this.timePeriod.getField());
                endDate = startDate.add(this.timePeriod);
                String name = this.collectionName + "-" + this.cdf.toString(startDate);
                curr = new CollectionListRange(name, this.root, startDate, endDate, this.logger);
                curr.putAuxInfo("fcConfig", this.config);
                result.add(curr);
            }
            curr.addFile(mfile);
        }
        return result;
    }
}

