/*
 * Decompiled with CFR 0.152.
 */
package thredds.client.catalog.writer;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import thredds.client.catalog.Access;
import thredds.client.catalog.Catalog;
import thredds.client.catalog.CatalogRef;
import thredds.client.catalog.Dataset;
import thredds.client.catalog.Documentation;
import thredds.client.catalog.Property;
import thredds.client.catalog.Service;
import thredds.client.catalog.ServiceType;
import thredds.client.catalog.ThreddsMetadata;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.util.Format;
import ucar.unidata.util.StringUtil2;

public class DatasetHtmlWriter {
    public void writeHtmlDescription(Formatter out, Dataset ds, boolean complete, boolean isServer, boolean datasetEvents, boolean catrefEvents, boolean resolveRelativeUrls) {
        DateRange tc;
        ThreddsMetadata.GeospatialCoverage gc;
        List<ThreddsMetadata.VariableGroup> vars;
        List<ThreddsMetadata.Source> publishers;
        List<ThreddsMetadata.Source> creators;
        List<ThreddsMetadata.Vocab> projects;
        List<DateType> dates;
        List<ThreddsMetadata.Vocab> keywords;
        List<ThreddsMetadata.Contributor> contributors;
        List<Access> access;
        if (ds == null) {
            return;
        }
        if (complete) {
            out.format("<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\"%n", new Object[0]);
            out.format("        \"http://www.w3.org/TR/html4/loose.dtd\">%n", new Object[0]);
            out.format("<html>%n", new Object[0]);
            out.format("<head>%n", new Object[0]);
            out.format("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=iso-8859-1\">%n", new Object[0]);
            out.format("</head>%n", new Object[0]);
            out.format("<body>%n", new Object[0]);
        }
        out.format("<h2>Dataset: %s</h2>%n<ul>", ds.getName());
        if (ds.getDataFormatName() != null) {
            out.format(" <li><em>Data format: </em>%s</li>%n", StringUtil2.quoteHtmlContent(ds.getDataFormatName()));
        }
        if (ds.getDataSize() > 0L) {
            out.format(" <li><em>Data size: </em>%s</li>%n", Format.formatByteSize(ds.getDataSize()));
        }
        if (ds.getFeatureTypeName() != null) {
            out.format(" <li><em>Feature type: </em>%s</li>%n", StringUtil2.quoteHtmlContent(ds.getFeatureTypeName()));
        }
        if (ds.getCollectionType() != null) {
            out.format(" <li><em>Collection type: </em>%s</li>%n", StringUtil2.quoteHtmlContent(ds.getCollectionType()));
        }
        if (ds.isHarvest()) {
            out.format(" <li><em>Harvest:</em> true</li>%n", new Object[0]);
        }
        if (ds.getAuthority() != null) {
            out.format(" <li><em>Naming Authority: </em>%s</li>%n%n", StringUtil2.quoteHtmlContent(ds.getAuthority()));
        }
        if (ds.getId() != null) {
            out.format(" <li><em>ID: </em>%s</li>%n", StringUtil2.quoteHtmlContent(ds.getId()));
        }
        if (ds.getRestrictAccess() != null) {
            out.format(" <li><em>RestrictAccess: </em>%s</li>%n", StringUtil2.quoteHtmlContent(ds.getRestrictAccess()));
        }
        if (ds instanceof CatalogRef) {
            String href;
            CatalogRef catref = (CatalogRef)ds;
            String string = href = resolveRelativeUrls || catrefEvents ? this.resolve(ds, catref.getXlinkHref()) : catref.getXlinkHref();
            if (catrefEvents) {
                href = "catref:" + href;
            }
            out.format(" <li><em>CatalogRef: </em>%s</li>%n", this.makeHref(href, null));
        }
        out.format("</ul>%n", new Object[0]);
        List<Documentation> docs = ds.getDocumentation();
        if (docs.size() > 0) {
            out.format("<h3>Documentation:</h3>%n<ul>%n", new Object[0]);
            for (Documentation doc : docs) {
                String type = doc.getType() == null ? "" : "<strong>" + StringUtil2.quoteHtmlContent(doc.getType()) + ":</strong> ";
                String inline = doc.getInlineContent();
                if (inline != null && inline.length() > 0) {
                    out.format(" <li>%s %s</li>%n", type, StringUtil2.quoteHtmlContent(inline));
                }
                if (!doc.hasXlink()) continue;
                out.format(" <li>%s %s</li>%n", type, this.makeHref(doc.getXlinkHref(), doc.getXlinkTitle()));
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((access = ds.getAccess()).size() > 0) {
            out.format("<h3>Access:</h3>%n<ol>%n", new Object[0]);
            for (Access a : access) {
                String urlString;
                Service s = a.getService();
                String fullUrlString = urlString = resolveRelativeUrls || datasetEvents ? a.getStandardUrlName() : a.getUnresolvedUrlName();
                if (datasetEvents) {
                    fullUrlString = "dataset:" + fullUrlString;
                }
                if (isServer) {
                    ServiceType stype = s.getType();
                    if (stype == ServiceType.OPENDAP || stype == ServiceType.DODS) {
                        fullUrlString = fullUrlString + ".html";
                    } else if (stype == ServiceType.DAP4) {
                        fullUrlString = fullUrlString + ".dmr.xml";
                    } else if (stype == ServiceType.WCS) {
                        fullUrlString = fullUrlString + "?service=WCS&version=1.0.0&request=GetCapabilities";
                    } else if (stype == ServiceType.WMS) {
                        fullUrlString = fullUrlString + "?service=WMS&version=1.3.0&request=GetCapabilities";
                    } else if (stype == ServiceType.NCML || stype == ServiceType.UDDC || stype == ServiceType.ISO) {
                        String catalogUrl = ds.getCatalogUrl();
                        String datasetId = ds.getId();
                        if (catalogUrl != null && datasetId != null) {
                            if (catalogUrl.indexOf(35) > 0) {
                                catalogUrl = catalogUrl.substring(0, catalogUrl.lastIndexOf(35));
                            }
                            try {
                                catalogUrl = URLEncoder.encode(catalogUrl, "UTF-8");
                                datasetId = URLEncoder.encode(datasetId, "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            fullUrlString = fullUrlString + "?catalog=" + catalogUrl + "&dataset=" + datasetId;
                        } else if (stype == ServiceType.NetcdfSubset) {
                            fullUrlString = fullUrlString + "/dataset.html";
                        } else if (stype == ServiceType.CdmRemote || stype == ServiceType.CdmrFeature) {
                            fullUrlString = fullUrlString + "?req=form";
                        }
                    }
                }
                out.format(" <li> <b>%s:</b>%s</li>%n", s.getServiceTypeName(), this.makeHref(fullUrlString, urlString));
            }
            out.format("</ol>%n", new Object[0]);
        }
        if ((contributors = ds.getContributors()).size() > 0) {
            out.format("<h3>Contributors:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Contributor t : contributors) {
                String role = t.getRole() == null ? "" : "<strong> (" + StringUtil2.quoteHtmlContent(t.getRole()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", StringUtil2.quoteHtmlContent(t.getName()), role);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((keywords = ds.getKeywords()).size() > 0) {
            out.format("<h3>Keywords:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Vocab t : keywords) {
                String vocab = t.getVocabulary() == null ? "" : " <strong>(" + StringUtil2.quoteHtmlContent(t.getVocabulary()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", StringUtil2.quoteHtmlContent(t.getText()), vocab);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((dates = ds.getDates()).size() > 0) {
            out.format("<h3>Dates:</h3>%n<ul>%n", new Object[0]);
            for (DateType d : dates) {
                String type = d.getType() == null ? "" : " <strong>(" + StringUtil2.quoteHtmlContent(d.getType()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", StringUtil2.quoteHtmlContent(d.getText()), type);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((projects = ds.getProjects()).size() > 0) {
            out.format("<h3>Projects:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Vocab t : projects) {
                String vocab = t.getVocabulary() == null ? "" : " <strong>(" + StringUtil2.quoteHtmlContent(t.getVocabulary()) + ")</strong> ";
                out.format(" <li>%s %s</li>%n", StringUtil2.quoteHtmlContent(t.getText()), vocab);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((creators = ds.getCreators()).size() > 0) {
            out.format("<h3>Creators:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Source t : creators) {
                out.format(" <li><strong>%s</strong><ul>%n", StringUtil2.quoteHtmlContent(t.getName()));
                out.format(" <li><em>email: </em>%s</li>%n", StringUtil2.quoteHtmlContent(t.getEmail()));
                if (t.getUrl() != null) {
                    String newUrl = resolveRelativeUrls ? this.makeHrefResolve(ds, t.getUrl(), null) : this.makeHref(t.getUrl(), null);
                    out.format(" <li> <em>%s</em></li>%n", newUrl);
                }
                out.format(" </ul></li>%n", new Object[0]);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((publishers = ds.getPublishers()).size() > 0) {
            out.format("<h3>Publishers:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.Source t : publishers) {
                out.format(" <li><strong>%s</strong><ul>%n", StringUtil2.quoteHtmlContent(t.getName()));
                out.format(" <li><em>email: </em>%s%n", StringUtil2.quoteHtmlContent(t.getEmail()));
                if (t.getUrl() != null) {
                    String urlLink = resolveRelativeUrls ? this.makeHrefResolve(ds, t.getUrl(), null) : this.makeHref(t.getUrl(), null);
                    out.format(" <li> <em>%s</em></li>%n", urlLink);
                }
                out.format(" </ul>%n", new Object[0]);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if ((vars = ds.getVariables()).size() > 0) {
            out.format("<h3>Variables:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.VariableGroup t : vars) {
                out.format("<li><em>Vocabulary</em> [", new Object[0]);
                if (t.getVocabUri() != null) {
                    ThreddsMetadata.UriResolved uri = t.getVocabUri();
                    String vocabLink = resolveRelativeUrls ? this.makeHref(uri.resolved.toString(), t.getVocabulary()) : this.makeHref(uri.href, t.getVocabulary());
                    out.format(vocabLink, new Object[0]);
                } else {
                    out.format(StringUtil2.quoteHtmlContent(t.getVocabulary()), new Object[0]);
                }
                out.format("]:%n<ul>%n", new Object[0]);
                List<ThreddsMetadata.Variable> vlist = t.getVariableList();
                if (vlist.size() > 0) {
                    for (ThreddsMetadata.Variable v : vlist) {
                        String units = v.getUnits() == null || v.getUnits().length() == 0 ? "" : " (" + v.getUnits() + ") ";
                        out.format(" <li><strong>%s</strong> = ", StringUtil2.quoteHtmlContent(v.getName() + units));
                        if (v.getDescription() != null) {
                            out.format(" <i>%s</i> = ", StringUtil2.quoteHtmlContent(v.getDescription()));
                        }
                        if (v.getVocabularyName() != null) {
                            out.format("%s", StringUtil2.quoteHtmlContent(v.getVocabularyName()));
                        }
                        out.format("%n", new Object[0]);
                    }
                }
                out.format("</ul>%n", new Object[0]);
            }
            out.format("</ul>%n", new Object[0]);
        }
        if (ds.getVariableMapLink() != null) {
            out.format("<h3>Variables:</h3>%n", new Object[0]);
            ThreddsMetadata.UriResolved uri = ds.getVariableMapLink();
            out.format("<ul><li>" + this.makeHref(uri.resolved.toASCIIString(), "VariableMap") + "</li></ul>%n", new Object[0]);
        }
        if ((gc = ds.getGeospatialCoverage()) != null) {
            List<ThreddsMetadata.Vocab> nlist;
            out.format("<h3>GeospatialCoverage:</h3>%n<ul>%n", new Object[0]);
            if (gc.isGlobal()) {
                out.format(" <li><em> Global </em>%n", new Object[0]);
            }
            out.format(" <li><em> Longitude: </em> %s</li>%n", this.rangeString(gc.getEastWestRange()));
            out.format(" <li><em> Latitude: </em> %s</li>%n", this.rangeString(gc.getNorthSouthRange()));
            if (gc.getUpDownRange() != null) {
                out.format(" <li><em> Altitude: </em> %s (positive is <strong>%s)</strong></li>%n", this.rangeString(gc.getUpDownRange()), gc.getZPositive());
            }
            if ((nlist = gc.getNames()) != null && nlist.size() > 0) {
                out.format(" <li><em>  Names: </em> <ul>%n", new Object[0]);
                for (ThreddsMetadata.Vocab elem : nlist) {
                    out.format(" <li>%s</li>%n", StringUtil2.quoteHtmlContent(elem.getText()));
                }
                out.format(" </ul>%n", new Object[0]);
            }
            out.format(" </ul>%n", new Object[0]);
        }
        if ((tc = ds.getTimeCoverage()) != null) {
            TimeDuration resolution;
            TimeDuration duration;
            DateType end;
            out.format("<h3>TimeCoverage:</h3>%n<ul>%n", new Object[0]);
            DateType start = tc.getStart();
            if (start != null) {
                out.format(" <li><em>  Start: </em> %s</li>%n", start.toString());
            }
            if ((end = tc.getEnd()) != null) {
                out.format(" <li><em>  End: </em> %s</li>%n", end.toString());
            }
            if ((duration = tc.getDuration()) != null) {
                out.format(" <li><em>  Duration: </em> %s</li>%n", StringUtil2.quoteHtmlContent(duration.toString()));
            }
            if ((resolution = tc.getResolution()) != null) {
                out.format(" <li><em>  Resolution: </em> %s</li>%n", StringUtil2.quoteHtmlContent(resolution.toString()));
            }
            out.format(" </ul>%n", new Object[0]);
        }
        List<ThreddsMetadata.MetadataOther> metadata = ds.getMetadataOther();
        boolean gotSomeMetadata = false;
        for (ThreddsMetadata.MetadataOther m : metadata) {
            if (m.getXlinkHref() == null) continue;
            gotSomeMetadata = true;
        }
        if (gotSomeMetadata) {
            out.format("<h3>Metadata:</h3>%n<ul>%n", new Object[0]);
            for (ThreddsMetadata.MetadataOther m : metadata) {
                String type;
                String string = type = m.getType() == null ? "" : m.getType();
                if (m.getXlinkHref() == null) continue;
                String title = m.getTitle() == null ? "Type " + type : m.getTitle();
                String mdLink = resolveRelativeUrls ? this.makeHrefResolve(ds, m.getXlinkHref(), title) : this.makeHref(m.getXlinkHref(), title);
                out.format(" <li> %s</li>%n", mdLink);
            }
            out.format("</ul>%n", new Object[0]);
        }
        List<Property> propsOrg = ds.getProperties();
        ArrayList<Property> props = new ArrayList<Property>(ds.getProperties().size());
        for (Property p : propsOrg) {
            if (p.getName().startsWith("viewer")) continue;
            props.add(p);
        }
        if (props.size() > 0) {
            out.format("<h3>Properties:</h3>%n<ul>%n", new Object[0]);
            for (Property p : props) {
                if (p.getName().equals("attachments")) {
                    String attachLink = resolveRelativeUrls ? this.makeHrefResolve(ds, p.getValue(), p.getName()) : this.makeHref(p.getValue(), p.getName());
                    out.format(" <li>%s</li>%n", attachLink);
                    continue;
                }
                out.format(" <li>%s = \"%s\"</li>%n", StringUtil2.quoteHtmlContent(p.getName()), StringUtil2.quoteHtmlContent(p.getValue()));
            }
            out.format("</ul>%n", new Object[0]);
        }
        if (complete) {
            out.format("</body></html>", new Object[0]);
        }
    }

    private String rangeString(ThreddsMetadata.GeospatialRange r) {
        if (r == null) {
            return "";
        }
        String units = r.getUnits() == null ? "" : " " + r.getUnits();
        String resolution = r.hasResolution() ? " Resolution=" + r.getResolution() : "";
        return StringUtil2.quoteHtmlContent(r.getStart() + " to " + (r.getStart() + r.getSize()) + resolution + units);
    }

    public String resolve(Dataset ds, String href) {
        Catalog cat = ds.getParentCatalog();
        if (cat != null) {
            try {
                URI uri = cat.resolveUri(href);
                href = uri.toString();
            }
            catch (URISyntaxException e) {
                return "DatasetHtmlWriter: error parsing URL= " + href;
            }
        }
        return href;
    }

    private String makeHref(String href, String title) {
        if (title == null) {
            title = href;
        }
        return "<a href='" + StringUtil2.quoteHtmlContent(href) + "'>" + StringUtil2.quoteHtmlContent(title) + "</a>";
    }

    private String makeHrefResolve(Dataset ds, String href, String title) {
        if (title == null) {
            title = href;
        }
        href = this.resolve(ds, href);
        return this.makeHref(href, title);
    }
}

