/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.writer2;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataComposite;
import ucar.ma2.StructureDataFromMember;
import ucar.ma2.StructureMembers;
import ucar.nc2.Attribute;
import ucar.nc2.AttributeContainer;
import ucar.nc2.Dimension;
import ucar.nc2.Structure;
import ucar.nc2.VariableSimpleBuilder;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.CF;
import ucar.nc2.ft.DsgFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.writer.CFPointWriterUtils;
import ucar.nc2.ft.point.writer2.CFPointWriterConfig;
import ucar.nc2.ft.point.writer2.WriterCFPointAbstract;
import ucar.nc2.time.CalendarDateUnit;

class WriterCFStationCollection
extends WriterCFPointAbstract {
    private List<StationFeature> stnList;
    private Structure stationStruct;
    private HashMap<String, Integer> stationIndexMap;
    private boolean useDesc;
    private boolean useWmoId;
    private int desc_strlen = 1;
    private int wmo_strlen = 1;
    private HashSet<String> featureVarMap = new HashSet();
    private int stnRecno;
    private int obsRecno;

    WriterCFStationCollection(String fileOut, AttributeContainer atts, List<VariableSimpleIF> dataVars, CalendarDateUnit timeUnit, String altUnits, CFPointWriterConfig config) throws IOException {
        super(fileOut, atts, dataVars, timeUnit, altUnits, config);
        this.writerb.addAttribute(new Attribute("featureType", CF.FeatureType.timeSeries.name()));
        this.writerb.addAttribute(new Attribute("DSG_representation", "Timeseries of station data in the indexed ragged array representation, H.2.5"));
    }

    @Override
    void finishBuilding() throws IOException {
        super.finishBuilding();
        this.stationStruct = this.findStructure("station");
    }

    protected void writeHeader(List<StationFeature> stations) throws IOException {
        this.stnList = stations.stream().distinct().collect(Collectors.toList());
        ArrayList<VariableSimpleIF> coords = new ArrayList<VariableSimpleIF>();
        ArrayList<PointFeatureCollection> flattenStations = new ArrayList<PointFeatureCollection>();
        ArrayList<StructureData> stationData = new ArrayList<StructureData>();
        for (StationFeature stn : stations) {
            stationData.add(stn.getFeatureData());
            boolean bl = this.useAlt = this.altUnits != null;
            if (stn.getWmoId() != null && !stn.getWmoId().trim().isEmpty()) {
                this.useWmoId = true;
            }
            if (stn.getDescription() != null && !stn.getDescription().trim().isEmpty()) {
                this.useDesc = true;
            }
            this.id_strlen = Math.max(this.id_strlen, stn.getName().length());
            if (stn.getDescription() != null) {
                this.desc_strlen = Math.max(this.desc_strlen, stn.getDescription().length());
            }
            if (stn.getWmoId() != null) {
                this.wmo_strlen = Math.max(this.wmo_strlen, stn.getWmoId().length());
            }
            if (stn instanceof DsgFeatureCollection) {
                DsgFeatureCollection dsgStation = (DsgFeatureCollection)((Object)stn);
                flattenStations.add((PointFeatureCollection)dsgStation);
                if (!coords.stream().noneMatch(x -> x.getShortName().equals(dsgStation.getTimeName()))) continue;
                coords.add(VariableSimpleBuilder.makeScalar(dsgStation.getTimeName(), "time of measurement", dsgStation.getTimeUnit().getUdUnit(), DataType.DOUBLE).addAttribute("calendar", dsgStation.getTimeUnit().getCalendar().toString()).build());
                continue;
            }
            coords.add(VariableSimpleBuilder.makeScalar("time", "time of measurement", this.timeUnit.getUdUnit(), DataType.DOUBLE).addAttribute("calendar", this.timeUnit.getCalendar().toString()).build());
        }
        this.altitudeCoordinateName = "stationAltitude";
        this.llbb = CFPointWriterUtils.getBoundingBox(this.stnList);
        coords.add(VariableSimpleBuilder.makeScalar("stationIndex", "station index for this observation record", null, DataType.INT).addAttribute("instance_dimension", "station").build());
        super.writeHeader(coords, flattenStations, stationData, null);
        int count = 0;
        this.stationIndexMap = new HashMap(this.stnList.size(), 1.0f);
        for (StationFeature stn : this.stnList) {
            this.writeStationData(stn);
            this.stationIndexMap.put(stn.getName(), count);
            ++count;
        }
    }

    @Override
    void makeFeatureVariables(List<StructureData> featureDataStructs, boolean isExtended) {
        Dimension stationDim = this.writerb.addDimension("station", this.stnList.size());
        ArrayList<VariableSimpleIF> stnVars = new ArrayList<VariableSimpleIF>();
        stnVars.add(VariableSimpleBuilder.makeScalar("latitude", "station latitude", "degrees_north", DataType.DOUBLE).build());
        stnVars.add(VariableSimpleBuilder.makeScalar("longitude", "station longitude", "degrees_east", DataType.DOUBLE).build());
        if (this.useAlt) {
            stnVars.add(VariableSimpleBuilder.makeScalar("stationAltitude", "station altitude", this.altUnits, DataType.DOUBLE).addAttribute("standard_name", "station_altitude").build());
        }
        stnVars.add(VariableSimpleBuilder.makeString("station_id", "station identifier", null, this.id_strlen).addAttribute("cf_role", "timeseries_id").build());
        if (this.useDesc) {
            stnVars.add(VariableSimpleBuilder.makeString("station_description", "station description", null, this.desc_strlen).addAttribute("standard_name", "platform_name").build());
        }
        if (this.useWmoId) {
            stnVars.add(VariableSimpleBuilder.makeString("wmo_id", "station WMO id", null, this.wmo_strlen).addAttribute("standard_name", "platform_id").build());
        }
        for (StructureData featureData : featureDataStructs) {
            for (StructureMembers.Member m : featureData.getMembers()) {
                if (this.findDataVar(m.getName()) == null) continue;
                stnVars.add(VariableSimpleBuilder.fromMember(m).build());
            }
        }
        if (isExtended) {
            Structure.Builder structb = this.writerb.addStructure("station", "station");
            this.addCoordinatesExtended(structb, stnVars);
        } else {
            this.addCoordinatesClassic(stationDim, stnVars, this.featureVarMap);
        }
    }

    private void writeStationData(StationFeature stn) throws IOException {
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar("latitude", null, null, DataType.DOUBLE, stn.getLatLon().getLatitude());
        smb.addMemberScalar("longitude", null, null, DataType.DOUBLE, stn.getLatLon().getLongitude());
        if (this.useAlt) {
            smb.addMemberScalar("stationAltitude", null, null, DataType.DOUBLE, stn.getAltitude());
        }
        smb.addMemberString("station_id", null, null, stn.getName().trim(), this.id_strlen);
        if (this.useDesc) {
            smb.addMemberString("station_description", null, null, stn.getDescription().trim(), this.desc_strlen);
        }
        if (this.useWmoId) {
            smb.addMemberString("wmo_id", null, null, stn.getWmoId().trim(), this.wmo_strlen);
        }
        StructureDataFromMember stnCoords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create((Iterable<StructureData>)ImmutableList.of((Object)stnCoords, (Object)stn.getFeatureData()));
        this.stnRecno = super.writeStructureData(this.stnRecno, this.stationStruct, sdall, this.featureVarMap);
    }

    protected void writeObsData(PointFeature pf) throws IOException {
        this.trackBB(null, pf.getObservationTimeAsCalendarDate());
        String stationName = pf.getFeatureCollection().getName();
        Integer parentIndex = this.stationIndexMap.get(stationName);
        if (parentIndex == null) {
            throw new RuntimeException("Cant find station " + stationName);
        }
        StructureMembers.Builder smb = StructureMembers.builder().setName("Coords");
        smb.addMemberScalar(pf.getFeatureCollection().getTimeName(), null, null, DataType.DOUBLE, pf.getObservationTime());
        if (this.altUnits != null) {
            smb.addMemberScalar(pf.getFeatureCollection().getAltName(), null, null, DataType.DOUBLE, pf.getLocation().getAltitude());
        }
        smb.addMemberScalar("stationIndex", null, null, DataType.INT, parentIndex);
        StructureDataFromMember coords = new StructureDataFromMember(smb.build());
        StructureDataComposite sdall = StructureDataComposite.create((Iterable<StructureData>)ImmutableList.of((Object)coords, (Object)pf.getFeatureData()));
        this.obsRecno = super.writeStructureData(this.obsRecno, this.record, sdall, this.dataMap);
    }

    protected void resetObsIndex() {
        this.obsRecno = 0;
    }
}

