/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.Misc;
import ucar.nc2.util.NamedAnything;
import ucar.nc2.util.NamedObject;
import ucar.unidata.util.Format;

public class CoordinateAxis1D
extends CoordinateAxis {
    private static Logger log = LoggerFactory.getLogger(CoordinateAxis1D.class);
    private boolean wasRead;
    private boolean wasBoundsDone;
    private boolean isInterval;
    private boolean isAscending;
    private double[] coords;
    private String[] names;
    private double[] edge;
    private double[] bound1;
    private double[] bound2;
    private boolean wasCalcRegular;
    private boolean isRegular;
    private double start;
    private double increment;

    public CoordinateAxis1D(NetcdfDataset ncd, VariableDS vds) {
        super(ncd, vds);
        vds.setCaching(true);
    }

    CoordinateAxis1D(NetcdfDataset ncd, CoordinateAxis1D org) {
        super(ncd, org);
        this.orgName = org.orgName;
        this.cache = new Variable.Cache();
        org.setCaching(true);
        this.increment = org.getIncrement();
        this.isAscending = org.isAscending;
        this.isInterval = org.isInterval();
        this.isRegular = org.isRegular();
        if (this.isNumeric()) {
            this.coords = org.getCoordValues();
            this.edge = org.getCoordEdges();
        }
        this.names = org.names;
        if (this.isInterval) {
            this.bound1 = org.getBound1();
            this.bound2 = org.getBound2();
        }
        this.wasBoundsDone = org.wasBoundsDone;
        this.wasCalcRegular = org.wasCalcRegular;
        this.wasRead = org.wasRead;
    }

    public CoordinateAxis1D(NetcdfDataset ds, Group group, String shortName, DataType dataType, String dims, String units, String desc) {
        super(ds, group, shortName, dataType, dims, units, desc);
    }

    public CoordinateAxis1D section(Range r) throws InvalidRangeException {
        Section section = new Section().appendRange(r);
        CoordinateAxis1D result = (CoordinateAxis1D)this.section(section);
        int len = r.length();
        if (this.isNumeric()) {
            double[] new_mids = new double[len];
            for (int idx = 0; idx < len; ++idx) {
                int old_idx = r.element(idx);
                new_mids[idx] = this.coords[old_idx];
            }
            result.coords = new_mids;
            if (this.isInterval) {
                double[] new_bound1 = new double[len];
                double[] new_bound2 = new double[len];
                double[] new_edge = new double[len + 1];
                for (int idx = 0; idx < len; ++idx) {
                    int old_idx = r.element(idx);
                    new_bound1[idx] = this.bound1[old_idx];
                    new_bound2[idx] = this.bound2[old_idx];
                    new_edge[idx] = this.bound1[old_idx];
                    new_edge[idx + 1] = this.bound2[old_idx];
                }
                result.bound1 = new_bound1;
                result.bound2 = new_bound2;
                result.edge = new_edge;
            } else {
                double[] new_edge = new double[len + 1];
                for (int idx = 0; idx < len; ++idx) {
                    int old_idx = r.element(idx);
                    new_edge[idx] = this.edge[old_idx];
                    new_edge[idx + 1] = this.edge[old_idx + 1];
                }
                result.edge = new_edge;
            }
        }
        if (this.names != null) {
            String[] new_names = new String[len];
            for (int idx = 0; idx < len; ++idx) {
                int old_idx = r.element(idx);
                new_names[idx] = this.names[old_idx];
            }
            result.names = new_names;
        }
        result.wasCalcRegular = false;
        result.calcIsRegular();
        return result;
    }

    @Override
    protected Variable copy() {
        return new CoordinateAxis1D(this.ncd, this);
    }

    @Override
    public CoordinateAxis copyNoCache() {
        CoordinateAxis1D axis = new CoordinateAxis1D(this.ncd, this.getParentGroup(), this.getShortName(), this.getDataType(), this.getDimensionsString(), this.getUnitsString(), this.getDescription());
        axis.axisType = this.axisType;
        axis.boundaryRef = this.boundaryRef;
        axis.isContiguous = this.isContiguous;
        axis.positive = this.positive;
        axis.cache = new Variable.Cache();
        return axis;
    }

    public List<NamedObject> getNames() {
        int n = this.getDimension(0).getLength();
        ArrayList<NamedObject> names = new ArrayList<NamedObject>(n);
        for (int i = 0; i < n; ++i) {
            names.add(new NamedAnything(this.getCoordName(i), this.getShortName() + " " + this.getUnitsString()));
        }
        return names;
    }

    public String getCoordName(int index) {
        if (!this.wasRead) {
            this.doRead();
        }
        if (this.isNumeric()) {
            return Format.d(this.getCoordValue(index), 5, 8);
        }
        return this.names[index];
    }

    public double getCoordValue(int index) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return this.coords[index];
    }

    @Override
    public double getMinValue() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.min(this.coords[0], this.coords[this.coords.length - 1]);
    }

    @Override
    public double getMaxValue() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.max(this.coords[0], this.coords[this.coords.length - 1]);
    }

    public double getMinEdgeValue() {
        if (this.edge == null) {
            return this.getMinValue();
        }
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.min(this.edge[0], this.edge[this.edge.length - 1]);
    }

    public double getMaxEdgeValue() {
        if (this.edge == null) {
            return this.getMaxValue();
        }
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValue() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return Math.max(this.edge[0], this.edge[this.edge.length - 1]);
    }

    public double getCoordEdge(int index) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordEdge() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return this.edge[index];
    }

    public double[] getCoordValues() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordValues() on non-numeric");
        }
        if (!this.wasRead) {
            this.doRead();
        }
        return (double[])this.coords.clone();
    }

    public double[] getCoordEdges() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getCoordEdges() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return (double[])this.edge.clone();
    }

    @Override
    public boolean isContiguous() {
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return this.isContiguous;
    }

    @Override
    public boolean isInterval() {
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        return this.isInterval;
    }

    public double[] getBound1() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getBound1() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        if (this.bound1 == null) {
            this.makeBoundsFromEdges();
        }
        assert (this.bound1 != null);
        return (double[])this.bound1.clone();
    }

    public double[] getBound2() {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis1D.getBound2() on non-numeric");
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        if (this.bound2 == null) {
            this.makeBoundsFromEdges();
        }
        assert (this.bound2 != null);
        return (double[])this.bound2.clone();
    }

    public double[] getCoordBounds(int i) {
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        double[] e = new double[2];
        if (this.isContiguous()) {
            e[0] = this.getCoordEdge(i);
            e[1] = this.getCoordEdge(i + 1);
        } else {
            e[0] = this.bound1[i];
            e[1] = this.bound2[i];
        }
        return e;
    }

    public double getCoordBoundsMidpoint(int i) {
        double[] bounds = this.getCoordBounds(i);
        return (bounds[0] + bounds[1]) / 2.0;
    }

    public int findCoordElement(double coordVal) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElement() on non-numeric");
        }
        if (this.isRegular()) {
            return this.findCoordElementRegular(coordVal, false);
        }
        if (this.isContiguous()) {
            return this.findCoordElementIrregular(coordVal, false);
        }
        return this.findCoordElementNonContiguous(coordVal, false);
    }

    public int findCoordElementBounded(double coordVal) {
        if (!this.isNumeric()) {
            throw new UnsupportedOperationException("CoordinateAxis.findCoordElementBounded() on non-numeric");
        }
        if (this.getSize() == 1L) {
            return 0;
        }
        if (this.isRegular()) {
            return this.findCoordElementRegular(coordVal, true);
        }
        if (this.isContiguous()) {
            return this.findCoordElementIrregular(coordVal, true);
        }
        return this.findCoordElementNonContiguous(coordVal, true);
    }

    public int findCoordElement(double coordVal, int lastIndex) {
        return this.findCoordElement(coordVal);
    }

    private int findCoordElementRegular(double coordValue, boolean bounded) {
        int n = (int)this.getSize();
        if (this.getSize() == 1L) {
            return 0;
        }
        double distance = coordValue - this.start;
        double exactNumSteps = distance / this.increment;
        int index = (int)Math.round(exactNumSteps);
        if (index < 0) {
            return bounded ? 0 : -1;
        }
        if (index >= n) {
            return bounded ? n - 1 : -1;
        }
        return index;
    }

    private boolean betweenLon(double lon, double lonBeg, double lonEnd) {
        while (lon < lonBeg) {
            lon += 360.0;
        }
        return lon >= lonBeg && lon <= lonEnd;
    }

    private int findCoordElementIrregular(double target, boolean bounded) {
        int n = (int)this.getSize();
        int low = 0;
        int high = n;
        if (this.isAscending) {
            if (target < this.edge[low]) {
                return bounded ? 0 : -1;
            }
            if (target > this.edge[high]) {
                return bounded ? n - 1 : -1;
            }
            while (high > low + 1) {
                int mid = (low + high) / 2;
                double midVal = this.edge[mid];
                if (midVal == target) {
                    return mid;
                }
                if (midVal < target) {
                    low = mid;
                    continue;
                }
                high = mid;
            }
            return low;
        }
        if (target > this.edge[low]) {
            return bounded ? 0 : -1;
        }
        if (target < this.edge[high]) {
            return bounded ? n - 1 : -1;
        }
        while (high > low + 1) {
            int mid = (low + high) / 2;
            double midVal = this.edge[mid];
            if (midVal == target) {
                return mid;
            }
            if (midVal < target) {
                high = mid;
                continue;
            }
            low = mid;
        }
        return high - 1;
    }

    private int findCoordElementNonContiguous(double target, boolean bounded) {
        double[] bounds1 = this.getBound1();
        double[] bounds2 = this.getBound2();
        int n = bounds1.length;
        if (this.isAscending) {
            if (target < bounds1[0]) {
                return bounded ? 0 : -1;
            }
            if (target > bounds2[n - 1]) {
                return bounded ? n - 1 : -1;
            }
            int[] idx = this.findSingleHit(bounds1, bounds2, target);
            if (idx[0] == 0 && !bounded) {
                return -1;
            }
            if (idx[0] == 1) {
                return idx[1];
            }
            return this.findClosest(this.coords, target);
        }
        if (target > bounds1[0]) {
            return bounded ? 0 : -1;
        }
        if (target < bounds2[n - 1]) {
            return bounded ? n - 1 : -1;
        }
        int[] idx = this.findSingleHit(bounds2, bounds1, target);
        if (idx[0] == 0 && !bounded) {
            return -1;
        }
        if (idx[0] == 1) {
            return idx[1];
        }
        return this.findClosest(this.getCoordValues(), target);
    }

    private int[] findSingleHit(double[] low, double[] high, double target) {
        int hits = 0;
        int idxFound = -1;
        int n = low.length;
        for (int i = 0; i < n; ++i) {
            if (!(low[i] <= target) || !(target <= high[i])) continue;
            ++hits;
            idxFound = i;
        }
        return new int[]{hits, idxFound};
    }

    private int findClosest(double[] values, double target) {
        double minDiff = Double.MAX_VALUE;
        int idxFound = -1;
        int n = values.length;
        for (int i = 0; i < n; ++i) {
            double diff = Math.abs(values[i] - target);
            if (!(diff < minDiff)) continue;
            minDiff = diff;
            idxFound = i;
        }
        return idxFound;
    }

    public double getStart() {
        this.calcIsRegular();
        return this.start;
    }

    public double getIncrement() {
        this.calcIsRegular();
        return this.increment;
    }

    public boolean isRegular() {
        this.calcIsRegular();
        return this.isRegular;
    }

    private void calcIsRegular() {
        if (this.wasCalcRegular) {
            return;
        }
        if (!this.wasRead) {
            this.doRead();
        }
        if (!this.isNumeric()) {
            this.isRegular = false;
        } else if (this.getSize() < 2L) {
            this.isRegular = true;
        } else {
            this.start = this.getCoordValue(0);
            int n = (int)this.getSize();
            this.increment = (this.getCoordValue(n - 1) - this.getCoordValue(0)) / (double)(n - 1);
            this.isRegular = true;
            int i = 1;
            while ((long)i < this.getSize()) {
                if (!Misc.nearlyEquals(this.getCoordValue(i) - this.getCoordValue(i - 1), this.increment, 0.005)) {
                    this.isRegular = false;
                    break;
                }
                ++i;
            }
        }
        this.wasCalcRegular = true;
    }

    private void doRead() {
        if (this.isNumeric()) {
            this.readValues();
            this.wasRead = true;
            this.isAscending = this.getSize() < 2L ? true : this.getCoordValue(0) < this.getCoordValue(1);
        } else if (this.getDataType() == DataType.STRING) {
            this.readStringValues();
            this.wasRead = true;
        } else {
            this.readCharValues();
            this.wasRead = true;
        }
    }

    public void correctLongitudeWrap() {
        if (this.axisType != AxisType.Lon) {
            return;
        }
        if (!this.wasRead) {
            this.doRead();
        }
        if (!this.wasBoundsDone) {
            this.makeBounds();
        }
        boolean monotonic = true;
        for (int i = 0; i < this.coords.length - 1; ++i) {
            monotonic &= this.isAscending ? this.coords[i] < this.coords[i + 1] : this.coords[i] > this.coords[i + 1];
        }
        if (!monotonic) {
            int i;
            boolean cross = false;
            if (this.isAscending) {
                for (i = 0; i < this.coords.length; ++i) {
                    if (cross) {
                        int n = i;
                        this.coords[n] = this.coords[n] + 360.0;
                    }
                    if (cross || i >= this.coords.length - 1 || !(this.coords[i] > this.coords[i + 1])) continue;
                    cross = true;
                }
            } else {
                for (i = 0; i < this.coords.length; ++i) {
                    if (cross) {
                        int n = i;
                        this.coords[n] = this.coords[n] - 360.0;
                    }
                    if (cross || i >= this.coords.length - 1 || !(this.coords[i] < this.coords[i + 1])) continue;
                    cross = true;
                }
            }
            Array cachedData = Array.factory(DataType.DOUBLE, this.getShape(), (Object)this.coords);
            if (this.getDataType() != DataType.DOUBLE) {
                cachedData = MAMath.convert(cachedData, this.getDataType());
            }
            this.setCachedData(cachedData);
            if (!this.isInterval) {
                this.makeEdges();
            }
        }
    }

    private void readStringValues() {
        Array data;
        int count = 0;
        try {
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading string coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        this.names = new String[(int)data.getSize()];
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            this.names[count++] = (String)ii.getObjectNext();
        }
    }

    private void readCharValues() {
        ArrayChar data;
        int count = 0;
        try {
            data = (ArrayChar)this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading char coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        ArrayChar.StringIterator iter = data.getStringIterator();
        this.names = new String[iter.getNumElems()];
        while (iter.hasNext()) {
            this.names[count++] = iter.next();
        }
    }

    private void readValues() {
        Array data;
        try {
            data = this.read();
        }
        catch (IOException ioe) {
            log.error("Error reading coordinate values ", (Throwable)ioe);
            throw new IllegalStateException(ioe);
        }
        this.coords = (double[])data.get1DJavaArray(DataType.DOUBLE);
    }

    private void makeBounds() {
        if (!this.wasRead) {
            this.doRead();
        }
        if (this.isNumeric() && !this.makeBoundsFromAux()) {
            this.makeEdges();
        }
        this.wasBoundsDone = true;
    }

    private boolean makeBoundsFromAux() {
        int i;
        Array data;
        Attribute boundsAtt = this.findAttributeIgnoreCase("bounds");
        if (null == boundsAtt || !boundsAtt.isString()) {
            return false;
        }
        String boundsVarName = boundsAtt.getStringValue();
        VariableDS boundsVar = (VariableDS)this.ncd.findVariable(this.getParentGroup(), boundsVarName);
        if (null == boundsVar) {
            return false;
        }
        if (2 != boundsVar.getRank()) {
            return false;
        }
        if (this.getDimension(0) != boundsVar.getDimension(0)) {
            return false;
        }
        if (2 != boundsVar.getDimension(1).getLength()) {
            return false;
        }
        try {
            boundsVar.removeEnhancement(NetcdfDataset.Enhance.ConvertMissing);
            data = boundsVar.read();
        }
        catch (IOException e) {
            log.warn("CoordinateAxis1D.hasBounds read failed ", (Throwable)e);
            return false;
        }
        assert (data.getRank() == 2 && data.getShape()[1] == 2) : "incorrect shape data for variable " + boundsVar;
        int n = this.shape[0];
        double[] value1 = new double[n];
        double[] value2 = new double[n];
        Index ima = data.getIndex();
        for (int i2 = 0; i2 < n; ++i2) {
            ima.set0(i2);
            value1[i2] = data.getDouble(ima.set1(0));
            value2[i2] = data.getDouble(ima.set1(1));
        }
        boolean contig = true;
        for (i = 0; i < n - 1; ++i) {
            if (Misc.nearlyEquals(value1[i + 1], value2[i])) continue;
            contig = false;
        }
        if (contig) {
            this.edge = new double[n + 1];
            this.edge[0] = value1[0];
            for (i = 1; i < n + 1; ++i) {
                this.edge[i] = value2[i - 1];
            }
        } else {
            this.edge = new double[n + 1];
            this.edge[0] = value1[0];
            for (i = 1; i < n; ++i) {
                this.edge[i] = (value1[i] + value2[i - 1]) / 2.0;
            }
            this.edge[n] = value2[n - 1];
            this.isContiguous = false;
        }
        this.bound1 = value1;
        this.bound2 = value2;
        this.isInterval = true;
        return true;
    }

    private void makeEdges() {
        int size = (int)this.getSize();
        this.edge = new double[size + 1];
        if (size < 1) {
            return;
        }
        for (int i = 1; i < size; ++i) {
            this.edge[i] = (this.coords[i - 1] + this.coords[i]) / 2.0;
        }
        this.edge[0] = this.coords[0] - (this.edge[1] - this.coords[0]);
        this.edge[size] = this.coords[size - 1] + (this.coords[size - 1] - this.edge[size - 1]);
        this.isContiguous = true;
    }

    private void makeBoundsFromEdges() {
        int size = (int)this.getSize();
        if (size == 0) {
            return;
        }
        this.bound1 = new double[size];
        this.bound2 = new double[size];
        for (int i = 0; i < size; ++i) {
            this.bound1[i] = this.edge[i];
            this.bound2[i] = this.edge[i + 1];
        }
        if (this.bound1[0] > this.bound2[0]) {
            double[] temp = this.bound1;
            this.bound1 = this.bound2;
            this.bound2 = temp;
        }
    }
}

