/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.treebank;

import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConfigParser
implements Iterable<Properties> {
    private static Redwood.RedwoodChannels log = Redwood.channels(ConfigParser.class);
    private static final String DELIM = "=";
    public static final String paramName = "NAME";
    public static final String paramPath = "PATH";
    public static final String paramOutputPath = "OUTPUT_PATH";
    public static final String paramSplit = "SPLIT";
    public static final String paramEncode = "OUTPUT_ENCODING";
    public static final String paramMapping = "MAPPING";
    public static final String paramDistrib = "DISTRIB";
    public static final String paramType = "TYPE";
    public static final String paramFlat = "FLAT";
    public static final String paramDT = "USEDET";
    public static final String paramTagDelim = "TAGDELIM";
    public static final String paramFileExt = "FILEEXT";
    public static final String paramLexMapper = "LEXMAPPER";
    public static final String paramLexMapOptions = "LEXOPTS";
    public static final String paramNoDashTags = "NODASHTAGS";
    public static final String paramAddRoot = "ADDROOT";
    public static final String paramUnEscape = "UNESCAPE";
    public static final String paramPosMapper = "POSMAPPER";
    public static final String paramPosMapOptions = "POSOPTS";
    public static final String paramMaxLen = "MAXLEN";
    public static final String paramMorph = "MORPH";
    public static final String paramTransform = "TVISITOR";
    public static final String paramCCTagset = "CC_TAGSET";
    private static final Pattern matchName = Pattern.compile("NAME=");
    private static final Pattern matchSplit = Pattern.compile("SPLIT=");
    private static final Pattern matchDistrib = Pattern.compile("DISTRIB=");
    private static final Pattern matchType = Pattern.compile("TYPE=");
    private static final Pattern matchFlat = Pattern.compile("FLAT=");
    private static final Pattern matchDT = Pattern.compile("USEDET=");
    private static final Pattern matchTagDelim = Pattern.compile("TAGDELIM=");
    private static final Pattern matchFileExt = Pattern.compile("FILEEXT=");
    private static final Pattern matchLexMapper = Pattern.compile("LEXMAPPER=");
    private static final Pattern matchNoDashTags = Pattern.compile("NODASHTAGS=");
    private static final Pattern matchAddRoot = Pattern.compile("ADDROOT=");
    private static final Pattern matchUnEscape = Pattern.compile("UNESCAPE=");
    private static final Pattern matchLexMapOptions = Pattern.compile("LEXOPTS=");
    private static final Pattern matchPosMapper = Pattern.compile("POSMAPPER=");
    private static final Pattern matchPosMapOptions = Pattern.compile("POSOPTS=");
    private static final Pattern matchMaxLen = Pattern.compile("MAXLEN=");
    private static final Pattern matchMorph = Pattern.compile("MORPH=");
    private static final Pattern matchTransform = Pattern.compile("TVISITOR=");
    private static final Pattern matchEncode = Pattern.compile("OUTPUT_ENCODING=");
    private static final Pattern matchEncodeArgs = Pattern.compile("Buckwalter|UTF8");
    private static final Pattern matchCCTagset = Pattern.compile("CC_TAGSET=");
    private static final Pattern booleanArgs = Pattern.compile("true|false");
    public static final Pattern matchPath = Pattern.compile("PATH");
    public static final Pattern matchOutputPath = Pattern.compile("OUTPUT_PATH");
    public static final Pattern matchMapping = Pattern.compile("MAPPING");
    private static final Pattern setDelim = Pattern.compile(";;");
    private static final Pattern skipLine = Pattern.compile("^#|^\\s*$");
    private final List<Properties> datasetList;
    private final Map<String, Pair<Pattern, Pattern>> patternsMap;
    private final String configFile;

    public ConfigParser(String filename) {
        this.configFile = filename;
        this.datasetList = new ArrayList<Properties>();
        this.patternsMap = Generics.newHashMap();
        this.patternsMap.put(paramName, new Pair<Pattern, Object>(matchName, null));
        this.patternsMap.put(paramType, new Pair<Pattern, Object>(matchType, null));
        this.patternsMap.put(paramPath, new Pair<Pattern, Object>(matchPath, null));
        this.patternsMap.put(paramOutputPath, new Pair<Pattern, Object>(matchOutputPath, null));
        this.patternsMap.put(paramSplit, new Pair<Pattern, Object>(matchSplit, null));
        this.patternsMap.put(paramTagDelim, new Pair<Pattern, Object>(matchTagDelim, null));
        this.patternsMap.put(paramFileExt, new Pair<Pattern, Object>(matchFileExt, null));
        this.patternsMap.put(paramEncode, new Pair<Pattern, Pattern>(matchEncode, matchEncodeArgs));
        this.patternsMap.put(paramMapping, new Pair<Pattern, Object>(matchMapping, null));
        this.patternsMap.put(paramDistrib, new Pair<Pattern, Pattern>(matchDistrib, booleanArgs));
        this.patternsMap.put(paramFlat, new Pair<Pattern, Pattern>(matchFlat, booleanArgs));
        this.patternsMap.put(paramDT, new Pair<Pattern, Pattern>(matchDT, booleanArgs));
        this.patternsMap.put(paramLexMapper, new Pair<Pattern, Object>(matchLexMapper, null));
        this.patternsMap.put(paramNoDashTags, new Pair<Pattern, Pattern>(matchNoDashTags, booleanArgs));
        this.patternsMap.put(paramAddRoot, new Pair<Pattern, Pattern>(matchAddRoot, booleanArgs));
        this.patternsMap.put(paramUnEscape, new Pair<Pattern, Pattern>(matchUnEscape, booleanArgs));
        this.patternsMap.put(paramLexMapOptions, new Pair<Pattern, Object>(matchLexMapOptions, null));
        this.patternsMap.put(paramPosMapper, new Pair<Pattern, Object>(matchPosMapper, null));
        this.patternsMap.put(paramPosMapOptions, new Pair<Pattern, Object>(matchPosMapOptions, null));
        this.patternsMap.put(paramMaxLen, new Pair<Pattern, Object>(matchMaxLen, null));
        this.patternsMap.put(paramMorph, new Pair<Pattern, Object>(matchMorph, null));
        this.patternsMap.put(paramTransform, new Pair<Pattern, Object>(matchTransform, null));
        this.patternsMap.put(paramCCTagset, new Pair<Pattern, Object>(matchCCTagset, null));
    }

    @Override
    public Iterator<Properties> iterator() {
        Iterator<Properties> itr = Collections.unmodifiableList(this.datasetList).iterator();
        return itr;
    }

    public void parse() {
        int lineNum = 0;
        try {
            LineNumberReader reader = new LineNumberReader(new FileReader(this.configFile));
            Properties paramsForDataset = null;
            while (reader.ready()) {
                String line = reader.readLine();
                lineNum = reader.getLineNumber();
                Matcher m = skipLine.matcher(line);
                if (m.lookingAt()) continue;
                m = setDelim.matcher(line);
                if (m.matches() && paramsForDataset != null) {
                    this.datasetList.add(paramsForDataset);
                    paramsForDataset = null;
                    continue;
                }
                if (paramsForDataset == null) {
                    paramsForDataset = new Properties();
                }
                boolean matched = false;
                for (String param : this.patternsMap.keySet()) {
                    Pair<Pattern, Pattern> paramTemplate = this.patternsMap.get(param);
                    Matcher paramToken = ((Pattern)paramTemplate.first).matcher(line);
                    if (!paramToken.lookingAt()) continue;
                    matched = true;
                    String[] tokens = line.split(DELIM);
                    if (tokens.length != 2) {
                        System.err.printf("%s: Skipping malformed parameter in %s (line %d)%n", this.getClass().getName(), this.configFile, reader.getLineNumber());
                        break;
                    }
                    String actualParam = tokens[0].trim();
                    String paramValue = tokens[1].trim();
                    if (paramTemplate.second != null) {
                        paramToken = ((Pattern)paramTemplate.second).matcher(paramValue);
                        if (paramToken.matches()) {
                            paramsForDataset.setProperty(actualParam, paramValue);
                            continue;
                        }
                        System.err.printf("%s: Skipping illegal parameter value in %s (line %d)%n", this.getClass().getName(), this.configFile, reader.getLineNumber());
                        break;
                    }
                    paramsForDataset.setProperty(actualParam, paramValue);
                }
                if (matched) continue;
                String error = this.getClass().getName() + ": Unknown token in " + this.configFile + " (line " + reader.getLineNumber() + ")%n";
                System.err.printf(error, new Object[0]);
                throw new IllegalArgumentException(error);
            }
            if (paramsForDataset != null) {
                this.datasetList.add(paramsForDataset);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.printf("%s: Cannot open file %s%n", this.getClass().getName(), this.configFile);
        }
        catch (IOException e) {
            System.err.printf("%s: Error reading %s (line %d)%n", this.getClass().getName(), this.configFile, lineNum);
        }
    }

    public String toString() {
        int numDatasets = this.datasetList.size();
        StringBuilder sb = new StringBuilder(String.format("Loaded %d datasets: %n", numDatasets));
        int dataSetNum = 1;
        for (Properties sm : this.datasetList) {
            if (sm.containsKey(paramName)) {
                sb.append(String.format(" %d: %s%n", dataSetNum++, sm.getProperty(paramName)));
                continue;
            }
            sb.append(String.format(" %d: %s%n", dataSetNum++, "UNKNOWN NAME"));
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ConfigParser cp = new ConfigParser("configurations/sample.conf");
        cp.parse();
        System.out.println(cp.toString());
        for (Properties sm : cp) {
            System.out.println("--------------------");
            for (String key : sm.stringPropertyNames()) {
                System.out.printf(" %s: %s%n", key, sm.get(key));
            }
        }
    }
}

