/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.lexparser.EvaluateTreebank;
import edu.stanford.nlp.parser.shiftreduce.BaseModel;
import edu.stanford.nlp.parser.shiftreduce.CombinationFeatureFactory;
import edu.stanford.nlp.parser.shiftreduce.FeatureFactory;
import edu.stanford.nlp.parser.shiftreduce.Oracle;
import edu.stanford.nlp.parser.shiftreduce.OracleTransition;
import edu.stanford.nlp.parser.shiftreduce.ReorderingOracle;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceOptions;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceParser;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceTrainOptions;
import edu.stanford.nlp.parser.shiftreduce.ShiftReduceUtils;
import edu.stanford.nlp.parser.shiftreduce.State;
import edu.stanford.nlp.parser.shiftreduce.Transition;
import edu.stanford.nlp.parser.shiftreduce.Weight;
import edu.stanford.nlp.stats.IntCounter;
import edu.stanford.nlp.tagger.common.Tagger;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.ReflectionLoading;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.ScoredComparator;
import edu.stanford.nlp.util.ScoredObject;
import edu.stanford.nlp.util.Timing;
import edu.stanford.nlp.util.Triple;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import edu.stanford.nlp.util.logging.Redwood;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Random;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PerceptronModel
extends BaseModel {
    private static final Redwood.RedwoodChannels log = Redwood.channels(PerceptronModel.class);
    private float learningRate = 1.0f;
    Map<String, Weight> featureWeights;
    final FeatureFactory featureFactory;
    private static final NumberFormat NF = new DecimalFormat("0.00");
    private static final NumberFormat FILENAME = new DecimalFormat("0000");
    private static final long serialVersionUID = 1L;

    public PerceptronModel(ShiftReduceOptions op, Index<Transition> transitionIndex, Set<String> knownStates, Set<String> rootStates, Set<String> rootOnlyStates) {
        super(op, transitionIndex, knownStates, rootStates, rootOnlyStates);
        this.featureWeights = Generics.newHashMap();
        String[] classes = op.featureFactoryClass.split(";");
        if (classes.length == 1) {
            this.featureFactory = (FeatureFactory)ReflectionLoading.loadByReflection(classes[0], new Object[0]);
        } else {
            FeatureFactory[] factories = new FeatureFactory[classes.length];
            for (int i = 0; i < classes.length; ++i) {
                int paren = classes[i].indexOf(40);
                if (paren >= 0) {
                    String arg = classes[i].substring(paren + 1, classes[i].length() - 1);
                    factories[i] = (FeatureFactory)ReflectionLoading.loadByReflection(classes[i].substring(0, paren), arg);
                    continue;
                }
                factories[i] = (FeatureFactory)ReflectionLoading.loadByReflection(classes[i], new Object[0]);
            }
            this.featureFactory = new CombinationFeatureFactory(factories);
        }
    }

    public PerceptronModel(PerceptronModel other) {
        super(other);
        this.featureFactory = other.featureFactory;
        this.featureWeights = Generics.newHashMap();
        for (String feature : other.featureWeights.keySet()) {
            this.featureWeights.put(feature, new Weight(other.featureWeights.get(feature)));
        }
    }

    public void averageScoredModels(Collection<ScoredObject<PerceptronModel>> scoredModels) {
        if (scoredModels.isEmpty()) {
            throw new IllegalArgumentException("Cannot average empty models");
        }
        log.info("Averaging " + scoredModels.size() + " models with scores");
        for (ScoredObject<PerceptronModel> model : scoredModels) {
            log.info(" " + NF.format(model.score()));
        }
        log.info(new Object[0]);
        List<PerceptronModel> models = CollectionUtils.transformAsList(scoredModels, ScoredObject::object);
        this.averageModels(models);
    }

    public void averageModels(Collection<PerceptronModel> models) {
        if (models.isEmpty()) {
            throw new IllegalArgumentException("Cannot average empty models");
        }
        Set<String> features = Generics.newHashSet();
        for (PerceptronModel model : models) {
            for (String feature : model.featureWeights.keySet()) {
                features.add(feature);
            }
        }
        this.featureWeights = Generics.newHashMap();
        for (String feature : features) {
            this.featureWeights.put(feature, new Weight());
        }
        int numModels = models.size();
        for (String feature : features) {
            for (PerceptronModel model : models) {
                if (!model.featureWeights.containsKey(feature)) continue;
                this.featureWeights.get(feature).addScaled(model.featureWeights.get(feature), 1.0f / (float)numModels);
            }
        }
    }

    private void condenseFeatures() {
        Iterator<String> featureIt = this.featureWeights.keySet().iterator();
        while (featureIt.hasNext()) {
            String feature = featureIt.next();
            Weight weights = this.featureWeights.get(feature);
            weights.condense();
            if (weights.size() != 0) continue;
            featureIt.remove();
        }
    }

    private void filterFeatures(Set<String> keep) {
        Iterator<String> featureIt = this.featureWeights.keySet().iterator();
        while (featureIt.hasNext()) {
            if (keep.contains(featureIt.next())) continue;
            featureIt.remove();
        }
    }

    public void outputStats() {
        log.info("Number of known features: " + this.featureWeights.size());
        int numWeights = 0;
        for (Map.Entry<String, Weight> stringWeightEntry : this.featureWeights.entrySet()) {
            numWeights += stringWeightEntry.getValue().size();
        }
        log.info("Number of non-zero weights: " + numWeights);
        int wordLength = 0;
        for (String feature : this.featureWeights.keySet()) {
            wordLength += feature.length();
        }
        log.info("Total word length: " + wordLength);
        log.info("Number of transitions: " + this.transitionIndex.size());
    }

    @Override
    Set<String> tagSet() {
        Set<String> tags = Generics.newHashSet();
        Pattern p1 = Pattern.compile("Q0TQ1T-([^-]+)-.*");
        Pattern p2 = Pattern.compile("S0T-(.*)");
        for (String feat : this.featureWeights.keySet()) {
            Matcher m2;
            Matcher m1 = p1.matcher(feat);
            if (m1.matches()) {
                tags.add(m1.group(1));
            }
            if (!(m2 = p2.matcher(feat)).matches()) continue;
            tags.add(m2.group(1));
        }
        tags.add(".$$.");
        return tags;
    }

    private ScoredObject<Integer> findHighestScoringTransition(State state, List<String> features, boolean requireLegal) {
        Collection<ScoredObject<Integer>> transitions = this.findHighestScoringTransitions(state, features, requireLegal, 1, null);
        if (transitions.isEmpty()) {
            return null;
        }
        return transitions.iterator().next();
    }

    @Override
    public Collection<ScoredObject<Integer>> findHighestScoringTransitions(State state, boolean requireLegal, int numTransitions, List<ParserConstraint> constraints) {
        List<String> features = this.featureFactory.featurize(state);
        return this.findHighestScoringTransitions(state, features, requireLegal, numTransitions, constraints);
    }

    private Collection<ScoredObject<Integer>> findHighestScoringTransitions(State state, List<String> features, boolean requireLegal, int numTransitions, List<ParserConstraint> constraints) {
        float[] scores = new float[this.transitionIndex.size()];
        for (String feature : features) {
            Weight weight = this.featureWeights.get(feature);
            if (weight == null) continue;
            weight.score(scores);
        }
        PriorityQueue<Scored> queue = new PriorityQueue<Scored>(numTransitions + 1, ScoredComparator.ASCENDING_COMPARATOR);
        for (int i = 0; i < scores.length; ++i) {
            if (requireLegal && !((Transition)this.transitionIndex.get(i)).isLegal(state, constraints)) continue;
            queue.add(new ScoredObject<Integer>(i, scores[i]));
            if (queue.size() <= numTransitions) continue;
            queue.poll();
        }
        return queue;
    }

    private Pair<Integer, Integer> trainTree(int index, List<Tree> binarizedTrees, List<List<Transition>> transitionLists, List<Update> updates, Oracle oracle) {
        int numWrong;
        int numCorrect;
        block28: {
            ReorderingOracle reorderer;
            Tree tree;
            block30: {
                block29: {
                    numCorrect = 0;
                    numWrong = 0;
                    tree = binarizedTrees.get(index);
                    reorderer = null;
                    if (this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.REORDER_ORACLE || this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.REORDER_BEAM) {
                        reorderer = new ReorderingOracle(this.op);
                    }
                    if (this.op.trainOptions().trainingMethod != ShiftReduceTrainOptions.TrainingMethod.ORACLE) break block29;
                    State state = ShiftReduceParser.initialStateFromGoldTagTree(tree);
                    while (!state.isFinished()) {
                        int transitionNum;
                        List<String> features = this.featureFactory.featurize(state);
                        ScoredObject<Integer> prediction = this.findHighestScoringTransition(state, features, true);
                        if (prediction == null) {
                            throw new AssertionError((Object)"Did not find a legal transition");
                        }
                        int predictedNum = prediction.object();
                        Transition predicted = (Transition)this.transitionIndex.get(predictedNum);
                        OracleTransition gold = oracle.goldTransition(index, state);
                        if (gold.isCorrect(predicted)) {
                            ++numCorrect;
                            if (gold.transition != null && !gold.transition.equals(predicted)) {
                                transitionNum = this.transitionIndex.indexOf(gold.transition);
                                if (transitionNum < 0) continue;
                                updates.add(new Update(features, transitionNum, -1, this.learningRate));
                            }
                        } else {
                            ++numWrong;
                            transitionNum = -1;
                            if (gold.transition != null) {
                                transitionNum = this.transitionIndex.indexOf(gold.transition);
                            }
                            updates.add(new Update(features, transitionNum, predictedNum, this.learningRate));
                        }
                        state = predicted.apply(state);
                    }
                    break block28;
                }
                if (this.op.trainOptions().trainingMethod != ShiftReduceTrainOptions.TrainingMethod.BEAM && this.op.trainOptions().trainingMethod != ShiftReduceTrainOptions.TrainingMethod.REORDER_BEAM) break block30;
                if (this.op.trainOptions().beamSize <= 0) {
                    throw new IllegalArgumentException("Illegal beam size " + this.op.trainOptions().beamSize);
                }
                LinkedList<Transition> transitions = Generics.newLinkedList((Collection)transitionLists.get(index));
                PriorityQueue<Scored> agenda = new PriorityQueue<Scored>(this.op.trainOptions().beamSize + 1, ScoredComparator.ASCENDING_COMPARATOR);
                State goldState = ShiftReduceParser.initialStateFromGoldTagTree(tree);
                agenda.add(goldState);
                while (transitions.size() > 0) {
                    Transition goldTransition = (Transition)transitions.get(0);
                    Transition highestScoringTransitionFromGoldState = null;
                    double highestScoreFromGoldState = 0.0;
                    PriorityQueue<Scored> newAgenda = new PriorityQueue<Scored>(this.op.trainOptions().beamSize + 1, ScoredComparator.ASCENDING_COMPARATOR);
                    State highestScoringState = null;
                    State highestCurrentState = null;
                    for (State state : agenda) {
                        boolean isGoldState = this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.REORDER_BEAM && goldState.areTransitionsEqual(state);
                        List<String> features = this.featureFactory.featurize(state);
                        Collection<ScoredObject<Integer>> stateTransitions = this.findHighestScoringTransitions(state, features, true, this.op.trainOptions().beamSize, null);
                        for (ScoredObject<Integer> transition : stateTransitions) {
                            State newState = ((Transition)this.transitionIndex.get(transition.object())).apply(state, transition.score());
                            newAgenda.add(newState);
                            if (newAgenda.size() > this.op.trainOptions().beamSize) {
                                newAgenda.poll();
                            }
                            if (highestScoringState == null || highestScoringState.score() < newState.score()) {
                                highestScoringState = newState;
                                highestCurrentState = state;
                            }
                            if (!isGoldState || highestScoringTransitionFromGoldState != null && !(transition.score() > highestScoreFromGoldState)) continue;
                            highestScoringTransitionFromGoldState = (Transition)this.transitionIndex.get(transition.object());
                            highestScoreFromGoldState = transition.score();
                        }
                    }
                    if (this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.REORDER_BEAM && highestScoringTransitionFromGoldState == null) break block28;
                    State newGoldState = goldTransition.apply(goldState, 0.0);
                    if (!newGoldState.areTransitionsEqual(highestScoringState)) {
                        ++numWrong;
                        List<String> list = this.featureFactory.featurize(goldState);
                        int lastTransition = this.transitionIndex.indexOf(highestScoringState.transitions.peek());
                        updates.add(new Update(this.featureFactory.featurize(highestCurrentState), -1, lastTransition, this.learningRate));
                        updates.add(new Update(list, this.transitionIndex.indexOf(goldTransition), -1, this.learningRate));
                        if (this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.BEAM) {
                            if (!ShiftReduceUtils.findStateOnAgenda(newAgenda, newGoldState)) break block28;
                            transitions.remove(0);
                        } else if (this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.REORDER_BEAM) {
                            if (!ShiftReduceUtils.findStateOnAgenda(newAgenda, newGoldState)) {
                                if (!reorderer.reorder(goldState, highestScoringTransitionFromGoldState, transitions) || !ShiftReduceUtils.findStateOnAgenda(newAgenda, newGoldState = highestScoringTransitionFromGoldState.apply(goldState))) {
                                    break block28;
                                }
                            } else {
                                transitions.remove(0);
                            }
                        }
                    } else {
                        ++numCorrect;
                        transitions.remove(0);
                    }
                    goldState = newGoldState;
                    agenda = newAgenda;
                }
                break block28;
            }
            if (this.op.trainOptions().trainingMethod != ShiftReduceTrainOptions.TrainingMethod.REORDER_ORACLE && this.op.trainOptions().trainingMethod != ShiftReduceTrainOptions.TrainingMethod.EARLY_TERMINATION && this.op.trainOptions().trainingMethod != ShiftReduceTrainOptions.TrainingMethod.GOLD) break block28;
            State state = ShiftReduceParser.initialStateFromGoldTagTree(tree);
            List<Transition> transitions = transitionLists.get(index);
            transitions = Generics.newLinkedList(transitions);
            boolean keepGoing = true;
            block9: while (transitions.size() > 0 && keepGoing) {
                Transition transition = transitions.get(0);
                int transitionNum = this.transitionIndex.indexOf(transition);
                List<String> features = this.featureFactory.featurize(state);
                int predictedNum = this.findHighestScoringTransition(state, features, false).object();
                Transition predicted = (Transition)this.transitionIndex.get(predictedNum);
                if (transitionNum == predictedNum) {
                    transitions.remove(0);
                    state = transition.apply(state);
                    ++numCorrect;
                    continue;
                }
                ++numWrong;
                updates.add(new Update(features, transitionNum, predictedNum, this.learningRate));
                switch (this.op.trainOptions().trainingMethod) {
                    case EARLY_TERMINATION: {
                        keepGoing = false;
                        continue block9;
                    }
                    case GOLD: {
                        transitions.remove(0);
                        state = transition.apply(state);
                        continue block9;
                    }
                    case REORDER_ORACLE: {
                        keepGoing = reorderer.reorder(state, predicted, transitions);
                        if (!keepGoing) continue block9;
                        state = predicted.apply(state);
                        continue block9;
                    }
                }
                throw new IllegalArgumentException("Unexpected method " + (Object)((Object)this.op.trainOptions().trainingMethod));
            }
        }
        return Pair.makePair(numCorrect, numWrong);
    }

    private Triple<List<Update>, Integer, Integer> trainBatch(List<Integer> indices, List<Tree> binarizedTrees, List<List<Transition>> transitionLists, List<Update> updates, Oracle oracle, MulticoreWrapper<Integer, Pair<Integer, Integer>> wrapper) {
        int numCorrect = 0;
        int numWrong = 0;
        if (this.op.trainOptions.trainingThreads == 1) {
            for (Integer index : indices) {
                Pair<Integer, Integer> count = this.trainTree(index, binarizedTrees, transitionLists, updates, oracle);
                numCorrect += ((Integer)count.first).intValue();
                numWrong += ((Integer)count.second).intValue();
            }
        } else {
            for (Integer index : indices) {
                wrapper.put(index);
            }
            wrapper.join(false);
            while (wrapper.peek()) {
                Pair<Integer, Integer> result = wrapper.poll();
                numCorrect += ((Integer)result.first).intValue();
                numWrong += ((Integer)result.second).intValue();
            }
        }
        return new Triple<List<Update>, Integer, Integer>(updates, numCorrect, numWrong);
    }

    private void trainModel(String serializedPath, Tagger tagger, Random random, List<Tree> binarizedTrees, List<List<Transition>> transitionLists, Treebank devTreebank, int nThreads, Set<String> allowedFeatures) {
        EvaluateTreebank evaluator;
        double bestScore = 0.0;
        int bestIteration = 0;
        PriorityQueue<Scored> bestModels = null;
        if (this.op.trainOptions().averagedModels > 0) {
            bestModels = new PriorityQueue<Scored>(this.op.trainOptions().averagedModels + 1, ScoredComparator.ASCENDING_COMPARATOR);
        }
        ArrayList<Integer> indices = Generics.newArrayList();
        for (int i = 0; i < binarizedTrees.size(); ++i) {
            indices.add(i);
        }
        Oracle oracle = null;
        if (this.op.trainOptions().trainingMethod == ShiftReduceTrainOptions.TrainingMethod.ORACLE) {
            oracle = new Oracle(binarizedTrees, this.op.compoundUnaries, this.rootStates);
        }
        ArrayList<Update> updates = Generics.newArrayList();
        MulticoreWrapper<Integer, Pair<Integer, Integer>> wrapper = null;
        if (nThreads != 1) {
            updates = Collections.synchronizedList(updates);
            wrapper = new MulticoreWrapper<Integer, Pair<Integer, Integer>>(this.op.trainOptions.trainingThreads, new TrainTreeProcessor(binarizedTrees, transitionLists, updates, oracle));
        }
        IntCounter<String> featureFrequencies = null;
        if (this.op.trainOptions().featureFrequencyCutoff > 1) {
            featureFrequencies = new IntCounter<String>();
        }
        for (int iteration = 1; iteration <= this.op.trainOptions.trainingIterations; ++iteration) {
            Timing trainingTimer = new Timing();
            int numCorrect = 0;
            int numWrong = 0;
            Collections.shuffle(indices, random);
            for (int start = 0; start < indices.size(); start += this.op.trainOptions.batchSize) {
                int end = Math.min(start + this.op.trainOptions.batchSize, indices.size());
                Triple<List<Update>, Integer, Integer> result = this.trainBatch(indices.subList(start, end), binarizedTrees, transitionLists, updates, oracle, wrapper);
                numCorrect += ((Integer)result.second).intValue();
                numWrong += ((Integer)result.third).intValue();
                for (Update update : (List)result.first) {
                    for (String feature : update.features) {
                        if (allowedFeatures != null && !allowedFeatures.contains(feature)) continue;
                        Weight weights = this.featureWeights.get(feature);
                        if (weights == null) {
                            weights = new Weight();
                            this.featureWeights.put(feature, weights);
                        }
                        weights.updateWeight(update.goldTransition, update.delta);
                        weights.updateWeight(update.predictedTransition, -update.delta);
                        if (featureFrequencies == null) continue;
                        featureFrequencies.incrementCount(feature, update.goldTransition >= 0 && update.predictedTransition >= 0 ? 2 : 1);
                    }
                }
                updates.clear();
            }
            trainingTimer.done("Iteration " + iteration);
            log.info("While training, got " + numCorrect + " transitions correct and " + numWrong + " transitions wrong");
            this.outputStats();
            double labelF1 = 0.0;
            if (devTreebank != null) {
                evaluator = new EvaluateTreebank(this.op, null, new ShiftReduceParser(this.op, this), tagger);
                evaluator.testOnTreebank(devTreebank);
                labelF1 = evaluator.getLBScore();
                log.info("Label F1 after " + iteration + " iterations: " + labelF1);
                if (labelF1 > bestScore) {
                    log.info("New best dev score (previous best " + bestScore + ")");
                    bestScore = labelF1;
                    bestIteration = iteration;
                } else {
                    log.info("Failed to improve for " + (iteration - bestIteration) + " iteration(s) on previous best score of " + bestScore);
                    if (this.op.trainOptions.stalledIterationLimit > 0 && iteration - bestIteration >= this.op.trainOptions.stalledIterationLimit) {
                        log.info("Failed to improve for too long, stopping training");
                        break;
                    }
                }
                log.info(new Object[0]);
                if (bestModels != null) {
                    bestModels.add(new ScoredObject<PerceptronModel>(new PerceptronModel(this), labelF1));
                    if (bestModels.size() > this.op.trainOptions().averagedModels) {
                        bestModels.poll();
                    }
                }
            }
            if (this.op.trainOptions().saveIntermediateModels && serializedPath != null && this.op.trainOptions.debugOutputFrequency > 0) {
                String tempName = serializedPath.substring(0, serializedPath.length() - 7) + "-" + FILENAME.format(iteration) + "-" + NF.format(labelF1) + ".ser.gz";
                ShiftReduceParser temp = new ShiftReduceParser(this.op, this);
                temp.saveModel(tempName);
            }
            if (iteration % 10 != 0 || !(this.op.trainOptions().decayLearningRate > 0.0)) continue;
            this.learningRate = (float)((double)this.learningRate * this.op.trainOptions().decayLearningRate);
        }
        if (wrapper != null) {
            wrapper.join();
        }
        if (bestModels != null) {
            if (this.op.trainOptions().cvAveragedModels && devTreebank != null) {
                ArrayList<Scored> models = Generics.newArrayList();
                while (bestModels.size() > 0) {
                    models.add(bestModels.poll());
                }
                Collections.reverse(models);
                double bestF1 = 0.0;
                int bestSize = 0;
                for (int i = 1; i <= models.size(); ++i) {
                    log.info("Testing with " + i + " models averaged together");
                    this.averageScoredModels(models.subList(0, i));
                    ShiftReduceParser temp = new ShiftReduceParser(this.op, this);
                    evaluator = new EvaluateTreebank(temp.getOp(), null, temp, tagger);
                    evaluator.testOnTreebank(devTreebank);
                    double labelF1 = evaluator.getLBScore();
                    log.info("Label F1 for " + i + " models: " + labelF1);
                    if (!(labelF1 > bestF1)) continue;
                    bestF1 = labelF1;
                    bestSize = i;
                }
                this.averageScoredModels(models.subList(0, bestSize));
            } else {
                this.averageScoredModels(bestModels);
            }
        }
        if (featureFrequencies != null) {
            this.filterFeatures(featureFrequencies.keysAbove(this.op.trainOptions().featureFrequencyCutoff));
        }
        this.condenseFeatures();
    }

    @Override
    public void trainModel(String serializedPath, Tagger tagger, Random random, List<Tree> binarizedTrees, List<List<Transition>> transitionLists, Treebank devTreebank, int nThreads) {
        if (this.op.trainOptions().retrainAfterCutoff && this.op.trainOptions().featureFrequencyCutoff > 0) {
            String tempName = serializedPath.substring(0, serializedPath.length() - 7) + "-temp.ser.gz";
            this.trainModel(tempName, tagger, random, binarizedTrees, transitionLists, devTreebank, nThreads, null);
            ShiftReduceParser temp = new ShiftReduceParser(this.op, this);
            temp.saveModel(tempName);
            Set<String> features = this.featureWeights.keySet();
            this.featureWeights = Generics.newHashMap();
            this.trainModel(serializedPath, tagger, random, binarizedTrees, transitionLists, devTreebank, nThreads, features);
        } else {
            this.trainModel(serializedPath, tagger, random, binarizedTrees, transitionLists, devTreebank, nThreads, null);
        }
    }

    private class TrainTreeProcessor
    implements ThreadsafeProcessor<Integer, Pair<Integer, Integer>> {
        List<Tree> binarizedTrees;
        List<List<Transition>> transitionLists;
        List<Update> updates;
        Oracle oracle;

        public TrainTreeProcessor(List<Tree> binarizedTrees, List<List<Transition>> transitionLists, List<Update> updates, Oracle oracle) {
            this.binarizedTrees = binarizedTrees;
            this.transitionLists = transitionLists;
            this.updates = updates;
            this.oracle = oracle;
        }

        @Override
        public Pair<Integer, Integer> process(Integer index) {
            return PerceptronModel.this.trainTree(index, this.binarizedTrees, this.transitionLists, this.updates, this.oracle);
        }

        public TrainTreeProcessor newInstance() {
            return this;
        }
    }

    private static class Update {
        final List<String> features;
        final int goldTransition;
        final int predictedTransition;
        final float delta;

        Update(List<String> features, int goldTransition, int predictedTransition, float delta) {
            this.features = features;
            this.goldTransition = goldTransition;
            this.predictedTransition = predictedTransition;
            this.delta = delta;
        }
    }
}

