/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.international.arabic.pipeline;

import edu.stanford.nlp.international.arabic.ArabicMorphoFeatureSpecification;
import edu.stanford.nlp.international.arabic.pipeline.LDCPosMapper;
import edu.stanford.nlp.international.morph.MorphoFeatureSpecification;
import edu.stanford.nlp.international.morph.MorphoFeatures;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.List;
import java.util.Map;

public class UniversalPOSMapper
extends LDCPosMapper {
    private static Redwood.RedwoodChannels log = Redwood.channels(UniversalPOSMapper.class);
    private final Map<String, String> universalMap = Generics.newHashMap();
    private final MorphoFeatureSpecification morphoSpec = new ArabicMorphoFeatureSpecification();

    public UniversalPOSMapper() {
        super(false);
    }

    @Override
    public String map(String posTag, String terminal) {
        String shortTag;
        String rawTag = posTag.trim();
        String string = shortTag = this.tagsToEscape.contains(rawTag) ? rawTag : (String)this.tagMap.get(rawTag);
        if (shortTag == null) {
            System.err.printf("%s: No LDC shortened tag for %s%n", this.getClass().getName(), rawTag);
            return rawTag;
        }
        String universalTag = this.universalMap.get(shortTag);
        if (!this.universalMap.containsKey(shortTag)) {
            System.err.printf("%s: No universal tag for LDC tag %s%n", this.getClass().getName(), shortTag);
            universalTag = shortTag;
        }
        MorphoFeatures feats = new MorphoFeatures(this.morphoSpec.strToFeatures(rawTag));
        String functionalTag = feats.getTag(universalTag);
        return functionalTag;
    }

    @Override
    public void setup(File path, String ... options) {
        super.setup(path, new String[0]);
        for (String opt : options) {
            String[] optToks = opt.split(":");
            if (optToks[0].equals("UniversalMap") && optToks.length == 2) {
                this.loadUniversalMap(optToks[1]);
                continue;
            }
            MorphoFeatureSpecification.MorphoFeatureType feat = MorphoFeatureSpecification.MorphoFeatureType.valueOf(optToks[0]);
            List<String> featVals = this.morphoSpec.getValues(feat);
            this.morphoSpec.activate(feat);
        }
    }

    private void loadUniversalMap(String path) {
        LineNumberReader reader = null;
        try {
            String line;
            reader = new LineNumberReader(new FileReader(path));
            while ((line = reader.readLine()) != null) {
                if (line.trim().equals("")) continue;
                String[] toks = line.trim().split("\\s+");
                if (toks.length != 2) {
                    throw new RuntimeException("Invalid mapping line: " + line);
                }
                this.universalMap.put(toks[0], toks[1]);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            System.err.printf("%s: File not found %s%n", this.getClass().getName(), path);
        }
        catch (IOException e) {
            int lineId = reader == null ? -1 : reader.getLineNumber();
            System.err.printf("%s: Error at line %d%n", this.getClass().getName(), lineId);
            e.printStackTrace();
        }
    }
}

