/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators.descriptors.RSTBCustomStepDescriptor;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBStateHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.researchstack.backbone.ResourcePathManager;

public class RSTBTaskBuilderHelper {
    private Context context;
    private ResourcePathManager resourcePathManager;
    private Gson gson;
    private JsonParser jsonParser;
    private RSTBStateHelper stateHelper;
    private int defaultResourceType;

    public int getDefaultResourceType() {
        return this.defaultResourceType;
    }

    public void setDefaultResourceType(int defaultResourceType) {
        this.defaultResourceType = defaultResourceType;
    }

    RSTBTaskBuilderHelper(Context context, ResourcePathManager resourcePathManager, RSTBStateHelper stateHelper) {
        this.context = context;
        this.resourcePathManager = resourcePathManager;
        this.gson = new Gson();
        this.jsonParser = new JsonParser();
        this.stateHelper = stateHelper;
        this.defaultResourceType = 1;
    }

    public Context getContext() {
        return this.context;
    }

    public ResourcePathManager getResourcePathManager() {
        return this.resourcePathManager;
    }

    public Gson getGson() {
        return this.gson;
    }

    public String pathForFilename(String filename, int resourceType) {
        return this.resourcePathManager.generatePath(resourceType, filename);
    }

    @Nullable
    public JsonElement getJsonElementForFilename(String filename, int resourceType) {
        String jsonPath = this.pathForFilename(filename, resourceType);
        InputStream stream = ResourcePathManager.getResouceAsInputStream((Context)this.context, (String)jsonPath);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        JsonElement element = null;
        try {
            element = this.jsonParser.parse((Reader)reader);
        }
        catch (Exception e) {
            Log.w((String)this.getClass().getSimpleName(), (String)"could not parse json element", (Throwable)e);
            return null;
        }
        return element;
    }

    @Nullable
    public JsonElement getJsonElementForFilename(String filename) {
        return this.getJsonElementForFilename(filename, this.defaultResourceType);
    }

    @Nullable
    public RSTBCustomStepDescriptor getCustomStepDescriptor(JsonObject jsonObject) {
        JsonElement element;
        RSTBCustomStepDescriptor stepDescriptor = (RSTBCustomStepDescriptor)this.getGson().fromJson((JsonElement)jsonObject, RSTBCustomStepDescriptor.class);
        if (stepDescriptor.parameters == null && stepDescriptor.parameterFileName != null && !stepDescriptor.parameterFileName.isEmpty() && (element = this.getJsonElementForFilename(stepDescriptor.parameterFileName)).isJsonObject()) {
            stepDescriptor.parameters = element.getAsJsonObject();
        }
        return stepDescriptor;
    }

    public RSTBStateHelper getStateHelper() {
        return this.stateHelper;
    }
}

