/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators.RSTBQuestionStepGenerator;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators.descriptors.RSTBChoiceStepDescriptor;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators.descriptors.RSTBChoiceStepItemDescriptor;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBHelpers;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBTaskBuilderHelper;
import java.util.ArrayList;
import java.util.List;
import org.researchstack.backbone.answerformat.AnswerFormat;
import org.researchstack.backbone.answerformat.ChoiceAnswerFormat;
import org.researchstack.backbone.model.Choice;

public abstract class RSTBChoiceStepGenerator
extends RSTBQuestionStepGenerator {
    protected abstract boolean allowsMultiple();

    public ChoiceFilter generateFilter(RSTBTaskBuilderHelper helper, String type, JsonObject jsonObject) {
        return new ChoiceFilter(){

            @Override
            public boolean filter(RSTBChoiceStepItemDescriptor itemDescriptor) {
                return true;
            }
        };
    }

    protected Choice[] generateChoices(List<RSTBChoiceStepItemDescriptor> items, boolean shuffleItems) {
        Choice[] choices = new Choice[items.size()];
        List<RSTBChoiceStepItemDescriptor> choiceItems = shuffleItems ? RSTBHelpers.shuffled(items) : items;
        for (int i = 0; i < choiceItems.size(); ++i) {
            RSTBChoiceStepItemDescriptor choice = choiceItems.get(i);
            if (choice.value instanceof String) {
                choices[i] = new Choice(choice.prompt, (Object)((String)choice.value));
                continue;
            }
            if (choice.value instanceof Number) {
                choices[i] = new Choice(choice.prompt, (Object)((Number)choice.value).intValue());
                continue;
            }
            throw new RuntimeException("String and Integer are the only supported values for generating Choices from json");
        }
        return choices;
    }

    @Override
    public AnswerFormat generateAnswerFormat(RSTBTaskBuilderHelper helper, String type, JsonObject jsonObject) {
        RSTBChoiceStepDescriptor choiceStepDescriptor = (RSTBChoiceStepDescriptor)helper.getGson().fromJson((JsonElement)jsonObject, RSTBChoiceStepDescriptor.class);
        AnswerFormat.ChoiceAnswerStyle answerStyle = this.allowsMultiple() ? AnswerFormat.ChoiceAnswerStyle.MultipleChoice : AnswerFormat.ChoiceAnswerStyle.SingleChoice;
        ChoiceFilter choiceFilter = this.generateFilter(helper, type, jsonObject);
        ArrayList<RSTBChoiceStepItemDescriptor> filteredItems = new ArrayList<RSTBChoiceStepItemDescriptor>();
        for (RSTBChoiceStepItemDescriptor item : choiceStepDescriptor.items) {
            if (!choiceFilter.filter(item)) continue;
            filteredItems.add(item);
        }
        ChoiceAnswerFormat answerFormat = new ChoiceAnswerFormat(answerStyle, this.generateChoices(filteredItems, choiceStepDescriptor.shuffleItems));
        return answerFormat;
    }

    public static interface ChoiceFilter {
        public boolean filter(RSTBChoiceStepItemDescriptor var1);
    }
}

