/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class RSTBHelpers {
    static Random rnd = new Random();

    public static <T> void shuffle(T[] ar) {
        for (int i = ar.length - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            T a = ar[index];
            ar[index] = ar[i];
            ar[i] = a;
        }
    }

    public static <T> List<T> shuffled(List<T> list) {
        ArrayList<T> ar = new ArrayList<T>(list);
        for (int i = ar.size() - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            T a = ar.get(i);
            ar.set(i, ar.get(index));
            ar.set(index, a);
        }
        return ar;
    }

    public static JsonArray shuffled(JsonArray jsonArray) {
        JsonArray shuffledArray = new JsonArray();
        shuffledArray.addAll(jsonArray);
        for (int i = shuffledArray.size() - 1; i > 0; --i) {
            int index = rnd.nextInt(i + 1);
            JsonElement a = shuffledArray.get(index);
            shuffledArray.set(index, shuffledArray.get(i));
            shuffledArray.set(i, a);
        }
        return shuffledArray;
    }

    public static JsonElement randomElement(JsonArray jsonArray) {
        int index = rnd.nextInt(jsonArray.size());
        return jsonArray.get(index);
    }

    public static <T> T coinFlip(T obj1, T obj2, double bias) {
        double realBias = Math.max(Math.min(bias, 1.0), 0.0);
        double flip = rnd.nextDouble();
        if (flip < realBias) {
            return obj1;
        }
        return obj2;
    }
}

