/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBElementGeneratorServiceProvider;

import android.support.annotation.Nullable;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBElementGeneratorServiceProvider.spi.RSTBElementGenerator;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBTaskBuilderHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;

public class RSTBElementGeneratorService {
    private static RSTBElementGeneratorService service;
    private ServiceLoader<RSTBElementGenerator> loader = ServiceLoader.load(RSTBElementGenerator.class);

    private RSTBElementGeneratorService() {
    }

    public static synchronized RSTBElementGeneratorService getInstance() {
        if (service == null) {
            service = new RSTBElementGeneratorService();
        }
        return service;
    }

    @Nullable
    public JsonArray generateElements(RSTBTaskBuilderHelper helper, String type, JsonObject jsonObject) {
        JsonArray elements = null;
        try {
            Iterator<RSTBElementGenerator> elementGenerators = this.loader.iterator();
            while (elements == null && elementGenerators.hasNext()) {
                RSTBElementGenerator elementGenerator = elementGenerators.next();
                if (!elementGenerator.supportsType(type)) continue;
                elements = elementGenerator.generateElements(helper, type, jsonObject);
            }
        }
        catch (ServiceConfigurationError serviceError) {
            elements = null;
            serviceError.printStackTrace();
        }
        return elements;
    }

    public List<String> supportedStepTypes() {
        ArrayList<String> supportedTypes = new ArrayList<String>();
        try {
            for (RSTBElementGenerator elementGenerator : this.loader) {
                supportedTypes.addAll(elementGenerator.supportedStepTypes());
            }
        }
        catch (ServiceConfigurationError serviceError) {
            supportedTypes = new ArrayList();
            serviceError.printStackTrace();
        }
        return supportedTypes;
    }

    public boolean supportsType(String type) {
        try {
            for (RSTBElementGenerator elementGenerator : this.loader) {
                if (!elementGenerator.supportsType(type)) continue;
                return true;
            }
        }
        catch (ServiceConfigurationError serviceError) {
            serviceError.printStackTrace();
            return false;
        }
        return false;
    }
}

