/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.tech.foundry.researchsuitetaskbuilder;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Log;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.DefaultStepGenerators.descriptors.RSTBCustomStepDescriptor;
import edu.cornell.tech.foundry.researchsuitetaskbuilder.RSTBStateHelper;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.researchstack.skin.ResourceManager;

public class RSTBTaskBuilderHelper {
    private Context context;
    private ResourceManager resourceManager;
    private Gson gson;
    private JsonParser jsonParser;
    private RSTBStateHelper stateHelper;

    RSTBTaskBuilderHelper(Context context, ResourceManager resourceManager, RSTBStateHelper stateHelper) {
        this.context = context;
        this.resourceManager = resourceManager;
        this.gson = new Gson();
        this.jsonParser = new JsonParser();
        this.stateHelper = stateHelper;
    }

    public Context getContext() {
        return this.context;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public Gson getGson() {
        return this.gson;
    }

    @Nullable
    public JsonElement getJsonElementForFilename(String filename) {
        String jsonPath = this.resourceManager.generatePath(1, filename);
        InputStream stream = ResourceManager.getResouceAsInputStream((Context)this.context, (String)jsonPath);
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(stream, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        JsonElement element = null;
        try {
            element = this.jsonParser.parse((Reader)reader);
        }
        catch (Exception e) {
            Log.w((String)this.getClass().getSimpleName(), (String)"could not parse json element", (Throwable)e);
            return null;
        }
        return element;
    }

    @Nullable
    public RSTBCustomStepDescriptor getCustomStepDescriptor(JsonObject jsonObject) {
        JsonElement element;
        RSTBCustomStepDescriptor stepDescriptor = (RSTBCustomStepDescriptor)this.getGson().fromJson((JsonElement)jsonObject, RSTBCustomStepDescriptor.class);
        if (stepDescriptor.parameters == null && stepDescriptor.parameterFileName != null && !stepDescriptor.parameterFileName.isEmpty() && (element = this.getJsonElementForFilename(stepDescriptor.parameterFileName)).isJsonObject()) {
            stepDescriptor.parameters = element.getAsJsonObject();
        }
        return stepDescriptor;
    }

    public RSTBStateHelper getStateHelper() {
        return this.stateHelper;
    }
}

