/*
 * Copyright 2022 Nedra Team
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package digital.nedra.commons.starter.security.engine.core;

import static digital.nedra.commons.starter.security.engine.core.Fields.Type.AND;
import static digital.nedra.commons.starter.security.engine.core.Fields.Type.OR;

import com.google.common.collect.ImmutableList;
import lombok.AccessLevel;
import lombok.Setter;

public interface ContextConfigure {

  /**
   * Выполнение сравнения полей по критерию "ВСЕ ИЗ".
   *
   * @param name Имена полей
   * @return Контекст
   */
  ContextConfigure allOf(String... name);

  /**
   * Выполнение сравнения полей по критерию "ЛЮБОЕ ИЗ".
   *
   * @param name Имена полей
   * @return Контекст
   */
  ContextConfigure anyOf(String... name);

  /**
   * Установка запрета права для роли.
   *
   * @return Контекст
   */
  DefaultContextConfigure forbidden();

  RoleBuilder and();

  RoleHandler build();

  class DefaultContextConfigure implements ContextConfigure {
    @Setter(AccessLevel.PACKAGE)
    RoleBuilder parent;

    public DefaultContextConfigure allOf(String... name) {
      ((RoleBuilder.DefaultRoleBuilder) this.parent)
          .conf.setFields(Fields.builder()
              .value(ImmutableList.copyOf(name))
              .type(AND)
              .build());
      return this;
    }

    public DefaultContextConfigure anyOf(String... name) {
      ((RoleBuilder.DefaultRoleBuilder) this.parent)
          .conf.setFields(Fields.builder()
              .value(ImmutableList.copyOf(name))
              .type(OR)
              .build());
      return this;
    }

    public DefaultContextConfigure forbidden() {
      ((RoleBuilder.DefaultRoleBuilder) this.parent).conf.forbidden();
      return this;
    }

    public RoleBuilder and() {
      return this.parent.and();
    }

    public RoleHandler build() {
      this.parent.and();
      return this.parent.build();
    }

  }
}
