/*
 * Decompiled with CFR 0.152.
 */
package zio.stm;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.Option;
import scala.Predef$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.RichLong$;
import scala.runtime.function.JProcedure3;
import zio.Scope;
import zio.Scope$;
import zio.Unsafe$;
import zio.ZIO;
import zio.ZIO$;
import zio.stm.TRef;
import zio.stm.TSemaphore$;
import zio.stm.ZSTM;
import zio.stm.ZSTM$;
import zio.stm.ZSTM$Acquire$;
import zio.stm.ZSTM$Effect$;
import zio.stm.ZSTM$RetryException$;

public final class TSemaphore
implements Serializable {
    private final TRef permits;

    public static ZSTM<Object, Nothing$, TSemaphore> make(Function0<Object> function0, Object object) {
        return TSemaphore$.MODULE$.make(function0, object);
    }

    public static ZIO<Object, Nothing$, TSemaphore> makeCommit(Function0<Object> function0, Object object) {
        return TSemaphore$.MODULE$.makeCommit(function0, object);
    }

    public TSemaphore(TRef<Object> permits) {
        this.permits = permits;
    }

    public TRef<Object> permits() {
        return this.permits;
    }

    public ZSTM<Object, Nothing$, BoxedUnit> acquire() {
        return this.acquireBetween(1L, 1L).unit();
    }

    public ZSTM<Object, Nothing$, BoxedUnit> acquireN(long n) {
        return this.acquireBetween(n, n).unit();
    }

    public ZSTM<Object, Nothing$, Object> acquireBetween(long min, long max) {
        return ZSTM$Effect$.MODULE$.apply((Function3 & Serializable)(journal, _$1, _$2) -> {
            Predef$.MODULE$.require(min <= max, () -> TSemaphore.acquireBetween$$anonfun$1$$anonfun$1(min, max));
            this.assertNonNegative(min);
            this.assertNonNegative(max);
            long available = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((ZSTM.internal.Journal)journal));
            if (available < min) {
                throw ZSTM$RetryException$.MODULE$;
            }
            long requested = RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(available), max);
            this.permits().unsafeSet((ZSTM.internal.Journal)journal, BoxesRunTime.boxToLong((long)(available - requested)));
            return requested;
        });
    }

    public ZSTM<Object, Nothing$, Object> acquireUpTo(long max) {
        return this.acquireBetween(0L, max);
    }

    public ZSTM<Object, Nothing$, Object> available() {
        return this.permits().get();
    }

    public ZSTM<Object, Nothing$, BoxedUnit> release() {
        return this.releaseN(1L);
    }

    public ZSTM<Object, Nothing$, BoxedUnit> releaseN(long n) {
        return ZSTM$Effect$.MODULE$.apply((JProcedure3 & Serializable)(journal, _$3, _$4) -> {
            this.assertNonNegative(n);
            long current = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((ZSTM.internal.Journal)journal));
            this.permits().unsafeSet((ZSTM.internal.Journal)journal, BoxesRunTime.boxToLong((long)(current + n)));
        });
    }

    public ZSTM<Object, Nothing$, Object> tryAcquire() {
        return this.tryAcquireN(1L);
    }

    public ZSTM<Object, Nothing$, Object> tryAcquireN(long n) {
        return ZSTM$Effect$.MODULE$.apply((Function3 & Serializable)(journal, _$5, _$6) -> {
            this.assertNonNegative(n);
            long available = BoxesRunTime.unboxToLong((Object)this.permits().unsafeGet((ZSTM.internal.Journal)journal));
            if (available >= n) {
                this.permits().unsafeSet((ZSTM.internal.Journal)journal, BoxesRunTime.boxToLong((long)(available - n)));
                return true;
            }
            return false;
        });
    }

    public <R, E, A> ZIO<R, E, Option<A>> tryWithPermit(ZIO<R, E, A> zio, Object trace) {
        return this.tryWithPermits(1L, zio, trace);
    }

    public <R, E, A> ZIO<R, E, Option<A>> tryWithPermits(long n, ZIO<R, E, A> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.tryAcquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$7 -> this.tryWithPermits$$anonfun$1(n, trace, BoxesRunTime.unboxToBoolean((Object)_$7))).apply((Function1 & Serializable)_$8 -> zio.when((Function0<Object>)((Function0 & Serializable)() -> TSemaphore.tryWithPermits$$anonfun$2$$anonfun$1(BoxesRunTime.unboxToBoolean((Object)_$8))), trace), trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermit(ZIO<R, E, A> zio, Object trace) {
        return this.withPermits(1L, zio, trace);
    }

    public ZIO<Scope, Nothing$, BoxedUnit> withPermitScoped(Object trace) {
        return this.withPermitsScoped(1L, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermits(long n, ZIO<R, E, A> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$9 -> this.releaseN(n).commit(trace)).apply((Function1 & Serializable)_$10 -> zio, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermitsBetween(long min, long max, Function1<Object, ZIO<R, E, A>> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireBetween(min, max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsBetween$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply(zio, trace);
    }

    public <R, E, A> ZIO<R, E, A> withPermitsUpTo(long max, Function1<Object, ZIO<R, E, A>> zio, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireUpTo(max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsUpTo$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply(zio, trace);
    }

    public ZIO<Scope, Nothing$, BoxedUnit> withPermitsScoped(long n, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireN(n));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)_$11 -> Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsScoped$$anonfun$1$$anonfun$1(n, trace)), trace)).apply((Function1 & Serializable)_$12 -> ZIO$.MODULE$.unit(), trace);
    }

    public ZIO<Scope, Nothing$, Object> withPermitsBetweenScoped(long min, long max, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireBetween(min, max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsBetweenScoped$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply((Function1 & Serializable)_$13 -> TSemaphore.withPermitsBetweenScoped$$anonfun$2(trace, BoxesRunTime.unboxToLong((Object)_$13)), trace);
    }

    public ZIO<Scope, Nothing$, Object> withPermitsUpToScoped(long max, Object trace) {
        Function0 function0 = ZSTM$.MODULE$.acquireReleaseWith(this.acquireUpTo(max));
        return ZSTM$Acquire$.MODULE$.apply$extension(function0, (Function1 & Serializable)actualN -> this.withPermitsUpToScoped$$anonfun$1(trace, BoxesRunTime.unboxToLong((Object)actualN))).apply((Function1 & Serializable)_$14 -> TSemaphore.withPermitsUpToScoped$$anonfun$2(trace, BoxesRunTime.unboxToLong((Object)_$14)), trace);
    }

    private void assertNonNegative(long n) {
        Predef$.MODULE$.require(n >= 0L, () -> TSemaphore.assertNonNegative$$anonfun$1(n));
    }

    private static final Object acquireBetween$$anonfun$1$$anonfun$1(long min$2, long max$2) {
        return "Unexpected `" + min$2 + "` > `" + max$2 + "` passed to acquireRange.";
    }

    private static final boolean tryWithPermits$$anonfun$1$$anonfun$1(boolean _$7$1) {
        return _$7$1;
    }

    private final /* synthetic */ ZIO tryWithPermits$$anonfun$1(long n$3, Object trace$1, boolean _$7) {
        return this.releaseN(n$3).commit(trace$1).whenDiscard((Function0<Object>)((Function0 & Serializable)() -> TSemaphore.tryWithPermits$$anonfun$1$$anonfun$1(_$7)), trace$1);
    }

    private static final boolean tryWithPermits$$anonfun$2$$anonfun$1(boolean _$8$1) {
        return _$8$1;
    }

    private final /* synthetic */ ZIO withPermitsBetween$$anonfun$1(Object trace$4, long actualN) {
        return this.releaseN(actualN).commit(trace$4);
    }

    private final /* synthetic */ ZIO withPermitsUpTo$$anonfun$1(Object trace$5, long actualN) {
        return this.releaseN(actualN).commit(trace$5);
    }

    private final ZIO withPermitsScoped$$anonfun$1$$anonfun$1(long n$6, Object trace$7) {
        return this.releaseN(n$6).commit(trace$7);
    }

    private final ZIO withPermitsBetweenScoped$$anonfun$1$$anonfun$1(long actualN$1, Object trace$8) {
        return this.releaseN(actualN$1).commit(trace$8);
    }

    private final /* synthetic */ ZIO withPermitsBetweenScoped$$anonfun$1(Object trace$9, long actualN) {
        return Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsBetweenScoped$$anonfun$1$$anonfun$1(actualN, trace$9)), trace$9);
    }

    private static final /* synthetic */ ZIO withPermitsBetweenScoped$$anonfun$2(Object trace$10, long _$13) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$10, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return _$13;
        });
    }

    private final ZIO withPermitsUpToScoped$$anonfun$1$$anonfun$1(long actualN$2, Object trace$11) {
        return this.releaseN(actualN$2).commit(trace$11);
    }

    private final /* synthetic */ ZIO withPermitsUpToScoped$$anonfun$1(Object trace$12, long actualN) {
        return Scope$.MODULE$.addFinalizer((Function0<ZIO<Object, Nothing$, Object>>)((Function0 & Serializable)() -> this.withPermitsUpToScoped$$anonfun$1$$anonfun$1(actualN, trace$12)), trace$12);
    }

    private static final /* synthetic */ ZIO withPermitsUpToScoped$$anonfun$2(Object trace$13, long _$14) {
        ZIO$ ZIOCompanionVersionSpecific_this = ZIO$.MODULE$;
        return ZIOCompanionVersionSpecific_this.inline$Sync$i1(ZIO$.MODULE$).apply(trace$13, (Function0 & Serializable)() -> {
            Unsafe$ unsafe$ = Unsafe$.MODULE$;
            return _$14;
        });
    }

    private static final Object assertNonNegative$$anonfun$1(long n$7) {
        return "Unexpected negative `" + n$7 + "` permits requested.";
    }
}

