/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.time.Duration;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import zio.Chunk;
import zio.Chunk$;
import zio.Unsafe$;
import zio.internal.PartitionedRingBuffer;
import zio.internal.Platform$;
import zio.internal.RingBuffer;
import zio.internal.WeakConcurrentBag$;
import zio.internal.WeakConcurrentBag$IsAlive$;
import zio.internal.WeakConcurrentBagGc$;

public class WeakConcurrentBag<A> {
    public final IsAlive<A> zio$internal$WeakConcurrentBag$$isAlive;
    private final PartitionedRingBuffer<WeakReference<A>> nursery;
    private final int nurseryActualSize;
    public final Set<WeakReference<A>> zio$internal$WeakConcurrentBag$$graduates;
    private final AtomicBoolean gcStatus;
    private final AtomicBoolean autoGc;
    private final Predicate<WeakReference<A>> notAlive;

    public static <A> WeakConcurrentBag<A> apply(int n, IsAlive<A> isAlive) {
        return WeakConcurrentBag$.MODULE$.apply(n, isAlive);
    }

    public static <A> IsAlive<Object> apply$default$2() {
        return WeakConcurrentBag$.MODULE$.apply$default$2();
    }

    public WeakConcurrentBag(int nurserySize, IsAlive<A> isAlive) {
        this.zio$internal$WeakConcurrentBag$$isAlive = isAlive;
        this.nursery = new PartitionedRingBuffer(this.nCpu() * 4, nurserySize, true);
        this.nurseryActualSize = this.nursery.capacity();
        this.zio$internal$WeakConcurrentBag$$graduates = Platform$.MODULE$.newConcurrentSet(this.nurseryActualSize * 2, Unsafe$.MODULE$.unsafe());
        this.gcStatus = new AtomicBoolean(false);
        this.autoGc = new AtomicBoolean(false);
        this.notAlive = new Predicate<WeakReference<A>>(this){
            private final /* synthetic */ WeakConcurrentBag $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public boolean test(WeakReference ref) {
                T value = ref.get();
                return value == null || !this.$outer.zio$internal$WeakConcurrentBag$$isAlive.apply(value);
            }
        };
    }

    private int nCpu() {
        return Runtime.getRuntime().availableProcessors();
    }

    public WeakConcurrentBag<A> withAutoGc(Duration every) {
        if (this.autoGc.compareAndSet(false, true)) {
            WeakConcurrentBagGc$.MODULE$.start(this, every);
        }
        return this;
    }

    public final void add(A a) {
        Chunk<WeakReference<A>> flushed = this.maybeFlushAndOffer(new WeakReference<A>(a));
        if (flushed.nonEmpty()) {
            this.addToLongTermStorage(flushed);
            if (this.zio$internal$WeakConcurrentBag$$graduates.size() > this.nurseryActualSize) {
                this.gc(false);
                return;
            }
            return;
        }
    }

    public final void gc() {
        this.gc(true);
    }

    public final void gc(boolean force) {
        boolean lockAcquired = this.gcStatus.compareAndSet(false, true);
        try {
            if (force || lockAcquired) {
                this.zio$internal$WeakConcurrentBag$$graduates.removeIf(this.notAlive);
            }
        }
        finally {
            if (lockAcquired) {
                this.gcStatus.set(false);
            }
        }
    }

    public final void graduate() {
        this.flushNurseryToLongTermStorage();
        if (this.zio$internal$WeakConcurrentBag$$graduates.size() > this.nurseryActualSize) {
            this.gc(false);
            return;
        }
    }

    private void flushNurseryToLongTermStorage() {
        Iterator<RingBuffer<WeakReference<A>>> partitions = this.nursery.partitionIterator();
        while (partitions.hasNext()) {
            RingBuffer partition = (RingBuffer)partitions.next();
            this.addToLongTermStorage(partition.pollUpTo(partition.capacity()));
        }
    }

    private Chunk<WeakReference<A>> maybeFlushAndOffer(WeakReference<A> a) {
        RingBuffer<WeakReference<WeakReference<A>>> queue = this.nursery.randomPartition(ThreadLocalRandom.current());
        if (!queue.offer(a)) {
            Chunk<WeakReference<A>> flushed = queue.pollUpTo(queue.capacity() >> 1);
            if (queue.offer(a)) {
                return flushed;
            }
            return (Chunk)flushed.$colon$plus(a);
        }
        return Chunk$.MODULE$.empty();
    }

    private void addToLongTermStorage(Chunk<WeakReference<A>> chunk) {
        int i = 0;
        Chunk.ChunkIterator<WeakReference<A>> iter = chunk.chunkIterator();
        while (iter.hasNextAt(i)) {
            WeakReference<A> ref = iter.nextAt(i);
            Object value = ref.get();
            if (value != null && this.zio$internal$WeakConcurrentBag$$isAlive.apply(value)) {
                this.zio$internal$WeakConcurrentBag$$graduates.add(ref);
            }
            ++i;
        }
    }

    public final Iterator<A> iterator() {
        this.flushNurseryToLongTermStorage();
        return new Iterator<A>(this){
            private final java.util.Iterator it;
            private Object _next;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.it = $outer.zio$internal$WeakConcurrentBag$$graduates.iterator();
                this._next = this.prefetch();
            }

            public java.util.Iterator it() {
                return this.it;
            }

            public Object _next() {
                return this._next;
            }

            public void _next_$eq(Object x$1) {
                this._next = x$1;
            }

            public Object prefetch() {
                while (this.it().hasNext()) {
                    T next = ((Reference)this.it().next()).get();
                    if (next == null) {
                        this.it().remove();
                        continue;
                    }
                    return next;
                }
                return null;
            }

            public boolean hasNext() {
                return this._next() != null;
            }

            public Object next() {
                if (this._next() == null) {
                    throw new NoSuchElementException("There is no more element in the weak concurrent bag iterator");
                }
                Object result = this._next();
                this._next_$eq(this.prefetch());
                return result;
            }
        };
    }

    public int size() {
        return this.zio$internal$WeakConcurrentBag$$graduates.size() + this.nursery.size();
    }

    public final String toString() {
        return this.iterator().mkString("WeakConcurrentBag(", ",", ")");
    }

    public static interface IsAlive<A> {
        public static IsAlive<Object> always() {
            return WeakConcurrentBag$IsAlive$.MODULE$.always();
        }

        public boolean apply(A var1);
    }
}

