/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.runtime.RichInt$;
import zio.internal.MutableConcurrentQueue;
import zio.internal.MutableConcurrentQueue$;
import zio.internal.RingBuffer;
import zio.internal.RingBuffer$;

public final class PartitionedRingBuffer<A>
extends MutableConcurrentQueue<A>
implements Serializable {
    public final int zio$internal$PartitionedRingBuffer$$mask;
    public final int zio$internal$PartitionedRingBuffer$$nQueues;
    private final int partitionSize;
    public final RingBuffer<A>[] zio$internal$PartitionedRingBuffer$$queues;
    private final int capacity;

    public PartitionedRingBuffer(int preferredPartitions, int preferredCapacity, boolean roundToPow2) {
        this.zio$internal$PartitionedRingBuffer$$mask = MutableConcurrentQueue$.MODULE$.roundToPow2MinusOne(preferredPartitions);
        this.zio$internal$PartitionedRingBuffer$$nQueues = this.zio$internal$PartitionedRingBuffer$$mask + 1;
        int cap = RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper((int)Math.ceil((double)preferredCapacity / (double)this.zio$internal$PartitionedRingBuffer$$nQueues)), 2);
        this.partitionSize = roundToPow2 ? RingBuffer$.MODULE$.nextPow2(cap) : cap;
        this.zio$internal$PartitionedRingBuffer$$queues = (RingBuffer[])Array$.MODULE$.fill(this.zio$internal$PartitionedRingBuffer$$nQueues, this::$init$$$anonfun$1, ClassTag$.MODULE$.apply(RingBuffer.class));
        this.capacity = this.zio$internal$PartitionedRingBuffer$$nQueues * this.partitionSize;
    }

    @Override
    public final int capacity() {
        return this.capacity;
    }

    public int nPartitions() {
        return this.zio$internal$PartitionedRingBuffer$$nQueues;
    }

    @Override
    public int size() {
        int from = ThreadLocalRandom.current().nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        int size = 0;
        for (int i = 0; i < this.zio$internal$PartitionedRingBuffer$$nQueues; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            size += this.zio$internal$PartitionedRingBuffer$$queues[idx].size();
        }
        return size;
    }

    @Override
    public long enqueuedCount() {
        int from = ThreadLocalRandom.current().nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        long size = 0L;
        for (int i = 0; i < this.zio$internal$PartitionedRingBuffer$$nQueues; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            size += this.zio$internal$PartitionedRingBuffer$$queues[idx].enqueuedCount();
        }
        return size;
    }

    @Override
    public long dequeuedCount() {
        int from = ThreadLocalRandom.current().nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        long size = 0L;
        for (int i = 0; i < this.zio$internal$PartitionedRingBuffer$$nQueues; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            size += this.zio$internal$PartitionedRingBuffer$$queues[idx].dequeuedCount();
        }
        return size;
    }

    public boolean offer(A a, ThreadLocalRandom random) {
        int from = random.nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        boolean result = false;
        for (int i = 0; i < this.zio$internal$PartitionedRingBuffer$$nQueues && !result; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            result = this.zio$internal$PartitionedRingBuffer$$queues[idx].offer(a);
        }
        return result;
    }

    public RingBuffer<A> randomPartition(ThreadLocalRandom random) {
        return this.zio$internal$PartitionedRingBuffer$$queues[random.nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues)];
    }

    @Override
    public boolean offer(A a) {
        return this.offer(a, ThreadLocalRandom.current());
    }

    public A poll(A a, ThreadLocalRandom random) {
        int from = random.nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        Object result = null;
        for (int i = 0; result == null && i < this.zio$internal$PartitionedRingBuffer$$nQueues; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            RingBuffer<Object> queue = this.zio$internal$PartitionedRingBuffer$$queues[idx];
            result = queue.poll(result);
        }
        if (result == null) {
            return a;
        }
        return result;
    }

    @Override
    public A poll(A a) {
        return this.poll(a, ThreadLocalRandom.current());
    }

    @Override
    public boolean isEmpty() {
        int from = ThreadLocalRandom.current().nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        boolean result = true;
        for (int i = 0; result && i < this.zio$internal$PartitionedRingBuffer$$nQueues; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            result = this.zio$internal$PartitionedRingBuffer$$queues[idx].isEmpty();
        }
        return result;
    }

    @Override
    public boolean isFull() {
        int from = ThreadLocalRandom.current().nextInt(this.zio$internal$PartitionedRingBuffer$$nQueues);
        boolean result = true;
        for (int i = 0; result && i < this.zio$internal$PartitionedRingBuffer$$nQueues; ++i) {
            int idx = from + i & this.zio$internal$PartitionedRingBuffer$$mask;
            result = this.zio$internal$PartitionedRingBuffer$$queues[idx].isFull();
        }
        return result;
    }

    public Iterator<RingBuffer<A>> partitionIterator() {
        return new Iterator<RingBuffer<A>>(this){
            private final int from;
            private int i;
            private final int _size;
            private final int _mask;
            private final RingBuffer[] _queues;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                IterableOnce.$init$((IterableOnce)this);
                IterableOnceOps.$init$((IterableOnceOps)this);
                Iterator.$init$((Iterator)this);
                this.from = ThreadLocalRandom.current().nextInt($outer.zio$internal$PartitionedRingBuffer$$nQueues);
                this.i = 0;
                this._size = $outer.zio$internal$PartitionedRingBuffer$$nQueues;
                this._mask = $outer.zio$internal$PartitionedRingBuffer$$mask;
                this._queues = $outer.zio$internal$PartitionedRingBuffer$$queues;
            }

            public boolean hasNext() {
                return this.i < this._size;
            }

            public RingBuffer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("next on empty iterator");
                }
                int idx = this.from + this.i & this._mask;
                RingBuffer q = this._queues[idx];
                ++this.i;
                return q;
            }
        };
    }

    private final RingBuffer $init$$$anonfun$1() {
        return RingBuffer$.MODULE$.apply(this.partitionSize);
    }
}

