/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.io.Serializable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ThreadLocalRandom;
import scala.Array$;
import scala.collection.Iterable;
import scala.reflect.ClassTag$;
import zio.Chunk;
import zio.Chunk$;
import zio.internal.MutableConcurrentQueue$;

public final class PartitionedLinkedQueue<A>
implements Serializable {
    private final int mask;
    private final int nQueues;
    private final ConcurrentLinkedQueue<A>[] queues;

    public PartitionedLinkedQueue(int preferredPartitions) {
        this.mask = MutableConcurrentQueue$.MODULE$.roundToPow2MinusOne(preferredPartitions);
        this.nQueues = this.mask + 1;
        this.queues = (ConcurrentLinkedQueue[])Array$.MODULE$.fill(this.nQueues, PartitionedLinkedQueue::$init$$$anonfun$1, ClassTag$.MODULE$.apply(ConcurrentLinkedQueue.class));
    }

    public int nPartitions() {
        return this.nQueues;
    }

    public int size() {
        int from = ThreadLocalRandom.current().nextInt(this.nQueues);
        int size = 0;
        for (int i = 0; i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            size += this.queues[idx].size();
        }
        return size;
    }

    public void offer(A a, ThreadLocalRandom random) {
        int idx = random.nextInt(this.nQueues);
        this.queues[idx].offer(a);
    }

    public boolean offer(A a) {
        this.offer(a, ThreadLocalRandom.current());
        return true;
    }

    public <A1 extends A> void offerAll(Iterable<A1> as, ThreadLocalRandom random) {
        int from = random.nextInt(this.nQueues);
        int i = 0;
        for (Object value : as) {
            int idx = from + i & this.mask;
            this.queues[idx].offer(value);
            ++i;
        }
    }

    public <A1 extends A> Chunk<A1> offerAll(Iterable<A1> as) {
        this.offerAll(as, ThreadLocalRandom.current());
        return Chunk$.MODULE$.empty();
    }

    public A poll(ThreadLocalRandom random) {
        int from = random.nextInt(this.nQueues);
        A result = null;
        for (int i = 0; result == null && i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            result = this.queues[idx].poll();
        }
        return result;
    }

    public A poll() {
        return this.poll(ThreadLocalRandom.current());
    }

    public boolean isEmpty() {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        int from = random.nextInt(this.nQueues);
        boolean result = true;
        for (int i = 0; result && i < this.nQueues; ++i) {
            int idx = from + i & this.mask;
            result = this.queues[idx].isEmpty();
        }
        return result;
    }

    private static final ConcurrentLinkedQueue $init$$$anonfun$1() {
        return new ConcurrentLinkedQueue();
    }
}

