/*
 * Decompiled with CFR 0.152.
 */
package zio.internal;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public final class NamedThreadFactory
implements ThreadFactory {
    private final String name;
    private final boolean daemon;
    private final ThreadGroup threadGroup;
    private final AtomicInteger threadCount;

    public NamedThreadFactory(String name, boolean daemon) {
        this.name = name;
        this.daemon = daemon;
        ThreadGroup parentGroup = Thread.currentThread().getThreadGroup();
        this.threadGroup = new ThreadGroup(parentGroup, name);
        this.threadCount = new AtomicInteger(1);
    }

    @Override
    public Thread newThread(Runnable r) {
        int newThreadNumber = this.threadCount.getAndIncrement();
        Thread thread = new Thread(this.threadGroup, r);
        thread.setName(this.name + "-" + newThreadNumber);
        thread.setDaemon(this.daemon);
        return thread;
    }
}

