/*
 * Decompiled with CFR 0.152.
 */
package dev.sergiobelda.compose.vectorize.generator;

import com.squareup.kotlinpoet.ClassName;
import com.squareup.kotlinpoet.CodeBlock;
import com.squareup.kotlinpoet.FileSpec;
import com.squareup.kotlinpoet.FunSpec;
import com.squareup.kotlinpoet.KModifier;
import com.squareup.kotlinpoet.MemberName;
import com.squareup.kotlinpoet.PropertySpec;
import com.squareup.kotlinpoet.TypeName;
import dev.sergiobelda.compose.vectorize.generator.AnnotationNames;
import dev.sergiobelda.compose.vectorize.generator.ClassNames;
import dev.sergiobelda.compose.vectorize.generator.MemberNames;
import dev.sergiobelda.compose.vectorize.generator.utils.KotlinPoetUtilsKt;
import dev.sergiobelda.compose.vectorize.generator.vector.PathNode;
import dev.sergiobelda.compose.vectorize.generator.vector.StrokeCap;
import dev.sergiobelda.compose.vectorize.generator.vector.StrokeJoin;
import dev.sergiobelda.compose.vectorize.generator.vector.Vector;
import dev.sergiobelda.compose.vectorize.generator.vector.VectorColor;
import dev.sergiobelda.compose.vectorize.generator.vector.VectorNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0003H\u0002J\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\fH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J-\u0010\u0015\u001a\u00020\u0016*\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00160\u001b\u00a2\u0006\u0002\b\u001cH\u0002J(\u0010\u001d\u001a\u00020\u0016*\u00020\u00172\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00030\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u001fH\u0002J\u0014\u0010\"\u001a\u00020\u0016*\u00020\u00172\u0006\u0010#\u001a\u00020$H\u0002J\f\u0010%\u001a\u00020\u0003*\u00020&H\u0002J\f\u0010%\u001a\u00020\u0003*\u00020'H\u0002R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Ldev/sergiobelda/compose/vectorize/generator/ImageVectorGenerator;", "", "imageName", "", "imagePackageName", "imageCategoryName", "vector", "Ldev/sergiobelda/compose/vectorize/generator/vector/Vector;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ldev/sergiobelda/compose/vectorize/generator/vector/Vector;)V", "isComposable", "", "backingProperty", "Lcom/squareup/kotlinpoet/PropertySpec;", "name", "createFileSpec", "Lcom/squareup/kotlinpoet/FileSpec;", "createFileSpecBuilder", "Lcom/squareup/kotlinpoet/FileSpec$Builder;", "getBackingProperty", "imageGetter", "Lcom/squareup/kotlinpoet/FunSpec;", "addPathCode", "", "Lcom/squareup/kotlinpoet/CodeBlock$Builder;", "path", "Ldev/sergiobelda/compose/vectorize/generator/vector/VectorNode$Path;", "pathBody", "Lkotlin/Function1;", "Lkotlin/ExtensionFunctionType;", "addPathParameters", "parameterList", "", "memberList", "Lcom/squareup/kotlinpoet/MemberName;", "addVectorNodeCode", "vectorNode", "Ldev/sergiobelda/compose/vectorize/generator/vector/VectorNode;", "processValue", "Ldev/sergiobelda/compose/vectorize/generator/vector/VectorColor$Attribute;", "Ldev/sergiobelda/compose/vectorize/generator/vector/VectorColor$Hexadecimal;", "compose-vectorize-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nImageVectorGenerator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageVectorGenerator.kt\ndev/sergiobelda/compose/vectorize/generator/ImageVectorGenerator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 CodeBlock.kt\ncom/squareup/kotlinpoet/CodeBlocks\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,294:1\n1#2:295\n535#3:296\n535#3:299\n1855#4,2:297\n1855#4,2:300\n37#5,2:302\n*S KotlinDebug\n*F\n+ 1 ImageVectorGenerator.kt\ndev/sergiobelda/compose/vectorize/generator/ImageVectorGenerator\n*L\n108#1:296\n140#1:299\n132#1:297,2\n171#1:300,2\n285#1:302,2\n*E\n"})
public final class ImageVectorGenerator {
    @NotNull
    private final String imageName;
    @NotNull
    private final String imagePackageName;
    @NotNull
    private final String imageCategoryName;
    @NotNull
    private final Vector vector;
    private boolean isComposable;

    public ImageVectorGenerator(@NotNull String imageName, @NotNull String imagePackageName, @NotNull String imageCategoryName, @NotNull Vector vector) {
        Intrinsics.checkNotNullParameter((Object)imageName, (String)"imageName");
        Intrinsics.checkNotNullParameter((Object)imagePackageName, (String)"imagePackageName");
        Intrinsics.checkNotNullParameter((Object)imageCategoryName, (String)"imageCategoryName");
        Intrinsics.checkNotNullParameter((Object)vector, (String)"vector");
        this.imageName = imageName;
        this.imagePackageName = imagePackageName;
        this.imageCategoryName = imageCategoryName;
        this.vector = vector;
    }

    @NotNull
    public final FileSpec createFileSpec() {
        FileSpec.Builder builder = this.createFileSpecBuilder();
        PropertySpec backingProperty = this.getBackingProperty();
        String[] stringArray = new String[]{"Images", this.imageCategoryName};
        PropertySpec.Builder propertySpecBuilder = PropertySpec.Companion.builder(this.imageName, (TypeName)ClassNames.INSTANCE.getImageVector(), new KModifier[0]).receiver((TypeName)new ClassName(this.imagePackageName, stringArray)).getter(this.imageGetter(backingProperty, this.imageName));
        builder.addProperty(propertySpecBuilder.build());
        builder.addProperty(backingProperty);
        return KotlinPoetUtilsKt.setIndent(builder).build();
    }

    private final FileSpec.Builder createFileSpecBuilder() {
        String string = this.imageCategoryName;
        Locale locale = Locale.ROOT;
        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
        String string2 = string.toLowerCase(locale);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String imagesPackage = this.imagePackageName + "." + string2;
        return FileSpec.Companion.builder(imagesPackage, this.imageName);
    }

    /*
     * WARNING - void declaration
     */
    private final PropertySpec getBackingProperty() {
        String string;
        String string2 = this.imageName;
        if (((CharSequence)string2).length() > 0) {
            void it;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = false;
            Locale locale = Locale.ROOT;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ROOT");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)CharsKt.lowercase((char)it, (Locale)locale));
            String string3 = string2;
            int n = 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"substring(...)");
            string = stringBuilder2.append(string4).toString();
        } else {
            string = string2;
        }
        String backingPropertyName = "_" + string;
        return this.backingProperty(backingPropertyName);
    }

    /*
     * WARNING - void declaration
     */
    private final FunSpec imageGetter(PropertySpec backingProperty, String imageName) {
        Object[] objectArray;
        CodeBlock.Builder builder;
        boolean $i$f$buildCodeBlock = false;
        CodeBlock.Builder $this$imageGetter_u24lambda_u242 = builder = CodeBlock.Companion.builder();
        boolean bl = false;
        String[] stringArray = new String[]{"name = \"%N\"", "width = " + this.vector.getWidth() + "f", "height = " + this.vector.getHeight() + "f", "viewportWidth = " + this.vector.getViewportWidth() + "f", "viewportHeight = " + this.vector.getViewportHeight() + "f", "autoMirror = " + this.vector.getAutoMirror()};
        List parameterList = CollectionsKt.listOfNotNull((Object[])stringArray);
        String parameters = !((Collection)parameterList).isEmpty() ? CollectionsKt.joinToString$default((Iterable)parameterList, (CharSequence)",\n\t", (CharSequence)"%N = %M(\n\t", (CharSequence)"\n)", (int)0, null, null, (int)56, null) : "";
        Object[] objectArray2 = new Object[]{backingProperty, MemberNames.INSTANCE.getImageVector(), imageName};
        $this$imageGetter_u24lambda_u242.beginControlFlow(parameters, objectArray2);
        Iterable $this$forEach$iv = this.vector.getNodes();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            VectorNode node = (VectorNode)element$iv;
            boolean bl2 = false;
            this.addVectorNodeCode($this$imageGetter_u24lambda_u242, node);
        }
        $this$imageGetter_u24lambda_u242.endControlFlow();
        CodeBlock imageVectorCodeBlock = builder.build();
        Object[] $this$imageGetter_u24lambda_u244 = objectArray = FunSpec.Companion.getterBuilder();
        boolean bl3 = false;
        if (!this.isComposable) {
            void $this$imageGetter_u24lambda_u244_u24lambda_u243;
            boolean $i$f$buildCodeBlock2 = false;
            stringArray = CodeBlock.Companion.builder();
            parameterList = stringArray;
            objectArray2 = $this$imageGetter_u24lambda_u244;
            boolean bl4 = false;
            Object[] objectArray3 = new Object[]{backingProperty};
            $this$imageGetter_u24lambda_u244_u24lambda_u243.beginControlFlow("if (%N != null)", objectArray3);
            objectArray3 = new Object[]{backingProperty};
            $this$imageGetter_u24lambda_u244_u24lambda_u243.addStatement("return %N!!", objectArray3);
            $this$imageGetter_u24lambda_u244_u24lambda_u243.endControlFlow();
            objectArray2.addCode(stringArray.build());
        }
        $this$imageGetter_u24lambda_u244.addCode(imageVectorCodeBlock);
        Object[] objectArray4 = new Object[]{backingProperty};
        $this$imageGetter_u24lambda_u244.addStatement("return %N!!", objectArray4);
        if (this.isComposable) {
            $this$imageGetter_u24lambda_u244.addAnnotation(AnnotationNames.INSTANCE.getComposable());
        }
        return objectArray.build();
    }

    private final PropertySpec backingProperty(String name2) {
        TypeName nullableImageVector = TypeName.copy$default((TypeName)((TypeName)ClassNames.INSTANCE.getImageVector()), (boolean)true, null, (int)2, null);
        KModifier[] kModifierArray = new KModifier[]{KModifier.PRIVATE};
        return PropertySpec.Builder.mutable$default((PropertySpec.Builder)PropertySpec.Companion.builder(name2, nullableImageVector, new KModifier[0]), (boolean)false, (int)1, null).addModifiers(kModifierArray).initializer("null", new Object[0]).build();
    }

    private final void addVectorNodeCode(CodeBlock.Builder $this$addVectorNodeCode, VectorNode vectorNode) {
        VectorNode vectorNode2 = vectorNode;
        if (vectorNode2 instanceof VectorNode.Group) {
            Object[] objectArray = new Object[]{MemberNames.INSTANCE.getGroup()};
            $this$addVectorNodeCode.beginControlFlow("%M", objectArray);
            Iterable $this$forEach$iv = ((VectorNode.Group)vectorNode).getPaths();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                VectorNode.Path path = (VectorNode.Path)element$iv;
                boolean bl = false;
                this.addVectorNodeCode($this$addVectorNodeCode, path);
            }
            $this$addVectorNodeCode.endControlFlow();
        } else if (vectorNode2 instanceof VectorNode.Path) {
            this.addPathCode($this$addVectorNodeCode, (VectorNode.Path)vectorNode, (Function1<? super CodeBlock.Builder, Unit>)((Function1)new Function1<CodeBlock.Builder, Unit>(vectorNode){
                final /* synthetic */ VectorNode $vectorNode;
                {
                    this.$vectorNode = $vectorNode;
                    super(1);
                }

                public final void invoke(CodeBlock.Builder $this$addPathCode) {
                    Intrinsics.checkNotNullParameter((Object)$this$addPathCode, (String)"$this$addPathCode");
                    Iterable $this$forEach$iv = ((VectorNode.Path)this.$vectorNode).getNodes();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        PathNode pathNode = (PathNode)element$iv;
                        boolean bl = false;
                        $this$addPathCode.addStatement(pathNode.asFunctionCall(), new Object[0]);
                    }
                }
            }));
        }
    }

    private final void addPathCode(CodeBlock.Builder $this$addPathCode, VectorNode.Path path, Function1<? super CodeBlock.Builder, Unit> pathBody) {
        VectorColor vectorColor;
        List parameterList = new ArrayList();
        List memberList = new ArrayList();
        VectorNode.Path $this$addPathCode_u24lambda_u2422 = path;
        boolean bl = false;
        memberList.add(MemberNames.INSTANCE.getPath());
        Object object = Float.valueOf($this$addPathCode_u24lambda_u2422.getFillAlpha());
        float it = ((Number)object).floatValue();
        boolean bl2 = false;
        Float f = !(it == 1.0f) ? object : null;
        if (f != null) {
            it = ((Number)f).floatValue();
            boolean bl3 = false;
            parameterList.add("fillAlpha = " + it + "f");
        }
        VectorColor vectorColor2 = $this$addPathCode_u24lambda_u2422.getFillColor();
        if (vectorColor2 != null) {
            VectorColor it2 = vectorColor2;
            boolean bl4 = false;
            vectorColor = it2;
            if (vectorColor instanceof VectorColor.Hexadecimal) {
                parameterList.add("fill = %M(%M(" + this.processValue((VectorColor.Hexadecimal)it2) + "))");
                memberList.add(MemberNames.INSTANCE.getSolidColor());
                memberList.add(MemberNames.INSTANCE.getColor());
            } else if (vectorColor instanceof VectorColor.Attribute) {
                parameterList.add("fill = %M(%M." + this.processValue((VectorColor.Attribute)it2) + ")");
                memberList.add(MemberNames.INSTANCE.getSolidColor());
                memberList.add(MemberNames.INSTANCE.getMaterial3ColorScheme());
                this.isComposable = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object it3 = object = $this$addPathCode_u24lambda_u2422.getFillType();
        boolean bl5 = false;
        Object object2 = it3 != VectorNode.Path.Companion.getDefaultFillType() ? object : null;
        if (object2 != null) {
            it3 = object2;
            boolean bl6 = false;
            parameterList.add("pathFillType = %M");
            memberList.add(MemberNames.PathFillType.INSTANCE.getEvenOdd());
        }
        object = Float.valueOf($this$addPathCode_u24lambda_u2422.getStrokeAlpha());
        float it2 = ((Number)object).floatValue();
        boolean bl7 = false;
        Object object3 = !(it2 == 1.0f) ? object : null;
        if (object3 != null) {
            it2 = ((Number)object3).floatValue();
            boolean bl8 = false;
            parameterList.add("strokeAlpha = " + it2 + "f");
        }
        VectorColor vectorColor3 = $this$addPathCode_u24lambda_u2422.getStrokeColor();
        if (vectorColor3 != null) {
            VectorColor it4 = vectorColor3;
            boolean bl9 = false;
            vectorColor = it4;
            if (vectorColor instanceof VectorColor.Hexadecimal) {
                parameterList.add("stroke = %M(%M(" + this.processValue((VectorColor.Hexadecimal)it4) + "))");
                memberList.add(MemberNames.INSTANCE.getSolidColor());
                memberList.add(MemberNames.INSTANCE.getColor());
            } else if (vectorColor instanceof VectorColor.Attribute) {
                parameterList.add("stroke = %M(%M." + this.processValue((VectorColor.Attribute)it4) + ")");
                memberList.add(MemberNames.INSTANCE.getSolidColor());
                memberList.add(MemberNames.INSTANCE.getMaterial3ColorScheme());
                this.isComposable = true;
            } else {
                throw new NoWhenBranchMatchedException();
            }
        }
        Object it5 = object = $this$addPathCode_u24lambda_u2422.getStrokeCap();
        boolean bl10 = false;
        Object object4 = it5 != VectorNode.Path.Companion.getDefaultStrokeCap() ? object : null;
        if (object4 != null) {
            it5 = object4;
            boolean bl11 = false;
            parameterList.add("strokeLineCap = %M");
            switch (WhenMappings.$EnumSwitchMapping$0[$this$addPathCode_u24lambda_u2422.getStrokeCap().ordinal()]) {
                case 1: {
                    boolean bl12 = memberList.add(MemberNames.StrokeCapType.INSTANCE.getRound());
                    break;
                }
                case 2: {
                    boolean bl12 = memberList.add(MemberNames.StrokeCapType.INSTANCE.getSquare());
                    break;
                }
                default: {
                    boolean bl12 = memberList.add(MemberNames.StrokeCapType.INSTANCE.getButt());
                }
            }
        }
        object = Float.valueOf($this$addPathCode_u24lambda_u2422.getStrokeLineMiter());
        float it32 = ((Number)object).floatValue();
        boolean bl13 = false;
        Object object5 = !(it32 == 4.0f) ? object : null;
        if (object5 != null) {
            it32 = ((Number)object5).floatValue();
            boolean bl14 = false;
            parameterList.add("strokeLineMiter = " + $this$addPathCode_u24lambda_u2422.getStrokeLineMiter() + "f");
        }
        it = object = $this$addPathCode_u24lambda_u2422.getStrokeLineJoin();
        boolean bl15 = false;
        Object object6 = it != VectorNode.Path.Companion.getDefaultStrokeLineJoin() ? object : null;
        if (object6 != null) {
            it = object6;
            boolean bl16 = false;
            parameterList.add("strokeLineJoin = %M");
            switch (WhenMappings.$EnumSwitchMapping$1[$this$addPathCode_u24lambda_u2422.getStrokeLineJoin().ordinal()]) {
                case 1: {
                    boolean bl17 = memberList.add(MemberNames.StrokeJoinType.INSTANCE.getBevel());
                    break;
                }
                case 2: {
                    boolean bl17 = memberList.add(MemberNames.StrokeJoinType.INSTANCE.getRound());
                    break;
                }
                default: {
                    boolean bl17 = memberList.add(MemberNames.StrokeJoinType.INSTANCE.getMiter());
                }
            }
        }
        object = Float.valueOf($this$addPathCode_u24lambda_u2422.getStrokeWidth());
        float it4 = ((Number)object).floatValue();
        boolean bl18 = false;
        Object object7 = !(it4 == 0.0f) ? object : null;
        if (object7 != null) {
            it4 = ((Number)object7).floatValue();
            boolean bl19 = false;
            parameterList.add("strokeLineWidth = " + $this$addPathCode_u24lambda_u2422.getStrokeWidth() + "f");
        }
        this.addPathParameters($this$addPathCode, parameterList, memberList);
        pathBody.invoke((Object)$this$addPathCode);
        $this$addPathCode.endControlFlow();
    }

    private final void addPathParameters(CodeBlock.Builder $this$addPathParameters, List<String> parameterList, List<MemberName> memberList) {
        String parameters = !((Collection)parameterList).isEmpty() ? CollectionsKt.joinToString$default((Iterable)parameterList, (CharSequence)",\n\t", (CharSequence)"(\n\t", (CharSequence)"\n)", (int)0, null, null, (int)56, null) : "";
        Collection $this$toTypedArray$iv = memberList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        MemberName[] memberNameArray = thisCollection$iv.toArray(new MemberName[0]);
        $this$addPathParameters.beginControlFlow("%M" + parameters, (Object[])Arrays.copyOf(memberNameArray, memberNameArray.length));
    }

    /*
     * WARNING - void declaration
     */
    private final String processValue(VectorColor.Attribute $this$processValue) {
        String string;
        String string2 = StringsKt.replace$default((String)$this$processValue.getValue(), (String)"?color", (String)"", (boolean)false, (int)4, null);
        if (((CharSequence)string2).length() > 0) {
            void p0;
            char c = string2.charAt(0);
            StringBuilder stringBuilder = new StringBuilder();
            boolean $i$f$processValue$stub_for_inlining = false;
            boolean bl = false;
            String string3 = String.valueOf((char)p0);
            Intrinsics.checkNotNull((Object)string3, (String)"null cannot be cast to non-null type java.lang.String");
            String string4 = string3.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
            StringBuilder stringBuilder2 = stringBuilder.append((Object)string4);
            String string5 = string2;
            int n = 1;
            String string6 = string5.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            string = stringBuilder2.append(string6).toString();
        } else {
            string = string2;
        }
        return string;
    }

    private final String processValue(VectorColor.Hexadecimal $this$processValue) {
        return StringsKt.replace$default((String)$this$processValue.getValue(), (String)"#", (String)"0x", (boolean)false, (int)4, null);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[StrokeCap.values().length];
            try {
                nArray[StrokeCap.Round.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StrokeCap.Square.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[StrokeJoin.values().length];
            try {
                nArray[StrokeJoin.Bevel.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[StrokeJoin.Round.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

